#include <errno.h>
#include <stdio.h>

int main() {
    struct {
        char const *name;
        int code;
    } errnos[] = {
        {"E2BIG", E2BIG},
        {"EACCES", EACCES},
        {"EADDRINUSE", EADDRINUSE},
        {"EADDRNOTAVAIL", EADDRNOTAVAIL},
        {"EAFNOSUPPORT", EAFNOSUPPORT},
        {"EAGAIN", EAGAIN},
        {"EALREADY", EALREADY},
        {"EBADF", EBADF},
        {"EBADMSG", EBADMSG},
        {"EBUSY", EBUSY},
        {"ECANCELED", ECANCELED},
        {"ECHILD", ECHILD},
        {"ECONNABORTED", ECONNABORTED},
        {"ECONNREFUSED", ECONNREFUSED},
        {"ECONNRESET", ECONNRESET},
        {"EDEADLK", EDEADLK},
        {"EDESTADDRREQ", EDESTADDRREQ},
        {"EDOM", EDOM},
        {"EDQUOT", EDQUOT},
        {"EEXIST", EEXIST},
        {"EFAULT", EFAULT},
        {"EFBIG", EFBIG},
        {"EHOSTUNREACH", EHOSTUNREACH},
        {"EIDRM", EIDRM},
        {"EILSEQ", EILSEQ},
        {"EINPROGRESS", EINPROGRESS},
        {"EINTR", EINTR},
        {"EINVAL", EINVAL},
        {"EIO", EIO},
        {"EISCONN", EISCONN},
        {"EISDIR", EISDIR},
        {"ELOOP", ELOOP},
        {"EMFILE", EMFILE},
        {"EMLINK", EMLINK},
        {"EMSGSIZE", EMSGSIZE},
        {"EMULTIHOP", EMULTIHOP},
        {"ENAMETOOLONG", ENAMETOOLONG},
        {"ENETDOWN", ENETDOWN},
        {"ENETRESET", ENETRESET},
        {"ENETUNREACH", ENETUNREACH},
        {"ENFILE", ENFILE},
        {"ENOBUFS", ENOBUFS},
        {"ENODATA", ENODATA},
        {"ENODEV", ENODEV},
        {"ENOENT", ENOENT},
        {"ENOEXEC", ENOEXEC},
        {"ENOLCK", ENOLCK},
        {"ENOLINK", ENOLINK},
        {"ENOMEM", ENOMEM},
        {"ENOMSG", ENOMSG},
        {"ENOPROTOOPT", ENOPROTOOPT},
        {"ENOSPC", ENOSPC},
        {"ENOSR", ENOSR},
        {"ENOSTR", ENOSTR},
        {"ENOSYS", ENOSYS},
        {"ENOTCONN", ENOTCONN},
        {"ENOTDIR", ENOTDIR},
        {"ENOTEMPTY", ENOTEMPTY},
        {"ENOTSOCK", ENOTSOCK},
        {"ENOTSUP", ENOTSUP},
        {"ENOTTY", ENOTTY},
        {"ENXIO", ENXIO},
        {"EOPNOTSUPP", EOPNOTSUPP},
        {"EOVERFLOW", EOVERFLOW},
        {"EPERM", EPERM},
        {"EPIPE", EPIPE},
        {"EPROTO", EPROTO},
        {"EPROTONOSUPPORT", EPROTONOSUPPORT},
        {"EPROTOTYPE", EPROTOTYPE},
        {"ERANGE", ERANGE},
        {"EROFS", EROFS},
        {"ESPIPE", ESPIPE},
        {"ESRCH", ESRCH},
        {"ESTALE", ESTALE},
        {"ETIME", ETIME},
        {"ETIMEDOUT", ETIMEDOUT},
        {"ETXTBSY", ETXTBSY},
        {"EWOULDBLOCK", EWOULDBLOCK},
        {"EXDEV", EXDEV},
    };
    for (int i = 0; i < sizeof(errnos) / sizeof(errnos[0]); ++i) {
        printf("constant %s = X::NativeCall::Errno.new(code => %d);\n", errnos[i].name, errnos[i].code);
    }
    return 0;
}
