#-------------------------------------------------------------------------------------
#simple error handler logger module
# Author: Sanjit Rath March 2006
# bugs mailto: sanjit.rath@oracle.com
#-------------------------------------------------------------------------------------
package ErrorHandler;
use strict;

sub new
{
	my ( $class, $format, $method, $logFile ) = @_;

	if ( $] < 5.008 )
	{
		die("Script requires perl version 5.8 or higher");
	}

	#private subroutine to return format strings
	sub __formatter
	{
		my ($formatString) = @_;
		my ( $file, $package, $line ) = ( __FILE__, __PACKAGE__, __LINE__ );
		$formatString =~ s/--file/$file/;
		$formatString =~ s/--package/$package/;
		$formatString =~ s/--line/$line/;
		return $formatString;
	}
	my $self = {
		__format => __formatter($format)
		,    #supported format values --package --file --line
		__method => defined($method) ? $method : 'normal',
		__logFile => ( defined($method) && $method eq 'log' )
		? ( defined($logFile) ? $logFile : die("log file not defined\n") )
		: 0
	};
}

sub error
{
	my ( $this, $msg ) = @_;
	my $errorMessage = $this->{__format} . $msg;
	if ( $this->{__method} eq 'normal' )
	{
		print STDERR $errorMessage;
	} elsif ( $this->{__method} eq 'log' )
	{

		#log yet to be implemented
		print STDERR $errorMessage;
	}

	#other logging options are yet to be coded
}

#static method to check arguments
#usage ErrorHandler::checkArgs(\@_,number_of_arguments); 
sub checkArgs
{
	my ( $listRef, $args ) = @_;
	my @list = @$listRef;
	my ( $file, $package, $line ) = ( __FILE__, __PACKAGE__, __LINE__ );
	if ( $#list >= ( $args - 1 ) )
	{
		return 1; 
	} else
	{
		die("Error: WrongNumber of Arguments:\nFile: $file\nPackage: $package\nLine: $line"); 
	}
}

1;    #return true

