package Task::Latemp;

use warnings;
use strict;

use 5.008;

=head1 NAME

Task::Latemp - Specifications for modules needed by the Latemp CMS.

=cut

our $VERSION = '0.0101';

=head1 DESCRIPTION

Latemp ( L<http://web-cpan.berlios.de/latemp/> ) is a Content Management
System based on Web Meta Language. This module install all of its
required dependencies.

=head1 AUTHOR

Shlomi Fish, C<< <shlomif at iglu.org.il> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-task-latemp at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Latemp>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::Latemp

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-Latemp>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-Latemp>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Latemp>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-Latemp>

=back

=head1 ACKNOWLEDGEMENTS

=head1 SEE ALSO

L<Task> .

=head1 COPYRIGHT & LICENSE

Copyright 2006 Shlomi Fish, all rights reserved.

This program is released under the following license: bsd

=cut

1; # End of Task::Latemp
