#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Net::Prometheus::ProcessCollector;

# known OS
SKIP: {
   skip "This collector only works on Linux", 1 unless $^O eq "linux";

   my $collector = Net::Prometheus::ProcessCollector->new;

   ok( defined $collector, '$collector is defined' );

   my @samples = $collector->collect;
   ok( scalar @samples, '$collector->collect gave some samples' );
}

# unknown OS
{
   ok( !defined Net::Prometheus::ProcessCollector->for_OS( "unknown" ),
      '->for_OS on unknown OS does not fail' );
}

done_testing;
