#! perl
use strict;
use warnings FATAL => 'all';

use CPAN::Meta;
use Test::More;
use Test::DZil;

my $tzil = Builder->from_config(
	{ dist_root => 't/does_not_exist' },
	{
		add_files => {
			'source/dist.ini' => simple_ini(
				[ ModuleBuildTiny => {
						version      => '0.030',
						minimum_perl => '5.008',
					}
				],
				'MetaJSON',
			),
		},
	},
);
$tzil->build;

my $VERSION = Dist::Zilla::Plugin::ModuleBuildTiny->VERSION;
my $expected = <<"END";
# This Build.PL for DZT-Sample was generated by Dist::Zilla::Plugin::ModuleBuildTiny $VERSION.
use 5.008;
use Module::Build::Tiny 0.030;
Build_PL();
END

is($tzil->built_in->file('Build.PL')->slurp, $expected, 'Build.PL is exactly like expected');

my $meta = CPAN::Meta->load_file($tzil->built_in->file('META.json'), { lazy_validation => 0 });
my $configure_requires = $meta->effective_prereqs->requirements_for('configure', 'requires')->as_string_hash;
is_deeply($configure_requires, { 'Module::Build::Tiny' => '0.030' } );

done_testing;
