package Kwiki::CachedDisplay;
use Kwiki::Plugin -Base;
our $VERSION = '0.01';

const class_id => 'cached_display';

sub register {
    my $reg = shift;
    $reg->add(hook => 'page:to_html', pre => 'load_cached_html');
    $reg->add(hook => 'page:store',  post => 'store_cached_html');
}

sub generate_html {
    my $page = shift;
    $self->hub->formatter->text_to_html($page->content);
}

sub cache_logic {
    my ($page,$update) = @_;
    my $html = io->catfile($self->plugin_directory,$page->id)->utf8->assert;
    my $return;
    unless($html->exists && !$update) {
        $return = $self->hub->formatter->text_to_html($page->content);
        $html->print($return);
    }
    return $return || $html->all;
}

sub load_cached_html {
    my $hook = pop;
    my $display = $self;
    $self = $display->hub->cached_display;
    my $page = $self->pages->current;
    if($page->exists) {
        $hook->cancel;
        return $self->cache_logic($page);
    }
}

sub store_cached_html {
    # $self is 'page' in this sub
    $self->hub->cached_display->cache_logic($self,"UPDATE");
}

__END__

=head1 NAME

  Kwiki::CachedDisplay - Speed-up Kwiki page display by caching

=head1 SYNOPSIS

  kwiki -add Kwiki::CachedDisplay

=head1 DESCRIPTION

This module use pre-generated page upon rendering, so that each
successive page-rendering takes no time in parsing and
template-processing. After you install this plugin, new pages will
automatically have pre-generated HTML copies on disk.  HTML copies for
old pages will be generated by next time anyone visit them.

If somehow you want to remove the generated HTML pages, they are under
C<plugin/cached_display> directory.

=head1 COPYRIGHT

Copyright 2005 by Kang-min Liu <gugod@gugod.org>.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

See <http://www.perl.com/perl/misc/Artistic.html>

=cut

