#ifndef SPVM_BASIC_TYPE_H
#define SPVM_BASIC_TYPE_H

#include <stdio.h>

#include "spvm_base.h"

enum {
  SPVM_BASIC_TYPE_C_ID_UNKNOWN,
  SPVM_BASIC_TYPE_C_ID_VOID,
  SPVM_BASIC_TYPE_C_ID_UNDEF,
  SPVM_BASIC_TYPE_C_ID_BYTE_REF,
  SPVM_BASIC_TYPE_C_ID_SHORT_REF,
  SPVM_BASIC_TYPE_C_ID_INT_REF,
  SPVM_BASIC_TYPE_C_ID_LONG_REF,
  SPVM_BASIC_TYPE_C_ID_FLOAT_REF,
  SPVM_BASIC_TYPE_C_ID_DOUBLE_REF,
  SPVM_BASIC_TYPE_C_ID_BYTE,
  SPVM_BASIC_TYPE_C_ID_SHORT,
  SPVM_BASIC_TYPE_C_ID_INT,
  SPVM_BASIC_TYPE_C_ID_LONG,
  SPVM_BASIC_TYPE_C_ID_FLOAT,
  SPVM_BASIC_TYPE_C_ID_DOUBLE,
  SPVM_BASIC_TYPE_C_ID_ANY_OBJECT,
};

enum {
  SPVM_BASIC_TYPE_C_CATEGORY_UNKNOWN,
  SPVM_BASIC_TYPE_C_CATEGORY_VOID,
  SPVM_BASIC_TYPE_C_CATEGORY_UNDEF,
  SPVM_BASIC_TYPE_C_CATEGORY_NUMERIC_REF,
  SPVM_BASIC_TYPE_C_CATEGORY_NUMERIC,
  SPVM_BASIC_TYPE_C_CATEGORY_ANY_OBJECT,
  SPVM_BASIC_TYPE_C_CATEGORY_CLASS,
  SPVM_BASIC_TYPE_C_CATEGORY_INTERFACE,
  SPVM_BASIC_TYPE_C_CATEGORY_POINTER,
  SPVM_BASIC_TYPE_C_CATEGORY_VALUE_T,
};

extern const char* const SPVM_BASIC_TYPE_C_ID_NAMES[];
extern const char* const SPVM_BASIC_TYPE_C_CATEGORY_NAMES[];

struct SPVM_basic_type {
  const char* name;
  int32_t id;
  int32_t category;
  SPVM_OP* op_package;
};

SPVM_BASIC_TYPE* SPVM_BASIC_TYPE_new(SPVM_COMPILER* compiler);

#endif
