#!perl
use strict;
use utf8;
use warnings 'all';

use Test::More;

use_ok('Text::Roman');

my $i = 0;
while (<DATA>) {
    my ($int, $roman) = /^(\d+)\s+([MDCLXVI]+)/x;

    ok($int && $roman, 'pair');
    ok(isroman($roman), 'isroman');
    ok(roman($int) eq $roman, 'roman');
    ok(roman2int($roman) == $int, 'roman2int');

    ++$i;
}

done_testing(1 + 4 * $i);

__DATA__
26	XXVI
27	XXVII
39	XXXIX
55	LV
128	CXXVIII
163	CLXIII
197	CXCVII
255	CCLV
257	CCLVII
312	CCCXII
366	CCCLXVI
373	CCCLXXIII
401	CDI
421	CDXXI
469	CDLXIX
532	DXXXII
536	DXXXVI
663	DCLXIII
687	DCLXXXVII
706	DCCVI
717	DCCXVII
747	DCCXLVII
764	DCCLXIV
897	DCCCXCVII
903	CMIII
931	CMXXXI
934	CMXXXIV
1072	MLXXII
1123	MCXXIII
1138	MCXXXVIII
1177	MCLXXVII
1233	MCCXXXIII
1411	MCDXI
1440	MCDXL
1481	MCDLXXXI
1488	MCDLXXXVIII
1492	MCDXCII
1573	MDLXXIII
1602	MDCII
1642	MDCXLII
1726	MDCCXXVI
1901	MCMI
1907	MCMVII
1991	MCMXCI
2003	MMIII
2021	MMXXI
2039	MMXXXIX
2213	MMCCXIII
2296	MMCCXCVI
2299	MMCCXCIX
2326	MMCCCXXVI
2345	MMCCCXLV
2351	MMCCCLI
2357	MMCCCLVII
2418	MMCDXVIII
2436	MMCDXXXVI
2499	MMCDXCIX
2593	MMDXCIII
2611	MMDCXI
2626	MMDCXXVI
2649	MMDCXLIX
2750	MMDCCL
2762	MMDCCLXII
2767	MMDCCLXVII
2848	MMDCCCXLVIII
2926	MMCMXXVI
2930	MMCMXXX
2939	MMCMXXXIX
2970	MMCMLXX
3001	MMMI
3108	MMMCVIII
3110	MMMCX
3123	MMMCXXIII
3138	MMMCXXXVIII
3192	MMMCXCII
3195	MMMCXCV
3215	MMMCCXV
3231	MMMCCXXXI
3252	MMMCCLII
3269	MMMCCLXIX
3271	MMMCCLXXI
3272	MMMCCLXXII
3407	MMMCDVII
3449	MMMCDXLIX
3461	MMMCDLXI
3489	MMMCDLXXXIX
3495	MMMCDXCV
3576	MMMDLXXVI
3653	MMMDCLIII
3666	MMMDCLXVI
3671	MMMDCLXXI
3674	MMMDCLXXIV
3682	MMMDCLXXXII
3701	MMMDCCI
3740	MMMDCCXL
3762	MMMDCCLXII
3813	MMMDCCCXIII
3837	MMMDCCCXXXVII
3934	MMMCMXXXIV
3939	MMMCMXXXIX
