package Acme::CPANAuthors::Japanese;

use strict;
use warnings;

our $VERSION = '0.130307';

use Acme::CPANAuthors::Register (
    ABUI      => 'DAISUKE ABUI',
    ACE       => 'yuichi tsunoda',
    ACIDLEMON => 'Masatoshi Kawazoe',
    ACOTIE    => 'Akiko Yokoyama',
    AERDAN    => 'Kiyoshi Aman',
    AGREW     => 'Naoyuki Okumura',
    AHIGUCHI  => 'Akira Higuchi',
    AHIGUTI   => 'Akira Higuchi',
    AHIROSE   => 'Akira HIROSE',
    AKIHITO   => 'Akihito Takeda',
    AKIRA     => 'Akira Hangai',
    AKIYM     => 'Takumi Akiyama',
    AKOBA     => 'Atsushi Kobayashi',
    AKXLIX    => 'azuma, kuniyuki',
    AMARISAN  => 'Ryoji Tanida',
    AMIMOTO   => 'Aki Mimoto',
    ANAZAWA   => 'Ryo Anazawa',
    AQL       => 'Tetsuya Toyoda',
    ARGRATH   => 'SHIRAKATA Kentaro',
    ARISAWA   => 'Kosuke Arisawa',
    ARUTEIDO  => 'satoshi ishikawa',
    ASAKURA   => 'ASAKURA Takuji',
    ASARIH    => 'Hiro Asari',
    ASKADNA   => 'Shinichiro Aska',
    AYANOKOUZ => 'AYANOKOUZI, Ryuunosuke',
    BANB      => 'ITO Nobuaki',
    BASHI     => 'Toshimasa Ishibashi',
    BAYASHI   => 'Dai Okabayashi',
    BAYSIDE   => 'Jun Shimizu',
    BOBPP     => 'Tadashi Matsuda',
    BOKUTIN   => 'Tomohiro Hosaka',
    BONAR     => 'Nakano Kyohei',
    BOXPHERE  => 'Satoshi Ohkubo',
    CASEY     => 'Keisuke Nagashima',
    CHIBA     => 'Masahiro Chiba',
    CLAIRVY   => 'NAGAYA Shinichiro',
    CLCL      => 'OONO Yoshitaka',
    COELA     => 'Satoshi Tamaki',
    COHTAN    => 'Kota Sakoda',
    CSIDE     => 'Hiroki Honda',
    DAEMONS   => 'MORI Shingo',
    DAIBA     => 'DAIBA, Keiichi',
    DAMEO     => 'Takashi Higashigata',
    DANJOU    => 'Nobuo Danjou',
    DANKOGAI  => 'Dan Kogai',
    DELPHINUS => 'JINNOUCHI Yasushi',
    DGSCOPE   => 'Masayuki Komori',
    DMAKI     => 'Daisuke Maki',
    DRAWNBOY  => 'Hideaki Tanaka',
    FNOBI     => 'Fujisawa Shin',
    FUJIMURA  => 'FUJIMURA Yuki',
    FUJISAWA  => 'Mizuki Fujisawa',
    FUJIWARA  => 'Fujiwara Shunichiro',
    FUKATA    => 'Tatsuya Fukata',
    FUKUDA    => 'Keisuke Fukuda',
    FUKUMURA  => 'Akinori Fukumura',
    FUTAYA    => 'Satoshi Futaya',
    GAOU      => 'Kazuharu Arakawa',
    GFUJI     => 'Goro Fuji',
    GOCCY     => 'Masaaki Goshima',
    GOLOGO    => 'Yohei Yamaguchi',
    GUNYA     => 'GUNYARA-KUN',
    HAKOBE    => 'Yohei Fushii',
    HAMANO    => 'Tsukasa Hamano',
    HANDLE    => 'NAGATA Hiroaki',
    HAOSAN    => 'Masafumi Yoshida',
    HAOYAYOI  => 'Soshi Tamura',
    HATA      => 'Masanori HATA',
    HATAK     => 'Hisashi HATAKEYAMA',
    HATTORI   => 'Fumiaki Hattori',
    HAYAJO    => 'Hayato Imai',
    HAYASHI   => 'Hiroo HAYASHI',
    HDAICHI   => 'daichi hiroki',
    HEDWIG    => 'Yusuke Sugiyama',
    HENTEKO   => 'Kenta Imai',
    HHORIUCHI => 'Hiroki Horiuchi',
    HIDE      => 'Hideo Kimura',
    HIDEDEN   => 'Hideyuki Kakiuchi',
    HIGU      => 'Higuchi hiroyuki',
    HIKARINE  => 'Hajime Kurita',
    HIMACHOCO => 'Wataru Seto',
    HIMAZU    => 'Hideyo Imazu',
    HIO       => 'YAMASHINA Hio',
    HIRAFOO   => 'Tomoya Hirano',
    HIRAMATSU => 'Kazutake Hiramatsu',
    HIRATA    => 'HIRATA Yasuyuki',
    HIRATARA  => 'Masahiro Honma',
    HIRO      => 'hiroshi kitano',
    HIROSE    => 'HIROSE Masaaki',
    HIROYUKI  => 'Hiroyuki Yamanaka',
    HIROYUKIM => 'Yamanaka Hiroyuki',
    HISAJU    => 'Kikumoto HIsatoshi',
    HRYK      => 'Hiroyuki Nakamura',
    HKOBA     => 'KOBAYASI, Hiroaki',
    HOKKE     => 'Yoichi Hirota',
    HOLLY     => 'Akira Horimoto',
    HORIUCHI  => 'Yasuhiro Horiuchi',
    HRK       => 'Haruka Kataoka',
    HWAT      => 'WATANABE Hiroaki',
    ICHI      => 'Takuya Ichikawa',
    IHARA     => 'Ikuhiro IHARA',
    IKEBE     => 'IKEBE Tomohiro',
    IKHRNET   => 'Tatsuya Ikehara',
    IKUTA     => 'Masahito Ikuta',
    IIZUKA    => 'Nao Iizuka',
    INA       => 'INABA Hitoshi',
    ISHIGAKI  => 'Kenichi Ishigaki',
    ISKATA    => 'Isao Katayama',
    ISOYA     => 'Ryohei Isoya',
    ISSM      => 'IWATA, Susumu',
    ITWARRIOR => 'Hitoshi Amano',
    IWAMATSU  => 'Nobuhiro Iwamatsu',
    JAMADAM   => 'Sugama Keita',
    JIRO      => 'Jiro Nishiguchi',
    JKONDO    => 'Junya Kondo',
    JUDIOO    => 'Udo Oji',
    JUNICHIRO => 'Junichiro Tobe',
    KAMIPO    => 'Ryuta Kamizono',
    KAMO      => 'Yoshikazu Kamoshida',
    KARUPA    => 'Kenta Sato',
    KAWABATA  => 'KAWABATA Kazumichi',
    KAWAMURAY => 'Yuto KAWAMURA',
    KAWASAKI  => 'Kawasaki Yusuke',
    KAZEBURO  => 'Masahiro Nagano',
    KAZUHISA  => 'KAZUHISA SUTO',
    KAZUHO    => 'Kazuho Oku',
    KAZUKIMA  => 'Kazuki MATSUDA',
    KAZUNORI  => 'Kazunori Minoda',
    KEISUKE   => 'Keisuke Kuramata',
    KENJIRO   => 'Kenjiro Hirakawa',
    KENSHIN   => 'Kenshin YAMADA',
    KENTARO   => 'Kentaro Kuribayashi',
    KIMATA    => 'Tetsuya KIMATA',
    KIMOTO    => 'Yuki Kimoto',
    KIMURA    => 'Takeshi Kimura',
    KINSAN    => 'Hitoshi Yokozawa',
    KISEKI    => 'keita iseki',
    KITAMAKI  => 'ryo kitamaki',
    KIWANAMI  => 'Masashi Sakurai',
    KMIYAZAKI => 'Keitaro Miyazaki',
    KNAGANO   => 'Keiichiro Nagano',
    KNOK      => 'NOKUBI Takatsugu',
    KOBAYASHI => 'Takeshi Kobayashi',
    KOBAYASI  => 'Hiroyuki Kobayasi',
    KOGA      => 'Seiki Koga',
    KOJIMAGI  => 'Koji Takiguchi',
    KOJUN     => 'Kojun Ueno',
    KOKOGIKO  => 'OHTSUKA Ko-hei',
    KOMORIYA  => 'Kazunari Komoriya',
    KONDO     => 'Yoshiyuki KONDO',
    KOPUG     => 'Masahiro Funakoshi',
    KOYACHI   => 'Tsutomu Koyachi',
    KSUZUKI   => 'Ken Suzuki',
    KTAKATA   => 'Ken Takata',
    KTAT      => 'Kato Atsushi',
    KTMK      => 'ryo kita',
    KUBOTA    => 'Tomohiro KUBOTA',
    KUMA      => 'KUMAGAI Kentaro',
    KUMAKATSU => 'katsuki ookuma',
    KUNIYOSHI => 'Kuniyoshi Kouji',
    KURIHARA  => 'Yoshiki KURIHARA',
    KURIYAMA  => 'Jun Kuriyama',
    KUZUHA    => 'Kuzuha SHINODA',
    KWATCH    => 'Makoto Kuwata',
    KWITKNR   => 'KAWAI, Takanori',
    KYANNY    => 'Kensuke Kaneko',
    KYO       => 'Kyo Nagashima',
    KYOKO     => 'N Kyoko',
    KYOMAIODP => 'Kyoma Takahashi',
    KYORO     => 'Kyosuke INOUE',
    KZFM      => 'Kazufumi Ohkawa',
    KZTOMITA  => 'Kazuyoshi Tomita',
    KZYS      => 'Kato Kazuyoshi',
    LAPIS     => 'Junichi Iwasaki',
    LIMITUSUS => 'Tomoya KABE',
    LURKER    => 'Takumi KIMOTO',
    LUSHE     => 'Masatoshi Mizuno',
    LYOKATO   => 'Lyo Kato',
    MACOPY    => 'Makoto Taniwaki',
    MAGICDRIV => 'Hiroshi IKEGAMI',
    MAHIRO    => 'Mahiro Ando',
    MAHITO    => 'Hogelist',
    MAIDO     => 'Masahiro Funakoshi',
    MAKAMAKA  => 'Makamaka Hannyaharamitu',
    MAKOTO    => 'Shin Honda',
    MAND      => 'Yuki Manno',
    MAOE      => 'Mitsutoshi Aoe',
    MASAHITO  => 'Masahito Yoshida',
    MASAKI    => 'NAKAGAWA Masaki',
    MASANORIH => 'Masanori Hara',
    MASAO     => 'Masao Kitamura',
    MASAP     => 'Masahiro Funakoshi',
    MASARTZ   => 'Masaru Hoshino',
    MASUTARO  => 'Kotaro MASUDA',
    MATSUMOTO => 'syushi matsumoto',
    MATTN     => 'Yasuhiro Matsumoto',
    MIKAGE    => 'SANO Taku',
    MIKI      => 'Takeshi Miki',
    MIKIHOSHI => 'KAN Fushihara',
    MIKIO     => 'Mikio Hirabayashi',
    MILANO    => 'Tsukui Akihiro',
    MINORU    => 'KAWAMOTO Minoru',
    MIYAGAWA  => 'Tatsuhiko Miyagawa',
    MIYAMUKO  => 'MIYAMUKO Katsuyuki',
    MIYAZAKI  => 'Ittetsu Miyazaki',
    MIZZY     => 'Gosuke Miyashita',
    MONMON    => 'Nobuo Kumagai',
    MORIYA    => 'Moriya Masaki',
    MOZNION   => 'Taiki Kawakami',
    MRMT      => 'Jun Morimoto',
    MUGENKEN  => 'Mugen Kenichi',
    MURATA    => 'Shingo Murata',
    MURATAYA  => 'MURATA Yasuhisa',
    MUYOSHI   => 'Mutsutoshi Yoshimoto',
    MYB       => 'Masayuki Iwai',
    MYUJI     => 'Yuji Maeda',
    NABESHIMA => 'Masaaki NABESHIMA',
    NAGATA    => 'Ichito Nagata',
    NAITO     => 'Naoyuki Ito',
    NANZOU    => 'Takaaki Mizuno',
    NAOKIURAI => 'Naoki URAI',
    NAOY      => 'Naoyuki Ito',
    NAOYA     => 'Naoya Ito',
    NAOYAT    => 'Naoya "naochan" Tozuka',
    NAOYUKI   => 'Naoyuki Ito',
    NARAZAKA  => 'N Narazaka',
    NARITOSHI => 'Naritoshi Hayashi',
    NARUSE    => 'NARUSE, Yui',
    NEJIGANE  => 'Yu Nejigane',
    NEKOKAK   => 'Atsushi Kobayashi',
    NEKOYA    => 'Ryo Miyake',
    NEZUMI    => 'IKEDA Soji',
    NGS       => 'Atsushi NAGASE',
    NISHIGAYA => 'NISHIGAYA, Yuki',
    NISHIKAWA => 'Kazuhiro Nishikawa',
    NODAJUN   => 'JUNICHI NODA',
    NOGUCHI   => 'Tatsuya Noguchi',
    NORITAKA  => 'Noritaka Okabe',
    NOZZZZZ   => 'Tetsunari Nozaki',
    NTSUTSUMI => 'Naoya Tsutsumi',
    NYARLA    => 'Naoki Okamura',
    OGATA     => 'OGATA Tetsuji',
    OGAWA     => 'Hirotaka Ogawa',
    OKAMUUU   => 'Masao Okamura',
    OINUME    => 'Kazuhiro Oinuma',
    OISHI     => 'Eisuke Oishi',
    ONISHI    => 'Yasuhiro Onishi',
    OUEST     => 'Daisuke NISHISAKA',
    OVERLAST  => 'Toshinori Sato',
    OYAMA     => 'Hiroyuki OYAMA',
    OZAWA     => 'OZAWA Sakuro',
    PAINA     => 'SATO Taisuke',
    PAPIX     => 'Takayuki Fukumoto',
    PAWAPAWA  => 'Kohei Yoshioka',
    PEN       => 'Abe Masahiro',
    PERFORB   => 'Yusuke Maeda',
    PIA       => 'Michiya Honda',
    PIROLIX   => 'Hiroyuki UENISHI',
    POCKET    => 'Masato Sogame',
    POPPEN    => 'Shinsuke Matsui',
    QUEEN     => 'Yasuhiro Miyazaki',
    RINTARO   => 'Rintaro Ishizaki',
    RITOU     => 'Ryo Ito',
    RIYWO     => 'Ryosuke IWANAGA',
    ROZARY    => 'Syunsuke Fujishiro',
    RYM       => 'Takayuki Murakami',
    RYOCHIN   => 'Okamoto RYO',
    SADAHIRO  => 'SADAHIRO Tomoyuki',
    SASAO     => 'SASAO Takahiro',
    SASAZUKA  => 'Seiji Sasazuka',
    SATOH     => 'cho45 (SATOH, Hiroh)',
    SATOSIN   => 'Shinichiro Sato',
    SATZZ     => 'Akihiko SATODA',
    SAWAMUR   => 'Masaki  Sawamura',
    SAYANO    => 'Satoru Yano',
    SEAGIRL   => 'Takuho Yoshizu',
    SEI       => 'Shinichiro Sei',
    SEKIMURA  => 'Masayoshi Sekimura',
    SERA      => 'Kazuhiro Sera',
    SEYN      => 'Yasushi Nakajima',
    SHARADA   => 'Seiji Harada',
    SHIBAZAKI => 'Yuki Shibazaki',
    SHIBUYA   => 'Kazuhiro Shibuya',
    SHIGETA   => 'Takatsugu Shigeta',
    SHIGIO    => 'Shigio Yamaguchi',
    SHIKONO   => 'Shinji KONO',
    SHIMAZU   => 'Yuki SHIMAZU',
    SHIMI     => 'Kazuhito Shimizu',
    SHINPEI   => 'HAYASHI, Shinpei',
    SHIRAIWA  => 'Kazuma Shiraiwa',
    SHMORIMO  => 'Shigeki Morimoto',
    SHOHEIK   => 'Shohei Kameda',
    SHOT      => 'Shota Takayama',
    SKJM      => 'Shin Kojima',
    SKONNO    => 'Satoshi Konno',
    SKUBOTA   => 'Satoshi KUBOTA',
    SKYFIVE   => 'Takeshi Ohishi',
    SNGJOKEN  => 'Shingo Kikugawa',
    SNUMANO   => 'Shugo Numano',
    SONGMU    => 'Masayuki Matsuki',
    SOTSA     => 'Shinichiro Sato',
    SSEI      => 'Shinichiro Sei',
    STAKASHIO => 'Shin Takashio',
    SUGMAK    => 'Makoto Sugiyama',
    SUGYAN    => 'Yoshihiro Sugi',
    SUHARA    => 'Yoshihiko Suhara',
    SUZUKI    => 'Yuji Suzuki',
    SYAGI     => 'Satoshi Yagi',
    SYNCLOVER => 'Naoya Sato',
    SYOHEX    => 'Syohei Yoshida',
    SYSTEMS   => 'Ken Suzuki',
    SZARATE   => 'Santiago Zarate',
    TABAYASHI => 'Tetsuya Tabayashi',
    TAC       => 'Takuya Iida',
    TADOKORO  => 'hiroshi tadokoro',
    TAGOMORIS => 'Satoshi Tagomori',
    TAILRIVER => 'Shinsuke Ogawa',
    TAIY      => 'Taisuke Yamada',
    TAKASH    => 'shuhei takahashi',
    TAKASHI   => 'Takashi Saeki',
    TAKAYUKI  => 'Takayuki Ikeda',
    TAKEFUMI  => 'KIMURA, takefumi',
    TAKEO     => 'Takeo Suzuki',
    TAKERU    => 'Takeru INOUE',
    TAKESAKO  => 'Yoshinori TAKESAKO',
    TAKESHI   => 'tee wada',
    TAKESHIGE => 'Ken Takeshige',
    TAKESHUN  => 'Shun Takeyama',
    TAKKYUN   => 'Takayuki Ikeda',
    TAKIMO    => 'Shinya Takimoto',
    TAKUJI    => 'Nishibayashi Takuji',
    TAKUMI    => 'Takumi Hayashi',
    TAMAKOTO  => 'Tanaka Makoto',
    TAMASHIRO => 'Yuji Tamashiro',
    TANABE    => 'Hisao Tanabe',
    TNAGA     => 'Tomohide Nagasima',
    TANIGUCHI => 'Koichi Taniguchi',
    TANIMOTO  => 'Satoshi Tanimoto',
    TARO      => 'Daisuke Komatsu',
    TAROK     => 'Taro Kawagishi',
    TATENO    => 'Yuichi Tateno',
    TAWAN     => 'Taro Funaki',
    THORIKAWA => 'Takahiro Horikawa',
    TKURITA   => 'Tetsuro KURITA',
    TMAESAKA  => 'Toru Maesaka',
    TNISHINO  => 'Taro Nishino',
    TOAMANO   => 'Tomoo Amano',
    TOCIYUKI  => 'MIZUTANI, Tociyuki',
    TODA      => 'Yusuke Toda',
    TOHAE     => 'tohae wakizaka',
    TOKUBASS  => 'Kouji Tominaga',
    TOKUHIROM => 'MATSUNO Tokuhiro',
    TOMITA    => 'Naoki Tomita',
    TOMYHERO  => 'Tomohiro Teranishi',
    TONODERA  => 'Takahiro Onodera',
    TOONA     => 'Naoto Ishikawa',
    TOPIA     => 'Tatuya Noda',
    TORU      => 'Toru Hisai',
    TOSHIFJW  => 'Toshimitsu FUJIWARA',
    TOSHIOITO => 'Toshio Ito',
    TRAVAIL   => 'Tomoyuki SAWA',
    TSAITO    => 'Toshiyuki Saito',
    TSUCCHI   => 'Takuya Tsuchida',
    TSUKAMOTO => 'Makio Tsukamoto',
    TSUNODA   => 'TSUNODA Kazuya',
    TURUGINA  => 'KATOU Akira',
    TXIWASAKI => 'Tooru Iwasaki',
    TYANO     => 'Tatsuhiro YANO',
    TYPESTER  => 'Daisuke Murase',
    TYRU      => 'Takuya Fujiwara',
    UASI      => 'Tomoki Aonuma',
    UCHIKO    => 'Kousuke Uchiyama',
    UGUTOMO   => 'Tomohiro Horiuchi',
    UMEMOTO   => 'Hajimu Umemoto',
    UMEYUKI   => 'Hiromitsu Ito',
    UNLEARNED => 'Takashi Uesugi',
    USUALOMA  => 'Taku Amano',
    UTAANI    => 'Takeshi Ueno',
    WAKAPON   => 'ASANO Kazunari',
    WATA      => 'Kouji Watanabe',
    WATANABE  => 'WATANABE Hirofumi',
    WOREMACX  => 'Wore Macx',
    XAICRON   => 'Yuji Shimada',
    XOR       => 'Izumi Kawashima',
    XCEZX     => 'Tsuyoshi Maekawa',
    YAKEX     => 'Yasutaka ATARASHI',
    YAMAKURA  => 'Kazuhiko Yamakura',
    YAMAMOTO  => 'Ryuzo Yamamoto',
    YAMATO    => 'Toshiyuki Yamato',
    YANA      => 'Toshimitu Yanagisawa',
    YANBE     => 'Yusuke Yanbe',
    YANMAR    => 'Yamamoto Keiichiro',
    YAPPO     => 'Kazuhiro Osawa',
    YASU      => 'Yasushi Saito',
    YASUHIRO  => 'Yasuhiro Onishi',
    YAYOHEI   => 'Yohei Yamamoto',
    YIBE      => 'Yuki Ibe',
    YISHINO   => 'Yukio Ishino',
    YOSHIAKI  => 'Yoshiaki Shiokawa',
    YOSHIDA   => 'Hironori Yoshida',
    YOSHIMI   => 'Keiji Yoshimi',
    YOSHIOKA  => 'Yuki Yoshioka',
    YOSTY     => 'Koji Komatsu',
    YSAS      => 'Yasuhiro Sasama',
    YSASAKI   => 'Yoshihiro Sasaki',
    YSHIBATA  => 'Yusuke Shibata',
    YSUZUKI   => 'Yoshihiro SUZUKI',
    YTAKEUCH  => 'TAKEUCHI, Yoji',
    YTURTLE   => 'Satoshi Azuma',
    YUKI      => 'Yuki ANAI',
    YUKINOBU  => 'NAGAYASU Yukinobu',
    YUKIO     => 'Yukio Suzuki',
    YUMATSUMO => 'yuya matsumoto',
    YOKKUNS   => 'Yohei Sato',
    YUPUG     => 'Yu Isobe',
    YUSUKE    => 'Yusuke Shibata',
    YUSUKEBE  => 'Yusuke Wada',
    YUTA      => 'MASUDA Yuta',
    YUUKI     => 'Yuuki Tsubouchi',
    YUYAW     => 'Yuya Watanabe',
    YWATASE   => 'Yusuke Watase',
    ZENTOOO   => 'Naosuke Yokoe',
    ZIGOROU   => 'Toru Yamaguchi',
    ZIGUZAGU  => 'Hiroshi Sakai',
);

1;

__END__

=head1 NAME

Acme::CPANAuthors::Japanese - We are Japanese CPAN authors

=head1 DESCRIPTION

This class provides a hash of Japanese CPAN authors' Pause ID/name to Acme::CPANAuthors.

=head1 MAINTENANCE

If you are a Japanese CPAN author not listed here, send me an email or a pull request to add your own id/name. If you are listed but are not Japanese (or just don't want to be listed), sorry to bother you but tell me via email, IRC, or RT. I'll remove.

=head1 REPOSITORY

https://github.com/charsbar/acme-cpanauthors-japanese

=head1 AUTHOR

Kenichi Ishigaki, E<lt>ishigaki at cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 by Kenichi Ishigaki.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
