package Task::Devel::Essentials;

use 5.006;
use strict;
use warnings;

=head1 NAME

Task::Devel::Essentials - Bundle of modules useful for developers

=head1 VERSION

Version 0.006

=cut

our $VERSION = '0.006';

=head1 SYNOPSIS

  # to install a couple of modules useful for developers in one go,
  # execute one of the commands below:

  cpan Task::Devel::Essentials
  cpanm Task::Devel::Essentials
  cpanp i Task::Devel::Essentials

=head1 MODULES

=over 4

=item L<App::CPANTS::Lint>

=item L<Archive::Tar>

=item L<Archive::Zip>

=item L<Assert::Conditional>

=item L<Contextual::Return>

=item L<CPAN>

=item L<CPAN::Reporter>

=item L<Data::Dumper>

=item L<Data::Dumper::Simple>

=item L<Data::Printer>

=item L<DateTime>

=item L<Devel::Cover>

=item L<Devel::NYTProf>

=item L<Devel::StackTrace>

=item L<Digest::SHA>

=item L<Dist::Zilla>

=item L<Encode>

=item L<ExtUtils::CBuilder>

=item L<ExtUtils::MakeMaker>

=item L<File::HomeDir>

=item L<File::ShareDir>

=item L<File::Spec>

=item L<File::Temp>

=item L<File::Which>

=item L<Getopt::Long>

=item L<Inline>

=item L<IO::Compress::Base>

=item L<IO::Zlib>

=item L<Iterator::Diamond>

=item L<JSON>

=item L<Kwalify>

=item L<List::MoreUtils>

=item L<LWP>

=item L<MIME::Base64>

=item L<MIME::Lite>

=item L<Modern::Perl>

=item L<Module::CoreList>

=item L<Module::CPANTS::Analyse>

=item L<Module::Install>

=item L<Module::Signature>

=item L<Module::Starter>

=item L<Module::Version>

=item L<Moo>

=item L<Moose>

=item L<Mouse>

=item L<Net::FTP>

=item L<Params::Check>

=item L<Parse::CPAN::Meta>

=item L<Perl::Critic>

=item L<Readonly>

=item L<Regexp::Common>

=item L<Role::Basic>

=item L<Scalar::Util>

=item L<Term::ReadKey>

=item L<Term::ReadLine>

=item L<Term::ReadLine::Gnu> (optional)

=item L<Test::Class>

=item L<Test::Differences>

=item L<Test::Exception>

=item L<Test::Fatal>

=item L<Test::Harness>

=item L<Test::MockModule>

=item L<Test::More>

=item L<Test::NoWarnings>

=item L<Test::Output>

=item L<Test::Pod>

=item L<Test::Pod::Coverage>

=item L<Test::Portability::Files>

=item L<Test::Regexp>

=item L<Test::Reporter::Transport::Metabase>

=item L<Test::Requires>

=item L<Test::Signature>

=item L<Test::Simple>

=item L<Test::Warn>

=item L<Test2::Suite>

=item L<Text::Glob>

=item L<Try::Tiny>

=item L<Type::Tiny>

=item L<YAML>

=item L<YAML::Syck>

=back

=head1 AUTHOR

Martin Becker, C<< <mhasch at cpan.org> >>

=head1 LICENSE AND COPYRIGHT

Copyright 2013-2017 Martin Becker.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut

1;

__END__
