#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "easyspice.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


#define DIALOG_BORDER_SPACING 5
#define DIALOG_V_SPACING 8
#define DIALOG_H_SPACING 10
#define DIALOG_INDENTATION 10

GtkWidget*
create_toplevel_window (EasySpice *easyspice)
{
  GtkWidget *window_prin;
  GtkWidget *vbox2;
  GtkWidget *menubar1;
  GtkWidget *fichier1;
  GtkWidget *menu_file;
  GtkAccelGroup *menu_file_accels;
  GtkWidget *menu_file_new;
  GtkWidget *menu_file_open;
  GtkWidget *menu_file_save;
  GtkWidget *menu_file_saveas;
  GtkWidget *sparateur2;
  GtkWidget *menu_file_quit;
  GtkWidget *options1;
  GtkWidget *menu_options;
  GtkAccelGroup *menu_options_accels;
  GtkWidget *menu_options_commands;
  GtkWidget *menu_options_library;
  GtkWidget *menu_options_gschem;
  GtkWidget *s_parateur3;
  GtkWidget *menu_options_save;
  GtkWidget *fen_tre1;
  GtkWidget *menu_windows;
  GtkAccelGroup *menu_windows_accels;
  GtkWidget *menu_windows_simulcommands;
  GtkWidget *menu_windows_plotcommands;
  GtkWidget *separateure;
  GtkWidget *menu_windows_spiceinteractive;
  GtkWidget *sparateur_t;
  GtkWidget *menu_windows_postproc;
  GtkWidget *menu_windows_plotresult;
  GtkWidget *help1;
  GtkWidget *help1_menu;
  GtkAccelGroup *help1_menu_accels;
  GtkWidget *menu_help_about;
  GtkWidget *menu_help_spiceman;
  GtkWidget *menu_help_spicehtml;
  GtkWidget *menu_help_spicehelp;
  GtkWidget *hbuttonbox9;
  GtkWidget *visu_schem;
  GtkWidget *gen_netlist;
  GtkWidget *visu_netlist;
  GtkWidget *alignment1;
  GtkWidget *notebook2;
  GtkWidget *vbox_op;
  GtkWidget *hbox42;
  GtkWidget *label14;
  GtkWidget *hseparator34;
  GtkWidget *op_listing;
  GtkWidget *op_param_view;
  GtkWidget *op_op_view_schem;
  GtkWidget *hseparator35;
  GtkWidget *op_ok;
  GtkWidget *hseparator84;
  GtkWidget *op_hbox_polarisation;
  GtkWidget *label154;
  GtkWidget *vseparator4;
  GtkWidget *label155;
  GtkWidget *op_node_combo;
  GtkWidget *op_node;
  GtkWidget *label156;
  GtkWidget *op_polarisation_value;
  GtkWidget *hseparator85;
  GtkWidget *op_hbox_device;
  GtkWidget *label157;
  GtkWidget *op_device_combo;
  GtkWidget *op_device;
  GtkWidget *label158;
  GtkWidget *op_item_combo;
  GtkWidget *op_item;
  GtkWidget *label159;
  GtkWidget *op_device_value;
  GtkWidget *label_op;
  GtkWidget *vbox_dc;
  GtkWidget *label18;
  GtkWidget *hseparator24;
  GtkWidget *hbox5;
  GtkWidget *vbox7;
  GtkWidget *hbox6;
  GtkWidget *label29;
  GtkWidget *hbox7;
  GtkWidget *toto1;
  GtkWidget *dc_source1_combo;
  GtkWidget *dc_source1;
  GtkWidget *hbox8;
  GtkWidget *dc_start1;
  GtkWidget *toto2;
  GtkWidget *hbox9;
  GtkWidget *toto3;
  GtkWidget *dc_stop1;
  GtkWidget *hbox10;
  GtkWidget *toto4;
  GtkWidget *dc_inc1;
  GtkWidget *vseparator1;
  GtkWidget *vbox8;
  GtkWidget *hbox11;
  GtkWidget *label30;
  GtkWidget *hbox12;
  GtkWidget *label25;
  GtkWidget *dc_source2_combo;
  GtkWidget *dc_source2;
  GtkWidget *hbox13;
  GtkWidget *label26;
  GtkWidget *dc_start2;
  GtkWidget *hbox14;
  GtkWidget *label27;
  GtkWidget *dc_stop2;
  GtkWidget *hbox15;
  GtkWidget *label28;
  GtkWidget *dc_inc2;
  GtkWidget *hseparator28;
  GtkWidget *dc_ok;
  GtkWidget *label_dc;
  GtkWidget *vbox_ac;
  GtkWidget *label31;
  GtkWidget *hseparator42;
  GtkWidget *hbox67;
  GtkWidget *label32;
  GSList *hbox67_group = NULL;
  GtkWidget *ac_dec;
  GtkWidget *ac_lin;
  GtkWidget *ac_oct;
  GtkWidget *hseparator44;
  GtkWidget *hbox68;
  GtkWidget *ac_label_step;
  GtkWidget *ac_nombre;
  GtkWidget *hbox69;
  GtkWidget *label34;
  GtkWidget *ac_fmin;
  GtkWidget *hbox70;
  GtkWidget *label35;
  GtkWidget *ac_fmax;
  GtkWidget *hseparator43;
  GtkWidget *ac_ok;
  GtkWidget *label_ac;
  GtkWidget *vbox_noise;
  GtkWidget *label132;
  GtkWidget *hseparator64;
  GtkWidget *hbox81;
  GtkWidget *label137;
  GtkWidget *noise_node_combo;
  GtkWidget *noise_node;
  GtkWidget *hbox82;
  GtkWidget *label138;
  GtkWidget *noise_source_combo;
  GtkWidget *noise_source;
  GtkWidget *hseparator67;
  GtkWidget *hbox77;
  GtkWidget *label133;
  GSList *hbox77_group = NULL;
  GtkWidget *noise_dec;
  GtkWidget *noise_lin;
  GtkWidget *noise_oct;
  GtkWidget *hseparator65;
  GtkWidget *hbox78;
  GtkWidget *noise_label_step;
  GtkWidget *noise_nombre;
  GtkWidget *hbox79;
  GtkWidget *label135;
  GtkWidget *noise_fmin;
  GtkWidget *hbox80;
  GtkWidget *label136;
  GtkWidget *noise_fmax;
  GtkWidget *hseparator66;
  GtkWidget *noise_ok;
  GtkWidget *label131;
  GtkWidget *vbox_tran;
  GtkWidget *label36;
  GtkWidget *hseparator30;
  GtkWidget *hbox71;
  GtkWidget *label37;
  GtkWidget *tran_tstep;
  GtkWidget *hbox72;
  GtkWidget *label38;
  GtkWidget *tran_tstop;
  GtkWidget *hbox73;
  GtkWidget *label39;
  GtkWidget *tran_tstart;
  GtkWidget *hbox74;
  GtkWidget *label116;
  GtkWidget *tran_tmax;
  GtkWidget *hseparator45;
  GtkWidget *tran_ok;
  GtkWidget *label_tran;
  GtkWidget *vbox25;
  GtkWidget *label89;
  GtkWidget *hseparator53;
  GtkWidget *hbox49;
  GtkWidget *label90;
  GtkWidget *tf_output_combo;
  GtkWidget *tf_output;
  GtkWidget *hbox50;
  GtkWidget *label91;
  GtkWidget *tf_source_combo;
  GtkWidget *tf_source;
  GtkWidget *hseparator3;
  GtkWidget *tf_ok;
  GtkWidget *result_tf;
  GtkWidget *vbox_param;
  GtkWidget *label129;
  GtkWidget *hseparator63;
  GtkWidget *param_enable;
  GtkWidget *hseparator62;
  GtkWidget *param_hbox_name;
  GtkWidget *label123;
  GtkWidget *param_name_combo;
  GtkWidget *param_name;
  GtkWidget *param_hbox_param;
  GtkWidget *label130;
  GtkWidget *param_param;
  GtkWidget *hseparator61;
  GtkWidget *param_hbox_val;
  GtkWidget *vbox37;
  GtkWidget *label124;
  GSList *vbox37_group = NULL;
  GtkWidget *param_lin;
  GtkWidget *param_dec;
  GtkWidget *param_list;
  GtkWidget *vseparator2;
  GtkWidget *vbox38;
  GtkWidget *param_hbox_start;
  GtkWidget *label125;
  GtkWidget *param_start;
  GtkWidget *param_hbox_stop;
  GtkWidget *label126;
  GtkWidget *param_stop;
  GtkWidget *param_hbox_step;
  GtkWidget *param_label_step;
  GtkWidget *param_step;
  GtkWidget *param_hbox_list;
  GtkWidget *label128;
  GtkWidget *param_values;
  GtkWidget *label_param;
  GtkWidget *plot_vbox;
  GtkWidget *label140;
  GtkWidget *hseparator79;
  GtkWidget *label150;
  GtkWidget *scrolledwindow15;
  GtkWidget *plot_pre_text;
  GtkWidget *hbox85;
  GtkWidget *hseparator69;
  GtkWidget *hbox83;
  GtkWidget *label142;
  GtkWidget *vbox43;
  GSList *x_axis_group = NULL;
  GtkWidget *plot_xdefault;
  GtkWidget *hbox93;
  GtkWidget *plot_xscale_value;
  GtkWidget *plot_x;
  GtkWidget *vbox42;
  GtkWidget *plot_xlog_scale;
  GtkWidget *plot_xlin_scale;
  GtkWidget *hseparator71;
  GtkWidget *hbox84;
  GtkWidget *label143;
  GtkWidget *plot_y;
  GtkWidget *plot_ylog_scale;
  GtkWidget *hseparator74;
  GtkWidget *hbox86;
  GtkWidget *plot_auto_update;
  GtkWidget *plot_reset;
  GtkWidget *hseparator70;
  GtkWidget *plot_ok;
  GtkWidget *label139;
  GtkWidget *notebook3;
  GtkWidget *scrolledwindow12;
  GtkWidget *text_log;
  GtkWidget *hbox97;
  GtkWidget *label163;
  GtkWidget *pixmap_log_ok;
  GtkWidget *pixmap_log_false;
  GtkWidget *scrolledwindow1;
  GtkWidget *text_spice_output;
  GtkWidget *hbox94;
  GtkWidget *label145;
  GtkWidget *viewerspiceoutput;
  GtkWidget *scrolledwindow13;
  GtkWidget *text_spice_error;
  GtkWidget *label146;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  window_prin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window_prin), "window_prin", window_prin);
  gtk_window_set_title (GTK_WINDOW (window_prin), "easy_spice");
  gtk_window_set_policy (GTK_WINDOW (window_prin), FALSE, TRUE, TRUE);

  vbox2 = gtk_vbox_new (FALSE, DIALOG_V_SPACING);
  gtk_container_set_border_width(GTK_CONTAINER(vbox2), DIALOG_BORDER_SPACING);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (window_prin), vbox2);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_ref (menubar1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menubar1", menubar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox2), menubar1, FALSE, FALSE, 0);

  fichier1 = gtk_menu_item_new_with_label (_("File"));
  gtk_widget_ref (fichier1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "fichier1", fichier1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fichier1);
  gtk_container_add (GTK_CONTAINER (menubar1), fichier1);

  menu_file = gtk_menu_new ();
  gtk_widget_ref (menu_file);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file", menu_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (fichier1), menu_file);
  //  menu_file_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (menu_file));

  menu_file_new = gtk_menu_item_new_with_label (_("New project"));
  gtk_widget_ref (menu_file_new);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file_new", menu_file_new, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_file_new);
  gtk_container_add (GTK_CONTAINER (menu_file), menu_file_new);

  menu_file_open = gtk_menu_item_new_with_label (_("Open project"));
  gtk_widget_ref (menu_file_open);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file_open", menu_file_open, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_file_open);
  gtk_container_add (GTK_CONTAINER (menu_file), menu_file_open);

  menu_file_save = gtk_menu_item_new_with_label (_("Save project"));
  gtk_widget_ref (menu_file_save);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file_save", menu_file_save,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_file_save);
  gtk_container_add (GTK_CONTAINER (menu_file), menu_file_save);

  menu_file_saveas = gtk_menu_item_new_with_label (_("Save as..."));
  gtk_widget_ref (menu_file_saveas);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file_saveas", menu_file_saveas, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_file_saveas);
  gtk_container_add (GTK_CONTAINER (menu_file), menu_file_saveas);

  sparateur2 = gtk_menu_item_new ();
  gtk_widget_ref (sparateur2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "sparateur2", sparateur2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sparateur2);
  gtk_container_add (GTK_CONTAINER (menu_file), sparateur2);
  gtk_widget_set_sensitive (sparateur2, FALSE);

  menu_file_quit = gtk_menu_item_new_with_label (_("Quit"));
  gtk_widget_ref (menu_file_quit);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_file_quit", menu_file_quit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_file_quit);
  gtk_container_add (GTK_CONTAINER (menu_file), menu_file_quit);

  options1 = gtk_menu_item_new_with_label (_("Options"));
  gtk_widget_ref (options1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "options1", options1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (options1);
  gtk_container_add (GTK_CONTAINER (menubar1), options1);

  menu_options = gtk_menu_new ();
  gtk_widget_ref (menu_options);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_options", menu_options,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (options1), menu_options);
  //  menu_options_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (menu_options));

  menu_options_commands = gtk_menu_item_new_with_label (_("commands ..."));
  gtk_widget_ref (menu_options_commands);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_options_commands", menu_options_commands,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_options_commands);
  gtk_container_add (GTK_CONTAINER (menu_options), menu_options_commands);

  menu_options_library = gtk_menu_item_new_with_label (_("spice libraries ..."));
  gtk_widget_ref (menu_options_library);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_options_library", menu_options_library,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_options_library);
  gtk_container_add (GTK_CONTAINER (menu_options), menu_options_library);

  menu_options_gschem = gtk_menu_item_new_with_label (_("gEDA options ..."));
  gtk_widget_ref (menu_options_gschem);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "gschem1", menu_options_gschem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_options_gschem);
  gtk_container_add (GTK_CONTAINER (menu_options), menu_options_gschem);

  s_parateur3 = gtk_menu_item_new ();
  gtk_widget_ref (s_parateur3);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "s_parateur3", s_parateur3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (s_parateur3);
  gtk_container_add (GTK_CONTAINER (menu_options), s_parateur3);
  gtk_widget_set_sensitive (s_parateur3, FALSE);

  menu_options_save = gtk_menu_item_new_with_label(_("Save options"));
  gtk_widget_ref(menu_options_save);
  gtk_object_set_data_full(GTK_OBJECT(window_prin), "menu_options_save", menu_options_save,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(menu_options_save);
  gtk_container_add (GTK_CONTAINER (menu_options), menu_options_save);

  fen_tre1 = gtk_menu_item_new_with_label (_("Window"));
  gtk_widget_ref (fen_tre1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "fen_tre1", fen_tre1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fen_tre1);
  gtk_container_add (GTK_CONTAINER (menubar1), fen_tre1);

  menu_windows = gtk_menu_new ();
  gtk_widget_ref (menu_windows);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows", menu_windows,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (fen_tre1), menu_windows);
  //  menu_windows_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (menu_windows));

  menu_windows_simulcommands = gtk_menu_item_new_with_label (_("show simul commands"));
  gtk_widget_ref (menu_windows_simulcommands);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows_simulcommands", menu_windows_simulcommands,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_windows_simulcommands);
  gtk_container_add (GTK_CONTAINER (menu_windows), menu_windows_simulcommands);

  menu_windows_plotcommands = gtk_menu_item_new_with_label (_("show plot commands"));
  gtk_widget_ref (menu_windows_plotcommands);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows_plotcommands", menu_windows_plotcommands,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_windows_plotcommands);
  gtk_container_add (GTK_CONTAINER (menu_windows), menu_windows_plotcommands);

  separateure = gtk_menu_item_new ();
  gtk_widget_ref (separateure);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "separateure", separateure,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separateure);
  gtk_container_add (GTK_CONTAINER (menu_windows), separateure);
  gtk_widget_set_sensitive (separateure, FALSE);

  menu_windows_spiceinteractive = gtk_menu_item_new_with_label (_("interactive spice"));
  gtk_widget_ref (menu_windows_spiceinteractive);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows_spiceinteractive", menu_windows_spiceinteractive,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_windows_spiceinteractive);
  gtk_container_add (GTK_CONTAINER (menu_windows), menu_windows_spiceinteractive);

  sparateur_t = gtk_menu_item_new ();
  gtk_widget_ref (sparateur_t);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "sparateur_t", sparateur_t,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (sparateur_t);
  gtk_container_add (GTK_CONTAINER (menu_windows), sparateur_t);
  gtk_widget_set_sensitive (sparateur_t, FALSE);

  menu_windows_postproc = gtk_menu_item_new_with_label (_("post processing"));
  gtk_widget_ref (menu_windows_postproc);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows_postproc", menu_windows_postproc,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_windows_postproc);
  gtk_container_add (GTK_CONTAINER (menu_windows), menu_windows_postproc);

  menu_windows_plotresult = gtk_menu_item_new_with_label (_("plot results"));
  gtk_widget_ref (menu_windows_plotresult);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_windows_plotresult", menu_windows_plotresult,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_windows_plotresult);
  gtk_container_add (GTK_CONTAINER (menu_windows), menu_windows_plotresult);

  help1 = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_ref (help1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "help1", help1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help1);
  gtk_container_add (GTK_CONTAINER (menubar1), help1);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (help1));

  help1_menu = gtk_menu_new ();
  gtk_widget_ref (help1_menu);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "help1_menu", help1_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help1), help1_menu);
  //  help1_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (help1_menu));

  menu_help_about = gtk_menu_item_new_with_label (_("About"));
  gtk_widget_ref (menu_help_about);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_help_about", menu_help_about,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_help_about);
  gtk_container_add (GTK_CONTAINER (help1_menu), menu_help_about);

  menu_help_spiceman = gtk_menu_item_new_with_label (_("Page man spice"));
  gtk_widget_ref (menu_help_spiceman);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_help_spiceman", menu_help_spiceman,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_help_spiceman);
  gtk_container_add (GTK_CONTAINER (help1_menu), menu_help_spiceman);

  menu_help_spicehtml = gtk_menu_item_new_with_label (_("doc spice (html)"));
  gtk_widget_ref (menu_help_spicehtml);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_help_spicehtml", menu_help_spicehtml,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_help_spicehtml);
  gtk_container_add (GTK_CONTAINER (help1_menu), menu_help_spicehtml);

  menu_help_spicehelp = gtk_menu_item_new_with_label (_("doc spice (txt)"));
  gtk_widget_ref (menu_help_spicehelp);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "menu_help_spicehelp", menu_help_spicehelp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menu_help_spicehelp);
  gtk_container_add (GTK_CONTAINER (help1_menu), menu_help_spicehelp);

  hbuttonbox9 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox9);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbuttonbox9", hbuttonbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox9);
  gtk_box_pack_start (GTK_BOX (vbox2), hbuttonbox9, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox9), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox9), 0);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox9), 0, 6);
  gtk_button_box_set_child_ipadding (GTK_BUTTON_BOX (hbuttonbox9), 0, 0);

  visu_schem = gtk_button_new_with_label (_("Edit the \nschematic"));
  gtk_widget_ref (visu_schem);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "visu_schem", visu_schem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (visu_schem);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), visu_schem);
  GTK_WIDGET_SET_FLAGS (visu_schem, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, visu_schem, _("edit the schematic using gschem"), NULL);

  gen_netlist = gtk_button_new_with_label (_("Create the \nnetlist"));
  gtk_widget_ref (gen_netlist);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "gen_netlist", gen_netlist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gen_netlist);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), gen_netlist);
  GTK_WIDGET_SET_FLAGS (gen_netlist, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, gen_netlist, _("create the netlist from the schematic"), NULL);

  visu_netlist = gtk_button_new_with_label (_("Show the \nnetlist"));
  gtk_widget_ref (visu_netlist);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "visu_netlist", visu_netlist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (visu_netlist);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), visu_netlist);
  GTK_WIDGET_SET_FLAGS (visu_netlist, GTK_CAN_DEFAULT);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_ref (alignment1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "alignment1", alignment1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (alignment1);
  gtk_box_pack_start (GTK_BOX (vbox2), alignment1, FALSE, FALSE, 0);

  notebook2 = gtk_notebook_new ();
  gtk_widget_ref (notebook2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "notebook2", notebook2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook2);
  gtk_container_add (GTK_CONTAINER (alignment1), notebook2);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook2), FALSE);
  gtk_notebook_set_tab_hborder (GTK_NOTEBOOK (notebook2), 7);
  gtk_notebook_set_tab_vborder (GTK_NOTEBOOK (notebook2), 0);

  vbox_op = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_op);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_op", vbox_op,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_op);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_op);

  hbox42 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox42);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox42", hbox42,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox42);
  gtk_box_pack_start (GTK_BOX (vbox_op), hbox42, FALSE, FALSE, 0);

  label14 = gtk_label_new (_("Operating point calculation"));
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (hbox42), label14, TRUE, FALSE, 0);
  gtk_widget_set_usize (label14, -2, 44);

  hseparator34 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator34);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator34", hseparator34,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator34);
  gtk_box_pack_start (GTK_BOX (vbox_op), hseparator34, FALSE, TRUE, 1);

  op_listing = gtk_check_button_new_with_label (_("See the circuit listing"));
  gtk_widget_ref (op_listing);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_listing", op_listing,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_listing);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_listing, FALSE, FALSE, 0);

  op_param_view = gtk_check_button_new_with_label (_("See the model used"));
  gtk_widget_ref (op_param_view);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_param_view", op_param_view,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_param_view);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_param_view, FALSE, FALSE, 0);

  op_op_view_schem = gtk_check_button_new_with_label (_("show the results on the schematic"));
  gtk_widget_ref (op_op_view_schem);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_op_view_schem", op_op_view_schem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_op_view_schem);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_op_view_schem, FALSE, FALSE, 0);

  hseparator35 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator35);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator35", hseparator35,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator35);
  gtk_box_pack_start (GTK_BOX (vbox_op), hseparator35, FALSE, TRUE, 3);

  op_ok = gtk_button_new_with_label (_("Simulate OP"));
  gtk_widget_ref (op_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_ok", op_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_ok);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_ok, TRUE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, op_ok, _("start the op simulation. See the results on the spice output window"), NULL);

  hseparator84 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator84);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator84", hseparator84,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator84);
  gtk_box_pack_start (GTK_BOX (vbox_op), hseparator84, FALSE, TRUE, 3);

  op_hbox_polarisation = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (op_hbox_polarisation);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_hbox_polarisation", op_hbox_polarisation,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_hbox_polarisation);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_hbox_polarisation, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (op_hbox_polarisation, FALSE);

  label154 = gtk_label_new (_("Polarisation"));
  gtk_widget_ref (label154);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label154", label154,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label154);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), label154, FALSE, FALSE, 2);
  gtk_label_set_justify (GTK_LABEL (label154), GTK_JUSTIFY_LEFT);

  vseparator4 = gtk_vseparator_new ();
  gtk_widget_ref (vseparator4);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vseparator4", vseparator4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vseparator4);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), vseparator4, TRUE, TRUE, 0);

  label155 = gtk_label_new (_("Node\nor current"));
  gtk_widget_ref (label155);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label155", label155,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label155);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), label155, FALSE, FALSE, 2);
  gtk_label_set_justify (GTK_LABEL (label155), GTK_JUSTIFY_RIGHT);

  op_node_combo = gtk_combo_new ();
  gtk_widget_ref (op_node_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_node_combo", op_node_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_node_combo);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), op_node_combo, FALSE, TRUE, 6);

  op_node = GTK_COMBO (op_node_combo)->entry;
  gtk_widget_ref (op_node);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_node", op_node,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_node);
  gtk_widget_set_usize (op_node, 80, -2);

  label156 = gtk_label_new (_("Value"));
  gtk_widget_ref (label156);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label156", label156,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label156);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), label156, FALSE, FALSE, 0);

  op_polarisation_value = gtk_entry_new ();
  gtk_widget_ref (op_polarisation_value);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_polarisation_value", op_polarisation_value,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_polarisation_value);
  gtk_box_pack_start (GTK_BOX (op_hbox_polarisation), op_polarisation_value, FALSE, TRUE, 2);
  gtk_widget_set_usize (op_polarisation_value, 80, -2);
  gtk_entry_set_editable (GTK_ENTRY (op_polarisation_value), FALSE);

  hseparator85 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator85);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator85", hseparator85,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator85);
  gtk_box_pack_start (GTK_BOX (vbox_op), hseparator85, FALSE, TRUE, 2);

  op_hbox_device = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (op_hbox_device);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_hbox_device", op_hbox_device,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_hbox_device);
  gtk_box_pack_start (GTK_BOX (vbox_op), op_hbox_device, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (op_hbox_device, FALSE);

  label157 = gtk_label_new (_("Device:"));
  gtk_widget_ref (label157);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label157", label157,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label157);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), label157, FALSE, FALSE, 2);

  op_device_combo = gtk_combo_new ();
  gtk_widget_ref (op_device_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_device_combo", op_device_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_device_combo);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), op_device_combo, FALSE, TRUE, 2);

  op_device = GTK_COMBO (op_device_combo)->entry;
  gtk_widget_ref (op_device);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_device", op_device,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_device);
  gtk_widget_set_usize (op_device, 80, -2);

  label158 = gtk_label_new (_("Item"));
  gtk_widget_ref (label158);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label158", label158,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label158);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), label158, FALSE, FALSE, 2);

  op_item_combo = gtk_combo_new ();
  gtk_widget_ref (op_item_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_item_combo", op_item_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_item_combo);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), op_item_combo, FALSE, TRUE, 2);

  op_item = GTK_COMBO (op_item_combo)->entry;
  gtk_widget_ref (op_item);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_item", op_item,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_item);
  gtk_widget_set_usize (op_item, 80, -2);

  label159 = gtk_label_new (_("Value"));
  gtk_widget_ref (label159);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label159", label159,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label159);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), label159, FALSE, FALSE, 2);

  op_device_value = gtk_entry_new ();
  gtk_widget_ref (op_device_value);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "op_device_value", op_device_value,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (op_device_value);
  gtk_box_pack_start (GTK_BOX (op_hbox_device), op_device_value, FALSE, TRUE, 2);
  gtk_widget_set_usize (op_device_value, 80, -2);

  label_op = gtk_label_new (_("op"));
  gtk_widget_ref (label_op);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label_op", label_op,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_op);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 0), label_op);

  vbox_dc = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_dc);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_dc", vbox_dc,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_dc);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_dc);

  label18 = gtk_label_new (_("dc sweep"));
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (vbox_dc), label18, TRUE, FALSE, 0);

  hseparator24 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator24);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator24", hseparator24,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator24);
  gtk_box_pack_start (GTK_BOX (vbox_dc), hseparator24, FALSE, TRUE, 2);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox_dc), hbox5, FALSE, TRUE, 0);

  vbox7 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox7);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox7", vbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox7);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox7, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox6, FALSE, FALSE, 0);

  label29 = gtk_label_new (_("First var"));
  gtk_widget_ref (label29);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label29", label29,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label29);
  gtk_box_pack_start (GTK_BOX (hbox6), label29, TRUE, FALSE, 0);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox7, FALSE, TRUE, 0);

  toto1 = gtk_label_new (_("Source : "));
  gtk_widget_ref (toto1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "toto1", toto1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toto1);
  gtk_box_pack_start (GTK_BOX (hbox7), toto1, FALSE, FALSE, 0);
  gtk_widget_set_usize (toto1, 76, -2);
  gtk_label_set_justify (GTK_LABEL (toto1), GTK_JUSTIFY_LEFT);

  dc_source1_combo = gtk_combo_new ();
  gtk_widget_ref (dc_source1_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_source1_combo", dc_source1_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_source1_combo);
  gtk_box_pack_end (GTK_BOX (hbox7), dc_source1_combo, FALSE, TRUE, 2);

  dc_source1 = GTK_COMBO (dc_source1_combo)->entry;
  gtk_widget_ref (dc_source1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_source1", dc_source1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_source1);
  gtk_widget_set_usize (dc_source1, 80, -2);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox8);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox8", hbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox8, FALSE, TRUE, 0);

  dc_start1 = gtk_entry_new ();
  gtk_widget_ref (dc_start1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_start1", dc_start1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_start1);
  gtk_box_pack_end (GTK_BOX (hbox8), dc_start1, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_start1, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_start1, _("the first value of the sweep"), NULL);

  toto2 = gtk_label_new (_("Start : "));
  gtk_widget_ref (toto2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "toto2", toto2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toto2);
  gtk_box_pack_start (GTK_BOX (hbox8), toto2, FALSE, FALSE, 0);
  gtk_widget_set_usize (toto2, 76, -2);
  gtk_label_set_justify (GTK_LABEL (toto2), GTK_JUSTIFY_LEFT);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox9);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox9", hbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox9, FALSE, TRUE, 0);

  toto3 = gtk_label_new (_("Stop : "));
  gtk_widget_ref (toto3);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "toto3", toto3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toto3);
  gtk_box_pack_start (GTK_BOX (hbox9), toto3, FALSE, FALSE, 0);
  gtk_widget_set_usize (toto3, 76, -2);
  gtk_label_set_justify (GTK_LABEL (toto3), GTK_JUSTIFY_RIGHT);

  dc_stop1 = gtk_entry_new ();
  gtk_widget_ref (dc_stop1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_stop1", dc_stop1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_stop1);
  gtk_box_pack_end (GTK_BOX (hbox9), dc_stop1, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_stop1, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_stop1, _("the last value of the sweep"), NULL);

  hbox10 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox10);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox10", hbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox10, FALSE, TRUE, 0);

  toto4 = gtk_label_new (_("Inc : "));
  gtk_widget_ref (toto4);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "toto4", toto4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toto4);
  gtk_box_pack_start (GTK_BOX (hbox10), toto4, FALSE, FALSE, 0);
  gtk_widget_set_usize (toto4, 76, -2);
  gtk_label_set_justify (GTK_LABEL (toto4), GTK_JUSTIFY_RIGHT);

  dc_inc1 = gtk_entry_new ();
  gtk_widget_ref (dc_inc1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_inc1", dc_inc1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_inc1);
  gtk_box_pack_end (GTK_BOX (hbox10), dc_inc1, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_inc1, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_inc1, _("the increment of the sweep"), NULL);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_ref (vseparator1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vseparator1", vseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox5), vseparator1, FALSE, FALSE, 6);

  vbox8 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox8);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox8", vbox8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox8);
  gtk_box_pack_start (GTK_BOX (hbox5), vbox8, TRUE, TRUE, 0);

  hbox11 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox11);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox11", hbox11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox11, FALSE, TRUE, 0);

  label30 = gtk_label_new (_("Second var(Optional)"));
  gtk_widget_ref (label30);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label30", label30,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label30);
  gtk_box_pack_start (GTK_BOX (hbox11), label30, FALSE, FALSE, 0);

  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox12);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox12", hbox12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox12);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox12, FALSE, TRUE, 2);

  label25 = gtk_label_new (_("Source : "));
  gtk_widget_ref (label25);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label25", label25,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (hbox12), label25, FALSE, FALSE, 0);
  gtk_widget_set_usize (label25, 76, -2);

  dc_source2_combo = gtk_combo_new ();
  gtk_widget_ref (dc_source2_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_source2_combo", dc_source2_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_source2_combo);
  gtk_box_pack_end (GTK_BOX (hbox12), dc_source2_combo, FALSE, TRUE, 2);

  dc_source2 = GTK_COMBO (dc_source2_combo)->entry;
  gtk_widget_ref (dc_source2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_source2", dc_source2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_source2);
  gtk_widget_set_usize (dc_source2, 80, -2);

  hbox13 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox13);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox13", hbox13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox13);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox13, FALSE, TRUE, 2);

  label26 = gtk_label_new (_("Start : "));
  gtk_widget_ref (label26);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label26", label26,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label26);
  gtk_box_pack_start (GTK_BOX (hbox13), label26, FALSE, FALSE, 0);
  gtk_widget_set_usize (label26, 76, -2);

  dc_start2 = gtk_entry_new ();
  gtk_widget_ref (dc_start2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_start2", dc_start2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_start2);
  gtk_box_pack_end (GTK_BOX (hbox13), dc_start2, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_start2, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_start2, _("the first value of the sweep"), NULL);

  hbox14 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox14);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox14", hbox14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox14);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox14, FALSE, TRUE, 0);

  label27 = gtk_label_new (_("Stop : "));
  gtk_widget_ref (label27);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label27", label27,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label27);
  gtk_box_pack_start (GTK_BOX (hbox14), label27, FALSE, FALSE, 0);
  gtk_widget_set_usize (label27, 76, -2);

  dc_stop2 = gtk_entry_new ();
  gtk_widget_ref (dc_stop2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_stop2", dc_stop2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_stop2);
  gtk_box_pack_end (GTK_BOX (hbox14), dc_stop2, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_stop2, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_stop2, _("the last value of the sweep"), NULL);

  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox15);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox15", hbox15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox15, FALSE, TRUE, 0);

  label28 = gtk_label_new (_("Inc "));
  gtk_widget_ref (label28);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label28", label28,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label28);
  gtk_box_pack_start (GTK_BOX (hbox15), label28, FALSE, FALSE, 0);
  gtk_widget_set_usize (label28, 76, -2);

  dc_inc2 = gtk_entry_new ();
  gtk_widget_ref (dc_inc2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_inc2", dc_inc2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_inc2);
  gtk_box_pack_end (GTK_BOX (hbox15), dc_inc2, FALSE, TRUE, 2);
  gtk_widget_set_usize (dc_inc2, 80, -2);
  gtk_tooltips_set_tip (tooltips, dc_inc2, _("the last value of the sweep"), NULL);

  hseparator28 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator28);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator28", hseparator28,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator28);
  gtk_box_pack_start (GTK_BOX (vbox_dc), hseparator28, FALSE, TRUE, 2);

  dc_ok = gtk_button_new_with_label (_("Simulate DC"));
  gtk_widget_ref (dc_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "dc_ok", dc_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dc_ok);
  gtk_box_pack_start (GTK_BOX (vbox_dc), dc_ok, TRUE, FALSE, 0);

  label_dc = gtk_label_new (_("dc"));
  gtk_widget_ref (label_dc);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label_dc", label_dc,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_dc);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 1), label_dc);

  vbox_ac = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_ac);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_ac", vbox_ac,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_ac);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_ac);

  label31 = gtk_label_new (_("Small signal analysis"));
  gtk_widget_ref (label31);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label31", label31,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (vbox_ac), label31, TRUE, FALSE, 0);

  hseparator42 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator42);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator42", hseparator42,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator42);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hseparator42, FALSE, TRUE, 2);

  hbox67 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox67);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox67", hbox67,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox67);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hbox67, FALSE, TRUE, 0);

  label32 = gtk_label_new (_("Type of analysis"));
  gtk_widget_ref (label32);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label32", label32,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox67), label32, FALSE, FALSE, 5);

  ac_dec = gtk_radio_button_new_with_label (hbox67_group, _("DEC"));
  hbox67_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ac_dec));
  gtk_widget_ref (ac_dec);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_dec", ac_dec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_dec);
  gtk_box_pack_start (GTK_BOX (hbox67), ac_dec, TRUE, FALSE, 0);

  ac_lin = gtk_radio_button_new_with_label (hbox67_group, _("LIN"));
  hbox67_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ac_lin));
  gtk_widget_ref (ac_lin);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_lin", ac_lin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_lin);
  gtk_box_pack_start (GTK_BOX (hbox67), ac_lin, TRUE, FALSE, 0);

  ac_oct = gtk_radio_button_new_with_label (hbox67_group, _("OCT"));
  hbox67_group = gtk_radio_button_group (GTK_RADIO_BUTTON (ac_oct));
  gtk_widget_ref (ac_oct);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_oct", ac_oct,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_oct);
  gtk_box_pack_start (GTK_BOX (hbox67), ac_oct, TRUE, FALSE, 0);

  hseparator44 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator44);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator44", hseparator44,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator44);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hseparator44, FALSE, TRUE, 2);

  hbox68 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox68);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox68", hbox68,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox68);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hbox68, FALSE, TRUE, 2);

  ac_label_step = gtk_label_new (_("Pts/decade"));
  gtk_widget_ref (ac_label_step);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_label_step", ac_label_step,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_label_step);
  gtk_box_pack_start (GTK_BOX (hbox68), ac_label_step, FALSE, FALSE, 5);

  ac_nombre = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (ac_nombre);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_nombre", ac_nombre,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_nombre);
  gtk_box_pack_end (GTK_BOX (hbox68), ac_nombre, FALSE, TRUE, 2);
  gtk_tooltips_set_tip (tooltips, ac_nombre, _("Number of points per decade(DEC) or per octave(OCT) or between fmin and fmax"), NULL);

  hbox69 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox69);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox69", hbox69,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox69);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hbox69, FALSE, TRUE, 2);

  label34 = gtk_label_new (_("fmin"));
  gtk_widget_ref (label34);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label34", label34,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (hbox69), label34, FALSE, FALSE, 5);

  ac_fmin = gtk_entry_new ();
  gtk_widget_ref (ac_fmin);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_fmin", ac_fmin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_fmin);
  gtk_box_pack_end (GTK_BOX (hbox69), ac_fmin, FALSE, TRUE, 2);
  gtk_tooltips_set_tip (tooltips, ac_fmin, _("first value for the ac analysis"), NULL);

  hbox70 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox70);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox70", hbox70,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox70);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hbox70, FALSE, TRUE, 2);

  label35 = gtk_label_new (_("fmax"));
  gtk_widget_ref (label35);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label35", label35,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label35);
  gtk_box_pack_start (GTK_BOX (hbox70), label35, FALSE, FALSE, 5);

  ac_fmax = gtk_entry_new ();
  gtk_widget_ref (ac_fmax);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_fmax", ac_fmax,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_fmax);
  gtk_box_pack_end (GTK_BOX (hbox70), ac_fmax, FALSE, TRUE, 3);
  gtk_tooltips_set_tip (tooltips, ac_fmax, _("last value for the ac analysis"), NULL);

  hseparator43 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator43);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator43", hseparator43,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator43);
  gtk_box_pack_start (GTK_BOX (vbox_ac), hseparator43, FALSE, TRUE, 2);

  ac_ok = gtk_button_new_with_label (_("Simulate AC"));
  gtk_widget_ref (ac_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "ac_ok", ac_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ac_ok);
  gtk_box_pack_start (GTK_BOX (vbox_ac), ac_ok, TRUE, FALSE, 2);
  gtk_tooltips_set_tip (tooltips, ac_ok, _("start the ac analysis"), NULL);

  label_ac = gtk_label_new (_("ac"));
  gtk_widget_ref (label_ac);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label_ac", label_ac,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ac);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 2), label_ac);

  vbox_noise = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_noise);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_noise", vbox_noise,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_noise);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_noise);

  label132 = gtk_label_new (_("Noise analysis"));
  gtk_widget_ref (label132);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label132", label132,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label132);
  gtk_box_pack_start (GTK_BOX (vbox_noise), label132, FALSE, FALSE, 0);

  hseparator64 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator64);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator64", hseparator64,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator64);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hseparator64, FALSE, TRUE, 2);

  hbox81 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox81);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox81", hbox81,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox81);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox81, FALSE, TRUE, 2);

  label137 = gtk_label_new (_("Node"));
  gtk_widget_ref (label137);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label137", label137,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label137);
  gtk_box_pack_start (GTK_BOX (hbox81), label137, FALSE, FALSE, 2);

  noise_node_combo = gtk_combo_new ();
  gtk_widget_ref (noise_node_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_node_combo", noise_node_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_node_combo);
  gtk_box_pack_end (GTK_BOX (hbox81), noise_node_combo, FALSE, TRUE, 2);

  noise_node = GTK_COMBO (noise_node_combo)->entry;
  gtk_widget_ref (noise_node);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_node", noise_node,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_node);
  gtk_widget_set_usize (noise_node, 80, -2);

  hbox82 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox82);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox82", hbox82,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox82);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox82, FALSE, TRUE, 2);

  label138 = gtk_label_new (_("Source"));
  gtk_widget_ref (label138);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label138", label138,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label138);
  gtk_box_pack_start (GTK_BOX (hbox82), label138, FALSE, FALSE, 2);

  noise_source_combo = gtk_combo_new ();
  gtk_widget_ref (noise_source_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_source_combo", noise_source_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_source_combo);
  gtk_box_pack_end (GTK_BOX (hbox82), noise_source_combo, FALSE, TRUE, 2);

  noise_source = GTK_COMBO (noise_source_combo)->entry;
  gtk_widget_ref (noise_source);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_source", noise_source,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_source);
  gtk_widget_set_usize (noise_source, 80, -2);

  hseparator67 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator67);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator67", hseparator67,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator67);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hseparator67, FALSE, TRUE, 2);

  hbox77 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox77);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox77", hbox77,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox77);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox77, FALSE, TRUE, 0);

  label133 = gtk_label_new (_("Type of analysis"));
  gtk_widget_ref (label133);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label133", label133,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label133);
  gtk_box_pack_start (GTK_BOX (hbox77), label133, FALSE, FALSE, 5);

  noise_dec = gtk_radio_button_new_with_label (hbox77_group, _("DEC"));
  hbox77_group = gtk_radio_button_group (GTK_RADIO_BUTTON (noise_dec));
  gtk_widget_ref (noise_dec);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_dec", noise_dec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_dec);
  gtk_box_pack_start (GTK_BOX (hbox77), noise_dec, TRUE, FALSE, 0);

  noise_lin = gtk_radio_button_new_with_label (hbox77_group, _("LIN"));
  hbox77_group = gtk_radio_button_group (GTK_RADIO_BUTTON (noise_lin));
  gtk_widget_ref (noise_lin);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_lin", noise_lin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_lin);
  gtk_box_pack_start (GTK_BOX (hbox77), noise_lin, TRUE, FALSE, 0);

  noise_oct = gtk_radio_button_new_with_label (hbox77_group, _("OCT"));
  hbox77_group = gtk_radio_button_group (GTK_RADIO_BUTTON (noise_oct));
  gtk_widget_ref (noise_oct);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_oct", noise_oct,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_oct);
  gtk_box_pack_start (GTK_BOX (hbox77), noise_oct, TRUE, FALSE, 0);

  hseparator65 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator65);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator65", hseparator65,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator65);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hseparator65, FALSE, TRUE, 2);

  hbox78 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox78);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox78", hbox78,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox78);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox78, FALSE, TRUE, 2);

  noise_label_step = gtk_label_new (_("Pts/Decade"));
  gtk_widget_ref (noise_label_step);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_label_step", noise_label_step,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_label_step);
  gtk_box_pack_start (GTK_BOX (hbox78), noise_label_step, FALSE, FALSE, 5);

  noise_nombre = gtk_entry_new_with_max_length (25);
  gtk_widget_ref (noise_nombre);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_nombre", noise_nombre,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_nombre);
  gtk_box_pack_end (GTK_BOX (hbox78), noise_nombre, FALSE, TRUE, 3);
  gtk_widget_set_usize (noise_nombre, 80, -2);
  gtk_tooltips_set_tip (tooltips, noise_nombre, _("Number of points per decade(DEC) or per octave(OCT) or between fmin and fmax"), NULL);

  hbox79 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox79);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox79", hbox79,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox79);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox79, FALSE, TRUE, 2);

  label135 = gtk_label_new (_("fmin"));
  gtk_widget_ref (label135);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label135", label135,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label135);
  gtk_box_pack_start (GTK_BOX (hbox79), label135, FALSE, FALSE, 5);

  noise_fmin = gtk_entry_new ();
  gtk_widget_ref (noise_fmin);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_fmin", noise_fmin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_fmin);
  gtk_box_pack_end (GTK_BOX (hbox79), noise_fmin, FALSE, TRUE, 3);
  gtk_widget_set_usize (noise_fmin, 80, -2);
  gtk_tooltips_set_tip (tooltips, noise_fmin, _("first value for the ac analysis"), NULL);

  hbox80 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox80);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox80", hbox80,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox80);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hbox80, FALSE, TRUE, 2);

  label136 = gtk_label_new (_("fmax"));
  gtk_widget_ref (label136);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label136", label136,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label136);
  gtk_box_pack_start (GTK_BOX (hbox80), label136, FALSE, FALSE, 5);

  noise_fmax = gtk_entry_new ();
  gtk_widget_ref (noise_fmax);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_fmax", noise_fmax,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_fmax);
  gtk_box_pack_end (GTK_BOX (hbox80), noise_fmax, FALSE, TRUE, 3);
  gtk_widget_set_usize (noise_fmax, 80, -2);
  gtk_tooltips_set_tip (tooltips, noise_fmax, _("last value for the ac analysis"), NULL);

  hseparator66 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator66);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator66", hseparator66,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator66);
  gtk_box_pack_start (GTK_BOX (vbox_noise), hseparator66, FALSE, TRUE, 2);

  noise_ok = gtk_button_new_with_label (_("Simulate Noise"));
  gtk_widget_ref (noise_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "noise_ok", noise_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (noise_ok);
  gtk_box_pack_start (GTK_BOX (vbox_noise), noise_ok, FALSE, FALSE, 2);
  gtk_tooltips_set_tip (tooltips, noise_ok, _("start the ac analysis"), NULL);

  label131 = gtk_label_new (_("noise"));
  gtk_widget_ref (label131);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label131", label131,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label131);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 3), label131);

  vbox_tran = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_tran);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_tran", vbox_tran,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_tran);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_tran);

  label36 = gtk_label_new (_("Transient analysis"));
  gtk_widget_ref (label36);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label36", label36,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label36);
  gtk_box_pack_start (GTK_BOX (vbox_tran), label36, TRUE, FALSE, 2);

  hseparator30 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator30);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator30", hseparator30,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator30);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hseparator30, FALSE, TRUE, 2);

  hbox71 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox71);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox71", hbox71,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox71);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hbox71, FALSE, TRUE, 2);

  label37 = gtk_label_new (_("tstep"));
  gtk_widget_ref (label37);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label37", label37,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label37);
  gtk_box_pack_start (GTK_BOX (hbox71), label37, FALSE, FALSE, 4);

  tran_tstep = gtk_entry_new ();
  gtk_widget_ref (tran_tstep);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tran_tstep", tran_tstep,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tran_tstep);
  gtk_box_pack_end (GTK_BOX (hbox71), tran_tstep, FALSE, TRUE, 2);
  gtk_tooltips_set_tip (tooltips, tran_tstep, _("the time step report"), NULL);

  hbox72 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox72);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox72", hbox72,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox72);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hbox72, FALSE, TRUE, 2);

  label38 = gtk_label_new (_("tstop"));
  gtk_widget_ref (label38);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label38", label38,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label38);
  gtk_box_pack_start (GTK_BOX (hbox72), label38, FALSE, FALSE, 4);

  tran_tstop = gtk_entry_new ();
  gtk_widget_ref (tran_tstop);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tran_tstop", tran_tstop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tran_tstop);
  gtk_box_pack_end (GTK_BOX (hbox72), tran_tstop, FALSE, TRUE, 2);
  gtk_tooltips_set_tip (tooltips, tran_tstop, _("the last value of the transient analysis "), NULL);

  hbox73 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox73);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox73", hbox73,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox73);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hbox73, FALSE, TRUE, 2);

  label39 = gtk_label_new (_("tstart(opt)"));
  gtk_widget_ref (label39);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label39", label39,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (hbox73), label39, FALSE, FALSE, 4);

  tran_tstart = gtk_entry_new ();
  gtk_widget_ref (tran_tstart);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tran_tstart", tran_tstart,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tran_tstart);
  gtk_box_pack_end (GTK_BOX (hbox73), tran_tstart, FALSE, TRUE, 2);
  gtk_tooltips_set_tip (tooltips, tran_tstart, _("the first value for the analysis (default 0)"), NULL);

  hbox74 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox74);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox74", hbox74,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox74);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hbox74, FALSE, TRUE, 2);

  label116 = gtk_label_new (_("tmax (opt)"));
  gtk_widget_ref (label116);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label116", label116,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label116);
  gtk_box_pack_start (GTK_BOX (hbox74), label116, FALSE, FALSE, 4);

  tran_tmax = gtk_entry_new ();
  gtk_widget_ref (tran_tmax);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tran_tmax", tran_tmax,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tran_tmax);
  gtk_box_pack_end (GTK_BOX (hbox74), tran_tmax, FALSE, TRUE, 2);

  hseparator45 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator45);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator45", hseparator45,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator45);
  gtk_box_pack_start (GTK_BOX (vbox_tran), hseparator45, FALSE, TRUE, 2);

  tran_ok = gtk_button_new_with_label (_("Simulate TRAN"));
  gtk_widget_ref (tran_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tran_ok", tran_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tran_ok);
  gtk_box_pack_start (GTK_BOX (vbox_tran), tran_ok, TRUE, FALSE, 2);
  gtk_tooltips_set_tip (tooltips, tran_ok, _("start the transient analysis"), NULL);

  label_tran = gtk_label_new (_("tran"));
  gtk_widget_ref (label_tran);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label_tran", label_tran,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_tran);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 4), label_tran);

  vbox25 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox25);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox25", vbox25,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox25);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox25);

  label89 = gtk_label_new (_("Calculate a transfert function"));
  gtk_widget_ref (label89);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label89", label89,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label89);
  gtk_box_pack_start (GTK_BOX (vbox25), label89, TRUE, FALSE, 0);

  hseparator53 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator53);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator53", hseparator53,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator53);
  gtk_box_pack_start (GTK_BOX (vbox25), hseparator53, FALSE, TRUE, 2);

  hbox49 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox49);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox49", hbox49,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox49);
  gtk_box_pack_start (GTK_BOX (vbox25), hbox49, FALSE, TRUE, 2);

  label90 = gtk_label_new (_("Output var :"));
  gtk_widget_ref (label90);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label90", label90,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label90);
  gtk_box_pack_start (GTK_BOX (hbox49), label90, FALSE, FALSE, 2);
  gtk_label_set_justify (GTK_LABEL (label90), GTK_JUSTIFY_RIGHT);

  tf_output_combo = gtk_combo_new ();
  gtk_widget_ref (tf_output_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tf_output_combo", tf_output_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tf_output_combo);
  gtk_box_pack_end (GTK_BOX (hbox49), tf_output_combo, FALSE, TRUE, 2);

  tf_output = GTK_COMBO (tf_output_combo)->entry;
  gtk_widget_ref (tf_output);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tf_output", tf_output,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tf_output);
  gtk_widget_set_usize (tf_output, 80, -2);

  hbox50 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox50);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox50", hbox50,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox50);
  gtk_box_pack_start (GTK_BOX (vbox25), hbox50, FALSE, FALSE, 2);

  label91 = gtk_label_new (_("Source : "));
  gtk_widget_ref (label91);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label91", label91,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label91);
  gtk_box_pack_start (GTK_BOX (hbox50), label91, FALSE, FALSE, 4);
  gtk_widget_set_usize (label91, 96, -2);
  gtk_label_set_justify (GTK_LABEL (label91), GTK_JUSTIFY_LEFT);

  tf_source_combo = gtk_combo_new ();
  gtk_widget_ref (tf_source_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tf_source_combo", tf_source_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tf_source_combo);
  gtk_box_pack_end (GTK_BOX (hbox50), tf_source_combo, FALSE, TRUE, 2);

  tf_source = GTK_COMBO (tf_source_combo)->entry;
  gtk_widget_ref (tf_source);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tf_source", tf_source,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tf_source);
  gtk_widget_set_usize (tf_source, 80, -2);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator3);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator3", hseparator3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (vbox25), hseparator3, FALSE, TRUE, 4);

  tf_ok = gtk_button_new_with_label (_("Simulate TF"));
  gtk_widget_ref (tf_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "tf_ok", tf_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tf_ok);
  gtk_box_pack_start (GTK_BOX (vbox25), tf_ok, TRUE, FALSE, 2);
  gtk_tooltips_set_tip (tooltips, tf_ok, _("start the transfert function simulation. See the results on the spice output window"), NULL);

  result_tf = gtk_label_new (_("tf"));
  gtk_widget_ref (result_tf);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "result_tf", result_tf,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (result_tf);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 5), result_tf);

  vbox_param = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox_param);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox_param", vbox_param,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox_param);
  gtk_container_add (GTK_CONTAINER (notebook2), vbox_param);

  label129 = gtk_label_new (_("Do a parametric analysis"));
  gtk_widget_ref (label129);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label129", label129,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label129);
  gtk_box_pack_start (GTK_BOX (vbox_param), label129, FALSE, FALSE, 0);

  hseparator63 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator63);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator63", hseparator63,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator63);
  gtk_box_pack_start (GTK_BOX (vbox_param), hseparator63, FALSE, TRUE, 2);

  param_enable = gtk_check_button_new_with_label (_("enable"));
  gtk_widget_ref (param_enable);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_enable", param_enable,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_enable);
  gtk_box_pack_start (GTK_BOX (vbox_param), param_enable, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (param_enable), 2);

  hseparator62 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator62);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator62", hseparator62,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator62);
  gtk_box_pack_start (GTK_BOX (vbox_param), hseparator62, FALSE, TRUE, 2);

  param_hbox_name = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_name);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_name", param_hbox_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_name);
  gtk_box_pack_start (GTK_BOX (vbox_param), param_hbox_name, FALSE, TRUE, 3);
  gtk_widget_set_sensitive (param_hbox_name, FALSE);

  label123 = gtk_label_new (_("name"));
  gtk_widget_ref (label123);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label123", label123,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label123);
  gtk_box_pack_start (GTK_BOX (param_hbox_name), label123, FALSE, FALSE, 2);

  param_name_combo = gtk_combo_new ();
  gtk_widget_ref (param_name_combo);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_name_combo", param_name_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_name_combo);
  gtk_box_pack_end (GTK_BOX (param_hbox_name), param_name_combo, FALSE, TRUE, 2);

  param_name = GTK_COMBO (param_name_combo)->entry;
  gtk_widget_ref (param_name);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_name", param_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_name);
  gtk_widget_set_usize (param_name, 80, -2);

  param_hbox_param = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_param);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_param", param_hbox_param,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_param);
  gtk_box_pack_start (GTK_BOX (vbox_param), param_hbox_param, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (param_hbox_param, FALSE);

  label130 = gtk_label_new (_("param"));
  gtk_widget_ref (label130);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label130", label130,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label130);
  gtk_box_pack_start (GTK_BOX (param_hbox_param), label130, FALSE, FALSE, 0);

  param_param = gtk_entry_new ();
  gtk_widget_ref (param_param);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_param", param_param,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_param);
  gtk_box_pack_end (GTK_BOX (param_hbox_param), param_param, FALSE, TRUE, 2);

  hseparator61 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator61);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator61", hseparator61,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator61);
  gtk_box_pack_start (GTK_BOX (vbox_param), hseparator61, FALSE, TRUE, 2);

  param_hbox_val = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_val);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_val", param_hbox_val,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_val);
  gtk_box_pack_start (GTK_BOX (vbox_param), param_hbox_val, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (param_hbox_val, FALSE);

  vbox37 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox37);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox37", vbox37,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox37);
  gtk_box_pack_start (GTK_BOX (param_hbox_val), vbox37, FALSE, TRUE, 0);

  label124 = gtk_label_new (_("Type"));
  gtk_widget_ref (label124);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label124", label124,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label124);
  gtk_box_pack_start (GTK_BOX (vbox37), label124, FALSE, FALSE, 0);

  param_lin = gtk_radio_button_new_with_label (vbox37_group, _("LIN"));
  vbox37_group = gtk_radio_button_group (GTK_RADIO_BUTTON (param_lin));
  gtk_widget_ref (param_lin);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_lin", param_lin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_lin);
  gtk_box_pack_start (GTK_BOX (vbox37), param_lin, FALSE, FALSE, 0);

  param_dec = gtk_radio_button_new_with_label (vbox37_group, _("DEC"));
  vbox37_group = gtk_radio_button_group (GTK_RADIO_BUTTON (param_dec));
  gtk_widget_ref (param_dec);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_dec", param_dec,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_dec);
  gtk_box_pack_start (GTK_BOX (vbox37), param_dec, FALSE, FALSE, 0);

  param_list = gtk_radio_button_new_with_label (vbox37_group, _("LIST"));
  vbox37_group = gtk_radio_button_group (GTK_RADIO_BUTTON (param_list));
  gtk_widget_ref (param_list);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_list", param_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_list);
  gtk_box_pack_start (GTK_BOX (vbox37), param_list, FALSE, FALSE, 0);

  vseparator2 = gtk_vseparator_new ();
  gtk_widget_ref (vseparator2);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vseparator2", vseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vseparator2);
  gtk_box_pack_start (GTK_BOX (param_hbox_val), vseparator2, FALSE, TRUE, 13);

  vbox38 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox38);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox38", vbox38,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox38);
  gtk_box_pack_start (GTK_BOX (param_hbox_val), vbox38, TRUE, TRUE, 0);

  param_hbox_start = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_start);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_start", param_hbox_start,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_start);
  gtk_box_pack_start (GTK_BOX (vbox38), param_hbox_start, TRUE, TRUE, 0);

  label125 = gtk_label_new (_("Start"));
  gtk_widget_ref (label125);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label125", label125,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label125);
  gtk_box_pack_start (GTK_BOX (param_hbox_start), label125, FALSE, FALSE, 0);

  param_start = gtk_entry_new ();
  gtk_widget_ref (param_start);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_start", param_start,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_start);
  gtk_box_pack_end (GTK_BOX (param_hbox_start), param_start, FALSE, TRUE, 2);

  param_hbox_stop = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_stop);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_stop", param_hbox_stop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_stop);
  gtk_box_pack_start (GTK_BOX (vbox38), param_hbox_stop, TRUE, TRUE, 0);

  label126 = gtk_label_new (_("Stop"));
  gtk_widget_ref (label126);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label126", label126,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label126);
  gtk_box_pack_start (GTK_BOX (param_hbox_stop), label126, FALSE, FALSE, 0);

  param_stop = gtk_entry_new ();
  gtk_widget_ref (param_stop);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_stop", param_stop,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_stop);
  gtk_box_pack_end (GTK_BOX (param_hbox_stop), param_stop, FALSE, TRUE, 2);

  param_hbox_step = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_step);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_step", param_hbox_step,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_step);
  gtk_box_pack_start (GTK_BOX (vbox38), param_hbox_step, TRUE, TRUE, 0);

  param_label_step = gtk_label_new (_("Step"));
  gtk_widget_ref (param_label_step);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_label_step", param_label_step,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_label_step);
  gtk_box_pack_start (GTK_BOX (param_hbox_step), param_label_step, FALSE, FALSE, 0);

  param_step = gtk_entry_new ();
  gtk_widget_ref (param_step);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_step", param_step,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_step);
  gtk_box_pack_end (GTK_BOX (param_hbox_step), param_step, FALSE, TRUE, 2);

  param_hbox_list = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (param_hbox_list);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_hbox_list", param_hbox_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_hbox_list);
  gtk_box_pack_start (GTK_BOX (vbox38), param_hbox_list, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (param_hbox_list, FALSE);

  label128 = gtk_label_new (_("Values"));
  gtk_widget_ref (label128);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label128", label128,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label128);
  gtk_box_pack_start (GTK_BOX (param_hbox_list), label128, FALSE, FALSE, 0);

  param_values = gtk_entry_new ();
  gtk_widget_ref (param_values);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "param_values", param_values,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_values);
  gtk_box_pack_end (GTK_BOX (param_hbox_list), param_values, FALSE, TRUE, 2);

  label_param = gtk_label_new (_("param"));
  gtk_widget_ref (label_param);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label_param", label_param,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_param);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 6), label_param);

  plot_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (plot_vbox);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_vbox", plot_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_vbox);
  gtk_container_add (GTK_CONTAINER (notebook2), plot_vbox);
  gtk_widget_set_sensitive (plot_vbox, FALSE);

  label140 = gtk_label_new (_("Plot the results"));
  gtk_widget_ref (label140);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label140", label140,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label140);
  gtk_box_pack_start (GTK_BOX (plot_vbox), label140, FALSE, FALSE, 0);

  hseparator79 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator79);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator79", hseparator79,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator79);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hseparator79, TRUE, FALSE, 2);

  label150 = gtk_label_new (_("Commands before plotting :"));
  gtk_widget_ref (label150);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label150", label150,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label150);
  gtk_box_pack_start (GTK_BOX (plot_vbox), label150, FALSE, FALSE, 0);

  scrolledwindow15 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow15);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "scrolledwindow15", scrolledwindow15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow15);
  gtk_box_pack_start (GTK_BOX (plot_vbox), scrolledwindow15, FALSE, FALSE, 2);
  gtk_widget_set_size_request (scrolledwindow15, -1, 56);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow15),
				  GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  
  plot_pre_text = gtk_text_view_new ();
  gtk_widget_ref (plot_pre_text);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_pre_text", plot_pre_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_pre_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow15), plot_pre_text);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (plot_pre_text), TRUE);

  hbox85 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox85);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox85", hbox85,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox85);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hbox85, FALSE, FALSE, 0);

  hseparator69 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator69);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator69", hseparator69,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator69);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hseparator69, FALSE, TRUE, 2);

  hbox83 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox83);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox83", hbox83,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox83);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hbox83, FALSE, TRUE, 0);

  label142 = gtk_label_new (_("X axis : "));
  gtk_widget_ref (label142);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label142", label142,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label142);
  gtk_box_pack_start (GTK_BOX (hbox83), label142, FALSE, FALSE, 2);

  vbox43 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox43);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox43", vbox43,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox43);
  gtk_box_pack_start (GTK_BOX (hbox83), vbox43, FALSE, FALSE, 0);

  plot_xdefault = gtk_radio_button_new_with_label (x_axis_group, _("default"));
  x_axis_group = gtk_radio_button_group (GTK_RADIO_BUTTON (plot_xdefault));
  gtk_widget_ref (plot_xdefault);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_xdefault", plot_xdefault,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_xdefault);
  gtk_box_pack_start (GTK_BOX (vbox43), plot_xdefault, FALSE, FALSE, 0);

  hbox93 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox93);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox93", hbox93,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox93);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox93, TRUE, TRUE, 0);

  plot_xscale_value = gtk_radio_button_new_with_label (x_axis_group, _("value"));
  x_axis_group = gtk_radio_button_group (GTK_RADIO_BUTTON (plot_xscale_value));
  gtk_widget_ref (plot_xscale_value);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_xscale_value", plot_xscale_value,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_xscale_value);
  gtk_box_pack_start (GTK_BOX (hbox93), plot_xscale_value, FALSE, FALSE, 0);

  plot_x = gtk_entry_new ();
  gtk_widget_ref (plot_x);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_x", plot_x,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_x);
  gtk_box_pack_start (GTK_BOX (hbox93), plot_x, FALSE, TRUE, 2);
  gtk_widget_set_usize (plot_x, 120, -2);
  gtk_widget_set_sensitive (plot_x, FALSE);

  vbox42 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox42);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "vbox42", vbox42,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox42);
  gtk_box_pack_start (GTK_BOX (hbox83), vbox42, FALSE, FALSE, 0);

  plot_xlog_scale = gtk_check_button_new_with_label (_("log scale"));
  gtk_widget_ref (plot_xlog_scale);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_xlog_scale", plot_xlog_scale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_xlog_scale);
  gtk_box_pack_start (GTK_BOX (vbox42), plot_xlog_scale, FALSE, FALSE, 0);
  gtk_widget_set_usize (plot_xlog_scale, -2, 22);

  plot_xlin_scale = gtk_check_button_new_with_label (_("lin scale"));
  gtk_widget_ref (plot_xlin_scale);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_xlin_scale", plot_xlin_scale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_xlin_scale);
  gtk_box_pack_start (GTK_BOX (vbox42), plot_xlin_scale, FALSE, FALSE, 0);
  gtk_widget_set_usize (plot_xlin_scale, -2, 22);

  hseparator71 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator71);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator71", hseparator71,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator71);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hseparator71, FALSE, TRUE, 2);

  hbox84 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox84);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox84", hbox84,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox84);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hbox84, FALSE, TRUE, 0);

  label143 = gtk_label_new (_("Y axis : "));
  gtk_widget_ref (label143);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label143", label143,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label143);
  gtk_box_pack_start (GTK_BOX (hbox84), label143, FALSE, FALSE, 2);

  plot_y = gtk_entry_new ();
  gtk_widget_ref (plot_y);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_y", plot_y,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_y);
  gtk_box_pack_start (GTK_BOX (hbox84), plot_y, FALSE, FALSE, 2);

  plot_ylog_scale = gtk_check_button_new_with_label (_("log scale"));
  gtk_widget_ref (plot_ylog_scale);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_ylog_scale", plot_ylog_scale,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_ylog_scale);
  gtk_box_pack_end (GTK_BOX (hbox84), plot_ylog_scale, FALSE, TRUE, 0);

  hseparator74 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator74);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator74", hseparator74,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator74);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hseparator74, FALSE, TRUE, 2);

  hbox86 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox86);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox86", hbox86,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox86);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hbox86, FALSE, FALSE, 0);

  plot_auto_update = gtk_check_button_new_with_label (_("auto update"));
  gtk_widget_ref (plot_auto_update);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_auto_update", plot_auto_update,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_auto_update);
  gtk_box_pack_start (GTK_BOX (hbox86), plot_auto_update, TRUE, FALSE, 0);

  plot_reset = gtk_button_new_with_label (_("Reset"));
  gtk_widget_ref (plot_reset);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_reset", plot_reset,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_reset);
  gtk_box_pack_start (GTK_BOX (hbox86), plot_reset, TRUE, FALSE, 0);
  GTK_WIDGET_SET_FLAGS (plot_reset, GTK_CAN_DEFAULT);

  hseparator70 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator70);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hseparator70", hseparator70,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator70);
  gtk_box_pack_start (GTK_BOX (plot_vbox), hseparator70, FALSE, TRUE, 2);

  plot_ok = gtk_button_new_with_label (_("Plot"));
  gtk_widget_ref (plot_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "plot_ok", plot_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (plot_ok);
  gtk_box_pack_start (GTK_BOX (plot_vbox), plot_ok, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, plot_ok, _("start the ac analysis"), NULL);

  label139 = gtk_label_new (_("plot"));
  gtk_widget_ref (label139);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label139", label139,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label139);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook2), 
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook2), 7), label139);

  notebook3 = gtk_notebook_new ();
  gtk_widget_ref (notebook3);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "notebook3", notebook3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (notebook3);
  gtk_box_pack_start (GTK_BOX (vbox2), notebook3, TRUE, TRUE, 0);
  gtk_notebook_set_tab_hborder (GTK_NOTEBOOK (notebook3), 8);

  scrolledwindow12 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow12);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "scrolledwindow12", scrolledwindow12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow12);
  gtk_container_add (GTK_CONTAINER (notebook3), scrolledwindow12);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow12), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text_log = gtk_text_view_new ();
  gtk_widget_ref (text_log);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "text_log", text_log,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text_log);
  gtk_container_add (GTK_CONTAINER (scrolledwindow12), text_log);
  gtk_widget_set_usize (text_log, -2, 131);

  hbox97 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox97);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox97", hbox97,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox97);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook3), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook3), 0), hbox97);

  label163 = gtk_label_new (_(" Log "));
  gtk_widget_ref (label163);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label163", label163,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label163);
  gtk_box_pack_start (GTK_BOX (hbox97), label163, FALSE, FALSE, 0);

  pixmap_log_ok = create_pixmap (window_prin, "green.xpm");
  gtk_widget_ref (pixmap_log_ok);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "pixmap_log_ok", pixmap_log_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap_log_ok);
  gtk_box_pack_start (GTK_BOX (hbox97), pixmap_log_ok, FALSE, FALSE, 2);

  pixmap_log_false = create_pixmap (window_prin, "red.xpm");
  gtk_widget_ref (pixmap_log_false);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "pixmap_log_false", pixmap_log_false,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap_log_false);
  gtk_box_pack_start (GTK_BOX (hbox97), pixmap_log_false, FALSE, FALSE, 2);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (notebook3), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text_spice_output = gtk_text_view_new ();
  gtk_widget_ref (text_spice_output);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "text_spice_output", text_spice_output,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text_spice_output);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text_spice_output);
  gtk_widget_set_usize (text_spice_output, 370, -2);

  hbox94 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox94);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "hbox94", hbox94,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox94);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook3), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook3), 1), hbox94);

  label145 = gtk_label_new (_("spice output "));
  gtk_widget_ref (label145);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label145", label145,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label145);
  gtk_box_pack_start (GTK_BOX (hbox94), label145, FALSE, FALSE, 0);

  viewerspiceoutput = gtk_button_new_with_label (_("-> view"));
  gtk_widget_ref (viewerspiceoutput);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "viewerspiceoutput", viewerspiceoutput,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewerspiceoutput);
  gtk_box_pack_start (GTK_BOX (hbox94), viewerspiceoutput, FALSE, FALSE, 0);

  scrolledwindow13 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow13);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "scrolledwindow13", scrolledwindow13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow13);
  gtk_container_add (GTK_CONTAINER (notebook3), scrolledwindow13);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow13), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text_spice_error = gtk_text_view_new ();
  gtk_widget_ref (text_spice_error);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "text_spice_error", text_spice_error,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (text_spice_error);
  gtk_container_add (GTK_CONTAINER (scrolledwindow13), text_spice_error);
  gtk_widget_set_usize (text_spice_error, 353, -2);

  label146 = gtk_label_new (_("Spice errors"));
  gtk_widget_ref (label146);
  gtk_object_set_data_full (GTK_OBJECT (window_prin), "label146", label146,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label146);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook3), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook3), 2), label146);

  gtk_signal_connect (GTK_OBJECT (menu_file_new), "activate",
                      GTK_SIGNAL_FUNC (on_menu_file_new_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_file_open), "activate",
                      GTK_SIGNAL_FUNC (on_menu_file_open_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_file_save), "activate",
                      GTK_SIGNAL_FUNC (on_menu_file_save_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_file_saveas), "activate",
                      GTK_SIGNAL_FUNC (on_menu_file_saveas_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_file_quit), "activate",
                      GTK_SIGNAL_FUNC (on_menu_file_quit_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (window_prin), "delete-event",
                      GTK_SIGNAL_FUNC (on_main_window_destroy_event),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_options_commands), "activate",
                      GTK_SIGNAL_FUNC (on_menu_options_commands_activate),
                      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (menu_options_gschem), "activate",
                      GTK_SIGNAL_FUNC (on_menu_options_gschem_activate),
                      easyspice->geda);
  gtk_signal_connect (GTK_OBJECT (menu_options_library), "activate",
                      GTK_SIGNAL_FUNC (on_menu_options_library_activate),
                      easyspice->spicelibrary);
  gtk_signal_connect (GTK_OBJECT (menu_options_save), "activate",
		      GTK_SIGNAL_FUNC (on_menu_options_save_activate),
		      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_windows_simulcommands), "activate",
                      GTK_SIGNAL_FUNC (on_menu_windows_simulcommands_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_windows_plotcommands), "activate",
                      GTK_SIGNAL_FUNC (on_menu_windows_plotcommands_activate),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (menu_windows_spiceinteractive), "activate",
                      GTK_SIGNAL_FUNC (on_menu_windows_spiceinteractive_activate),
                      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (menu_windows_postproc), "activate",
                      GTK_SIGNAL_FUNC (on_menu_windows_postproc_activate),
                      easyspice->postproc);
  gtk_signal_connect (GTK_OBJECT (menu_windows_plotresult), "activate",
                      GTK_SIGNAL_FUNC (on_plot_res_activate),
                      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (menu_help_about), "activate",
                      GTK_SIGNAL_FUNC (on_menu_help_about_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (menu_help_spiceman), "activate",
                      GTK_SIGNAL_FUNC (on_menu_help_spiceman_activate),
                      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (menu_help_spicehtml), "activate",
                      GTK_SIGNAL_FUNC (on_menu_help_spicehtml_activate),
		      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (menu_help_spicehelp), "activate",
                      GTK_SIGNAL_FUNC (on_menu_help_spicehelp_activate),
                      easyspice->commands);
  gtk_signal_connect (GTK_OBJECT (visu_schem), "clicked",
                      GTK_SIGNAL_FUNC (on_visu_schem_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (gen_netlist), "clicked",
                      GTK_SIGNAL_FUNC (on_gen_netlist_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (visu_netlist), "clicked",
                      GTK_SIGNAL_FUNC (on_visu_netlist_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (op_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_op_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (op_node), "changed",
                      GTK_SIGNAL_FUNC (on_op_node_changed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (op_device), "changed",
                      GTK_SIGNAL_FUNC (on_op_device_changed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (op_item), "changed",
                      GTK_SIGNAL_FUNC (on_op_item_changed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (dc_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_dc_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (ac_dec), "pressed",
                      GTK_SIGNAL_FUNC (on_ac_dec_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (ac_lin), "pressed",
                      GTK_SIGNAL_FUNC (on_ac_lin_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (ac_oct), "pressed",
                      GTK_SIGNAL_FUNC (on_ac_oct_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (ac_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_ac_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (noise_dec), "pressed",
                      GTK_SIGNAL_FUNC (on_noise_dec_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (noise_lin), "pressed",
                      GTK_SIGNAL_FUNC (on_noise_lin_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (noise_oct), "pressed",
                      GTK_SIGNAL_FUNC (on_noise_oct_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (noise_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_noise_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (tran_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_tran_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (tf_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_tf_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (param_enable), "pressed",
                      GTK_SIGNAL_FUNC (on_param_enable_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (param_lin), "pressed",
                      GTK_SIGNAL_FUNC (on_param_lin_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (param_dec), "pressed",
                      GTK_SIGNAL_FUNC (on_param_dec_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (param_list), "pressed",
                      GTK_SIGNAL_FUNC (on_param_list_pressed),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (plot_xdefault), "clicked",
                      GTK_SIGNAL_FUNC (on_plot_xscale_default_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (plot_xscale_value), "clicked",
                      GTK_SIGNAL_FUNC (on_plot_xscale_value_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (plot_reset), "clicked",
                      GTK_SIGNAL_FUNC (on_plot_reset_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (plot_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_plot_ok_clicked),
                      easyspice);
  gtk_signal_connect (GTK_OBJECT (viewerspiceoutput), "clicked",
                      GTK_SIGNAL_FUNC (on_viewerspiceoutput_clicked),
                      easyspice);

  gtk_object_set_data (GTK_OBJECT (window_prin), "tooltips", tooltips);

  return window_prin;
}


GtkWidget*
create_verify_quit (void)
{
  GtkWidget *verify_quit;
  GtkWidget *dialog_vbox1;
  GtkWidget *label1;
  GtkWidget *dialog_action_area1;
  GtkWidget *button_yes;
  GtkWidget *button_no;

  verify_quit = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (verify_quit), _("verify quit"));
  gtk_window_set_type_hint (GTK_WINDOW (verify_quit), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_set_modal (GTK_WINDOW (verify_quit), TRUE);

  dialog_vbox1 = GTK_DIALOG (verify_quit)->vbox;
  gtk_widget_show (dialog_vbox1);

  label1 = gtk_label_new (_("Are you sure you want\nto quit?"));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), label1, FALSE, FALSE, 5);

  dialog_action_area1 = GTK_DIALOG (verify_quit)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  button_yes = gtk_button_new_from_stock ("gtk-yes");
  gtk_widget_show (button_yes);
  gtk_dialog_add_action_widget (GTK_DIALOG (verify_quit), button_yes, GTK_RESPONSE_YES);
  GTK_WIDGET_SET_FLAGS (button_yes, GTK_CAN_DEFAULT);

  button_no = gtk_button_new_from_stock ("gtk-no");
  gtk_widget_show (button_no);
  gtk_dialog_add_action_widget (GTK_DIALOG (verify_quit), button_no, GTK_RESPONSE_NO);
  GTK_WIDGET_SET_FLAGS (button_no, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) button_yes, "clicked",
                    G_CALLBACK (on_verify_quit_button_yes_clicked),
                    GTK_WIDGET (verify_quit));
  g_signal_connect ((gpointer) button_no, "clicked",
                    G_CALLBACK (on_verify_quit_button_no_clicked),
                    GTK_WIDGET (verify_quit));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (verify_quit, verify_quit, "verify_quit");
  GLADE_HOOKUP_OBJECT_NO_REF (verify_quit, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (verify_quit, label1, "label1");
  GLADE_HOOKUP_OBJECT_NO_REF (verify_quit, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (verify_quit, button_yes, "button_yes");
  GLADE_HOOKUP_OBJECT (verify_quit, button_no, "button_no");

  gtk_widget_grab_default (button_no);
  return verify_quit;
}


GtkWidget*
create_config_spice (void)
{
  GtkWidget *config_spice;
  GtkWidget *vbox30;
  GtkWidget *scrolledwindow9;
  GtkWidget *viewport2;
  GtkWidget *vbox31;
  GtkWidget *label103;
  GtkWidget *hseparator16;
  GtkWidget *hbox58;
  GtkWidget *label104;
  GtkWidget *spice_reltol;
  GtkWidget *hseparator17;
  GtkWidget *hbox59;
  GtkWidget *label105;
  GtkWidget *spice_vntol;
  GtkWidget *hseparator22;
  GtkWidget *hbox63;
  GtkWidget *label110;
  GtkWidget *spice_abstol;
  GtkWidget *hseparator21;
  GtkWidget *hbox64;
  GtkWidget *label111;
  GtkWidget *spice_gmin;
  GtkWidget *hseparator23;
  GtkWidget *hbuttonbox20;
  GtkWidget *spice_ok;
  GtkWidget *spice_default;

  config_spice = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (config_spice), "config_spice", config_spice);
  gtk_window_set_title (GTK_WINDOW (config_spice), _("config spice"));

  vbox30 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox30);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "vbox30", vbox30,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox30);
  gtk_container_add (GTK_CONTAINER (config_spice), vbox30);

  scrolledwindow9 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow9);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "scrolledwindow9", scrolledwindow9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow9);
  gtk_box_pack_start (GTK_BOX (vbox30), scrolledwindow9, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow9, 62, -2);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow9), 2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow9), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  viewport2 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport2);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "viewport2", viewport2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow9), viewport2);

  vbox31 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox31);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "vbox31", vbox31,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox31);
  gtk_container_add (GTK_CONTAINER (viewport2), vbox31);

  label103 = gtk_label_new (_("Spice configuration"));
  gtk_widget_ref (label103);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "label103", label103,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label103);
  gtk_box_pack_start (GTK_BOX (vbox31), label103, FALSE, FALSE, 2);

  hseparator16 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator16);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hseparator16", hseparator16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator16);
  gtk_box_pack_start (GTK_BOX (vbox31), hseparator16, FALSE, TRUE, 2);

  hbox58 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox58);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hbox58", hbox58,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox58);
  gtk_box_pack_start (GTK_BOX (vbox31), hbox58, FALSE, TRUE, 0);

  label104 = gtk_label_new ("");
  gtk_label_parse_uline (GTK_LABEL (label104), "diff_reltol");
  gtk_widget_ref (label104);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "label104", label104,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label104);
  gtk_box_pack_start (GTK_BOX (hbox58), label104, FALSE, FALSE, 2);

  spice_reltol = gtk_entry_new ();
  gtk_widget_ref (spice_reltol);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_reltol", spice_reltol,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_reltol);
  gtk_box_pack_end (GTK_BOX (hbox58), spice_reltol, FALSE, TRUE, 2);
  gtk_widget_set_usize (spice_reltol, 75, -2);

  hseparator17 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator17);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hseparator17", hseparator17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator17);
  gtk_box_pack_start (GTK_BOX (vbox31), hseparator17, FALSE, TRUE, 2);

  hbox59 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox59);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hbox59", hbox59,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox59);
  gtk_box_pack_start (GTK_BOX (vbox31), hbox59, FALSE, TRUE, 0);

  label105 = gtk_label_new ("");
  gtk_label_parse_uline (GTK_LABEL (label105),
                         "diff_vntol");
  gtk_widget_ref (label105);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "label105", label105,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label105);
  gtk_box_pack_start (GTK_BOX (hbox59), label105, FALSE, FALSE, 2);

  spice_vntol = gtk_entry_new ();
  gtk_widget_ref (spice_vntol);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_vntol", spice_vntol,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_vntol);
  gtk_box_pack_end (GTK_BOX (hbox59), spice_vntol, FALSE, TRUE, 2);
  gtk_widget_set_usize (spice_vntol, 75, -2);

  hseparator22 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator22);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hseparator22", hseparator22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator22);
  gtk_box_pack_start (GTK_BOX (vbox31), hseparator22, FALSE, TRUE, 3);

  hbox63 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox63);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hbox63", hbox63,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox63);
  gtk_box_pack_start (GTK_BOX (vbox31), hbox63, FALSE, TRUE, 0);

  label110 = gtk_label_new ("ABSTOL");
  gtk_widget_ref (label110);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "label110", label110,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label110);
  gtk_box_pack_start (GTK_BOX (hbox63), label110, FALSE, FALSE, 2);

  spice_abstol = gtk_entry_new ();
  gtk_widget_ref (spice_abstol);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_abstol", spice_abstol,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_abstol);
  gtk_box_pack_end (GTK_BOX (hbox63), spice_abstol, FALSE, TRUE, 2);
  gtk_widget_set_usize (spice_abstol, 75, -2);
  gtk_entry_set_text (GTK_ENTRY (spice_abstol), "1p");

  hseparator21 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator21);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hseparator21", hseparator21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator21);
  gtk_box_pack_start (GTK_BOX (vbox31), hseparator21, FALSE, TRUE, 3);

  hbox64 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox64);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hbox64", hbox64,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox64);
  gtk_box_pack_start (GTK_BOX (vbox31), hbox64, FALSE, TRUE, 0);

  label111 = gtk_label_new ("GMIN");
  gtk_widget_ref (label111);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "label111", label111,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label111);
  gtk_box_pack_start (GTK_BOX (hbox64), label111, FALSE, FALSE, 2);

  spice_gmin = gtk_entry_new ();
  gtk_widget_ref (spice_gmin);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_gmin", spice_gmin,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_gmin);
  gtk_box_pack_end (GTK_BOX (hbox64), spice_gmin, FALSE, TRUE, 2);
  gtk_widget_set_usize (spice_gmin, 75, -2);
  gtk_entry_set_text (GTK_ENTRY (spice_gmin), "1.0e-12");

  hseparator23 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator23);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hseparator23", hseparator23,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator23);
  gtk_box_pack_start (GTK_BOX (vbox31), hseparator23, FALSE, TRUE, 0);

  hbuttonbox20 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox20);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "hbuttonbox20", hbuttonbox20,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox20);
  gtk_box_pack_start (GTK_BOX (vbox30), hbuttonbox20, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox20), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox20), 20);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox20), 76, 27);
  gtk_button_box_set_child_ipadding (GTK_BUTTON_BOX (hbuttonbox20), 2, 0);

  spice_ok = gtk_button_new_with_label (_("Ok"));
  gtk_widget_ref (spice_ok);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_ok", spice_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox20), spice_ok);
  GTK_WIDGET_SET_FLAGS (spice_ok, GTK_CAN_DEFAULT);

  spice_default = gtk_button_new_with_label (_("Default"));
  gtk_widget_ref (spice_default);
  gtk_object_set_data_full (GTK_OBJECT (config_spice), "spice_default", spice_default,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spice_default);
  gtk_container_add (GTK_CONTAINER (hbuttonbox20), spice_default);
  GTK_WIDGET_SET_FLAGS (spice_default, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (config_spice), "delete_event",
                      GTK_SIGNAL_FUNC (do_not_destroy),
                      NULL);
  gtk_signal_connect_object_after (GTK_OBJECT (spice_ok), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_hide),
                                   GTK_OBJECT (GTK_OBJECT(config_spice)));
  gtk_signal_connect (GTK_OBJECT (spice_default), "clicked",
                      GTK_SIGNAL_FUNC (on_spice_default_clicked),
                      NULL);

  gtk_widget_grab_default (spice_ok);
  return config_spice;
}


GtkWidget*
create_txt_viewer (Textviewer *textviewer)
{
  GtkWidget *txt_viewer;
  GtkWidget *vbox46;
  GtkWidget *hseparator86;
  GtkWidget *hbox95;
  GtkWidget *label160;
  GtkWidget *label_filename;
  GtkWidget *hseparator87;
  GtkWidget *scrolledwindow16;
  GtkWidget *gtk_txt_view;
  GtkWidget *hseparator89;
  GtkWidget *bbox1;
  GtkWidget *button_close;
  

  txt_viewer = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (txt_viewer), "txt_viewer", txt_viewer);
  gtk_window_set_title (GTK_WINDOW (txt_viewer), _("easy_spice: text viewer"));

  vbox46 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox46);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "vbox46", vbox46,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (txt_viewer), vbox46);

  hseparator86 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator86);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "hseparator86", hseparator86, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox46), hseparator86, FALSE, FALSE, 2);

  hbox95 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox95);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "hbox95", hbox95,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox46), hbox95, FALSE, FALSE, 0);

  label160 = gtk_label_new (_("Filename: "));
  gtk_widget_ref (label160);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "label160", label160,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox95), label160, FALSE, FALSE, 4);

  label_filename = gtk_label_new (_("Filename: "));
  gtk_widget_ref (label_filename);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "label_filename", label_filename, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox95), label_filename, FALSE, FALSE, 4);

  hseparator87 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator87);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "hseparator87", hseparator87,(GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox46), hseparator87, FALSE, FALSE, 2);

  scrolledwindow16 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow16);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "scrolledwindow16", scrolledwindow16, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox46), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow16), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  gtk_txt_view = gtk_text_view_new ();
  gtk_widget_ref (gtk_txt_view);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "gtk_txt_view", gtk_txt_view, (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (scrolledwindow16), gtk_txt_view);
  gtk_widget_set_usize (gtk_txt_view, 450, 400);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (gtk_txt_view), FALSE);

  hseparator89 = gtk_hseparator_new();
  gtk_widget_ref (hseparator89);
  gtk_object_set_data_full (GTK_OBJECT (txt_viewer), "hseparator89", hseparator89, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox46), hseparator89, FALSE, FALSE, 2);

  bbox1 = gtk_hbutton_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (bbox1), 2);
  gtk_box_pack_start (GTK_BOX (vbox46), bbox1, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox1), GTK_BUTTONBOX_END);

  button_close = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_container_add (GTK_CONTAINER (bbox1), button_close);

  gtk_widget_show_all (vbox46);

  gtk_signal_connect (GTK_OBJECT (txt_viewer), "destroy",
                      G_CALLBACK (on_textviewer_destroy),
                      textviewer);
  gtk_signal_connect (GTK_OBJECT (button_close), "clicked",
		      G_CALLBACK (on_textviewer_button_close_clicked),
		      textviewer);
  return txt_viewer;
}

 
GtkWidget*
create_geda_setup (GedaSettings *geda)
{
  GtkWidget *geda_setup;
  GtkWidget *dialog_vbox1;
  GtkWidget *frame1;
  GtkWidget *alignment1;
  GtkWidget *vbox1;
  GtkWidget *hbox2;
  GtkWidget *label6;
  GtkWidget *includecwd_no_radiobutton;
  GSList *includecwd_no_radiobutton_group = NULL;
  GtkWidget *includecwd_yes_radiobutton;
  GtkWidget *hbox3;
  GtkWidget *label7;
  GtkWidget *include_directory_entry;
  GtkWidget *gnetlist_command_line_entry;
  GtkWidget *hseparator1;
  GtkWidget *hbox4;
  GtkWidget *label8;
  GtkWidget *pinlabel_no_radiobutton;
  GSList *pinlabel_no_radiobutton_group = NULL;
  GtkWidget *pinlabel_yes_radiobutton;
  GtkWidget *hbox1;
  GtkWidget *label4;
  GtkWidget *geda_labels_entry;
  GtkWidget *label1;
  GtkWidget *frame2;
  GtkWidget *alignment2;
  GtkWidget *vbox2;
  GtkWidget *hbox5;
  GtkWidget *label9;
  GtkWidget *text_size_entry;
  GtkWidget *hseparator4;
  GtkWidget *hbox6;
  GtkWidget *label10;
  GtkWidget *snap_size_entry;
  GtkWidget *label2;
  GtkWidget *frame3;
  GtkWidget *alignment3;
  GtkWidget *vbox3;
  GtkWidget *hbox7;
  GtkWidget *label11;
  GtkWidget *netpriority_labels_radiobutton;
  GSList *netpriority_labels_radiobutton_group = NULL;
  GtkWidget *netpriority_nodes_radiobutton;
  GtkWidget *hseparator5;
  GtkWidget *hbox8;
  GtkWidget *hbox999;
  GtkWidget *label5;
  GtkWidget *label999;
  GtkWidget *hseparator999;
  GtkWidget *hierarchy_no_radiobutton;
  GSList *hierarchy_no_radiobutton_group = NULL;
  GtkWidget *hierarchy_yes_radiobutton;
  GtkWidget *label3;
  GtkWidget *dialog_action_area1;
  GtkWidget *defaultbutton1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;

  geda_setup = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (geda_setup), _("gEDA parameters"));
  gtk_window_set_type_hint (GTK_WINDOW (geda_setup), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (geda_setup)->vbox;
  gtk_widget_show (dialog_vbox1);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame1), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 12, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (alignment1), vbox1);

  hbox2 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

  label6 = gtk_label_new (_("Include current directory: "));
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox2), label6, FALSE, FALSE, 0);

  includecwd_no_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("No"));
  gtk_widget_show (includecwd_no_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox2), includecwd_no_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (includecwd_no_radiobutton), includecwd_no_radiobutton_group);
  includecwd_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (includecwd_no_radiobutton));

  includecwd_yes_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Yes"));
  gtk_widget_show (includecwd_yes_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox2), includecwd_yes_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (includecwd_yes_radiobutton), includecwd_no_radiobutton_group);
  includecwd_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (includecwd_yes_radiobutton));

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

  label7 = gtk_label_new (_("Other directories: "));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox3), label7, FALSE, FALSE, 0);

  include_directory_entry = gtk_entry_new ();
  gtk_widget_show (include_directory_entry);
  gtk_box_pack_start (GTK_BOX (hbox3), include_directory_entry, TRUE, TRUE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  hbox4 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, TRUE, TRUE, 0);

  label8 = gtk_label_new (_("pinlabel attribute: "));
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox4), label8, FALSE, FALSE, 0);

  pinlabel_no_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("No"));
  gtk_widget_show (pinlabel_no_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox4), pinlabel_no_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (pinlabel_no_radiobutton), pinlabel_no_radiobutton_group);
  pinlabel_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (pinlabel_no_radiobutton));

  pinlabel_yes_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Yes"));
  gtk_widget_show (pinlabel_yes_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox4), pinlabel_yes_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (pinlabel_yes_radiobutton), pinlabel_no_radiobutton_group);
  pinlabel_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (pinlabel_yes_radiobutton));

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  label4 = gtk_label_new (_("Other attributes: "));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox1), label4, FALSE, FALSE, 0);

  geda_labels_entry = gtk_entry_new ();
  gtk_widget_show (geda_labels_entry);
  gtk_box_pack_start (GTK_BOX (hbox1), geda_labels_entry, TRUE, TRUE, 0);

  label1 = gtk_label_new (_("Common gEDA configurations:"));
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label1);
  gtk_label_set_use_markup (GTK_LABEL (label1), TRUE);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame2, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);

  alignment2 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (frame2), alignment2);
  gtk_container_set_border_width (GTK_CONTAINER (alignment2), 1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment2), 0, 0, 12, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (alignment2), vbox2);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, TRUE, TRUE, 0);

  label9 = gtk_label_new (_("Text size: "));
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox5), label9, FALSE, FALSE, 0);

  text_size_entry = gtk_entry_new ();
  gtk_widget_show (text_size_entry);
  gtk_box_pack_end (GTK_BOX (hbox5), text_size_entry, FALSE, FALSE, 0);
  gtk_entry_set_width_chars (GTK_ENTRY (text_size_entry), 10);

  hseparator4 = gtk_hseparator_new ();
  gtk_widget_show (hseparator4);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator4, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox6, TRUE, TRUE, 0);

  label10 = gtk_label_new (_("Snap size: "));
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 0);

  snap_size_entry = gtk_entry_new ();
  gtk_widget_show (snap_size_entry);
  gtk_box_pack_end (GTK_BOX (hbox6), snap_size_entry, FALSE, FALSE, 0);
  gtk_entry_set_width_chars (GTK_ENTRY (snap_size_entry), 10);

  label2 = gtk_label_new (_("gschem configurations:"));
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label2);
  gtk_label_set_use_markup (GTK_LABEL (label2), TRUE);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame3, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame3), GTK_SHADOW_IN);

  alignment3 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (frame3), alignment3);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment3), 0, 0, 12, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (alignment3), vbox3);

  hbox7 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox7, TRUE, TRUE, 0);

  label11 = gtk_label_new (_("Net priority: "));
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (hbox7), label11, FALSE, FALSE, 0);

  netpriority_labels_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Labels"));
  gtk_widget_show (netpriority_labels_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox7), netpriority_labels_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (netpriority_labels_radiobutton), netpriority_labels_radiobutton_group);
  netpriority_labels_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (netpriority_labels_radiobutton));

  netpriority_nodes_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Nodes"));
  gtk_widget_show (netpriority_nodes_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox7), netpriority_nodes_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (netpriority_nodes_radiobutton), netpriority_labels_radiobutton_group);
  netpriority_labels_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (netpriority_nodes_radiobutton));

  hseparator5 = gtk_hseparator_new ();
  gtk_widget_show (hseparator5);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator5, TRUE, TRUE, 0);

  hbox8 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox8, TRUE, TRUE, 0);

  label5 = gtk_label_new (_("Allow hierarchy"));
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox8), label5, FALSE, FALSE, 0);

  hierarchy_no_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("No"));
  gtk_widget_show (hierarchy_no_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox8), hierarchy_no_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (hierarchy_no_radiobutton), hierarchy_no_radiobutton_group);
  hierarchy_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (hierarchy_no_radiobutton));

  hierarchy_yes_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Yes"));
  gtk_widget_show (hierarchy_yes_radiobutton);
  gtk_box_pack_end (GTK_BOX (hbox8), hierarchy_yes_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (hierarchy_yes_radiobutton), hierarchy_no_radiobutton_group);
  hierarchy_no_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (hierarchy_yes_radiobutton));

  //Added by Gudjon
  hbox999 = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (hbox999);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox999, TRUE, TRUE, 0);

  label999 = gtk_label_new (_("gnetlist command line: "));
  gtk_widget_show (label999);
  gtk_box_pack_start (GTK_BOX (hbox999), label999, FALSE, FALSE, 0);

  gnetlist_command_line_entry = gtk_entry_new ();
  gtk_widget_show (gnetlist_command_line_entry);
  gtk_box_pack_start (GTK_BOX (hbox999), gnetlist_command_line_entry, TRUE, TRUE, 0);

  hseparator999 = gtk_hseparator_new ();
  gtk_widget_show (hseparator999);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator999, TRUE, TRUE, 0);
  //End of addition by Gudjon

  label3 = gtk_label_new (_("gnetlist configurations:"));
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label3);
  gtk_label_set_use_markup (GTK_LABEL (label3), TRUE);

  dialog_action_area1 = GTK_DIALOG (geda_setup)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  defaultbutton1 = gtk_button_new_with_mnemonic (_("Default"));
  gtk_widget_show (defaultbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (geda_setup), defaultbutton1, 0);
  GTK_WIDGET_SET_FLAGS (defaultbutton1, GTK_CAN_DEFAULT);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (geda_setup), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (geda_setup), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) geda_setup, "destroy",
                    G_CALLBACK (on_geda_setup_destroy),
                    geda);
  g_signal_connect ((gpointer) defaultbutton1, "clicked",
                    G_CALLBACK (on_geda_setup_default_clicked),
                    geda);
  g_signal_connect ((gpointer) cancelbutton1, "clicked",
                    G_CALLBACK (on_geda_setup_cancel_clicked),
                    geda);
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_geda_setup_ok_clicked),
                    geda);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (geda_setup, geda_setup, "geda_setup");
  GLADE_HOOKUP_OBJECT_NO_REF (geda_setup, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (geda_setup, frame1, "frame1");
  GLADE_HOOKUP_OBJECT (geda_setup, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (geda_setup, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (geda_setup, label6, "label6");
  GLADE_HOOKUP_OBJECT (geda_setup, includecwd_no_radiobutton, "includecwd_no_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, includecwd_yes_radiobutton, "includecwd_yes_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (geda_setup, label7, "label7");
  GLADE_HOOKUP_OBJECT (geda_setup, include_directory_entry, "include_directory_entry");
  GLADE_HOOKUP_OBJECT (geda_setup, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox4, "hbox4");
  GLADE_HOOKUP_OBJECT (geda_setup, label8, "label8");
  GLADE_HOOKUP_OBJECT (geda_setup, pinlabel_no_radiobutton, "pinlabel_no_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, pinlabel_yes_radiobutton, "pinlabel_yes_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (geda_setup, label4, "label4");
  GLADE_HOOKUP_OBJECT (geda_setup, geda_labels_entry, "geda_labels_entry");
  GLADE_HOOKUP_OBJECT (geda_setup, label1, "label1");
  GLADE_HOOKUP_OBJECT (geda_setup, frame2, "frame2");
  GLADE_HOOKUP_OBJECT (geda_setup, alignment2, "alignment2");
  GLADE_HOOKUP_OBJECT (geda_setup, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox5, "hbox5");
  GLADE_HOOKUP_OBJECT (geda_setup, label9, "label9");
  GLADE_HOOKUP_OBJECT (geda_setup, text_size_entry, "text_size_entry");
  GLADE_HOOKUP_OBJECT (geda_setup, hseparator4, "hseparator4");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox6, "hbox6");
  GLADE_HOOKUP_OBJECT (geda_setup, label10, "label10");
  GLADE_HOOKUP_OBJECT (geda_setup, snap_size_entry, "snap_size_entry");
  GLADE_HOOKUP_OBJECT (geda_setup, label2, "label2");
  GLADE_HOOKUP_OBJECT (geda_setup, frame3, "frame3");
  GLADE_HOOKUP_OBJECT (geda_setup, alignment3, "alignment3");
  GLADE_HOOKUP_OBJECT (geda_setup, vbox3, "vbox3");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox7, "hbox7");
  GLADE_HOOKUP_OBJECT (geda_setup, label11, "label11");
  GLADE_HOOKUP_OBJECT (geda_setup, netpriority_labels_radiobutton, "netpriority_labels_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, netpriority_nodes_radiobutton, "netpriority_nodes_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, hseparator5, "hseparator5");
  GLADE_HOOKUP_OBJECT (geda_setup, hbox8, "hbox8");
  GLADE_HOOKUP_OBJECT (geda_setup, label5, "label5");
  GLADE_HOOKUP_OBJECT (geda_setup, hierarchy_no_radiobutton, "hierarchy_no_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, hierarchy_yes_radiobutton, "hierarchy_yes_radiobutton");
  GLADE_HOOKUP_OBJECT (geda_setup, gnetlist_command_line_entry, "gnetlist_command_line_entry");
  GLADE_HOOKUP_OBJECT (geda_setup, label3, "label3");
  GLADE_HOOKUP_OBJECT_NO_REF (geda_setup, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (geda_setup, defaultbutton1, "defaultbutton1");
  GLADE_HOOKUP_OBJECT (geda_setup, cancelbutton1, "cancelbutton1");
  GLADE_HOOKUP_OBJECT (geda_setup, okbutton1, "okbutton1");

  return geda_setup;
}


GtkWidget*
create_command_setup (ExternalProgramms *prog)
{
  GtkWidget *command_setup;
  GtkWidget *dialog_vbox1;
  GtkWidget *frame1;
  GtkWidget *alignment1;
  GtkWidget *vbox1;
  GtkWidget *hbox3;
  GtkWidget *label7;
  GtkWidget *simulator_command_entry;
  GtkWidget *hseparator1;
  GtkWidget *hbox1;
  GtkWidget *label4;
  GtkWidget *plot_command_entry;
  GtkWidget *label1;
  GtkWidget *frame2;
  GtkWidget *alignment2;
  GtkWidget *vbox2;
  GtkWidget *hbox5;
  GtkWidget *label9;
  GtkWidget *help_command_entry;
  GtkWidget *hseparator4;
  GtkWidget *hbox6;
  GtkWidget *label10;
  GtkWidget *html_index_entry;
  GtkWidget *label2;
  GtkWidget *frame3;
  GtkWidget *alignment3;
  GtkWidget *vbox3;
  GtkWidget *hbox7;
  GtkWidget *label11;
  GtkWidget *browser_entry;
  GtkWidget *hseparator5;
  GtkWidget *hbox8;
  GtkWidget *label5;
  GtkWidget *texteditor_entry;
  GtkWidget *label3;
  GtkWidget *dialog_action_area1;
  GtkWidget *defaultbutton1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;

  command_setup = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (command_setup), _("setup external programms"));
  gtk_window_set_type_hint (GTK_WINDOW (command_setup), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (command_setup)->vbox;
  gtk_widget_show (dialog_vbox1);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame1), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 12, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (alignment1), vbox1);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

  label7 = gtk_label_new (_("Simulator command: "));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox3), label7, FALSE, FALSE, 0);

  simulator_command_entry = gtk_entry_new ();
  gtk_widget_show (simulator_command_entry);
  gtk_box_pack_start (GTK_BOX (hbox3), simulator_command_entry, TRUE, TRUE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  label4 = gtk_label_new (_("Plot command: "));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox1), label4, FALSE, FALSE, 0);

  plot_command_entry = gtk_entry_new ();
  gtk_widget_show (plot_command_entry);
  gtk_box_pack_start (GTK_BOX (hbox1), plot_command_entry, TRUE, TRUE, 0);

  label1 = gtk_label_new (_("spice commands"));
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label1);
  gtk_label_set_use_markup (GTK_LABEL (label1), TRUE);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame2, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);

  alignment2 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (frame2), alignment2);
  gtk_container_set_border_width (GTK_CONTAINER (alignment2), 1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment2), 0, 0, 12, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (alignment2), vbox2);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, TRUE, TRUE, 0);

  label9 = gtk_label_new (_("Help command: "));
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox5), label9, FALSE, FALSE, 0);

  help_command_entry = gtk_entry_new ();
  gtk_widget_show (help_command_entry);
  gtk_box_pack_end (GTK_BOX (hbox5), help_command_entry, TRUE, TRUE, 0);
  gtk_entry_set_width_chars (GTK_ENTRY (help_command_entry), 10);

  hseparator4 = gtk_hseparator_new ();
  gtk_widget_show (hseparator4);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator4, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox6, TRUE, TRUE, 0);

  label10 = gtk_label_new (_("HTML index: "));
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox6), label10, FALSE, FALSE, 0);

  html_index_entry = gtk_entry_new ();
  gtk_widget_show (html_index_entry);
  gtk_box_pack_end (GTK_BOX (hbox6), html_index_entry, TRUE, TRUE, 0);
  gtk_entry_set_width_chars (GTK_ENTRY (html_index_entry), 10);

  label2 = gtk_label_new (_("spice help"));
  gtk_widget_show (label2);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label2);
  gtk_label_set_use_markup (GTK_LABEL (label2), TRUE);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame3, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame3), GTK_SHADOW_IN);

  alignment3 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (frame3), alignment3);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment3), 0, 0, 12, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (alignment3), vbox3);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox7, TRUE, TRUE, 0);

  label11 = gtk_label_new (_("Browser: "));
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (hbox7), label11, FALSE, FALSE, 0);

  browser_entry = gtk_entry_new ();
  gtk_widget_show (browser_entry);
  gtk_box_pack_end (GTK_BOX (hbox7), browser_entry, TRUE, TRUE, 0);

  hseparator5 = gtk_hseparator_new ();
  gtk_widget_show (hseparator5);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator5, TRUE, TRUE, 0);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox8, TRUE, TRUE, 0);

  label5 = gtk_label_new (_("Text editor: "));
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox8), label5, FALSE, FALSE, 0);

  texteditor_entry = gtk_entry_new ();
  gtk_widget_show (texteditor_entry);
  gtk_box_pack_end (GTK_BOX (hbox8), texteditor_entry, TRUE, TRUE, 0);

  label3 = gtk_label_new (_("other programms"));
  gtk_widget_show (label3);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label3);
  gtk_label_set_use_markup (GTK_LABEL (label3), TRUE);

  dialog_action_area1 = GTK_DIALOG (command_setup)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  defaultbutton1 = gtk_button_new_with_mnemonic (_("Default"));
  gtk_widget_show (defaultbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (command_setup), defaultbutton1, 0);
  GTK_WIDGET_SET_FLAGS (defaultbutton1, GTK_CAN_DEFAULT);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (command_setup), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (command_setup), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) command_setup, "destroy",
                    G_CALLBACK (on_command_setup_destroy),
                    prog);
  g_signal_connect ((gpointer) defaultbutton1, "clicked",
                    G_CALLBACK (on_command_setup_default_clicked),
                    prog);
  g_signal_connect ((gpointer) cancelbutton1, "clicked",
                    G_CALLBACK (on_command_setup_cancel_clicked),
                    prog);
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_command_setup_ok_clicked),
                    prog);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (command_setup, command_setup, "command_setup");
  GLADE_HOOKUP_OBJECT_NO_REF (command_setup, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (command_setup, frame1, "frame1");
  GLADE_HOOKUP_OBJECT (command_setup, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (command_setup, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (command_setup, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (command_setup, label7, "label7");
  GLADE_HOOKUP_OBJECT (command_setup, simulator_command_entry, "simulator_command_entry");
  GLADE_HOOKUP_OBJECT (command_setup, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (command_setup, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (command_setup, label4, "label4");
  GLADE_HOOKUP_OBJECT (command_setup, plot_command_entry, "plot_command_entry");
  GLADE_HOOKUP_OBJECT (command_setup, label1, "label1");
  GLADE_HOOKUP_OBJECT (command_setup, frame2, "frame2");
  GLADE_HOOKUP_OBJECT (command_setup, alignment2, "alignment2");
  GLADE_HOOKUP_OBJECT (command_setup, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (command_setup, hbox5, "hbox5");
  GLADE_HOOKUP_OBJECT (command_setup, label9, "label9");
  GLADE_HOOKUP_OBJECT (command_setup, help_command_entry, "help_command_entry");
  GLADE_HOOKUP_OBJECT (command_setup, hseparator4, "hseparator4");
  GLADE_HOOKUP_OBJECT (command_setup, hbox6, "hbox6");
  GLADE_HOOKUP_OBJECT (command_setup, label10, "label10");
  GLADE_HOOKUP_OBJECT (command_setup, html_index_entry, "html_index_entry");
  GLADE_HOOKUP_OBJECT (command_setup, label2, "label2");
  GLADE_HOOKUP_OBJECT (command_setup, frame3, "frame3");
  GLADE_HOOKUP_OBJECT (command_setup, alignment3, "alignment3");
  GLADE_HOOKUP_OBJECT (command_setup, vbox3, "vbox3");
  GLADE_HOOKUP_OBJECT (command_setup, hbox7, "hbox7");
  GLADE_HOOKUP_OBJECT (command_setup, label11, "label11");
  GLADE_HOOKUP_OBJECT (command_setup, browser_entry, "browser_entry");
  GLADE_HOOKUP_OBJECT (command_setup, hseparator5, "hseparator5");
  GLADE_HOOKUP_OBJECT (command_setup, hbox8, "hbox8");
  GLADE_HOOKUP_OBJECT (command_setup, label5, "label5");
  GLADE_HOOKUP_OBJECT (command_setup, texteditor_entry, "texteditor_entry");
  GLADE_HOOKUP_OBJECT (command_setup, label3, "label3");
  GLADE_HOOKUP_OBJECT_NO_REF (command_setup, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (command_setup, defaultbutton1, "defaultbutton1");
  GLADE_HOOKUP_OBJECT (command_setup, cancelbutton1, "cancelbutton1");
  GLADE_HOOKUP_OBJECT (command_setup, okbutton1, "okbutton1");

  return command_setup;
}


GtkWidget*
create_quickmessage (gchar *title, gchar *text)
{
  GtkWidget *quickmessage;
  GtkWidget *dialog_vbox1;
  GtkWidget *message;
  GtkWidget *dialog_action_area1;
  GtkWidget *okbutton1;

  quickmessage = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (quickmessage), title);
  gtk_window_set_modal (GTK_WINDOW (quickmessage), TRUE);
  gtk_window_set_type_hint (GTK_WINDOW (quickmessage), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (quickmessage)->vbox;
  gtk_widget_show (dialog_vbox1);

  message = gtk_label_new (text);
  gtk_widget_show (message);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), message, FALSE, FALSE, 2);
  GTK_WIDGET_SET_FLAGS (message, GTK_CAN_FOCUS);
  gtk_label_set_selectable (GTK_LABEL (message), TRUE);

  dialog_action_area1 = GTK_DIALOG (quickmessage)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (quickmessage), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) okbutton1, "clicked",
		    G_CALLBACK (on_quickmessage_ok_clicked),
		    GTK_OBJECT (quickmessage));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (quickmessage, quickmessage, "quickmessage");
  GLADE_HOOKUP_OBJECT_NO_REF (quickmessage, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (quickmessage, message, "message");
  GLADE_HOOKUP_OBJECT_NO_REF (quickmessage, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (quickmessage, okbutton1, "okbutton1");

  gtk_widget_show(quickmessage);
  return quickmessage;
}

GtkWidget*
create_postproc (PostProcessing *postproc)
{
  GtkWidget *dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox1;
  GtkWidget *label4;
  GtkWidget *hseparator1;
  GtkWidget *scrolledwindow2;
  GtkWidget *textview;
  GtkWidget *dialog_action_area2;
  GtkWidget *button_cancel;
  GtkWidget *button_ok;

  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Post traitement"));
  gtk_window_set_type_hint (GTK_WINDOW (dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox2 = GTK_DIALOG (dialog)->vbox;
  gtk_widget_show (dialog_vbox2);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

  label4 = gtk_label_new (_("For all simulations:"));
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (vbox1), label4, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_SHADOW_IN);

  textview = gtk_text_view_new ();
  gtk_widget_show (textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), textview);

  dialog_action_area2 = GTK_DIALOG (dialog)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  button_cancel = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (button_cancel);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button_cancel, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

  button_ok = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (button_ok);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button_ok, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) dialog, "destroy",
                    G_CALLBACK (on_postprocessing_destroy),
                    postproc);
  g_signal_connect ((gpointer) button_cancel, "clicked",
                    G_CALLBACK (on_postprocessing_button_cancel_clicked),
                    postproc);
  g_signal_connect ((gpointer) button_ok, "clicked",
                    G_CALLBACK (on_postprocessing_button_ok_clicked),
                    postproc);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog, "dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_vbox2, "dialog_vbox2");
  GLADE_HOOKUP_OBJECT (dialog, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (dialog, label4, "label4");
  GLADE_HOOKUP_OBJECT (dialog, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (dialog, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (dialog, textview, "textview");
  GLADE_HOOKUP_OBJECT_NO_REF (dialog, dialog_action_area2, "dialog_action_area2");
  GLADE_HOOKUP_OBJECT (dialog, button_cancel, "button_cancel");
  GLADE_HOOKUP_OBJECT (dialog, button_ok, "button_ok");

  return dialog;
}

GtkWidget*
create_library_dialog (SpiceLibrary *spicelib)
{
  GtkWidget *library_dialog;
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *treeview1;
  GtkWidget *hseparator1;
  GtkWidget *hbuttonbox1;
  GtkWidget *button_add;
  GtkWidget *button_remove;
  GtkWidget *button_edit;
  GtkWidget *hbuttonbox2;
  GtkWidget *button_cancel;
  GtkWidget *button_ok;
  
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  
  library_dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (library_dialog), _("library editor"));

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (library_dialog), vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_IN);

  treeview1 = gtk_tree_view_new_with_model(GTK_TREE_MODEL(spicelib->store));
  gtk_widget_show (treeview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), treeview1);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview1), FALSE);
  gtk_widget_set_size_request (treeview1, -1, 200);

  /* set the controller of the MVC-system */
  renderer=gtk_cell_renderer_text_new();
  column=gtk_tree_view_column_new_with_attributes(_("Libraries"),
						  renderer,"text",0,NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(treeview1),column);
  /* */

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 5);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox1), 5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox1), 5);

  button_add = gtk_button_new_from_stock ("gtk-add");
  gtk_widget_show (button_add);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_add);
  GTK_WIDGET_SET_FLAGS (button_add, GTK_CAN_DEFAULT);

  button_remove = gtk_button_new_from_stock ("gtk-remove");
  gtk_widget_show (button_remove);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_remove);
  GTK_WIDGET_SET_FLAGS (button_remove, GTK_CAN_DEFAULT);

  button_edit = gtk_button_new_from_stock ("gtk-edit");
  gtk_widget_show (button_edit);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_edit);
  GTK_WIDGET_SET_FLAGS (button_edit, GTK_CAN_DEFAULT);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox2, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox2), 5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (hbuttonbox2), 5);

  button_cancel = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), button_cancel);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

  button_ok = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (button_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), button_ok);
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) library_dialog, "destroy",
                    G_CALLBACK (on_library_dialog_destroy),
                    spicelib);
  g_signal_connect ((gpointer) button_add, "clicked",
                    G_CALLBACK (on_library_dialog_add_clicked),
                    spicelib);
  g_signal_connect ((gpointer) button_remove, "clicked",
                    G_CALLBACK (on_library_dialog_remove_clicked),
                    spicelib);
  g_signal_connect ((gpointer) button_edit, "clicked",
                    G_CALLBACK (on_library_dialog_edit_clicked),
                    spicelib);
  g_signal_connect ((gpointer) button_cancel, "clicked",
                    G_CALLBACK (on_library_dialog_cancel_clicked),
                    spicelib);
  g_signal_connect ((gpointer) button_ok, "clicked",
                    G_CALLBACK (on_library_dialog_ok_clicked),
                    spicelib);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (library_dialog, library_dialog, "library_dialog");
  GLADE_HOOKUP_OBJECT (library_dialog, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (library_dialog, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (library_dialog, treeview1, "treeview1");
  GLADE_HOOKUP_OBJECT (library_dialog, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (library_dialog, hbuttonbox1, "hbuttonbox1");
  GLADE_HOOKUP_OBJECT (library_dialog, button_add, "button_add");
  GLADE_HOOKUP_OBJECT (library_dialog, button_remove, "button_remove");
  GLADE_HOOKUP_OBJECT (library_dialog, button_edit, "button_edit");
  GLADE_HOOKUP_OBJECT (library_dialog, hbuttonbox2, "hbuttonbox2");
  GLADE_HOOKUP_OBJECT (library_dialog, button_cancel, "button_cancel");
  GLADE_HOOKUP_OBJECT (library_dialog, button_ok, "button_ok");

  return library_dialog;
}
