#!/usr/bin/python
import os, stat
from albatross.cgiapp import Request
from albatross import SimpleApp


class Node:

    def __init__(self, ctx, name, path):
        self.name = name
        self.path = path
        st_mode = os.stat(path)[0]
        if stat.S_ISDIR(st_mode):
            self.children = []
            self.children_loaded = 0

    def load_children(self, ctx):
        names = os.listdir(self.path)
        names.sort()
        self.children = []
        for name in names:
            if name in ('.', '..'):
                continue
            self.children.append(Node(ctx, name, os.path.join(self.path, name)))

    def albatross_alias(self):
        return self.path


class TreePage:

    def page_display(self, ctx):
        ctx.locals.tree = Node(ctx, '/', '/var/www')
        ctx.run_template('tree.html')


app = SimpleApp(base_url='tree.py',
                template_path='.',
                start_page='start',
                secret='-=-secret-=-')
app.register_page('start', TreePage())


if __name__ == '__main__':
    app.run(Request())
