# D.1 Why does state intervention occur?

The most obvious interaction between statism and capitalism is when the state
intervenes in the economy. Indeed, the full range of capitalist politics is
expressed in how much someone thinks this should happen. At one extreme, there
are the right-wing liberals (sometimes mistakenly called "libertarians") who
seek to reduce the state to a defender of private property rights. At the
other, there are those who seek the state to assume full ownership and control
of the economy (i.e. state capitalists who are usually mistakenly called
"socialists"). In practice, the level of state intervention lies between these
two extremes, moving back and forth along the spectrum as necessity requires.

For anarchists, capitalism as an economy requires state intervention. There
is, and cannot be, a capitalist economy which does not exhibit some form of
state action within it. The state is forced to intervene in society for three
reasons:

         1. To bolster the power of capital as a whole within society.  
         2. To benefit certain sections of the capitalist class against others.  
         3. To counteract the anti-social effects of capitalism. 

From our discussion of the state and its role in [section B.2](secB2.md),
the first two reasons are unexpected and straight forward. The state is an
instrument of class rule and, as such, acts to favour the continuation of the
system as a whole. The state, therefore, has always intervened in the
capitalist economy, usually to distort the market in favour of the capitalist
class within its borders as against the working class and foreign competitors.
This is done by means of taxes, tariffs, subsidies and so forth.

State intervention has been a feature of capitalism from the start. As
Kropotkin argued, _"nowhere has the system of 'non-intervention of the State'
ever existed. Everywhere the State has been, and still is, the main pillar and
the creator, direct and indirect, of Capitalism and its powers over the
masses. Nowhere, since States have grown up, have the masses had the freedom
of resisting the oppression by capitalists. . . The state has **always**
interfered in the economic life in favour of the capitalist exploiter. It has
always granted him protection in robbery, given aid and support for further
enrichment. **And it could not be otherwise.** To do so was one of the
functions -- the chief mission -- of the State."_ [**Evolution and
Environment**, pp. 97-8]

In addition to this role, the state has also regulated certain industries and,
at times, directly involved itself in employing wage labour to product goods
and services. The classic example of the latter is the construction and
maintenance of a transport network in order to facilitate the physical
circulation of goods. As Colin Ward noted, transport _"is an activity heavily
regulated by government. This regulation was introduced, not in the interests
of the commercial transport operators, but in the face of their intense
opposition, as well as that of the ideologists of 'free' enterprise."_ He
gives the example of the railways, which were _"built at a time when it was
believed that market forces would reward the good and useful and eliminate the
bad or socially useless."_ However, _"it was found necessary as early as 1840
for the government's Board of Trade to regulate and supervise them, simply for
the protection of the public."_ [**Freedom to Go**, p. 7 and pp. 7-8]

This sort of intervention was to ensure that no one capitalist or group of
capitalists had a virtual monopoly over the others which would allow them to
charge excessive prices. Thus the need to bolster capital as a whole may
involve regulating or expropriating certain capitalists and sections of that
class. Also, state ownership was and is a key means of rationalising
production methods, either directly by state ownership or indirectly by paying
for Research and Development. That certain sections of the ruling class may
seek advantages over others by control of the state is, likewise, a truism.

All in all, the idea that capitalism is a system without state intervention is
a myth. The rich use the state to bolster their wealth and power, as would be
expected. Yet even if such a thing as a truly "laissez-faire" capitalist state
were possible, it would still be protecting capitalist property rights and the
hierarchical social relations these produce against those subject to them.
This means, as Kropotkin stressed, it _"has never practised"_ the idea of
laissez faire. In fact, _"while all Governments have given the capitalists and
monopolists full liberty to enrich themselves with the underpaid labour of
working men [and women] . . . they have **never**, **nowhere** given the
working [people] the liberty of opposing that exploitation. Never has any
Government applied the 'leave things alone' principle to the exploited masses.
It reserved it for the exploiters only."_ [**Op. Cit.**, p. 96] As such, under
pure "free market" capitalism state intervention would still exist but it
would be limited to repressing the working class (see [section
D.1.4](secD1.md#secd14) for more discussion).

Then there is the last reason, namely counteracting the destructive effects of
capitalism itself. As Chomsky puts it, _"in a predatory capitalist economy,
state intervention would be an absolute necessity to preserve human existence
and to prevent the destruction of the physical environment -- I speak
optimistically . . . social protection . . . [is] therefore a minimal
necessity to constrain the irrational and destructive workings of the
classical free market."_ [**Chomsky on Anarchism**, p. 111] This kind of
intervention is required simply because _"government cannot want society to
break up, for it would mean that it and the dominant class would be deprived
of sources of exploitation; nor can it leave society to maintain itself
without official intervention, for then people would soon realise that
government serves only to defend property owners . . . and they would hasten
to rid themselves of both."_ [Malatesta, **Anarchy**, p. 25]

So while many ideologues of capitalism thunder against state intervention (for
the benefit of the masses), the fact is that capitalism itself produces the
need for such intervention. The abstractly individualistic theory on which
capitalism is based ("everyone for themselves") results in a high degree of
statism since the economic system itself contains no means to combat its own
socially destructive workings. The state must also intervene in the economy,
not only to protect the interests of the ruling class but also to protect
society from the atomising and destructive impact of capitalism. Moreover,
capitalism has an inherent tendency toward periodic recessions or depressions,
and the attempt to prevent them has become part of the state's function.
However, since preventing them is impossible (they are built into the system
-- see [section C.7](secC7.md)), in practice the state can only try to
postpone them and ameliorate their severity. Let's begin with the need for
social intervention.

Capitalism is based on turning both labour and land into commodities. As
socialist Karl Polanyi points out, however, _"labour and land are no other
than the human beings themselves of which every society consists and the
natural surroundings in which it exists; to include labour and land in the
market mechanism means to subordinate the substance of society itself to the
laws of the market."_ And this means that _"human society has become an
accessory to the economic system,"_ with humanity placing itself fully in the
hands of supply and demand. But such a situation _"could not exist for any
length of time without annihilating the human and natural substance of
society; it would have physically destroyed man and transformed his
surroundings into a wilderness."_ This, inevitably, provokes a reaction in
order to defend the basis of society and the environment that capitalism
needs, but ruthlessly exploits. As Polanyi summarises, _"the countermove
against economic liberalism and laissez-faire possessed all the unmistakable
characteristics of a spontaneous reaction . . . [A] closely similar change
from laissez-faire to 'collectivism' took place in various countries at a
definite stage of their industrial development, pointing to the depth and
independence of the underlying causes of the process."_ [**The Great
Transformation**, p. 71, pp. 41-42 and pp. 149-150]

To expect that a community would remain indifferent to the scourge of
unemployment, dangerous working conditions, 16-hour working days, the shifting
of industries and occupations, and the moral and psychological disruption
accompanying them -- merely because economic effects, in the long run, might
be better -- is an absurdity. Similarly, for workers to remain indifferent to,
for example, poor working conditions, peacefully waiting for a new boss to
offer them better conditions, or for citizens to wait passively for
capitalists to start voluntarily acting responsibly toward the environment, is
to assume a servile and apathetic role for humanity. Luckily, labour refuses
to be a commodity and citizens refuse to stand idly by while the planet's
ecosystems are destroyed.

In other words, the state and many of its various policies are not imposed
from outside of the capitalist system. It is not some alien body but rather
has evolved in response to clear failings within capitalism itself (either
from the perspective of the ruling elite or from the general population). It
contrast, as the likes of von Hayek did, to the "spontaneous" order of the
market versus a "designed" order associated with state fails to understand
that the latter can come about in response to the former. In other words, as
Polanyi noted, state intervention can be a _"spontaneous reaction"_ and so be
a product of social evolution itself. While the notion of a spontaneous order
may be useful to attack undesired forms of state intervention (usually social
welfare, in the case of von Hayek), it fails to note this process at work nor
the fact that the state itself played a key role in the creation of capitalism
in the first place as well as specifying the rules for the operation and so
evolution of the market itself.

Therefore state intervention occurs as a form of protection against the
workings of the market. As capitalism is based on atomising society in the
name of "freedom" on the competitive market, it is hardly surprising that
defence against the anti-social workings of the market should take statist
forms -- there being few other structures capable of providing such defence
(as such social institutions have been undermined, if not crushed, by the rise
of capitalism in the first place). Thus, ironically, "individualism" produces
a "collectivist" tendency within society as capitalism destroys communal forms
of social organisation in favour of ones based on abstract individualism,
authority, and hierarchy -- all qualities embodied in the state, the sole
remaining agent of collective action in the capitalist worldview. Strangely,
conservatives and other right-wingers fail to see this, instead spouting on
about "traditional values" while, at the same time, glorifying the "free
market." This is one of the (many) ironic aspects of free market dogma, namely
that it is often supported by people who are at the forefront of attacking the
**effects** of it. Thus we see conservatives bemoaning the breakdown of
traditional values while, at the same time, advocating the economic system
whose operation weakens family life, breaks up communities, undermines social
bonds and places individual gain above all else, particularly "traditional
values" and "community." They seem blissfully unaware that capitalism destroys
the traditions they claim to support and recognises only monetary values.

In addition to social protection, state intervention is required to protect a
country's economy (and so the economic interests of the ruling class). As Noam
Chomsky points out, even the USA, home of "free enterprise," was marked by _
"large-scale intervention in the economy after independence, and conquest of
resources and markets. . . [while] a centralised developmental state [was
constructed] committed to [the] creation and entrenchment of domestic
manufacture and commerce, subsidising local production and barring cheaper
British imports, constructing a legal basis for private corporate power, and
in numerous other ways providing an escape from the stranglehold of
comparative advantage."_ [**World Orders, Old and New**, p. 114] State
intervention is as natural to capitalism as wage labour.

In the case of Britain and a host of other countries (and more recently in the
cases of Japan and the Newly Industrialising Countries of the Far East, like
Korea) state intervention was the key to development and success in the "free
market." (see, for example, Robert Wade's **Governing the Market**). In other
"developing" countries which have had the misfortune to be subjected to "free-
market reforms" (e.g. neo-liberal Structural Adjustment Programs) rather than
following the interventionist Japanese and Korean models, the results have
been devastating for the vast majority, with drastic increases in poverty,
homelessness, malnutrition, etc. (for the elite, the results are somewhat
different of course). In the nineteenth century, states only turned to
laissez-faire once they could benefit from it and had a strong enough economy
to survive it: _"Only in the mid-nineteenth century, when it had become
powerful enough to overcome any competition, did England [sic!] embrace free
trade."_ [Chomsky, **Op. Cit.**, p. 115] Before this, protectionism and other
methods were used to nurture economic development. And once laissez-faire
started to undermine a country's economy, it was quickly revoked. For example,
protectionism is often used to protect a fragile economy and militarism has
always been a favourite way for the ruling elite to help the economy, as is
still the case, for example, in the "Pentagon System" in the USA (see [section
D.8](secD8.md)).

Therefore, contrary to conventional wisdom, state intervention will always be
associated with capitalism due to: (1) its authoritarian nature; (2) its
inability to prevent the anti-social results of the competitive market; (3)
its fallacious assumption that society should be _"an accessory to the
economic system"_; (4) the class interests of the ruling elite; and (5) the
need to impose its authoritarian social relationships upon an unwilling
population in the first place. Thus the contradictions of capitalism
necessitate government intervention. The more the economy grows, the greater
become the contradictions and the greater the contradictions, the greater the
need for state intervention. The development of capitalism as a system
provides amble empirical support for this theoretical assessment.

Part of the problem is that the assumption that "pure" capitalism does not
need the state is shared by both Marxists and supporters of capitalism. _"So
long as capital is still weak,"_ Marx wrote, _"_it supports itself by leaning
on the crutches of past, or disappearing, modes of production. As soon as it
begins to feel itself strong, it throws away these crutches and moves about in
accordance with its own laws of motion. But as soon as it begins to feel
itself as a hindrance to further development and is recognised as such, it
adapts forms of behaviour through the harnessing of competition which
seemingly indicate its absolute rule but actually point to its decay and
dissolution." [quoted by Paul Mattick, **Marx and Keynes**, p. 96] Council
Communist Paul Mattick comments that a _"healthy"_ capitalism _"is a strictly
competitive capitalism, and the imperfections of competition in the early and
late stages of its development must be regarded as the ailments of an
infantile and of a senile capitalism. For a capitalism which restricts
competition cannot find its indirect 'regulation' in the price and market
movements which derive from the value relations in the production process."_
[**Op. Cit.**, p. 97]

However, this gives capitalism far too much credit -- as well as ignoring how
far the reality of that system is from the theory. State intervention has
always been a constant aspect of economic life under capitalism. Its limited
attempts at laissez-faire have always been failures, resulting in a return to
its statist roots. The process of selective laissez-faire and collectivism has
been as much a feature of capitalism in the past as it is now. Indeed, as Noam
Chomsky argues, _"[w]hat is called 'capitalism' is basically a system of
corporate mercantilism, with huge and largely unaccountable private tyrannies
exercising vast control over the economy, political systems, and social and
cultural life, operating in close co-operation with powerful states that
intervene massively in the domestic economy and international society. That is
dramatically true of the United States, contrary to much illusion. The rich
and privileged are no more willing to face market discipline than they have
been in the past, though they consider it just fine for the general
population."_ [**Marxism, Anarchism, and Alternative Futures**, p. 784] As
Kropotkin put it:

> _ "What, then is the use of taking, with Marx, about the 'primitive
accumulation' -- as if this 'push' given to capitalists were a thing of the
past? . . . In short, nowhere has the system of 'non-intervention of the
State' ever existed . . . Nowhere, since States have grown up, have the masses
had the freedom of resisting the oppression by capitalists. The few rights
they have now they have gained only by determination and endless sacrifice.  
>  _

>

> _"To speak therefore of 'non-intervention of the State' may be all right for
middle-class economists, who try to persuade the workers that their misery is
'a law of Nature.' But -- how can Socialists use such language?"_ [**Op.
Cit.**, pp. 97-8]

In other words, while Marx was right to note that the _"silent compulsion of
economic relations sets the seal on the domination of the capitalist over the
worker"_ he was wrong to state that _"[d]irect extra-economic force is still
of course used, but only in exceptional cases."_ The ruling class rarely lives
up to its own rhetoric and while _"rely[ing] on his [the workers'] dependence
on capital"_ it always supplements that with state intervention. As such, Marx
was wrong to state it was _"otherwise during the historical genesis of
capitalist production."_ It is not only the _"rising bourgeoisie"_ which
_"needs the power of the state"_ nor is it just _"an essential aspect of so-
called primitive accumulation."_ [**Capital**, vol. 1, pp. 899-900]

The enthusiasm for the "free market" since the 1970s is in fact the product of
the extended boom, which in turn was a product of a state co-ordinated war
economy and highly interventionist Keynesian economics (a boom that the
apologists of capitalism use, ironically, as "evidence" that "capitalism"
works) plus an unhealthy dose of nostalgia for a past that never existed. It's
strange how a system that has never existed has produced so much! When the
Keynesian system went into crisis, the ideologues of "free market" capitalism
seized their chance and found many in the ruling class willing to utilise
their rhetoric to reduce or end those aspects of state intervention which
benefited the many or inconvenienced themselves. However, state intervention,
while reduced, did not end. It simply became more focused in the interests of
the elite (i.e. the natural order). As Chomsky stresses, the "minimal state"
rhetoric of the capitalists is a lie, for they will _"never get rid of the
state because they need it for their own purposes, but they love to use this
as an ideological weapon against everyone else."_ They are _"not going to
survive without a massive state subsidy, so they want a powerful state."_
[**Chomsky on Anarchism**, p. 215]

And neither should it be forgotten that state intervention was required to
create the "free" market in the first place. To quote Polanyi again, _"[f]or
as long as [the market] system is not established, economic liberals must and
will unhesitatingly call for the intervention of the state in order to
establish it, and once established, in order to maintain it."_ [**Op. Cit.**,
p. 149] Protectionism and subsidy (mercantilism) -- along with the liberal use
of state violence against the working class -- was required to create and
protect capitalism and industry in the first place (see [section
F.8](secF8.md) for details).

In short, although laissez-faire may be the ideological basis of capitalism --
the religion that justifies the system -- it has rarely if ever been actually
practised. So, while the ideologues are praising "free enterprise" as the
fountainhead of modern prosperity, the corporations and companies are gorging
at the table of the State. As such, it would be wrong to suggest that
anarchists are somehow "in favour" of state intervention. This is not true. We
are "in favour" of reality, not ideology. The reality of capitalism is that it
needs state intervention to be created and needs state intervention to
continue (both to secure the exploitation of labour and to protect society
from the effects of the market system). That we have no truck with the myths
of "free market" economics does not mean we "support" state intervention
beyond recognising it as a fact of a system we want to end and that some forms
of state intervention are better than others.

## D.1.1 Does state intervention cause the problems to begin with?

It depends. In the case of state intervention on behalf of the ruling class,
the answer is always yes! However, in terms of social intervention the answer
is usually no.

However, for classical liberals (or, as we would call them today, neo-
liberals, right-wing "libertarians" or "conservatives"), state intervention is
the root of all evil. It is difficult for anarchists to take such argument
that seriously. Firstly, it is easily concluded from their arguments that they
are only opposed to state intervention on behalf of the working class (i.e.
the welfare state or legal support for trade unionism). They either ignore or
downplay state intervention on behalf of the ruling class (a few **do**
consistently oppose all state intervention beyond that required to defend
private property, but these unsurprisingly have little influence beyond
appropriation of some rhetoric and arguments by those seeking to bolster the
ruling elite). So most of the right attack the social or regulatory activities
of the government, but fail to attack those bureaucratic activities (like
defence, protection of property) which they agree with. As such, their
arguments are so selective as to be little more than self-serving special
pleading. Secondly, it does appear that their concern for social problems is
limited simply to their utility for attacking those aspects of state
intervention which claim to help those most harmed by the current system. They
usually show greater compassion for the welfare of the elite and industry than
for the working class. For former, they are in favour of state aid, for the
latter the benefits of economic growth is all that counts.

So what to make of claims that it is precisely the state's interference with
the market which causes the problems that society blames on the market? For
anarchists, such a position is illogical, for _"whoever says regulation says
limitation: now, how conceive of limiting privilege before it existed?"_ It
_"would be an effect without a cause"_ and so _"regulation was a corrective to
privilege"_ and not vice versa. _"In logic as well as in history, everything
is appropriated and monopolised when laws and regulations arrive."_ [Proudhon,
**System of Economic Contradictions**, p. 371] As economist Edward Herman
notes:

> _ "The growth of government has closely followed perceived failings of the
private market system, especially in terms of market instability, income
insecurity, and the proliferation of negative externalities. Some of these
deficiencies of the market can be attributed to its very success, which have
generated more threatening externalities and created demands for things the
market is not well suited to provide. It may also be true that the growth of
the government further weakens the market. This does not alter the fact that
powerful underlying forces -- not power hungry bureaucrats or frustrated
intellectuals -- are determining the main drift."_ [Edward Herman, **Corporate
Control, Corporate Power**, pp. 300-1]

In other words, state intervention is the result of the problems caused by
capitalism rather than their cause. To say otherwise is like arguing that
murder is the result of passing laws against it.

As Polanyi explains, the neo-liberal premise is false, because state
intervention always _"dealt with some problem arising out of modern industrial
conditions or, at any rate, in the market method of dealing with them."_ In
fact, most of these "collectivist" measures were carried out by _"convinced
supporters of laissez-faire . . . [and who] were as a rule uncompromising
opponents of [state] socialism or any other form of collectivism."_ [**Op.
Cit.**, p. 146] Sometimes such measures were introduced to undermine support
for socialist ideas caused by the excesses of "free market" capitalism but
usually there were introduced due to a pressing social need or problem which
capitalism created but could not meet or solve. This means that key to
understanding state intervention, therefore, is to recognise that politics is
a **not** matter of free will on behalf of politicians or the electorate.
Rather they are the outcome of the development of capitalism itself and result
from social, economic or environmental pressures which the state has to
acknowledge and act upon as they were harming the viability of the system as a
whole.

Thus state intervention did not spring out of thin air, but occurred in
response to pressing social and economic needs. This can be observed in the
mid 19th century, which saw the closest approximation to laissez-faire in the
history of capitalism. As Takis Fotopoulos argues, _"the attempt to establish
pure economic liberalism, in the sense of free trade, a competitive labour
market and the Gold Standard, did not last more than 40 years, and by the
1870s and 1880s, protectionist legislation was back . . . It was also
significant. . . [that all major capitalist powers] passed through a period of
free trade and laissez-faire, followed by a period of anti-liberal
legislation."_ [_"The Nation-state and the Market"_, pp. 37-80, **Society and
Nature**, Vol. 2, No. 2, p. 48]

For example, the reason for the return of protectionist legislation was the
Depression of 1873-86, which marked the end of the first experiment with pure
economic liberalism. Paradoxically, then, the attempt to liberalise the
markets led to more regulation. In light of our previous analysis, this is not
surprising. Neither the owners of the country nor the politicians desired to
see society destroyed, the result to which unhindered laissez-faire leads.
Apologists of capitalism overlook the fact that _"[a]t the beginning of the
Depression, Europe had been in the heyday of free trade."_ [Polanyi, **Op.
Cit.**, p. 216] State intervention came about in response to the social
disruptions resulting from laissez-faire. It did not cause them.

Similarly, it is a fallacy to state, as Ludwig von Mises did, that _"as long
as unemployment benefit is paid, unemployment must exist."_ [quoted by
Polanyi, **Op. Cit.**, p. 283] This statement is not only ahistoric but
ignores the existence of the **involuntary** unemployment (the purer
capitalism of the nineteenth century regularly experienced periods of economic
crisis and mass unemployment). Even such a die-hard exponent of the minimal
state as Milton Friedman recognised involuntary unemployment existed:

> _ "The growth of government transfer payments in the form of unemployment
insurance, food stamps, welfare, social security, and so on, has reduced
drastically the suffering associated with involuntary unemployment. . . most
laid-off workers . . . may enjoy nearly as high an income when unemployed as
when employed . . . At the very least, he need not be so desperate to find
another job as his counterpart in the 1930's. He can afford to be choosy and
to wait until he is either recalled or a more attractive job turns up."_
[quoted by Elton Rayack, **Not so Free to Choose**, p. 130]

Which, ironically, contradicts Friedman's own claims as regards the welfare
state. In an attempt to show that being unemployed is not as bad as people
believe Friedman _"glaringly contradicts two of his main theses, (1) that the
worker is free to choose and (2) that no government social programs have
achieved the results promised by its proponents."_ As Rayack notes, by
_"admitting the existence of involuntary unemployment, Friedman is, in
essence, denying that . . . the market protects the worker's freedom to
choose. . . In addition, since those social programs have made it possible for
the worker to be 'choosy; in seeking employment, to that extent the welfare
state has increased his freedom."_ [**Op. Cit.**, p. 130] But, of course, the
likes of von Mises will dismiss Friedman as a "socialist" and no further
thought is required.

That governments started to pay out unemployment benefit is not surprising,
given that mass unemployment can produce mass discontent. This caused the
state to start paying out a dole in order eliminate the possibility of crime
as well as working class self-help, which could conceivably have undermined
the status quo. The elite was well aware of the danger in workers organising
for their own benefit and tried to counter-act it. What the likes of von Mises
forget is that the state has to consider the long term viability of the system
rather than the ideologically correct position produced by logically deducting
abstract principles.

Sadly, in pursuing of ideologically correct answers, capitalist apologists
often ignore common sense. If one believes people exist for the economy and
not the economy for people, one becomes willing to sacrifice people and their
society today for the supposed economic benefit of future generations (in
reality, current profits). If one accepts the ethics of mathematics, a future
increase in the size of the economy is more important than current social
disruption. Thus Polanyi again: _"a social calamity is primarily a cultural
not an economic phenomenon that can be measured by income figures."_ [**Op.
Cit.**, p. 157] And it is the nature of capitalism to ignore or despise what
cannot be measured.

This does not mean that state intervention cannot have bad effects on the
economy or society. Given the state's centralised, bureaucratic nature, it
would be impossible for it **not** to have some bad effects. State
intervention can and does make bad situations worse in some cases. It also has
a tendency for self-perpetuation. As Elisee Reclus put it:

> _ "As soon as an institution is established, even if it should be only to
combat flagrant abuses, it creates them anew through its very existence. It
has to adapt to its bad environment, and in order to function, it must do so
in a pathological way. Whereas the creators of the institution follow only
noble ideals, the employees that they appoint must consider above all their
remuneration and the continuation of their employment."_ [_"The Modern
State"_, pp. 201-15, John P Clark and Camille Martin (eds.), **Anarchy,
Geography, Modernity**, p. 207]

As such, welfare within a bureaucratic system will have problems but getting
rid of it will hardly **reduce** inequality (as proven by the onslaught on it
by Thatcher and Reagan). This is unsurprising, for while the state bureaucracy
can never eliminate poverty, it can and does reduce it -- if only to keep the
bureaucrats secure in employment by showing some results.

Moreover, as Malatesta notes, _"the practical evidence [is] that whatever
governments do is always motivated by the desire to dominate, and is always
geared to defending, extending and perpetuating its privileges and those of
the class of which it is both the representative and defender."_ [**Anarchy**,
p. 24] In such circumstances, it would be amazing that state intervention did
not have negative effects. However, to criticise those negative effects while
ignoring or downplaying the far worse social problems which produced the
intervention in the first place is both staggeringly illogical and deeply
hypocritical. As we discuss later, in [section D.1.5](secD1.md#secd15), the
anarchist approach to reforms and state intervention is based on this
awareness.

## D.1.2 Is state intervention the result of democracy?

No. Social and economic intervention by the modern state began long before
universal suffrage became widespread. While this intervention was usually in
the interests of the capitalist class, it was sometimes done explicitly in the
name of the general welfare and the public interest. Needless to say, while
the former usually goes unmentioned by defenders of capitalism, the latter is
denounced and attacked as violations of the natural order (often in terms of
the sinister sounding "collectivist" measures).

That democracy is not the root cause for the state's interference in the
market is easily seen from the fact that non-democratic capitalist states
presided over by defenders of "free market" capitalism have done so. For
example, in Britain, acts of state intervention were introduced when property
and sexual restrictions on voting rights still existed. More recently, taking
Pinochet's neo-liberal dictatorship in Chile, we find that the state, as would
be expected, _"often intervened on behalf of private and foreign business
interests."_ Given the history of capitalism, this is to be expected. However,
the state also practised social intervention at times, partly to diffuse
popular disaffection with the economic realities the system generated
(disaffection that state oppression could not control) and partly to counter-
act the negative effects of its own dogmas. As such, _"[f]ree-market
ideologues are reluctant to acknowledge that even the Pinochet government
intervened in many cases in the market-place in last-minute attempts to offset
the havoc wrecked by its free-market policies (low-income housing, air
quality, public health, etc.)"_ [Joseph Collins and John Lear, **Chile's Free-
Market Miracle: A Second Look**, p. 254]

The notion that it is "democracy" which causes politicians to promise the
electorate state action in return for office is based on a naive viewpoint of
representative democracy. The centralist and hierarchical nature of
"representative" democracy means that the population at large has little real
control over politicians, who are far more influenced by big business,
business lobby groups, and the state bureaucracy. This means that truly
popular and democratic pressures are limited within the capitalist state and
the interests of elites are far more decisive in explaining state actions.

Obviously anarchists are well aware that the state does say it intervenes to
protect the interests of the general public, not the elite. While much of this
is often rhetoric to hide policies which (in reality) benefit corporate
interests far more than the general public, it cannot be denied that such
intervention does exist, to some degree. However, even here the evidence
supports the anarchist claim that the state is an instrument of class rule,
not a representative of the general interest. This is because such reforms
have, in general, been few and far between compared to those laws which
benefit the few.

Moreover, historically when politicians have made legal changes favouring the
general public rather than the elite they have done so only after intense
social pressure from below. For examples, the state only passed pro-union laws
only when the alternative was disruptive industrial conflict. In the US, the
federal government, at best, ignored or, at worse, actively suppressed labour
unions during the 19th century. It was only when mineworkers were able to shut
down the anthracite coal fields for months in 1902, threatening disruption of
heating supplies around the country, that Teddy Roosevelt supported union
demands for binding arbitration to raise wages. He was the first President in
American history to intervene in a strike in a positive manner on behalf of
workers.

This can be seen from the "New Deal" and related measures of limited state
intervention to stimulate economic recovery during the Great Depression. These
were motivated by more material reasons than democracy. Thus Takis Fotopoulos
argues that _"[t]he fact . . .that 'business confidence' was at its lowest
could go a long way in explaining the much more tolerant attitude of those
controlling production towards measures encroaching on their economic power
and profits. In fact, it was only when -- and as long as -- state
interventionism had the approval of those actually controlling production that
it was successful."_ [_"The Nation-state and the Market"_, **Op. Cit.**, p.
55] As anarchist Sam Dolgoff notes, the New Deal in America (and similar
policies elsewhere) was introduced, in part, because the _"whole system of
human exploitation was threatened. The political state saved itself, and all
that was essential to capitalism, doing what 'private enterprise' could not
do. Concessions were made to the workers, the farmers, the middle-class, while
the private capitalists were deprived of some of their power."_ [**The
American Labor Movement**, pp. 25-6] Much the same can be said of the post-war
Keynesianism consensus, which combined state aid to the capitalist class with
social reforms. These reforms were rarely the result of generous politicians
but rather the product of social pressures from below and the needs of the
system as a whole. For example, the extensive reforms made by the 1945 Labour
Government in the UK was the direct result of ruling class fear, not
socialism. As Quentin Hogg, a Conservative M.P., put it in the House of
Parliament in 1943: _"If you do not give the people social reforms, they are
going to give you revolution."_ Memories of the near revolutions across Europe
after the First World War were obviously in many minds, on both sides.

Needless to say, when the ruling class considered a specific reform to be
against its interests, it will be abolished or restricted. An example of this
can be seen in the 1934 Wagner Act in the USA, which gave US labour its first
and last political victory. The Act was passed due to the upsurge in wildcat
strikes, factory occupations and successful union organising drives which were
spreading throughout the country. Its purpose was specifically to calm this
struggle in order to preserve "labour peace." The act made it legal for unions
to organise, but this placed labour struggles within the boundaries of legal
procedures and so meant that they could be more easily controlled. In
addition, this concession was a form of appeasement whose effect was to make
those involved in union actions less likely to start questioning the
fundamental bases of the capitalist system. Once the fear of a militant labour
movement had passed, the Wagner Act was undermined and made powerless by new
laws, laws which made illegal the tactics which forced the politicians to pass
the law in the first place and increased the powers of bosses over workers.
The same can be said of other countries.

The pattern is clear. It is always the case that things need to change on the
ground first and then the law acknowledges the changes. Any state intervention
on behalf of the general public or workers have all followed people and
workers organising and fighting for their rights. If labour or social "peace"
exists because of too little organising and protesting or because of lack of
strength in the workplace by unions, politicians will feel no real pressure to
change the law and, consequently, refuse to. As Malatesta put it, the _"only
limit to the oppression of government is that power with which the people show
themselves capable of opposing it . . . When the people meekly submit to the
law, or their protests are feeble and confined to words, the government
studies its own interests and ignores the needs of the people; when the
protests are lively, insistent, threatening, the government . . . gives way or
resorts to repression."_ [**Errico Malatesta: His Life and Ideas**, p. 196]

Needless to say, the implication of classical liberal ideology that popular
democracy is a threat to capitalism is the root of the fallacy that democracy
leads to state intervention. The notion that by limiting the franchise the
rich will make laws which benefit all says more about the classical liberals'
touching faith in the altruism of the rich than it does about their
understanding of human nature, the realities of both state and capitalism and
their grasp of history. The fact that they can join with John Locke and claim
with a straight face that all must abide by the rules that only the elite make
says a lot about their concept of "freedom."

Some of the more modern classical liberals (for example, many right-wing
"libertarians") advocate a "democratic" state which cannot intervene in
economic matters. This is no solution, however, as it only gets rid of the
statist response to real and pressing social problems caused by capitalism
without supplying anything better in its place. This is a form of paternalism,
as the elite determines what is, and is not, intervention and what the masses
should, and should not, be able to do (in their interests, of course). Then
there is the obvious conclusion that any such regime would have to exclude
change. After all, if people can change the regime they are under they may
change it in ways that the right does not support. The provision for ending
economic and other reforms would effectively ban most opposition parties as,
by definition, they could do nothing once in power. How this differs from a
dictatorship would be hard to say -- after all, most dictatorships have
parliamentary bodies which have no power but which can talk a lot.

Needless to say, the right often justify this position by appealing to the
likes of Adam Smith but this, needless to say, fails to appreciate the
changing political and economic situation since those days. As market
socialist Allan Engler argues:

> _ "In Smith's day government was openly and unashamedly an instrument of
wealth owners. Less than 10 per cent of British men -- and no women at all --
had the right to vote. When Smith opposed government interference in the
economy, he was opposing the imposition of wealth owners' interests on
everybody else. Today, when neoconservatives oppose state interference, their
aim to the opposite: to stop the representatives of the people from
interfering with the interests of wealth owners."_ [**Apostles of Greed**, p.
104]

As well as the changing political situation, Smith's society was without the
concentrations of economic power that marks capitalism as a developed system.
Whether Smith would have been happy to see his name appropriated to defend
corporate power is, obviously, a moot point. However, he had no illusions that
the state of his time interfered to bolster the elite, not the many (for
example: _"Whenever the law has attempted to regulate the wages of workmen, it
has always been rather to lower them than to raise them."_ [**The Wealth of
Nations**, p. 119]). As such, it is doubtful he would have agreed with those
who involve his name to defend corporate power and trusts while advocating the
restriction of trade unions as is the case with modern day neo-liberalism:

> _ "Whenever the legislature attempts to regulate the differences between
masters and their workmen, its counsellors are always masters. When the
regulation, therefore, is in favour of the workmen, it is always just and
equitable . . . When masters combine together in order to reduce the wages of
their workmen, they commonly enter into a private bond or agreement . . . Were
the workmen to enter into a contrary combination of the same kind. not to
accept of a certain wage under a certain penalty, the law would punish them
very severely; and if dealt impartially, it would treat the masters in the
same way."_ [**Op. Cit.**, p. 129]

The interest of merchants and master manufacturers, Smith stressed, _"is
always in some respects different from, and even opposite to, that of the
public . . . The proposal of any new law or regulation of commerce which comes
from this order ought always to be listened to with great precaution, and
ought never to be adopted till after having been long and carefully examined,
not only with the most scrupulous, but with the most suspicious attention. It
comes from an order of men whose interest is never exactly the same with that
of the public, who have generally an interest to deceive and even to oppress
the public, and who accordingly have, upon many occasions, both deceived and
oppressed it."_ [**Op. Cit.**, pp. 231-2] These days Smith would have likely
argued that this position applies equally to attempts by big business to
**revoke** laws and regulations!

To view the state intervention as simply implementing the wishes of the
majority is to assume that classes and other social hierarchies do not exist,
that one class does not oppress and exploit another and that they share common
interests. It means ignoring the realities of the current political system as
well as economic, for political parties will need to seek funds to campaign
and that means private cash. Unsurprisingly, they will do what their backers
demands and this dependence the wealthy changes the laws all obey. This means
that any government will tend to favour business and the wealthy as the
parties are funded by them and so they get some say over what is done. Only
those parties which internalise the values and interests of their donors will
prosper and so the wealthy acquire an unspoken veto power over government
policy. In other words, parties need to beg the rich for election funds. Some
parties do, of course, have trade union funding, but this is easily
counteracted by pressure from big business (i.e., that useful euphemism, _"the
markets"_) and the state bureaucracy. This explains why the unions in, say,
Britain spend a large part of their time under Labour governments trying to
influence it by means of strikes and lobbying.

The defenders of "free market" capitalism appear oblivious as to the reasons
**why** the state has approved regulations and nationalisations as well as
**why** trade unions, (libertarian and statist) socialist and populist
movements came about in the first place. Writing all these off as the products
of ideology and/or economic ignorance is far too facile an explanation, as is
the idea of power hungry bureaucrats seeking to extend their reach. The truth
is much more simple and lies at the heart of the current system. The reasons
why various "anti-capitalist" social movements and state interventions arise
with such regular periodicity is because of the effects of an economic system
which is inherently unstable and exploitative. For example, social movements
arose in the 19th century because workers, artisans and farmers were suffering
the effects of a state busy creating the necessary conditions for capitalism.
They were losing their independence and had become, or were being turned, into
wage slaves and, naturally, hated it. They saw the negative effects of
capitalism on their lives and communities and tried to stop it.

In terms of social regulation, the fact is that they were often the result of
pressing needs. Epidemics, for example, do not respect property rights and the
periodic deep recessions that marked 19th century capitalism made the desire
to avoid them an understandable one on the part of the ruling elite. Unlike
their ideological followers in the latter part of the century and onwards, the
political economists of the first half of the nineteenth century were too
intelligent and too well informed to advocate out-and-out laissez-faire. They
grasped the realities of the economic system in which they worked and thought
and, as a result, were aware of clash between the logic of pure abstract
theory and the demands of social life and morality. While they stressed the
pure theory, the usually did so in order to justify the need for state
intervention in some particular aspect of social or economic life. John Stuart
Mill's famous chapter on _"the grounds and limits of the laissez-faire and
non-interference principle"_ in his **Principles of Political Economy** is,
perhaps, the most obvious example of this dichotomy (unsurprisingly, von Mises
dismissed Mill as a "socialist" -- recognising the problems which capitalism
itself generates will make you ideologically suspect to the true believer).

To abolish these reforms without first abolishing capitalism is to return to
the social conditions which produced the social movements in the first place.
In other words, to return to the horrors of the 19th century. We can see this
in the USA today, where this process of turning back the clock is most
advanced: mass criminality, lower life expectancy, gated communities,
increased work hours, and a fortune spent on security. However, this should
not blind us to the limitations of these movements and reforms which, while
coming about as a means to overcome the negative effects of corporate
capitalism upon the population, **preserved** that system. In terms of
successful popular reform movements, the policies they lead to were (usually)
the minimum standard agreed upon by the capitalists themselves to offset
social unrest.

Unsurprisingly, most opponents of state intervention are equally opposed to
popular movements and the pressures they subject the state to. However trying
to weaken (or even get rid of) the social movements which have helped reform
capitalism ironically helps bolster the power and centralisation of the state.
This is because to get rid of working class organisations means eliminating a
key counter-balance to the might of the state. Atomised individuals not only
cannot fight capitalist exploitation and oppression, they also cannot fight
and restrict the might of the state nor attempt to influence it even a
fraction of what the wealthy elite can via the stock market and management
investment decisions. As such, von Hayek's assertion that _"it is inexcusable
to pretend that . . . the pressure which can be brought by the large firms or
corporation is comparable to that of the organisation of labour"_ is right,
but in the exact opposite way he intended. [**Law, Legislation and Liberty**,
vol. III, p. 89] Outside the imagination of conservatives and right-wing
liberals, big business has much greater influence than trade unions on
government policy (see [section D.2](secD2.md) for some details). While
trade union and other forms of popular action are more visible than elite
pressures, it does not mean that the form does not exist or less influential.
Quite the reverse. The latter may be more noticeable, true, but is only
because it has to be in order to be effective and because the former is so
prevalent.

The reality of the situation can be seen from looking at the US, a political
system where union influence is minimal while business influence and lobbying
is large scale (and has been since the 1980s). A poll of popular attitudes
about the 2005 US budget _"revealed that popular attitudes are virtually the
inverse of policy."_ In general, there is a _"dramatic divide between public
opinion and public policy,"_ but public opinion has little impact on state
officials. Unsurprisingly, the general population _"do not feel that the
government is responsive to the public will."_ The key to evaluating whether a
state is a functioning democracy is dependent on _"what public opinion is on
major issues"_ and _"how it relates to public policy."_ In the case of the US,
business interests are supreme and, as such, _"[n]ot only does the US
government stand apart from the rest of the world on many crucial issues, but
even from its own population."_ The state _"pursues the strategic and economic
interests of dominant sectors of the domestic population,"_ unless forced
otherwise by the people (for _"rights are not likely to be granted by
benevolent authorities"_ but rather by _"education and organising"_). In
summary, governments implement policies which benefit _"the short-term
interests of narrow sectors of power and wealth . . . It takes wilful
blindness not to see how these commitments guide . . . policy."_ [Chomsky,
**Failed States**, p. 234, p. 235, p. 228, p. 229, p. 262, p. 263 and p. 211]
A clearer example of how capitalist "democracy" works can hardly be found.

Von Hayek showed his grasp of reality by stating that the real problem is
_"not the selfish action of individual firms but the selfishness of organised
groups"_ and so _"the real exploiters in our present society are not egotistic
capitalists . . . but organisations which derive their power from the moral
support of collective action and the feeling of group loyalty."_ [**Op.
Cit.**, p. 96] So (autocratic) firms and (state privileged) corporations are
part of the natural order, but (self-organised and, at worse, relatively
democratic) unions are not. Ignoring the factual issues of the power and
influence of wealth and business, the logical problem with this opinion is
clear. Companies are, of course, _"organised groups"_ and based around
_"collective action"_. The difference is that the actions and groups are
dictated by the few individuals at the top. As would be expected, the
application of his ideas by the Thatcher government not only bolstered
capitalist power and resulted in increased inequality and exploitation (see
[section J.4.2](secJ4.md#secj42)) but also a strengthening and
centralisation of state power. One aspect of this the introduction of
government regulation of unions as well as new legislation which increase
police powers to restrict the right to strike and protest (both of which were,
in part, due opposition to free market policies by the population).

Anarchists may agree that the state, due to its centralisation and
bureaucracy, crushes the spontaneous nature of society and is a handicap to
social progress and evolution. However, leaving the market alone to work its
course fallaciously assumes that people will happily sit back and let market
forces rip apart their communities and environment. Getting rid of state
intervention without getting rid of capitalism and creating a free society
would mean that the need for social self-protection would still exist but that
there would be even less means of achieving it than now. The results of such a
policy, as history shows, would be a catastrophe for the working class (and
the environment, we must add) and beneficial only for the elite (as intended,
of course).

Ultimately, the implication of the false premise that democracy leads to state
intervention is that the state exists for the benefit of the majority, which
uses the state to exploit the elite! Amazingly, many capitalist apologists
accept this as a valid inference from their premise, even though it's
obviously a **reductio ad absurdum** of that premise as well as going against
the facts of history. That the ruling elite is sometimes forced to accept
state intervention outside its preferred area of aid for itself simply means
that, firstly, capitalism is an unstable system which undermines its own
social and ecological basis and, secondly, that they recognise that reform is
preferable to revolution (unlike their cheerleaders).

## D.1.3 Is state intervention socialistic?

No. Libertarian socialism is about self-liberation and self-management of
one's activities. Getting the state to act for us is the opposite of these
ideals. In addition, the question implies that socialism is connected with its
nemesis, statism, and that socialism means even more bureaucratic control and
centralisation (_"socialism is the contrary of governmentalism."_ [Proudhon,
**No Gods, No Masters**, vol. 1, p. 63]). As Kropotkin stressed: _"State
bureaucracy and centralisation are as irreconcilable with socialism as was
autocracy with capitalist rule."_ [**Evolution and Environment**, p. 185] The
history of both social democracy and state socialism proved this, with the
former merely reforming some aspects of capitalism while keeping the system
intact while the latter created an even worse form of class system.

The identification of socialism with the state is something that social
democrats, Stalinists and capitalist apologists **all** agree upon. However,
as we'll see in [section H.3.13](secH3.md#sech313), "state socialism" is in
reality just state capitalism -- the turning of the world into "one office and
one factory" (to use Lenin's expression). Little wonder that most sane people
join with anarchists in rejecting it. Who wants to work under a system in
which, if one does not like the boss (i.e. the state), one cannot even quit?

The theory that state intervention is "creeping socialism" takes the laissez-
faire ideology of capitalism at its face value, not realising that it is
ideology rather than reality. Capitalism is a dynamic system and evolves over
time, but this does not mean that by moving away from its theoretical starting
point it is negating its essential nature and becoming socialistic. Capitalism
was born from state intervention, and except for a very short period of
laissez-faire which ended in depression has always depended on state
intervention for its existence. As such, while there _"may be a residual sense
to the notion that the state serves as an equaliser, in that without its
intervention the destructive powers of capitalism would demolish social
existence and the physical environment, a fact that has been well understood
by the masters of the private economy who have regularly called upon the state
to restrain and organise these forces. But the common idea that the government
acts as a social equaliser can hardly be put forth as a general principle."_
[Noam Chomsky, **The Chomsky Reader**, p. 185]

The list of state aid to business is lengthy and can hardly be considered as
socialistic or egalitarian is aim (regardless of its supporters saying it is
about creating "jobs" rather than securing profits, the reality of the
situation). Government subsidies to arms companies and agribusiness, its
subsidy of research and development work undertaken by government-supported
universities, its spending to ensure a favourable international climate for
business operations, its defence of intellectual property rights, its tort
reform (i.e. the business agenda of limiting citizen power to sue
corporations), its manipulation of unemployment rates, and so forth, are all
examples of state intervention which can, by no stretch of the imagination be
considered as "socialistic." As left-liberal economist Dean Baker notes:

> _ "The key flaw in the stance that most progressives have taken on economic
issues is that they have accepted a framing whereby conservatives are assumed
to support market outcomes, while progressives want to rely on the government
. . . The reality is that conservatives have been quite actively using the
power of the government to shape market outcomes in ways that redistribute
income upward. However, conservatives have been clever enough to not own up to
their role in this process, pretending all along that everything is just the
natural working of the market. And, progressives have been foolish enough to
go along with this view."_ [**The Conservative Nanny State: How the Wealthy
Use the Government to Stay Rich and Get Richer**, p. v]

He stresses, that _"both conservatives and liberals want government
intervention. The difference between them is the goal of government
intervention, and the fact that conservatives are smart enough to conceal
their dependence on the government."_ They _"want to use the government to
distribute income upward to higher paid workers, business owners, and
investors. They support the establishment of rules and structures that have
this effect."_ Dean discusses numerous examples of right-wing forms of state
action, and notes that _"[i]n these areas of public policy . . . conservatives
are enthusiastic promoters of big government. They are happy to have the
government intervene into the inner workings of the economy to make sure that
money flows in the direction they like -- upward. It is accurate to say that
conservatives don't like big government social programs, but not because they
don't like big government. The problem with big government social programs is
that they tend to distribute money downward, or provide benefits to large
numbers of people."_ It seems redundant to note that _"conservatives don't own
up to the fact that the policies they favour are forms of government
intervention. Conservatives do their best to portray the forms of government
intervention that they favour, for example, patent and copyright protection,
as simply part of the natural order of things."_ [**Op. Cit.**, p. 1 and p. 2]

This, it should be stressed, is unexpected. As we explained in [section
B.2](secB2.md), the state is an instrument of minority rule. As such, it
strains belief that state intervention would be socialist in nature. After
all, if the state is an agent of a self-interesting ruling class, then its
laws are inevitably biased in its favour. The ultimate purpose of the state
and its laws are the protection of private property and so the form of law is
a class weapon while its content is the protection of class interests. They
are inseparable.

So the state and its institutions can _"challenge the use of authority by
other institutions, such as cruel parents, greedy landlords, brutal bosses,
violent criminals"_ as well as _"promot[ing] desirable social activities, such
as public works, disaster relief, communications and transport systems, poor
relief, education and broadcasting."_ Anarchists argue, though, the state
remains _"primarily . . . oppressive"_ and its _"main function is in fact to
hold down the people, to limit freedom"_ and that _"all the benevolent
functions of the state can be exercised and often have been exercised by
voluntary associations."_ Moreover, _"the essential function of the state is
to maintain the existing inequality"_ and so _"cannot redistribute wealth
fairly because it is the main agency of the unfair distribution."_ This is
because it is _"the political expression of the economic structure, that it is
the representative of the people who own or control the wealth of the
community and the oppressor of the people who do the work which creates
wealth."_ [Walters, **About Anarchism**, p. 36 and p. 37]

The claim that state intervention is "socialist" also ignores the realities of
power concentration under capitalism. Real socialism equalises power by
redistributing it to the people, but, as Noam Chomsky points out, _"[i]n a
highly inegalitarian society, it is most unlikely that government programs
will be equalisers. Rather, it is to be expected that they will be designed
and manipulated by private power for their own benefits; and to a significant
degree the expectation is fulfilled. It is not very likely that matters could
be otherwise in the absence of mass popular organisations that are prepared to
struggle for their rights and interests."_ [**Op. Cit.**, p. 184] The notion
that "welfare equals socialism" is nonsense, although it can reduce poverty
and economic inequality somewhat. As Colin Ward notes, _"when socialists have
achieved power"_ they have produced nothing more than _"[m]onopoly capitalism
with a veneer of social welfare as a substitute for social justice."_
[**Anarchy in Action**, p. 18]

This analysis applies to state ownership and control of industry. Britain, for
example, saw the nationalisation of roughly 20% of the economy by the 1945
Labour Government. These were the most unprofitable sections of the economy
but, at the time, essential for the economy as a whole. By taking it into
state ownership, these sections could be rationalised and developed at public
expense. Rather than nationalisation being feared as "socialism," the
capitalist class had no real issue with it. As anarchists at the time noted,
_"the real opinions of capitalists can be seen from Stock Exchange conditions
and statements of industrialists [rather] than the Tory Front bench . . . [and
from these we] see that the owning class is not at all displeased with the
record and tendency of the Labour Party."_ [Vernon Richards (ed.), **Neither
Nationalisation nor Privatisation -- Selections from Freedom 1945-1950**, p.
9]

Moreover, the example of nationalised industries is a good indicator of the
non-socialist nature of state intervention. Nationalisation meant replacing
the capitalist bureaucrat with a state one, with little real improvement for
those subjected to the "new" regime. At the height of the British Labour
Party's post-war nationalisations, anarchists were pointing out its anti-
socialist nature. Nationalisation was _"really consolidating the old
individual capitalist class into a new and efficient class of managers to run
. . . state capitalism"_ by _"installing the really creative industrialists in
dictatorial managerial positions."_ [Vernon Richards (ed.), **Op. Cit.**, p.
10] Thus, in practice, the real examples of nationalisation confirmed
Kropotkin's prediction that it would be _"an exchange of present capitalism
for state-capitalism"_ and simply be _"nothing but a new, perhaps improved,
but still undesirable form of the wage system."_ [**Evolution and
Environment**, p. 193 and p. 171] The nationalised industries were expected,
of course, to make a profit, partly for _"repaying the generous compensation
plus interest to the former owners of the mainly bankrupt industries that the
Labour government had taken over."_ [Richards, **Op. Cit.**, p. 7]

Ultimately, state ownership at local or national level is hardly socialistic
in principle or in practice. As Kropotkin stressed, _"no reasonable man [or
woman] will expect that Municipal Socialism, any more than Co-operation, could
solve to any extent the Social problem."_ This was because it was _"self-
evident that [the capitalists] will not let themselves be expropriated without
opposing resistance. They may favour municipal [or state] enterprise for a
time; but the moment they see that it really begins to reduce the number of
paupers . . . or gives them regular employment, and consequently threatens to
reduce the profits of the exploiters, they will soon put an end to it."_
[**Act for Yourselves**, p. 94 and p. 95] The rise of Monetarism in the 1970s
and the subsequent enthronement of the "Natural Rate" of unemployment thesis
proves this argument.

While state intervention is hardly socialistic, what can be said is that _"the
positive feature of welfare legislation is that, contrary to the capitalist
ethic, it is a testament to human solidarity. The negative feature is
precisely that it is an arm of the state."_ [Colin Ward, **Talking Anarchy**,
p. 79] For anarchists, while _"we are certainly in full sympathy with all that
is being done to widen the attributes of city life and to introduce
communistic conceptions into it. But it is only through a Social Revolution,
made by the workers themselves, that the present exploitation of Labour by
Capital can be altered."_ [Kropotkin, **Op. Cit.**, pp. 95-6] As British
anarchists stressed during the first post-war Labour Government:

> _ "The fact that the alternative, under capitalism, is destitution and the
sharper anomalies of poverty, does not make the Liberal-Socialistic
alternative a sound proposition."  
>  _

>

> _"The only rational insurance against the evils of poverty and industrialism
and old age under the wages system is the abolition of poverty and the wages
system, and the transformation of industrialism to serve human ends instead of
grinding up human beings."_ [Vernon Richards (ed.), **World War - Cold War**,
p. 347]

In reality, rather than genuine socialism we had reformists _"operating
capitalism while trying to give it a socialist gloss."_ [**Op. Cit.**, p. 353]
The fact is that the ruling class oppose those forms of state intervention
which aim, at least in rhetoric, to help working class people. This does not
make such reforms socialistic. The much more substantial state intervention
for the elite and business are simply part of the natural order and go
unmentioned. That this amounts to a welfare state for the wealthy or socialism
for the rich is, of course, one of the great unspeakable truths of capitalism.

## D.1.4 Is laissez-faire capitalism actually without state intervention?

The underlying assumption in the neo-liberal and conservative attacks against
state intervention is the assumption that their minimal state is without it.
The reality of the situation is, of course, different. Even the minimal state
of the ideologues dreams intervenes on behalf of the ruling class in order to
defend capitalist power and the property and property rights this flows from.

This means that the laissez-faire position is a form of state intervention as
well. State "neutrality" considered as simply enforcing property rights (the
"minimal state") instantly raises the question of **whose** conception of
property rights, popular ones or capitalist ones? Unsurprisingly, the
capitalist state enforces capitalist notions of property. In other words, it
sanctions and supports economic inequality and the privileges and power of
those who own property and, of course, the social relationships such a system
generates. Yet by defending capitalist property, the state can hardly remain
"neutral" with regards to ownership and the power it generates. In other
words, the "neutral" state **has** to intervene to defend the authority of the
boss or landlord over the workers they exploit and oppress. It is not a
"public body" defending some mythical "public interest" but rather a defender
of class society and the socio-economic relationships such a system creates.
Political power, therefore, reflects and defends economic and social power.

As Kropotkin argued, the _"major portion"_ of laws have _"but one object -- to
protect private property, i.e. wealth acquired by the exploitation of man by
man. Their aim is to open to capital fresh fields for exploitation, and to
sanction the new forms which that exploitation continually assumes, as capital
swallows up another branch of human activity . . . They exist to keep up the
machinery of government which serves to secure to capital the exploitation and
monopoly of wealth produced."_ This means that all modern states _"all serve
one God -- capital; all have but one object -- to facilitate the exploitation
of the worker by the capitalist."_ [**Anarchism**, p. 210]

Given that the capitalist market is marked by inequalities of power, any legal
framework will defend that power. The state simply allows the interaction
between parties to determine the norms of conduct in any contract. This
ensures that the more powerful party to impose its desires on the weaker one
as the market, by definition, does not and cannot have any protections against
the imposition of private power. The state (or legal code) by enforcing the
norms agreed to by the exchange is just as much a form of state intervention
as more obvious forms of state action. In other words, the state's monopoly of
power and coercion is used to enforce the contracts reached between the
powerful and powerless. As such contracts will hardly be neutral, the state
cannot be a neutral arbiter when presiding over capitalism. The net result is
simply that the state allows the more powerful party to an exchange to have
authority over the weaker party -- all under the fiction of equality and
freedom. And, as Malatesta stressed, state power and centralisation will have
to increase:

> _ "liberalism, is in theory a kind of anarchy without socialism, and
therefore is simply a lie, for freedom is not possible without equality, and
real anarchy cannot exist without solidarity, without socialism. The criticism
liberals direct at government consists of wanting to deprive it of some of its
functions and to call upon the capitalists to fight it out among themselves,
but it cannot attack the repressive functions which are of its essence: for
with the **gendarme** the property owner could not exist, indeed the
government's powers of repression must perforce increase as free competition
results in more discord and inequality."_ [**Anarchy**, p. 46]

His comments were more than confirmed by the rise of neo-liberalism nearly a
century later which combined the "free(r) market" with a strong state marked
by more extensive centralisation and police powers.

This is unsurprising, as laissez-faire capitalism being _"unable to solve its
celebrated problem of the harmony of interests, [is forced] to impose laws, if
only provisional ones, and abdicates in its turn before this new authority
that is incompatible with the practice of liberty."_ [Proudhon, quoted by Alan
Ritter, **The Political Thought of Pierre-Joseph Proudhon**, p. 122] Thus
capitalism always has to rely on the state, on political coercion, if only the
minimal state, to assure its survival. The capitalist market has to, in other
words, resort to the coercion it claims to avoid once people start to question
its shortcomings. Of course, this coercion need not be monopolised in the form
of state police and armed forces. It has been enforced successfully by private
police forces and security guards, but it does not change the fact that force
is required to maintain capitalist property, power and property rights.

In summary, **all** forms of capitalism rest on the superior force of economic
elites who have the backing of the state to defend the sources of that power
as well as any contracts it has agreed to. In other words, "laissez-faire"
capitalism does not end state intervention, it simply creates a situation
where the state leaves the market process to the domination of those who
occupy superior market positions. As Kropotkin put it, capitalism _"is called
the freedom of transactions but it is more truly called the freedom of
exploitation."_ [**Words of a Rebel**, p. 119]

Given this, it may be objected that in this case there is no reason for the
ruling class to interfere with the economy. If economic coercion is
sufficient, then the elite has no need to turn to the state for aid. This
objection, however, fails to appreciate that the state **has** to interfere to
counteract the negative impacts of capitalism. Moreover, as we discussed in
[section C.7](secC7.md), economic coercion becomes less pressing during
periods of low unemployment and these tend to provoke a slump. It is in the
interests of the ruling elite to use state action to reduce the power of the
working classes in society. Thus we find the Federal Reserve in the USA
studying economic statistics to see if workers are increasing their bargaining
power on the labour market (i.e. are in a position to demand more wages or
better conditions). If so, then interest rates are increased and the resulting
unemployment and job insecurity make workers more likely to put up with low
pay and do what their bosses demand. As Doug Henwood notes, _"policy makers
are exceedingly obsessed with wage increases and the state of labour
militancy. They're not only concerned with the state of the macroeconomy,
conventionally defined, they're also concerned with the state of the class
struggle, to use the old-fashioned language."_ [**Wall Street**, p. 219]
Little wonder the ruling class and its high priests within the "science" of
economics have embraced the concept of a "natural rate" of unemployment (see
[section C.9](secC9.md) on this and as we indicated in [section
C.6](secC6.md), this has been **very** enriching for the ruling class since
1980).

Ultimately, the business class wants the state to intervene in the economy
beyond the minimum desired by a few ideologues of capitalism simply to ensure
it gets even more wealth and power -- and to ensure that the system does not
implode. Ironically, to get capitalism to work as some of its defenders want
it to would require a revolution in itself -- against the capitalists! Yet if
we go to the trouble of fighting public tyranny (the state), why should we
stop there? Why should private tyranny (capitalism, its autocratic structures
and hierarchical social relationships) remain untouched? Particularly, as
Chomsky notes, under capitalism _"minimising the state means strengthening the
private sectors. It narrows the domain within which public influence can be
expressed. That's not an anarchist goal . . . It's minimising the state and
increasing an even worse power,"_ namely capitalist firms and corporations
which are _"private totalitarian organisations."_ [**Chomsky on Anarchism**,
p. 214 and p. 213] In other words, if a government "privatises" some
government function, it is not substituting a market for a bureaucracy. It is
substituting a private bureaucracy for a public one, usually at rock-bottom
prices, so that some more capitalists can make a profit. All the economic
mumbo-jumbo is just a smokescreen for this fact.

## D.1.5 Do anarchists support state intervention?

So where do anarchists stand on state intervention? This question does not
present a short answer simply because it is a complex issue. On the one hand,
as Proudhon stressed, the state exists to _"maintain **order** in society, by
consecrating and sanctifying obedience of the citizens to the State,
subordination of the poor to the rich, of the common people to the upper
class, of the worker to the idler."_ [**The General Idea of the Revolution**,
p. 243] In such circumstances, appealing to the state makes little sense. On
the other hand, the modern state does do some good things (to varying
degrees). As a result of past popular struggles, there is a basic welfare
system in some countries which does help the poorest sections of society. That
aspect of state intervention is what is under attack by the right under the
slogan of "minimising the state."

In the long term, of course, the real solution is to abolish capitalism _"and
both citizens and communities will have no need of the intervention of the
State."_ [Proudhon, **Op. Cit.**, p. 268] In a free society, social self-
defence would not be statist but would be similar in nature to trade unionism,
co-operatives and pressure groups -- individuals working together in voluntary
associations to ensure a free and just society -- within the context of an
egalitarian, decentralised and participatory system which eliminates or
reduces the problems in the first place (see [section I](secIcon.md)).

However, that does not answer the question of what we do in the here and now
when faced with demands that the welfare state (for the working class, **not**
corporate welfare) and other reforms be rolled back. This attack has been on
going since the 1970s, accelerating since 1980. We should be clear that claims
to be minimising the state should be taken with a massive pitch of salt as the
likes of Reagan were _"elected to office promising to downsize government and
to 'get the government off the people's back,' even though what he meant was
to deregulate big business, and make them free to exploit the workers and make
larger profits."_ [Lorenzo Kom'boa Ervin, **Anarchism and the Black
Revolution**, p. 100] As such, it would be a big mistake to confuse anarchist
hostility to the state with the rhetoric of right-wing politicians seeking to
reduce social spending (Brian Oliver Sheppard discusses this issue well in his
article _"Anarchism vs. Right-Wing 'Anti-Statism'"_ [**Anarcho-Syndicalist
Review**, no. 31, Spring 2001]). Chomsky puts it well:

> _ "State authority is now under severe attack in the more democratic
societies, but not because it conflicts with the libertarian vision. Rather
the opposite: because it offers (weak) protection to some aspects of that
vision. Governments have a fatal flaw: unlike the private tyrannies, the
institutions of state power and authority offer to the despised public an
opportunity to play some role, however limited, in managing their own affairs.
That defect is intolerable to the masters . . . the goals of a committed
anarchist should be to defend some state institutions from the attack against
them, while trying at the same time to pry them open to more meaningful public
participation -- and, ultimately, to dismantle them in a much more free
society, of the appropriate circumstances can be achieved."_ [**Chomsky on
Anarchism**, pp. 193-4]

There is, of course, a tension in this position. The state may be influenced
by popular struggle but it remains an instrument of **capitalist** rule. It
may intervene in society as a result of people power and by the necessity to
keep the system as a whole going, but it is bureaucratic and influenced by the
wealthy and big business. Indeed, the onslaught on the welfare state by both
Thatcher and Reagan was conducted under a "democratic" mandate although, in
fact, these governments took advantage of the lack of real accountability
between elections. They took advantage of an aspect of the state which
anarchists had been warning of for decades, being _"well aware that [the
politician] can now commit crimes with immunity, [and so] the elected official
finds himself immediately exposed to all sorts of seductions on behalf of the
ruling classes"_ and so implemented policies _"solicited by big industry, high
officials, and above all, by international finance."_ [Elisee Reclus, **The
Modern State**, p. 208 and pp. 208-9]

As such, while anarchists are against the state, our position on state
intervention depends on the specific issue at hand. Most of us think state
health care services and unemployment benefits (for example) are more socially
useful than arms production, and in lieu of more anarchistic solutions, better
than the alternative of "free market" capitalism. This does not mean we are
happy with state intervention, which in practice undermines working class
self-help, mutual aid and autonomy. Also, state intervention of the "social"
nature is often paternalistic, run by and for the "middle classes" (i.e.
professional/managerial types and other self-proclaimed "experts"). However,
until such time as a viable anarchist counterculture is created, we have
little option but to "support" the lesser evil (and make no mistake, it **is**
an evil).

Taking the issue of privatisation of state owned and run industry, the
anarchist position is opposition to both. As we noted in [section
D.1.3](secD1.md#secd13), the anarchist prediction that if you substitute
government ownership for private ownership, _"nothing is changed but the
stockholders and the management; beyond that, there is not the least
difference in the position of the workers."_ [Proudhon, quoted by Ritter,
**Op. Cit.**, pp. 167-8] However, privatisation is a rip-off of the general
public for the benefit of the wealthy:

> _ "Privatisation of public services -- whether it is through the direct sale
of utilities or through indirect methods such as PFI and PPP -- involves a
massive transfer of wealth from taxpayers to the pockets of private business
interests. It negates the concept of there being such a thing as 'public
service' and subjects everything to the bottom line of profit. In other words
it seeks to maximise the profits of a few at the expense of wages and social
obligations. Furthermore, privatisation inevitably leads to an attack on wages
and working conditions - conditions which have been fought for through years
of trade union agitation are done away with at the scratch of a pen."_ [Gregor
Kerr, _"Privatisation: the rip-off of public resources"_, pp. 14-18, **Black
and Red Revolution**, no. 11, p. 16]

In response to such "reforms", anarchists propose an alternatives to both
options. Anarchists aim not at state ownership but to _"transfer all that is
needed for production . . . from the hands of the individual capitalists into
those of the communities of producers and consumers."_ [Kropotkin,
**Environment and Evolution**, pp. 169-70] In other words, while _"[i]n
today's world 'public sector' has come to mean 'government.' It is only if
'public sector' can be made to mean 'people's ownership' in a real sense that
the call for public ownership can be a truly radical one."_ [Kerr, **Op.
Cit.**, p. 18] This is based on a common-sense conclusion from the analysis of
the state as an instrument of the ruling class:

> _ "While anarchists oppose the privatisation of state assets and services
for the reasons discussed above, we do not call -- as some on the left do --
for the 'nationalisation' of services as a solution to problems . . . We'd be
expecting the same politicians who are busily implementing the neo-liberal
agenda to now take on the role of workers' protectors . . . it is important to
point out that the 'nationalise it' or 'take it into public ownership' slogan
is far too often spun out by people on the left without their taking into
account that there is a massive difference between state control/ownership and
workers' control/ownership . . . we all know that even if the revenues . . .
were still in state ownership, spending it on housing the homeless or reducing
hospital waiting lists would not top the agenda of the government.  
>  _

>

> _"Put simply, state ownership does not equal workers' ownership . . . we are
sold the lie that the resource . . . is 'public property.' The reality however
is that far from being in the ownership of 'the public,' ordinary people have
no direct say in the allocation of these resources. Just as working class
people are consistently alienated from the product of their labour, this
selling of the idea of 'public ownership' over which the public have no real
say leads to an increase in apathy and a sense of helplessness among ordinary
people. It is much more likely that the political establishment who control
the purse strings supposedly 'in the public interest' will actually spend
revenues generated from these 'public assets' on measures that will have the
long-term effect of re-enforcing rather than alleviating social division.
Public policy consistently results in an increase in the gap between the well-
off and the poor."_ [Kerr, **Opt. Cit.**, pp. 16-7 and p. 17]

Thus an anarchist approach to this issue would be to reject both privatisation
**and** nationalisation in favour of socialisation, i.e. placing nationalised
firms under workers' self-management. In the terms of public utilities, such
as water and power suppliers, they could be self-managed by their workers in
association with municipal co-operatives -- based on one member, one vote --
which would be a much better alternative than privatising what is obviously a
natural monopoly (which, as experience shows, simply facilitates the fleecing
of the public for massive private profit). Christie and Meltzer state the
obvious:

> _ "It is true that government takes over the control of certain necessary
social functions. It does not follow that **only** the state could assume such
control. The postmen are 'civil servants' only because the State makes them
such. The railways were not always run by the state, They belonged to the
capitalists [and do once more, at least in the UK], and could as easily have
been run by the railway workers.  
>  _

>

> _"The opponents of anarchism assure us that if we put government under a
ban, there would be no education, for the state controls the schools. There
would be no hospitals - where would the money come from? Nobody would work --
who would pay their wages? . . . But in reality, not . . . the state, but the
people provide what the people have. If the people do not provide for
themselves, the state cannot help them. It only appears to do so because it is
in control. Those who have power may apportion work or regulate the standard
of living, but this is part of the attack upon the people, not something
undertaken on their behalf."_ [**The Floodgates of Anarchy**, p. 148-149]

Much the same can be said of other aspects of state intervention. For example,
if we look at state education or welfare an anarchist solution could be to
press for _"workers' control by all the people involved"_ in an institution,
in other words _"the extension of the principle of freedom from the economic
to the political side of the health [and education] system[s]."_ [Nicholas
Walters, **About Anarchism**, p. 76] The aim is to create _"new forms of
organisation for the social functions that the state fulfils through the
bureaucracy."_ [Colin Ward, **Anarchy in Action**, p. 19] This means that
anarchists, as part of the wider socialist, labour and social movements seek
_"to counterbalance as much as we [can] the centralistic, bureaucratic
ambitions of Social Democracy."_ [Kropotkin, **Act for Yourselves**, p. 120]
This applies both to the organisation and tactics of popular movements as well
as the proposed reforms and how they are implemented.

In terms of social reforms, anarchists stress that it cannot be left in the
hands of politicians (i.e. the agents of the ruling class). It should be
obvious that if you let the ruling class decide (on the basis of their own
needs and priorities) which reforms to introduce you can guess which ones will
be implemented. If the state establishes what is and is not a "reform", then
it will implement those which it favours in a manner which benefits itself and
the capitalist class. Such top-down "liberalisation" will only increase the
power and freedom of the capitalist class and make capitalist and statist
exploitation more efficient. It will not undermine the restrictions on liberty
for the many which ensure the profits, property and power of the few in the
first place. That is, there will be minor changes around the edges of the
state system in order to give more "freedom" to landlords and employers to
lord it over their tenants and workers. This can be seen from the experience
of neo-liberalism across the world.

This means that the decision of what aspects of statism to dismantle first
should **never** be handed over to politicians and bureaucrats who are
inevitably agents of the capitalist class. It should be decided from below and
guided by an overall strategy of dismantling capitalism **as a system.** That
means that any reforms should be aimed at those forms of state intervention
which bolster the profits and power of the ruling class and long before
addressing those laws which are aimed at making exploitation and oppression
tolerable for the working class. If this is not done, then any "reforms" will
be directed by the representatives of the business class and, consequently,
aim to cut social programmes people actually need while leaving welfare for
the rich in place. As such, anarchists argue that pressure from below is
required to prioritise reforms based on genuine need rather than the interests
of capital. For example, in the UK this would involve, say, urging the
privatisation of the Royal Family before even thinking about "reforming" the
National Health Service or fighting for the state to "get off the backs" of
the unions trying to deregulate business. The key is that people reject a
_"naive appeal to the legislators and high officials, waiting for salvation
through their deliberations and decrees."_ In reality _"freedom does not come
begging, but rather must be conquered."_ [Reclus, **Op. Cit.**, p. 210] This
is not done, then the results will simply confirm Voltairine de Cleyre's
insight:

> _ "Nearly all laws which were originally framed with the intention of
benefiting workers, have either turned into weapons in their enemies' hands,
or become dead letters unless the workers through their organisations have
directly enforced their observance. So that in the end, it is direct action
that has to be relied on anyway."_ [**The Voltairine de Cleyre Reader**, p.
59]

A classic example of the former are the anti-trust laws in America, originally
aimed at breaking the power of capitalist monopoly but were soon turned
against labour unions and strikers. De Cleyre's second point is a truism and,
obviously, means that anarchists aim to strengthen popular organisations and
create mass movements which use direct action to defend their rights. Just
because there are laws protecting workers, for example, there is no guarantee
that they will be enforced -- unless workers themselves are strong enough to
make sure the bosses comply with the law.

Anarchists are in favour of self-directed activity and direct action to get
improvements and defend reforms in the here and now. By organising strikes and
protests ourselves, we can improve our lives. This does not mean that using
direct action to get favourable laws passed or less-favourable ones revoked is
a waste of time. Far from it. However, unless ordinary people use their own
strength and grassroots organisations to enforce the law, the state and
employers will honour any disliked law purely in the breach. By trusting the
state, social self-protection against the market and power concentrations
becomes hollow. In the end, what the state gives (or, more correctly, is
pressurised into giving), it can take away but what we create and run
ourselves is always responsive to **our** desires and interests. We have seen
how vulnerable state welfare is to pressures from the capitalist class to see
that this is a truism.

This is not to deny that in many ways such state "support" can be used as a
means of regaining some of the power and labour stolen from us by capitalists
in the first place. State intervention **can** give working people more
options than they otherwise would have. If state action could not be used in
this way, it is doubtful that capitalists and their hired "experts" would
spend so much time trying to undermine and limit it. As the capitalist class
happily uses the state to enforce its power and property rights, working
people making whatever use they can of it is to be expected. Be that as it
may, this does not blind anarchists to the negative aspects of the welfare
state and other forms of state intervention (see [section
J.5.15](secJ5.md#secj515) for anarchist perspectives on the welfare state).

One problem with state intervention, as Kropotkin saw, is that the state's
absorption of social functions _"necessarily favoured the development of an
unbridled, narrow-minded individualism. In proportion as the obligations
towards the State grew in numbers, the citizens were evidently relieved from
their obligations towards each other."_ [**Mutual Aid**, p. 183] In the case
of state "social functions," such as the British National Health Service,
although they were created as a **result** of the social atomisation caused by
capitalism, they have tended to **reinforce** the individualism and lack of
personal and social responsibility that produced the need for such action in
the first place. The pressing need, therefore, is for working class people
need _"independent control . . . of their own welfare programs. Mutual aid and
welfare arrangements are necessary."_ [Sam Dolgoff, **The American Labour
Movement**, p. 26] Specific forms of community and social self-help and their
historical precedents are discussed in [section J.5.16](secJ5.md#secj516).

This means that the anarchist task is building popular resistance to the state
and capitalism and that may, at time, involves resisting attempts to impose
"reforms" which harm the working class and enrich and empower the ruling
class. As such, few anarchists subscribe to the notion that we should support
capitalism inspired "minimising" of the state in the believe that this will
increase poverty and inequality and so speed up the arrival of a social
revolution. However, such a position fails to appreciate that social change is
only possible when the hope for a better future has not been completely
destroyed:

> _ "Like many others I have believed in my youth that as social conditions
became worse, those who suffered so much would come to realise the deeper
causes of their poverty and suffering. I have since been convinced that such a
belief is a dangerous illusion . . . There is a pitch of material and
spiritual degradation from which a man can no longer rise. Those who have been
born into misery and never knew a better state are rarely able to resist and
revolt . . . Certainly the old slogan, 'The worse the better', was based on an
erroneous assumption. Like that other slogan, 'All or nothing', which made
many radical oppose any improvement in the lot of the workers, even when the
workers demanded it, on the ground that it would distract the mind of the
proletariat, and turn it away from the road which leads to social
emancipation. It is contrary to all the experience of history and of
psychology; people who are not prepared to fight for the betterment of their
living conditions are not likely to fight for social emancipation. Slogans of
this kind are like a cancer in the revolutionary movement."_ [Rudolf Rocker,
**London Years**, pp. 25-6]

The anarchist position is, therefore, a practical one based on the specific
situation rather than a simplistic application of what is ideologically
correct. Rolling back the state in the abstract is not without problems in a
class and hierarchy ridden system where opportunities in life are immensely
unequal. As such, any _"effort to develop and implement government programs
that really were equalisers would lead to a form of class war, and in the
present state of popular organisations and distribution of effective power,
there can hardly be much doubt as to who would win."_ [Chomsky, **The Chomsky
Reader**, p. 184] Anarchists seek to build the grassroots resistance for
politicians like Reagan, Bush Snr and Jnr, Thatcher and so on do not get
elected without some serious institutional forces at work. It would be insane
to think that once a particularly right-wing politician leaves office those
forces will go away or stop trying to influence the political decision making
process.

The task of anarchists therefore is not to abstractly oppose state
intervention but rather contribute to popular self-organisation and struggle,
creating pressures from the streets and workplaces that governments cannot
ignore or defy. This means supporting direct action rather than electioneering
(see [section J.2](secJ2.md)) for the _"make-up of the government, the
names, persons and political tendencies which rubbed shoulders in it, were
incapable of effecting the slightest amendment to the enduring quintessence of
the state organism . . . And the price of entering the of strengthening the
state is always unfailingly paid in the currency of a weakening of the forces
offering it their assistance. For every reinforcement of state power there is
always . . . a corresponding debilitation of grassroots elements. Men may come
and go, but the state remains."_ [Jose Peirats, **The CNT in the Spanish
Revolution**, vol. 2, p. 150]

[‹ D.0 Section D Introduction](secDint.md "Go to previous page" )
[up](secDcon.md "Go to parent page" ) [D.2 What influence does wealth have
over politics? ›](secD2.md "Go to next page" )

