// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OrderPlanner_h__
#define __OrderPlanner_h__

#include "OrderPlannerImpl.h"

template <class Item>
class OrderPlanner : public OrderPlannerImpl {
public:
  void precedence (Item &first, Item &later) {
    OrderPlannerImpl::precedence (&first, &later);
  }
  int items () { return OrderPlannerImpl::items (); }
  Item &item (int i) { return *(Item*)OrderPlannerImpl::item (i); }
  // calculate the total order => false if there is a cycle
  bool plan () { return OrderPlannerImpl::plan (); }

};

#endif // __OrderPlanner_h__
