#region license
// Copyright (c) 2009 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast
{
	using System;
	
	public delegate void NodeEvent<T>(T node) where T:Node;
	
	public partial class DepthFirstGuide : IAstVisitor
	{
		public event NodeEvent<CompileUnit> OnCompileUnit;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{	
			{
				var modules = node.Modules;
				if (modules != null)
				{
					var innerList = modules.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnCompileUnit;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<TypeMemberStatement> OnTypeMemberStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnTypeMemberStatement(Boo.Lang.Compiler.Ast.TypeMemberStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var typeMember = node.TypeMember;
				if (typeMember != null)
					typeMember.Accept(this);
			}
			var handler = OnTypeMemberStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ExplicitMemberInfo> OnExplicitMemberInfo;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{	
			{
				var interfaceType = node.InterfaceType;
				if (interfaceType != null)
					interfaceType.Accept(this);
			}
			var handler = OnExplicitMemberInfo;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SimpleTypeReference> OnSimpleTypeReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSimpleTypeReference(Boo.Lang.Compiler.Ast.SimpleTypeReference node)
		{
			var handler = OnSimpleTypeReference; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<ArrayTypeReference> OnArrayTypeReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{	
			{
				var elementType = node.ElementType;
				if (elementType != null)
					elementType.Accept(this);
			}
			{
				var rank = node.Rank;
				if (rank != null)
					rank.Accept(this);
			}
			var handler = OnArrayTypeReference;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<CallableTypeReference> OnCallableTypeReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{	
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			var handler = OnCallableTypeReference;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GenericTypeReference> OnGenericTypeReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{	
			{
				var genericArguments = node.GenericArguments;
				if (genericArguments != null)
				{
					var innerList = genericArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnGenericTypeReference;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GenericTypeDefinitionReference> OnGenericTypeDefinitionReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGenericTypeDefinitionReference(Boo.Lang.Compiler.Ast.GenericTypeDefinitionReference node)
		{
			var handler = OnGenericTypeDefinitionReference; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<CallableDefinition> OnCallableDefinition;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnCallableDefinition;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<NamespaceDeclaration> OnNamespaceDeclaration;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnNamespaceDeclaration(Boo.Lang.Compiler.Ast.NamespaceDeclaration node)
		{
			var handler = OnNamespaceDeclaration; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<Import> OnImport;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnImport(Boo.Lang.Compiler.Ast.Import node)
		{	
			{
				var assemblyReference = node.AssemblyReference;
				if (assemblyReference != null)
					assemblyReference.Accept(this);
			}
			{
				var alias = node.Alias;
				if (alias != null)
					alias.Accept(this);
			}
			var handler = OnImport;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Module> OnModule;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnModule(Boo.Lang.Compiler.Ast.Module node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var @namespace = node.Namespace;
				if (@namespace != null)
					@namespace.Accept(this);
			}
			{
				var imports = node.Imports;
				if (imports != null)
				{
					var innerList = imports.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var globals = node.Globals;
				if (globals != null)
					globals.Accept(this);
			}
			{
				var assemblyAttributes = node.AssemblyAttributes;
				if (assemblyAttributes != null)
				{
					var innerList = assemblyAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnModule;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ClassDefinition> OnClassDefinition;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnClassDefinition;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<StructDefinition> OnStructDefinition;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnStructDefinition;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<InterfaceDefinition> OnInterfaceDefinition;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnInterfaceDefinition;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<EnumDefinition> OnEnumDefinition;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnEnumDefinition;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<EnumMember> OnEnumMember;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
			var handler = OnEnumMember;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Field> OnField;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnField(Boo.Lang.Compiler.Ast.Field node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
			var handler = OnField;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Property> OnProperty;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnProperty(Boo.Lang.Compiler.Ast.Property node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var getter = node.Getter;
				if (getter != null)
					getter.Accept(this);
			}
			{
				var setter = node.Setter;
				if (setter != null)
					setter.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
			var handler = OnProperty;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Event> OnEvent;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnEvent(Boo.Lang.Compiler.Ast.Event node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var add = node.Add;
				if (add != null)
					add.Accept(this);
			}
			{
				var remove = node.Remove;
				if (remove != null)
					remove.Accept(this);
			}
			{
				var raise = node.Raise;
				if (raise != null)
					raise.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnEvent;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Local> OnLocal;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnLocal(Boo.Lang.Compiler.Ast.Local node)
		{
			var handler = OnLocal; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<BlockExpression> OnBlockExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{	
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			var handler = OnBlockExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Method> OnMethod;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnMethod(Boo.Lang.Compiler.Ast.Method node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
			var handler = OnMethod;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Constructor> OnConstructor;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
			var handler = OnConstructor;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Destructor> OnDestructor;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
			var handler = OnDestructor;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ParameterDeclaration> OnParameterDeclaration;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{	
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnParameterDeclaration;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GenericParameterDeclaration> OnGenericParameterDeclaration;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGenericParameterDeclaration(Boo.Lang.Compiler.Ast.GenericParameterDeclaration node)
		{	
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnGenericParameterDeclaration;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Declaration> OnDeclaration;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{	
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnDeclaration;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Attribute> OnAttribute;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{	
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var namedArguments = node.NamedArguments;
				if (namedArguments != null)
				{
					var innerList = namedArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnAttribute;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<StatementModifier> OnStatementModifier;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{	
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			var handler = OnStatementModifier;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GotoStatement> OnGotoStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var label = node.Label;
				if (label != null)
					label.Accept(this);
			}
			var handler = OnGotoStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<LabelStatement> OnLabelStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			var handler = OnLabelStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Block> OnBlock;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnBlock(Boo.Lang.Compiler.Ast.Block node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var statements = node.Statements;
				if (statements != null)
				{
					var innerList = statements.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnBlock;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<DeclarationStatement> OnDeclarationStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declaration = node.Declaration;
				if (declaration != null)
					declaration.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
			var handler = OnDeclarationStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<MacroStatement> OnMacroStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			var handler = OnMacroStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<TryStatement> OnTryStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var protectedBlock = node.ProtectedBlock;
				if (protectedBlock != null)
					protectedBlock.Accept(this);
			}
			{
				var exceptionHandlers = node.ExceptionHandlers;
				if (exceptionHandlers != null)
				{
					var innerList = exceptionHandlers.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var failureBlock = node.FailureBlock;
				if (failureBlock != null)
					failureBlock.Accept(this);
			}
			{
				var ensureBlock = node.EnsureBlock;
				if (ensureBlock != null)
					ensureBlock.Accept(this);
			}
			var handler = OnTryStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ExceptionHandler> OnExceptionHandler;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{	
			{
				var declaration = node.Declaration;
				if (declaration != null)
					declaration.Accept(this);
			}
			{
				var filterCondition = node.FilterCondition;
				if (filterCondition != null)
					filterCondition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			var handler = OnExceptionHandler;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<IfStatement> OnIfStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var trueBlock = node.TrueBlock;
				if (trueBlock != null)
					trueBlock.Accept(this);
			}
			{
				var falseBlock = node.FalseBlock;
				if (falseBlock != null)
					falseBlock.Accept(this);
			}
			var handler = OnIfStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<UnlessStatement> OnUnlessStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			var handler = OnUnlessStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ForStatement> OnForStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var iterator = node.Iterator;
				if (iterator != null)
					iterator.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			{
				var orBlock = node.OrBlock;
				if (orBlock != null)
					orBlock.Accept(this);
			}
			{
				var thenBlock = node.ThenBlock;
				if (thenBlock != null)
					thenBlock.Accept(this);
			}
			var handler = OnForStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<WhileStatement> OnWhileStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			{
				var orBlock = node.OrBlock;
				if (orBlock != null)
					orBlock.Accept(this);
			}
			{
				var thenBlock = node.ThenBlock;
				if (thenBlock != null)
					thenBlock.Accept(this);
			}
			var handler = OnWhileStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<BreakStatement> OnBreakStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			var handler = OnBreakStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ContinueStatement> OnContinueStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			var handler = OnContinueStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ReturnStatement> OnReturnStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnReturnStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<YieldStatement> OnYieldStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnYieldStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<RaiseStatement> OnRaiseStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var exception = node.Exception;
				if (exception != null)
					exception.Accept(this);
			}
			var handler = OnRaiseStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<UnpackStatement> OnUnpackStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnUnpackStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ExpressionStatement> OnExpressionStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExpressionStatement(Boo.Lang.Compiler.Ast.ExpressionStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnExpressionStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<OmittedExpression> OnOmittedExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnOmittedExpression(Boo.Lang.Compiler.Ast.OmittedExpression node)
		{
			var handler = OnOmittedExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<ExpressionPair> OnExpressionPair;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{	
			{
				var first = node.First;
				if (first != null)
					first.Accept(this);
			}
			{
				var second = node.Second;
				if (second != null)
					second.Accept(this);
			}
			var handler = OnExpressionPair;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<MethodInvocationExpression> OnMethodInvocationExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var namedArguments = node.NamedArguments;
				if (namedArguments != null)
				{
					var innerList = namedArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnMethodInvocationExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<UnaryExpression> OnUnaryExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{	
			{
				var operand = node.Operand;
				if (operand != null)
					operand.Accept(this);
			}
			var handler = OnUnaryExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<BinaryExpression> OnBinaryExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{	
			{
				var left = node.Left;
				if (left != null)
					left.Accept(this);
			}
			{
				var right = node.Right;
				if (right != null)
					right.Accept(this);
			}
			var handler = OnBinaryExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ConditionalExpression> OnConditionalExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{	
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var trueValue = node.TrueValue;
				if (trueValue != null)
					trueValue.Accept(this);
			}
			{
				var falseValue = node.FalseValue;
				if (falseValue != null)
					falseValue.Accept(this);
			}
			var handler = OnConditionalExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ReferenceExpression> OnReferenceExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnReferenceExpression(Boo.Lang.Compiler.Ast.ReferenceExpression node)
		{
			var handler = OnReferenceExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<MemberReferenceExpression> OnMemberReferenceExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			var handler = OnMemberReferenceExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GenericReferenceExpression> OnGenericReferenceExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var genericArguments = node.GenericArguments;
				if (genericArguments != null)
				{
					var innerList = genericArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnGenericReferenceExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<QuasiquoteExpression> OnQuasiquoteExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnQuasiquoteExpression(Boo.Lang.Compiler.Ast.QuasiquoteExpression node)
		{
			var handler = OnQuasiquoteExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<StringLiteralExpression> OnStringLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnStringLiteralExpression(Boo.Lang.Compiler.Ast.StringLiteralExpression node)
		{
			var handler = OnStringLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<CharLiteralExpression> OnCharLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCharLiteralExpression(Boo.Lang.Compiler.Ast.CharLiteralExpression node)
		{
			var handler = OnCharLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<TimeSpanLiteralExpression> OnTimeSpanLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnTimeSpanLiteralExpression(Boo.Lang.Compiler.Ast.TimeSpanLiteralExpression node)
		{
			var handler = OnTimeSpanLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<IntegerLiteralExpression> OnIntegerLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnIntegerLiteralExpression(Boo.Lang.Compiler.Ast.IntegerLiteralExpression node)
		{
			var handler = OnIntegerLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<DoubleLiteralExpression> OnDoubleLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnDoubleLiteralExpression(Boo.Lang.Compiler.Ast.DoubleLiteralExpression node)
		{
			var handler = OnDoubleLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<NullLiteralExpression> OnNullLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnNullLiteralExpression(Boo.Lang.Compiler.Ast.NullLiteralExpression node)
		{
			var handler = OnNullLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<SelfLiteralExpression> OnSelfLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSelfLiteralExpression(Boo.Lang.Compiler.Ast.SelfLiteralExpression node)
		{
			var handler = OnSelfLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<SuperLiteralExpression> OnSuperLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSuperLiteralExpression(Boo.Lang.Compiler.Ast.SuperLiteralExpression node)
		{
			var handler = OnSuperLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<BoolLiteralExpression> OnBoolLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnBoolLiteralExpression(Boo.Lang.Compiler.Ast.BoolLiteralExpression node)
		{
			var handler = OnBoolLiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<RELiteralExpression> OnRELiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnRELiteralExpression(Boo.Lang.Compiler.Ast.RELiteralExpression node)
		{
			var handler = OnRELiteralExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<SpliceExpression> OnSpliceExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{	
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnSpliceExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SpliceTypeReference> OnSpliceTypeReference;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{	
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnSpliceTypeReference;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SpliceMemberReferenceExpression> OnSpliceMemberReferenceExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
			var handler = OnSpliceMemberReferenceExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SpliceTypeMember> OnSpliceTypeMember;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var typeMember = node.TypeMember;
				if (typeMember != null)
					typeMember.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
			var handler = OnSpliceTypeMember;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SpliceTypeDefinitionBody> OnSpliceTypeDefinitionBody;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceTypeDefinitionBody(Boo.Lang.Compiler.Ast.SpliceTypeDefinitionBody node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			var handler = OnSpliceTypeDefinitionBody;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SpliceParameterDeclaration> OnSpliceParameterDeclaration;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSpliceParameterDeclaration(Boo.Lang.Compiler.Ast.SpliceParameterDeclaration node)
		{	
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameterDeclaration = node.ParameterDeclaration;
				if (parameterDeclaration != null)
					parameterDeclaration.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
			var handler = OnSpliceParameterDeclaration;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ExpressionInterpolationExpression> OnExpressionInterpolationExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{	
			{
				var expressions = node.Expressions;
				if (expressions != null)
				{
					var innerList = expressions.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnExpressionInterpolationExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<HashLiteralExpression> OnHashLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{	
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnHashLiteralExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ListLiteralExpression> OnListLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{	
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnListLiteralExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<CollectionInitializationExpression> OnCollectionInitializationExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCollectionInitializationExpression(Boo.Lang.Compiler.Ast.CollectionInitializationExpression node)
		{	
			{
				var collection = node.Collection;
				if (collection != null)
					collection.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
			var handler = OnCollectionInitializationExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ArrayLiteralExpression> OnArrayLiteralExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{	
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnArrayLiteralExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<GeneratorExpression> OnGeneratorExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{	
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var iterator = node.Iterator;
				if (iterator != null)
					iterator.Accept(this);
			}
			{
				var filter = node.Filter;
				if (filter != null)
					filter.Accept(this);
			}
			var handler = OnGeneratorExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<ExtendedGeneratorExpression> OnExtendedGeneratorExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{	
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnExtendedGeneratorExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<Slice> OnSlice;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSlice(Boo.Lang.Compiler.Ast.Slice node)
		{	
			{
				var begin = node.Begin;
				if (begin != null)
					begin.Accept(this);
			}
			{
				var end = node.End;
				if (end != null)
					end.Accept(this);
			}
			{
				var step = node.Step;
				if (step != null)
					step.Accept(this);
			}
			var handler = OnSlice;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<SlicingExpression> OnSlicingExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var indices = node.Indices;
				if (indices != null)
				{
					var innerList = indices.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			var handler = OnSlicingExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<TryCastExpression> OnTryCastExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnTryCastExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<CastExpression> OnCastExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{	
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnCastExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<TypeofExpression> OnTypeofExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{	
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			var handler = OnTypeofExpression;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<CustomStatement> OnCustomStatement;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCustomStatement(Boo.Lang.Compiler.Ast.CustomStatement node)
		{	
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			var handler = OnCustomStatement;
			if (handler != null)
				handler(node);
		}
		public event NodeEvent<CustomExpression> OnCustomExpression;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnCustomExpression(Boo.Lang.Compiler.Ast.CustomExpression node)
		{
			var handler = OnCustomExpression; 
			if (handler == null)
				return;
			handler(node);
		}
		public event NodeEvent<StatementTypeMember> OnStatementTypeMember;

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		void IAstVisitor.OnStatementTypeMember(Boo.Lang.Compiler.Ast.StatementTypeMember node)
		{	
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var statement = node.Statement;
				if (statement != null)
					statement.Accept(this);
			}
			var handler = OnStatementTypeMember;
			if (handler != null)
				handler(node);
		}
				
	}
}

