#
# Sample ldirectord configuration file to configure various virtual services.
#
# Ldirectord will connect to each real server once per second and request
# /index.html. If the data returned by the server does not contain the
# string "Test Message" then the test fails and the real server will be
# taken out of the available pool. The real server will be added back into
# the pool once the test succeeds. If all real servers are removed from the
# pool then localhost:80 is added to the pool as a fallback measure.

# Global Directives
checktimeout=3
checkinterval=1
#fallback=127.0.0.1:80
autoreload=yes
#logfile="/var/log/ldirectord.log"
#logfile="local0"
#emailalert="admin@x.y.z"
#emailalertfreq=3600
#emailalertstatus=all
quiescent=yes

# Sample for an http virtual service
virtual=192.168.6.240:80
	real=192.168.6.2:80 gate
	real=192.168.6.3:80 gate
	real=192.168.6.6:80 gate
 	fallback=127.0.0.1:80 gate
	service=http
	request="index.html"
	receive="Test Page"
	virtualhost=some.domain.com.au
	scheduler=rr
	#persistent=600
	#netmask=255.255.255.255
	protocol=tcp
  	checktype=negotiate
  	checkport=80
 	request="index.html"
 	receive="Test Page"
 	virtualhost=www.x.y.z

# Sample configuration for a fwmark based service For an explination of
# fwmark see the ipvsadm(8) man page
#virtual=1
#	real=192.168.6.2 gate
#	real=192.168.6.3 gate
#	real=192.168.6.6 gate
#	fallback=127.0.0.1:80 gate
#	service=http
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=fwm
#	checktype=negotiate
#	checkport=80
#	request="index.html"
#	receive="Test Page"
#	virtualhost=x.y.z

# Sample configuration for a service using a range of real servers
# and a single real server for a virtual service
#virtual=192.168.6.240:80
#	real=192.168.6.2->192.168.6.7:80 gate
#	real=192.168.6.32:80 gate
#	fallback=127.0.0.1:80 gate
#	service=http
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
#	checkport=80
#	request="index.html"
#	receive="Test Page"
#	virtualhost=x.y.z

#Sample configuration for an https virtual service.
#Fallback setting overides global
#virtual=192.168.6.240:443
#	real=192.168.16.3:443 masq
#	real=192.168.16.5:443 masq
#	fallback=127.0.0.1:443
#	service=https
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
# 	checkport=443
#	request="index.html"
#	receive="Test Page"
#	virtualhost=x.y.z

#Sample configuration for an ftp virtual service.
#Fallback setting overides global
#virtual=192.168.6.240:21
#	real=192.168.16.3:21 masq
#	real=192.168.16.5:21 masq
#	fallback=127.0.0.1:21
#	service=ftp
# 	checkport=21
#	scheduler=wlc
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
#	login="anonymous"
#	passwd="ldirectord@localhost"
#	request="welcome.msg"
#	receive="test"

#Sample configuration for an smtp virtual service.
#Fallback setting overides global
#virtual=192.168.6.240:25
#	real=192.168.16.3:25 masq
#	real=192.168.16.5:25 masq
#	fallback=127.0.0.1:25
#	service=smtp
#	scheduler=wlc
#	protocol=tcp
#	persistent=600
#	#netmask=255.255.255.255
#	checktype=negotiate
# 	checkport=25

#Sample configuration for a pop virtual service.
#Fallback setting overides global
#virtual=192.168.6.240:110
#	real=192.168.16.3:110 masq
#	real=192.168.16.5:110 masq
#	fallback=127.0.0.1:110
#	service=pop
#	scheduler=wlc
#	persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
# 	checkport=110
#	#login="test"
#	#passwd="test"

##Sample configuration for an imap virtual service.
#Fallback setting overides global
#virtual=192.168.6.240:143
#	real=127.0.0.1:143 masq
#	real=192.168.16.3:143 masq
#	real=192.168.16.5:143 masq
#	fallback=127.0.0.1:143
#	service=imap
#	scheduler=wlc
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
# 	checkport=143
#	#login="test"
#	#passwd="test"

#Sample configuration for an ldap virtual service.
#Fallback setting overides global
#virtual=192.168.84.5:389
#	real=10.0.1.4:389 masq
#	real=10.0.1.6:389 masq
#	fallback=127.0.0.1:389
#	service=ldap
#	scheduler=wlc
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
# 	checkport=369
#	request="dc=upmc, dc=fr"
#	receive="dc=upmc, dc=fr"
#	#login="test"
#	#passwd="test"

#Sample configuration for an nntp virtual service.
#Fallback setting overides global
#virtual=192.168.84.5:119
#	real=10.0.1.4:119 masq
#	real=10.0.1.6:119 masq
#	fallback=127.0.0.1:119
#	service=nntp
#	scheduler=wlc
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
# 	checkport=119

#Sample configuration for a UDP DNS virtual service.
#Fallback setting overides global
#virtual=192.168.84.5:53
#	real=10.0.1.4:53 masq
#	real=10.0.1.6:53 masq
#	fallback=127.0.0.1:53
#	service=dns
#	scheduler=wlc
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=udp
#	checktype=negotiate
# 	checkport=53
#	request="x.y.z"
#	receive="127.0.0.1"

#Sample configuration for a MySQL virtual service.
#virtual = 192.168.10.74:3306
#	real=sql01->sql03:3306 gate 10
#	fallback=127.0.0.1:3306
#	service=mysql
#	scheduler=wrr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
#	login="readuser"
#	passwd="genericpassword"
#	database="portal"
#	request="SELECT * FROM link"

#Sample configuration for a PostgreSQL virtual service.
#virtual = 192.168.10.74:5432
#	real=sql01->sql03:5432 gate 10
#	fallback=127.0.0.1:5432
#	service=pgsql
#	scheduler=wrr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
#	login="readuser"
#	passwd="genericpassword"
#	database="portal"
#	request="SELECT * FROM link"

#Sample configuration for a Oracle virtual service.
#virtual = 192.168.10.74:1521
#	real=sql01->sql03:1521 gate 10
#	fallback=127.0.0.1:1521
#	service=oracle
#	scheduler=wrr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=negotiate
#	login="readuser"
#	passwd="genericpassword"
#	database="portal"
#	request="SELECT * FROM link"

#Sample configuration for an unsuported protocol
#The real servers will just be brought up without checking for availability
#virtual=192.168.6.240:23
#	real=192.168.16.3:23 masq 
#	real=192.168.16.5:23 masq
#	fallback=127.0.0.1:23
#	service=none
#	scheduler=wlc
#	persistent=600
#	#netmask=255.255.255.255
#	protocol=tcp
#	checktype=on

# A sample virtual services that uses a ping check.
# Note that using checktype=connect and protocol=udp
# will also effect ping checks
#virtual=192.168.6.240:53
#	real=192.168.6.2:53 gate
#	real=192.168.6.3:53 gate
#	real=192.168.6.6:53 gate
# 	fallback=127.0.0.1:53 gate
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=udp
#	checktype=ping
#	checkcount=3

# A sample virtual services that uses a Radius check on UDP.
# Note that using checktype=connect and protocol=udp
# will also effect ping checks
#virtual=192.168.6.240:1812
#	real=192.168.6.2::1812 gate
#	real=192.168.6.3::1812 gate
#	real=192.168.6.6::1812 gate
#	fallback=127.0.0.1:1812 gate
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=udp
#	checktype=negotiate
#	service=radius
#	password="readuser"
#	passwd="genericpassword"
#	secret="somesecret"
#	checktimeout=1

# A sample virtual services that uses a SIP check on UDP.
# Note that using checktype=connect and protocol=udp
# will also effect ping checks
#virtual=192.168.6.240:5060
#	real=192.168.6.2::5060 gate
#	real=192.168.6.3::5060 gate
#	real=192.168.6.6::5060 gate
#	fallback=127.0.0.1:5060 gate
#	scheduler=rr
#	#persistent=600
#	#netmask=255.255.255.255
#	protocol=udp
#	checktype=negotiate
#	service=sip
#	checktimeout=1

