"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""

from gastables.PrandtlMeyer import PrandtlMeyer

def get_allValues_from_M(M,gamma) :
    pm = PrandtlMeyer(gamma)
    VALUES = {}
    VALUES["M"] = M
    try :
        VALUES["Prandtl function"] = pm.get_Prandtl_Func_from_M(M)
        VALUES["Mach angle"] = pm.get_Mach_Angle_from_M(M)
        return VALUES
    except Exception, e:
        raise Exception(e)

def get_allValues_from_Prandtl_Func(Prandtl_Func,gamma) :
    pm = PrandtlMeyer(gamma)
    try :
        return get_allValues_from_M(pm.get_M_from_Prandtl_Func(Prandtl_Func),gamma)
    except Exception, e:
        raise Exception(e)


def get_allValues_from_Mach_Angle(alpha,gamma):
    pm = PrandtlMeyer(gamma)
    try :
        return get_allValues_from_M(pm.get_M_from_Mach_Angle(alpha),gamma)
    except Exception, e:
        raise Exception(e)
