/*
 * Decompiled with CFR 0.152.
 */
package mspccs_spreadsheet_tester.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import mspccs_spreadsheet_tester.gui.AppResultsWindow;
import mspccs_spreadsheet_tester.gui.FilePanel;
import mspccs_spreadsheet_tester.utility.Directory;
import mspccs_spreadsheet_tester.utility.Platform;
import mspccs_spreadsheet_tester.utility.StartBrowser;
import mspccs_spreadsheet_tester.utility.Utility;

public class MSPCCS_SpreadsheetTester
extends JFrame {
    private Directory currentDir = new Directory(".");
    private FilePanel inputFilePanel = new FilePanel("Input File", this.currentDir);
    private FilePanel outputFilePanel = new FilePanel("Output File", this.currentDir);
    private JMenuItem aboutMenuItem;
    private JPanel buttonPanel;
    private JMenuItem contentsMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JSeparator helpMenuSeparator;
    private JMenuBar mspccsSpreadsheetTesterMenuBar;
    private JMenu optionsMenu;
    private JButton runButton;
    private JCheckBoxMenuItem warningsCheckBoxMenuItem;

    public MSPCCS_SpreadsheetTester() {
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.inputFilePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.getContentPane().add((Component)this.outputFilePanel, gridBagConstraints);
        this.pack();
        Utility.setIcon(this, "/mspccs_spreadsheet_tester/gui/icons/NGA.gif");
        Utility.center(null, this);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.mspccsSpreadsheetTesterMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.warningsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.helpMenuSeparator = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("MSP CCS Spreadsheet Tester");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MSPCCS_SpreadsheetTester.this.exitForm(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setMinimumSize(new Dimension(306, 47));
        this.buttonPanel.setPreferredSize(new Dimension(306, 47));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runButton.setText("Run");
        this.runButton.setBorder(BorderFactory.createBevelBorder(0));
        this.runButton.setMaximumSize(new Dimension(26, 25));
        this.runButton.setMinimumSize(new Dimension(26, 25));
        this.runButton.setPreferredSize(new Dimension(26, 25));
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSPCCS_SpreadsheetTester.this.runButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 32;
        gridBagConstraints.insets = new Insets(17, 0, 10, 0);
        this.buttonPanel.add((Component)this.runButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.fileMenu.setMnemonic(70);
        this.fileMenu.setText("File");
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSPCCS_SpreadsheetTester.this.exitActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mspccsSpreadsheetTesterMenuBar.add(this.fileMenu);
        this.optionsMenu.setText("Options");
        this.warningsCheckBoxMenuItem.setSelected(true);
        this.warningsCheckBoxMenuItem.setText("Warnings");
        this.warningsCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSPCCS_SpreadsheetTester.this.warningsCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.warningsCheckBoxMenuItem);
        this.mspccsSpreadsheetTesterMenuBar.add(this.optionsMenu);
        this.helpMenu.setMnemonic(72);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.contentsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/mspccs_spreadsheet_tester/gui/icons/Space16.gif")));
        this.contentsMenuItem.setMnemonic(67);
        this.contentsMenuItem.setText("Contents");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSPCCS_SpreadsheetTester.this.helpContentsActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.helpMenu.add(this.helpMenuSeparator);
        this.aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.aboutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/mspccs_spreadsheet_tester/gui/icons/Question16.gif")));
        this.aboutMenuItem.setMnemonic(65);
        this.aboutMenuItem.setText("About MSP CCS Spreadsheet Tester...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSPCCS_SpreadsheetTester.this.aboutActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mspccsSpreadsheetTesterMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mspccsSpreadsheetTesterMenuBar);
        this.pack();
    }

    private void helpContentsActionPerformed(ActionEvent actionEvent) {
        File file = new File("..");
        try {
            if (StartBrowser.isWindowsPlatform()) {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "\\help\\MSPCCS_SpreadsheetTester_Contents.htm");
            } else {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "/help/MSPCCS_SpreadsheetTester_Contents.htm");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Could not invoke browser", "Error", 0);
        }
    }

    private void aboutActionPerformed(ActionEvent actionEvent) {
        String string = "   MSP CCS SpreadsheetTester\n\n";
        string = string + "   Tests the coordinate conversion accuracy \n";
        string = string + "   of the MSP 3.0 coordinate conversion service.\n";
        JOptionPane.showMessageDialog(this, string, "About MSP CCS SpreadsheetTester", -1);
    }

    private void exitActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void runButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.inputFilePanel.getFileName();
        String string2 = this.outputFilePanel.getFileName();
        if (string.length() > 1 && string2.length() > 1) {
            boolean bl = false;
            Process process = null;
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            int n = 0;
            if (this.warningsCheckBoxMenuItem.isSelected()) {
                n = 1;
            }
            if (Platform.isWindows) {
                try {
                    process = Runtime.getRuntime().exec("MSPCCS_SpreadsheetTester \"" + string + "\"" + " " + "\"" + string2 + "\"" + " " + String.valueOf(n));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", 0);
                    bl = true;
                }
            } else if (Platform.isUnix) {
                try {
                    process = Runtime.getRuntime().exec("MSPCCS_SpreadsheetTester " + string + " " + string2 + " " + String.valueOf(n));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", 0);
                    bl = true;
                }
            } else if (Platform.isLinux) {
                try {
                    process = Runtime.getRuntime().exec("./MSPCCS_SpreadsheetTester " + string + " " + string2 + " " + String.valueOf(n));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", 0);
                    bl = true;
                }
            } else {
                JOptionPane.showMessageDialog(this, "OS undetermined\nCan't continue!", "Run Error!", 0);
                bl = true;
                process = null;
            }
            if (!bl) {
                new AppResultsWindow(process, "MSPCCS_SpreadsheetTester", string + " " + string2 + " " + String.valueOf(n), this.outputFilePanel.getCurrentDir());
            }
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    private void warningsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    public static void main(String[] stringArray) {
        new MSPCCS_SpreadsheetTester().show();
    }
}

