-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_common.ads,v $
--  Description     : common GUI procedures
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/11/25 18:22:17 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;

with Gsql_Types;               use Gsql_Types;

with Gtk.Box;                  use Gtk.Box;
with Gtk.GEntry;               use Gtk.GEntry;
with Gtk.Combo;                use Gtk.Combo;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Clist;                use Gtk.Clist;

package GUI_Common is

   -----------------
   -- Entry_Field --
   -----------------
   procedure Entry_Field(
      Vbox        : in out Gtk_Box;
      Field       : out Gtk_Entry;
      Description : in String;
      Default     : in String  := "";
      Maxlength   : in Natural := 60 );

   ------------------
   -- Display_Name --
   ------------------
   function Display_Name(
      S : in Unbounded_String ) return String;

   --------------
   -- Add_Text --
   --------------
   procedure Add_Text(
      A    : in Gtk_Box;
      Text : in String );

   ----------------
   -- Add_Editor --
   ----------------
   procedure Add_Editor(
      A    : in out Gtk_Box;
      T    : out Gtk_Text;
      Text : in String := "" );

   ---------------
   -- Add_Table --
   ---------------
   procedure Add_Table(
      A        : in out Gtk_Box;
      Clist    : out Gtk_Clist;
      Cols     : in Integer );

   procedure Insert_Row(
      Clist   : in out Gtk_Clist;
      Text    : in Text_Buffer;
      Row     : in Natural := 0);

   procedure Remove_Selection (
      CList : in out Gtk_Clist );

   procedure Combo_Field(
      Vbox        : in out Gtk_Box;
      Field       : out Gtk_Combo;
      Description : in  String;
      Values      : in  Text_Buffer;
      Maxlength   : in  Natural := 60 );

end GUI_Common;
