------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_var.ads,v 1.9 2006/12/11 04:31:47 vagul Exp $

with OCI.Thick.OCIHandle_Var,
     OCI.Thick.Statements;

package OCI.Thick.String_Var is

   use Statements;

   use OCI.Thick.OCIHandle_Var;

   type Variable is new Var_Type (SQLT_VST) with null record;

   procedure Resize (Var : in out Variable; Length : in Natural);

   procedure Set_Value (Var : in out Variable; Value : in String);
   function Get_Value (Var : in Variable) return String;
   function Value (Var : in Variable) return String renames Get_Value;

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive);

private

   procedure Initialize (Object : in out Variable);
   procedure Finalize   (Object : in out Variable);

end OCI.Thick.String_Var;
