# GPixPod - the free and open source way to manage photos on your POD!
# Copyright (C) 2006 Flavio Gargiulo (FLAGAR.com)
#
# This file has been contributed by Abaakouk Mehdi.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import dbus
import dbus.glib
import gnomevfs
import gobject


class iPodHal(gobject.GObject):
    __gsignals__ = {
        "ipod-removed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))   ,
        "ipod-added" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,)) 
    }
    def __init__(self):
        self.verbose = False
        gobject.GObject.__init__(self)

        self.ipod_udi = []

    def start_monitor(self):
        self.bus = dbus.SystemBus()
        self.vol_monitor =  gnomevfs.VolumeMonitor()
        self.vol_monitor.connect("volume_mounted",self.__volume_mounted_cb)
        self.vol_monitor.connect("volume_unmounted",self.__volume_unmounted_cb)

        volume = gnomevfs.Volume()
        for volume in self.vol_monitor.get_mounted_volumes():
            device_udi = volume.get_hal_udi()
            if device_udi!=None:
                device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
                device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")

                if self.is_ipod(device):
                    self.ipod_udi.append(device_udi)
                    self.emit("ipod-added",device_udi)
                    if self.verbose: print "IPOD found: ",device_udi


    def __volume_mounted_cb(self,monitor,volume):
        device_udi = volume.get_hal_udi()
        device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
        device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")

        if self.is_ipod(device):
            self.ipod_udi.append(device_udi)
            self.emit("ipod-added",device_udi)


    def __volume_unmounted_cb(self,monitor,volume):
        device_udi = volume.get_hal_udi()
        device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
        device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")

        if device_udi in self.ipod_udi:
            self.ipod_udi.remove(device_udi)
            self.emit("ipod-removed",device_udi)


    def get_ipod_mount_point(self,device_udi):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("volume.is_mounted") and device["volume.is_mounted"] and\
                device.has_key("volume.mount_point") and device["volume.mount_point"]!="":
                return device["volume.mount_point"]
            else:
                return ""

    def is_ipod(self,device):
        if device.has_key("info.parent"):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" , device["info.parent"])
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("storage.model") and device["storage.model"]=="iPod":
               return True
        return False



