// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"MSBM",

  0xf4,
  "TeX math symbols",
  0x00500000,
  0xfdf62117,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x0004ccd0 },
  { 0x03, "space_stretch", 0x00026660 },
  { 0x04, "space_shrink", 0x000199a0 },
  { 0x05, "x_height", 0x00076840 },
  { 0x06, "quad", 0x00100000 },
  { 0x07, "extra_space", 0x000199a0 },
  { 0x08, "num1", 0x000ecdca },
  { 0x09, "num2", 0x0006330d },
  { 0x0a, "num3", 0x000810ed },
  { 0x0b, "denom1", 0x00106763 },
  { 0x0c, "denom2", 0x000882b3 },
  { 0x0d, "sup1", 0x00080e90 },
  { 0x0e, "sup2", 0x000674f6 },
  { 0x0f, "sup3", 0x0004b60d },
  { 0x10, "sub1", 0x00033333 },
  { 0x11, "sub2", 0x00066666 },
  { 0x12, "supdrop", 0x0007e940 },
  { 0x13, "subdrop", 0x0001999a },
  { 0x14, "delim1", 0x001fae13 },
  { 0x15, "delim2", 0x0016b853 },
  { 0x16, "axis_height", 0x00040000 }
};



static TFM::Character character[] = {
  { 0x00, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00115566, 0x000d446d, 0x000555a0, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x00115566, 0x000d446d, 0x000555a0, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x00115566, 0x00112f5a, 0x00092f5a, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x00115566, 0x00112f5a, 0x00092f5a, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00115566, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x00138e4d, 0x000b05b0, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x00138e4d, 0x000c0000, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x00115566, 0x000e7036, 0x00067a0d, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00115566, 0x000e7036, 0x00067a0d, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x00115566, 0x000df15d, 0x0005da00, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0007555a, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x000638e6, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00098e40, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000e000d, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x001038f3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000e000d, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x001038f3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00115566, 0x000eeee6, 0x0006eee6, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00115566, 0x000cf3aa, 0x0004f3aa, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000ce39a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x42, 0x000aaa9a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x45, 0x000aaa9a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x0009c70d, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x47, 0x000c71b3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000c71b3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x000638da, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4a, 0x0007fff3, 0x000b05b0, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x000c71b3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4c, 0x000aaa9a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4d, 0x000f1c5a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000c71b3, 0x000b05b0, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x50, 0x0009c70d, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x51, 0x000c71b3, 0x000b05b0, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x53, 0x0008e380, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x000aaa9a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x55, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x57, 0x000fffe6, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x58, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x59, 0x000b8e26, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5a, 0x000aaa9a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x00278e66, 0x000d446d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x00307200, 0x000d446d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x00278e66, 0x000d446d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x00307200, 0x000e7036, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000ce39a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000e8e46, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x001038f3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x000ce39a, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00115566, 0x00083ca6, 0x00003ca6, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x000f1c80, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000aaab3, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000f1c80, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000638e6, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x00098e40, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x00115566, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x00115566, 0x00089da6, 0x00009da6, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x00115566, 0x000df15d, 0x000608ba, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x0015c733, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x0015c733, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00115566, 0x000a96aa, 0x000296aa, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000f1c80, 0x0006e38d, 0x00000000, 0x0000e390, 0, 0, 0, 0 },
  { 0x7c, 0x0008e380, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000caab6, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000caab6, 0x000b05b0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000a555d, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
msbm5_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
