; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; RUN: igc_opt -debugify --igc-gas-resolve -S < %s | FileCheck %s

; We use "-debugify" in order to have some metadata in addrspacecast instruction.
; addrspacecast instructions in both directions should have a metadata.

%st = type {i32 addrspace(4)*}

define i32 addrspace(4)* @should_add_addrspacecast_with_metadata(%st addrspace(1)* %src) {
; CHECK-LABEL: define i32 addrspace(4)* @should_add_addrspacecast_with_metadata(
; CHECK-SAME: [[ST:%.*]] addrspace(1)* [[SRC:%.*]]) !dbg [[DBG8:![0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = inttoptr i32 13 to i32 addrspace(2)*, !dbg [[DBG18:![0-9]+]]
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i32 addrspace(2)* [[TMP1]], metadata [[META12:![0-9]+]], metadata !DIExpression()), !dbg [[DBG18]]
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i32 addrspace(2)* [[TMP1]], metadata [[META14:![0-9]+]], metadata !DIExpression()), !dbg [[DBG19:![0-9]+]]
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr [[ST]], [[ST]] addrspace(1)* [[SRC]], i32 0, i32 0, !dbg [[DBG20:![0-9]+]]
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i32 addrspace(4)* addrspace(1)* [[TMP2]], metadata [[META15:![0-9]+]], metadata !DIExpression()), !dbg [[DBG20]]
; CHECK-NEXT:    [[POINTER_VALUE:%.*]] = load i32 addrspace(4)*, i32 addrspace(4)* addrspace(1)* [[TMP2]], align 8, !dbg [[DBG21:![0-9]+]]
; CHECK-NEXT:    [[TMP3:%.*]] = addrspacecast i32 addrspace(4)* [[POINTER_VALUE]] to i32 addrspace(1)*, !dbg [[DBG21]]
; CHECK-NEXT:    [[TMP4:%.*]] = addrspacecast i32 addrspace(1)* [[TMP3]] to i32 addrspace(4)*, !dbg [[DBG21]]
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i32 addrspace(4)* [[POINTER_VALUE]], metadata [[META16:![0-9]+]], metadata !DIExpression()), !dbg [[DBG21]]
; CHECK-NEXT:    [[POINTER_VALUE2:%.*]] = addrspacecast i32 addrspace(4)* [[TMP4]] to i32 addrspace(2)*, !dbg [[DBG22:![0-9]+]]
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i32 addrspace(2)* [[POINTER_VALUE2]], metadata [[META17:![0-9]+]], metadata !DIExpression()), !dbg [[DBG22]]
; CHECK-NEXT:    store i32 13, i32 addrspace(1)* [[TMP3]], align 4, !dbg [[DBG23:![0-9]+]]
; CHECK-NEXT:    store i32 14, i32 addrspace(2)* [[POINTER_VALUE2]], align 4, !dbg [[DBG24:![0-9]+]]
; CHECK-NEXT:    ret i32 addrspace(4)* [[TMP4]], !dbg [[DBG25:![0-9]+]]
;
  %1 = inttoptr i32 13 to i32 addrspace(2)*
  %2 = addrspacecast i32 addrspace(2)* %1 to i32 addrspace(4)*
  %3 = getelementptr %st, %st addrspace(1)* %src, i32 0, i32 0
  %pointer_value = load i32 addrspace(4)*, i32 addrspace(4)* addrspace(1)* %3
  %pointer_value2 = addrspacecast i32 addrspace(4)* %pointer_value to i32 addrspace(2)*
  store i32 13, i32 addrspace(4)* %pointer_value
  store i32 14, i32 addrspace(2)* %pointer_value2
  ret i32 addrspace(4)* %pointer_value
}

!igc.functions = !{!0}
!0 = !{i32 addrspace(4)* (%st addrspace(1)*)* @should_add_addrspacecast_with_metadata, !1}
!1 = !{!2}
!2 = !{!"function_type", i32 0}
;.
; CHECK: [[META3:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C, file: [[META4:![0-9]+]], producer: "debugify", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug)
; CHECK: [[META4]] = !DIFile(filename: "<stdin>", directory: {{.*}})
; CHECK: [[DBG8]] = distinct !DISubprogram(name: "should_add_addrspacecast_with_metadata", linkageName: "should_add_addrspacecast_with_metadata", scope: null, file: [[META4]], line: 1, type: [[META9:![0-9]+]], scopeLine: 1, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: [[META3]], retainedNodes: [[META11:![0-9]+]])
; CHECK: [[META9]] = !DISubroutineType(types: [[META10:![0-9]+]])
; CHECK: [[META10]] = !{}
; CHECK: [[META11]] = !{[[META12]], [[META14]], [[META15]], [[META16]], [[META17]]}
; CHECK: [[META12]] = !DILocalVariable(name: "1", scope: [[DBG8]], file: [[META4]], line: 1, type: [[META13:![0-9]+]])
; CHECK: [[META13]] = !DIBasicType(name: "ty64", size: 64, encoding: DW_ATE_unsigned)
; CHECK: [[META14]] = !DILocalVariable(name: "2", scope: [[DBG8]], file: [[META4]], line: 2, type: [[META13]])
; CHECK: [[META15]] = !DILocalVariable(name: "3", scope: [[DBG8]], file: [[META4]], line: 3, type: [[META13]])
; CHECK: [[META16]] = !DILocalVariable(name: "4", scope: [[DBG8]], file: [[META4]], line: 4, type: [[META13]])
; CHECK: [[META17]] = !DILocalVariable(name: "5", scope: [[DBG8]], file: [[META4]], line: 5, type: [[META13]])
; CHECK: [[DBG18]] = !DILocation(line: 1, column: 1, scope: [[DBG8]])
; CHECK: [[DBG19]] = !DILocation(line: 2, column: 1, scope: [[DBG8]])
; CHECK: [[DBG20]] = !DILocation(line: 3, column: 1, scope: [[DBG8]])
; CHECK: [[DBG21]] = !DILocation(line: 4, column: 1, scope: [[DBG8]])
; CHECK: [[DBG22]] = !DILocation(line: 5, column: 1, scope: [[DBG8]])
; CHECK: [[DBG23]] = !DILocation(line: 6, column: 1, scope: [[DBG8]])
; CHECK: [[DBG24]] = !DILocation(line: 7, column: 1, scope: [[DBG8]])
; CHECK: [[DBG25]] = !DILocation(line: 8, column: 1, scope: [[DBG8]])
;.
