### Issues are for Bug Reports and Feature Requests Only!

If you are looking for help or support please use one of the following methods

Create a New Topic on the Level1Tech's forum under the Looking Glass category:
* https://forum.level1techs.com/c/software/lookingGlass/142

Ask for help in the Looking Glass discord server
* https://discord.gg/52SMupxkvt

*Issues that are not bug reports or feature requests will be closed & ignored*

### Errors that are not bugs

Some errors generated by the LG client are not bugs, but rather issues with your
system's configuration and/or timing. Please do not report these, but rather use
one of the above resources to ask for advice/help.

* `LGMP_ERR_QUEUE_UNSUBSCRIBED` - Failure to heed advice on things such as
using `isolcpus` and CPU pinning may result in this message, especially if you
are over-taxing your CPU.

* `Could not create an SDL window: *` - Failure to create a SDL window is not an
issue with Looking Glass but rather a more substantial issue with your system,
such as missing hardware support for the RGBA32 pixmap format, or missing
required OpenGL EGL features.

* `The host application is not compatible with this client` - The Looking Glass
 Host application in Windows is the incorrect version and is not compatible,
you need to make sure you run matching versions of both the host and client
applications.

### Bug Report Required Information

The entire (not truncated) output from the client application (if applicable).
To obtain this run `looking-glass-client` in a terminal.

```
PASTE CLIENT OUTPUT HERE
```

The entire (not truncated) log file from the host application (if applicable).
Normally, this is found on the guest system at:

    %ProgramData%\Looking Glass (host)\looking-glass-host.txt

This log may be quite long, please delete the file first and then proceed to
launch the host and reproduce the issue so that the log only contains the
pertinent information.


```
PASTE HOST LOG FILE CONTENTS HERE
```

If the client is unexpectedly exiting without a backtrace, please provide one via
gdb with the command `thread apply all bt`. If you are unsure how to do this
please watch the video below on how to perform a Debug build and generate this
backtrace.

https://www.youtube.com/watch?v=EqxxJK9Yo64


```
PASTE FULL BACKTRACE HERE
```
