<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of·
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    require "accountmanager.data.php";
    function accountmanager_processlist($server, $username = Null) {
        global $config;
        $accountmanager = AccountManager::getInstance();

        # Generate a block containing a list of all application servers
        if ($username == Null) {
            $content="<b>"._("List of process on")." ".$server."</b><br /><br />";
        }
        else {
            $content="<b>"._("List of process for user")." ".$username." "._("on")." ".$server."</b><br /><br />";
        }
        $content.= "
            <form class=\"filter\" action=\"#\"><p style=\"font-weight:bold\">"._("Search").": <input onkeyup=\"javascript:filterTable(this,'listing')\" /></p></form>
            <table class=\"listing\">
                <tr class=\"trheader\">
            ";
        if ($username == Null) {
            $content.= "
                    <td><b>"._("Username")."</b></td>
            ";
        }
        $content.= "
                    <td><b>".str_replace(" ","&nbsp;",_("Process ID"))."</b></td>
                    <td><b>".str_replace(" ","&nbsp;",_("Process name"))."</b></td>
                    <td><b>".str_replace(" ","&nbsp;",_("Actions"))."</b></td>
                </tr>
        ";

        $process_id=0;
        $lines=split("\n",$accountmanager->listProcess($server,$username));
        foreach ($lines as $line) {
            $line=trim($line);
            if (!$line) {
                continue;
            }
            ereg("([0-9]*) (.*)",$line,$process);
            if (!$process[1]) {
                continue;
            }
            $colspan=3;
            $content.= "
                <tr>
            ";
            if ($username == Null) {
                $colspan=4;
                $content.= "
                    <td>Username</td>
                ";
            }
            $content.= "
                    <td>".$process[1]."</td>
                    <td>".$process[2]."</td>
                    <td>&nbsp;</td>
                </tr>
            ";
            $process_id++;
        }
        $content.= "
            </table>
        ";
        return $content;
    }
?>
