package Business::EDI::CodeList::StatusReasonDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {9013;}
my $usage       = 'C';

# 9013  Status reason description code                          [C]
# Desc: Code specifying the reason for a status.
# Repr: an..3

my %code_hash = (
'1' => [ 'Address ex delivery area',
    'The address for delivery is outside the area of the carrier/transporter.' ],
'2' => [ 'After transport departed',
    'The goods/consignments/equipment arrived after the means of transport has departed.' ],
'3' => [ 'Agent refusal',
    'The agent of the customer refused to accept delivery.' ],
'4' => [ 'Altered seals',
    'The seals on the equipment have been changed from those notified.' ],
'5' => [ 'Appointment scheduled',
    'An arrangement has been made to deliver at a specific time.' ],
'6' => [ 'Attempt unsuccessful',
    'An unsuccessful attempt has been made to deliver the goods/consignments/equipment.' ],
'7' => [ 'Business closed',
    'The goods/consignments/equipment could not be delivered/collected as the business was closed.' ],
'8' => [ 'Changed schedule',
    'The goods/consignments/equipment cannot/will not be delivered/collected at the arranged time because of a change of schedule.' ],
'9' => [ 'Complementary address needed',
    'A further address is needed to effect delivery/collection of the goods/consignments/equipment.' ],
'10' => [ 'Computer system down',
    'The computer system is inoperative.' ],
'11' => [ 'Credit approval requested',
    'The consignee requests delivery on a credit base.' ],
'12' => [ 'Customer arrangements',
    'Goods/consignments/equipment require delivery arrangements by the customer.' ],
'13' => [ 'Customs refusal',
    'The Customs authorities have refused to clear the goods/consignments/equipment.' ],
'14' => [ 'Damaged',
    'The goods/consignments/equipment have been damaged.' ],
'15' => [ 'Delivery at specific requested dates/times/periods',
    'Delivery of the goods/consignments/equipment is requested at specific dates/times/periods.' ],
'16' => [ 'Destination incorrect',
    'The goods/consignments/equipment have been sent to wrong destination.' ],
'17' => [ 'Departure delay',
    'The transport has been delayed in departing on the arranged transport action.' ],
'18' => [ 'Derailment',
    'The train carrying the goods/consignments/equipment has been derailed.' ],
'19' => [ 'Discrepancy',
    'There is a discrepancy between the details of goods/ equipment previously provided and the actual situation.' ],
'20' => [ 'Dock strike',
    'The goods/consignments/equipment cannot be delivered/collected due to a dock strike.' ],
'21' => [ 'Due to customer',
    'An action in the transport chain has been affected due to action of the customer.' ],
'22' => [ 'Empty',
    'The package/equipment is found to be empty.' ],
'23' => [ 'Equipment failure',
    'Delivery/collection could not be effected due to equipment failure.' ],
'24' => [ 'Examination required by relevant authority',
    'An examination of the goods/equipment has been ordered by the relevant authority.' ],
'25' => [ 'Export restrictions',
    'The goods/consignments/equipment have been prohibited from export pending further investigation.' ],
'26' => [ 'Frustrated export',
    'Attempts to export the goods/consignments/equipment have been unsuccessful.' ],
'27' => [ 'Goods units missing',
    'The tally of goods/consignments/equipment does not match the quantity as per advice. Result: less than advised.' ],
'28' => [ 'Import restrictions',
    'The goods/consignments/equipment need import checks and tests pending being released for importation.' ],
'29' => [ 'Incorrect pick information',
    'The goods/consignments/equipment were not collected due to incorrect pick information.' ],
'30' => [ 'Incorrect address',
    'The address given for the action was incorrect.' ],
'31' => [ 'Industrial dispute',
    'The action was frustrated by an industrial dispute.' ],
'32' => [ 'Instructions awaited',
    'Further instructions are required.' ],
'33' => [ 'Lost goods/consignments/equipment',
    'The goods/consignments/equipment have been lost in the course of a movement along the transport chain.' ],
'34' => [ 'Means of transport damaged',
    'The means of transport on which the goods/consignments/equipment were being (were to be) moved has been damaged.' ],
'35' => [ 'Mechanical breakdown',
    'There has been a mechanical breakdown of the means of transport/equipment on which the goods/consignments/equipment was being (was to be) moved.' ],
'36' => [ 'Mechanical inspection',
    'A mechanical inspection of the means of transport/ equipment on which the goods/consignments/equipment were being (were to be) moved, is required.' ],
'37' => [ 'Missing and/or incorrect documents',
    'The goods/consignments/equipment require complete and correct documentation.' ],
'38' => [ 'New delivery arrangements',
    'Alternative delivery arrangements advised by consignee after failed delivery.' ],
'39' => [ 'No recipient contact information',
    'No information available concerning the responsible person at delivery address.' ],
'40' => [ 'Not identified',
    'The goods/consignments/equipment expected to be located and identified in the transport chain cannot be identified.' ],
'41' => [ 'Not loaded',
    'The goods/consignments/equipment to be loaded onto a means of transport have not been loaded on the expected transport.' ],
'42' => [ 'On deck',
    'The goods/consignments/equipment have been stowed on deck.' ],
'43' => [ 'Package not ready',
    'The package was not available for collection.' ],
'44' => [ 'Package tracking number unknown',
    'The package tracking number is unknown.' ],
'45' => [ 'Partly missing',
    'The goods/consignments/equipment are partly, but not completely, missing.' ],
'46' => [ 'Payment not received',
    'The expected payment for the transport action was not received.' ],
'47' => [ 'Payment refused',
    'The payer refused to pay for the service.' ],
'48' => [ 'Plundered',
    'The goods/consignments/equipment have been plundered.' ],
'49' => [ 'Refused without reason given',
    'The transport action/documentation has been refused without explanation.' ],
'50' => [ 'Scheduled past cut-off',
    'The goods/consignments/equipment to be delivered/collected have been scheduled past/later than the cut-off time.' ],
'51' => [ 'Shunted to siding',
    'The transport on which the goods/consignments/equipment is to be placed has been shunted to siding.' ],
'52' => [ 'Signature not required',
    'No signature required.' ],
'53' => [ 'Sorted wrong route',
    'The goods/consignments/equipment have been sorted erroneously to an incorrect route.' ],
'54' => [ 'Special service required',
    'A special service is required for the goods/consignments/equipment.' ],
'55' => [ 'Split',
    'The consignment of goods has been split into two or more consignments.' ],
'56' => [ 'Totally missing',
    'The total goods/consignments/equipment is missing.' ],
'57' => [ 'Tracking information unavailable',
    'The tracking information of the goods/consignments/equipment is unavailable.' ],
'58' => [ 'Transit delay',
    'The goods/consignments/equipment have been delayed in transit.' ],
'59' => [ 'Unable to locate',
    'The goods/consignments/equipment cannot be located.' ],
'60' => [ 'Unacceptable condition',
    'The goods/consignments/equipment were in unacceptable condition at time of delivery/collection.' ],
'61' => [ 'Under deck',
    'The goods/consignments/equipment have been stowed under/below deck.' ],
'62' => [ 'Unknown',
    'The reason is unknown.' ],
'63' => [ 'Weather conditions',
    'The weather conditions have affected collection/delivery.' ],
'64' => [ 'Expired free time',
    'The goods/consignments/equipment have been in a storage facility for longer than permitted free time.' ],
'65' => [ 'Outstanding claims settled',
    'Outstanding claims in respect of goods/consignments/equipment have been settled.' ],
'66' => [ 'Stolen',
    'A consignment or goods have been stolen.' ],
'67' => [ 'Administrative error',
    'An administrative error has occurred.' ],
'68' => [ 'Undefined incident attributed to buyer',
    'An undefined incident has been attributed to the buyer.' ],
'69' => [ 'Undefined incident attributed to carrier',
    'An undefined incident has been attributed to the carrier.' ],
'70' => [ 'Undefined incident attributed to logistic service provider',
    'An undefined incident has been attributed to the logistic service provider.' ],
'71' => [ 'Change in agreed product reference',
    'An agreed reference associated with a product has changed.' ],
'72' => [ 'Difference in replenishment figures',
    'A difference has been identified between the opening inventory balance, the physical count of incoming replenishment inventory, and the closing inventory balance.' ],
'73' => [ 'Lost quantity of variable measurement product',
    'A quantity of a variable measurement product which has been lost.' ],
'74' => [ 'Damaged during manipulation in warehouse',
    'Product damaged during the manipulation process in a warehouse.' ],
'75' => [ 'Product degenerated during storage or transport',
    'A product has degenerated during storage or transport.' ],
'76' => [ 'Destroyed',
    'The goods, consignments, or equipment have been destroyed.' ],
'77' => [ 'Best before date expired',
    "A product's best before date has expired." ],
'78' => [ 'Log number assignment',
    'Log number is assigned.' ],
'79' => [ 'Entry point assessment of Data Maintenance Request (DMR)',
    'initial comment An entry point is providing its initial comments on a DMR.' ],
'80' => [ 'Entry point assessment of Data Maintenance Request (DMR)',
    'latest comment An entry point is providing its latest comments on a DMR.' ],
'81' => [ 'Unable to take corrective action',
    'Corrective action could not be taken.' ],
'82' => [ 'International assessment group reporting on Data',
    'Maintenance Request (DMR) The international assessment group has determined if the Data Maintenance Request (DMR) is to be included in the next publication of the standard.' ],
'84' => [ 'Central secretariat review cycle start',
    'Report start of the central secretariat review cycle.' ],
'85' => [ 'Data structure tag assigned',
    'A data structure has been assigned a permanent tag.' ],
'87' => [ 'Error',
    'Information is in error.' ],
'88' => [ 'Accident involving means of transport',
    'The means of transport being used to move the consignment has been involved in an accident.' ],
'89' => [ 'Order or instruction status change',
    'A status of an order or instruction has changed.' ],
'90' => [ 'Not accepted by delivery party',
    'The delivery was not accepted by the delivery party.' ],
'91' => [ 'Delivery requested to another location by ordering party',
    'Goods have been delivered to another location following an instruction from the ordering party.' ],
'92' => [ 'Incorrect goods delivered',
    'The goods delivered were incorrect.' ],
'93' => [ 'Undefined incident attributed to customs authority',
    'An undefined incident has been attributed to the customs authority.' ],
'94' => [ 'Imperfect item',
    'Item has defect(s).' ],
'95' => [ 'Excess goods delivered',
    'Excess goods have been delivered.' ],
'96' => [ 'Goods partially delivered',
    'Goods were partially delivered.' ],
'97' => [ 'Remove to federal court',
    'Action has been removed to a federal court level.' ],
'98' => [ 'Change of venue granted',
    'A change in venue has been approved.' ],
'99' => [ 'Replenish inventory',
    'The goods, consignment and/or equipment have replenished inventory.' ],
'100' => [ 'Unloading date and or time not received',
    'The unloading date and or time was not received.' ],
'101' => [ 'Stacked pallets not acceptable',
    'Stacked pallets are not accepted by the goods recipient.' ],
'102' => [ 'Pallets containing mixed goods not acceptable',
    'Pallets containing mixed goods are not accepted by goods recipient.' ],
'103' => [ 'Product expiry date not acceptable',
    'The product expiry date is not accepted.' ],
'104' => [ 'Pallet and goods height higher than permitted',
    'The combined height of the pallet and goods is higher than permitted.' ],
'105' => [ 'Delivery order not received',
    'The delivery order was not received.' ],
'106' => [ 'Back-orders not permitted by goods recipient',
    'Back-orders are not permitted by the goods recipient.' ],
'107' => [ 'Article identification not found in computer system',
    'Article identification is not found in computer system.' ],
'108' => [ 'Goods not barcoded',
    'Goods are not barcoded.' ],
);
sub get_codes { return \%code_hash; }

1;
