#if !defined (__LIMITS_HPP)
#define __LIMITS_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if !defined IN_COMMON_HPP
   #error Limits.hpp is included by Common.hpp only.
#endif

namespace   corelinux
{
   DECLARE_CLASS( Limits );

   /** 
   Limits is to provide information regarding CoreLinux++
   scalar types
   */
   class Limits
   {

   public:
      enum CharLimits
      {
         CHARBITS = 8,
         CHARMIN  = -128,
         CHARMAX  = 127
      };

      enum ByteLimits
      {
         BYTEBITS = 8,
         BYTEMIN  = 0,
         BYTEMAX  = 255
      };

      enum ShortLimits
      {
         SHORTBITS = 16,
         SHORTMIN  = (-32768),
         SHORTMAX  = 32767
      };

      enum WordLimits
      {
         WORDBITS  = 16,
         WORDMIN   = 0,
         WORDMAX   = 65535
      };

      enum LongLimits
      {
         LONGBITS  = 32,
         LONGMIN   = (-2147483647 - 1),
         LONGMAX   = 2147483647
      };

      enum DwordLimits
      {
         DWORDBITS = 32,
         DWORDMIN  = 0,
         DWORDMAX  = -1 // 4294967295U USE DWORD(DWORDMAX) IN CAST
      };

      enum SizeLimits
      {
         SIZEBITS = DWORDBITS,
         SIZEMIN  = DWORDMIN,
         SIZEMAX  = DWORDMAX
      };

      enum IndexLimits
      {
         INDEXBITS = DWORDBITS,
         INDEXMIN  = DWORDMIN,
         INDEXMAX  = DWORDMAX
      };

      enum CounterLimits
      {
         COUNTERBITS = LONGBITS,
         COUNTERMIN  = LONGMIN,
         COUNTERMAX  = LONGMAX
      };

      enum IdLimits
      {
         IDBITS = WORDBITS,
         IDMIN  = WORDMIN,
         IDMAX  = WORDMAX
      };

      // *******************************************
      // Real Limits
      // *******************************************

      static  Word            RealBits;
      static  Word            RealPrecision;      
      static  Real            RealMin;
      static  Real            RealMax;

      // *******************************************
      // Smallest number such that 1.0 + RealEpsilon != 1.0
      // *******************************************

      static  Real            RealEpsilon;
   };

}

#endif  // !defined HEADER_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

