/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.VirtualMachine;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;

public final class Scenario {
    private final BenchmarkMethod benchmarkMethod;
    private final VirtualMachine vm;
    private final ImmutableSortedMap<String, String> userParameters;
    private final ImmutableSortedMap<String, String> vmArguments;

    public Scenario(BenchmarkMethod benchmarkMethod, Map<String, String> userParameters, Map<String, String> vmArguments, VirtualMachine vm) {
        this.benchmarkMethod = benchmarkMethod;
        this.userParameters = ImmutableSortedMap.copyOf(userParameters);
        this.vmArguments = ImmutableSortedMap.copyOf(vmArguments);
        this.vm = vm;
    }

    public BenchmarkMethod benchmarkMethod() {
        return this.benchmarkMethod;
    }

    public ImmutableSortedMap<String, String> userParameters() {
        return this.userParameters;
    }

    public VirtualMachine vm() {
        return this.vm;
    }

    public ImmutableSortedMap<String, String> vmArguments() {
        return this.vmArguments;
    }

    public ImmutableMap<String, String> asFlattenedMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.userParameters).putAll(this.vmArguments).put((Object)"benchmark", (Object)this.benchmarkMethod.name()).put((Object)"vm", (Object)this.vm.name);
        return builder.build();
    }

    public boolean equals(Object object) {
        if (object instanceof Scenario) {
            Scenario that = (Scenario)object;
            return this.benchmarkMethod.equals(that.benchmarkMethod) && this.vm.equals(that.vm) && this.userParameters.equals(that.userParameters) && this.vmArguments.equals(that.vmArguments);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.benchmarkMethod, this.vm, this.userParameters, this.vmArguments});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("benchmarkMethod", (Object)this.benchmarkMethod).add("vm", (Object)this.vm).add("userParameters", this.userParameters).add("vmArguments", this.vmArguments).toString();
    }
}

