/*
 *  @(#)DefaultTestIssueRecord.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.itf.impl;

import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.IIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.ITestRecord;




/**
 * Simple immutable implementation of <tt>ITestIssueRecord</tt>.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:00 $
 * @since      July 7, 2002
 */
public class DefaultTestIssueRecord implements ITestIssueRecord
{
    
    private IIssueRecord ir;
    private ITestRecord tr;
    private String desc;
    
    
    public DefaultTestIssueRecord( IIssueRecord ir, ITestRecord tr, String d )
    {
        if (ir == null || tr == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        
        this.ir = ir;
        this.tr = tr;
        this.desc = d;
    }
    
    /**
     * Returns the issue this record is associated with.
     */
    public IIssueRecord getIssueRecord()
    {
        return this.ir;
    }
    
    
    /**
     * Returns the test this record is associated with.
     */
    public ITestRecord getTestRecord()
    {
        return this.tr;
    }
    
    
    /**
     * Returns any descriptive text the test associated itself with to the
     * issue.
     */
    public String getDescription()
    {
        return this.desc;
    }
}

