/*

Copyright (c) 2015, Arvid Norberg
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the distribution.
    * Neither the name of the author nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

*/

#include "libtorrent/settings_pack.hpp"
#include "libtorrent/alert.hpp"
#include "settings.hpp"

using namespace libtorrent;

libtorrent::settings_pack settings()
{
	const int mask =
		alert::error_notification
		| alert::peer_notification
		| alert::port_mapping_notification
		| alert::storage_notification
		| alert::tracker_notification
		| alert::debug_notification
		| alert::status_notification
		| alert::ip_block_notification
		| alert::dht_notification
		| alert::session_log_notification
		| alert::torrent_log_notification
		| alert::peer_log_notification
		| alert::incoming_request_notification
		| alert::dht_log_notification
		| alert::dht_operation_notification
		| alert::port_mapping_log_notification
		| alert::file_progress_notification
		| alert::piece_progress_notification;

	settings_pack pack;
	pack.set_bool(settings_pack::enable_lsd, false);
	pack.set_bool(settings_pack::enable_natpmp, false);
	pack.set_bool(settings_pack::enable_upnp, false);
	pack.set_bool(settings_pack::enable_dht, false);
	pack.set_str(settings_pack::dht_bootstrap_nodes, "");

	pack.set_bool(settings_pack::prefer_rc4, false);
	pack.set_int(settings_pack::in_enc_policy, settings_pack::pe_disabled);
	pack.set_int(settings_pack::out_enc_policy, settings_pack::pe_disabled);
	pack.set_int(settings_pack::allowed_enc_level, settings_pack::pe_both);

	pack.set_int(settings_pack::alert_mask, mask);

#ifndef TORRENT_BUILD_SIMULATOR
	pack.set_bool(settings_pack::allow_multiple_connections_per_ip, true);
#else
	// we use 0 threads (disk I/O operations will be performed in the network
	// thread) to be simulator friendly.
	pack.set_int(settings_pack::aio_threads, 0);
#endif

#ifndef TORRENT_NO_DEPRECATE
	pack.set_int(settings_pack::half_open_limit, 1);
#endif

	return pack;
}

