# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class Selection(DataObject):
    r"""
    Selection - data object that represents a "selection" in VTK.
    
    Superclass: DataObject
    
    Selection defines a selection. A selection is a data-object that
    defines which entities from another data-object are to treated as
    "selected". Filters like `vtkextract_selection` or
    `vtkextract_data_arrays_over_time` can then be used to extract these
    selected entities from the *other* data-object.
    
    Selection comprises of `vtkselection_node`s and optionally, an
    expression specified using `Selection::set_expression`. If
    non-empty, the expression is a boolean expression that defines now
    the selection nodes present in the selection are to be combined
    together to form the selection. If no expression is specified and
    there are multiple selection nodes, then the default expression
    simply combines all the selection nodes using an `or` operator.
    
    Each SelectionNode is used to define the selection criteria.
    SelectionNode API lets one select what kind of entities are being
    selected (vtkselection_node::field_type) and how they are being
    selected (vtkselection_node::content_type).
    
    @sa
    SelectionNode
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSelection, obj, update, **traits)
    
    expression = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the expression that defines the boolean expression to
        combine the selection nodes. Expression consists of node name
        identifiers, `|` for boolean-or, '^' for boolean-xor, '&' for
        boolean and, '!' for boolean not, and parenthesis `(` and `)`. If
        the expression consists of a node name identifier that is not
        assigned any `vtkselection_node` (using `set_node`) then it is
        evaluates to `false`.
        
        `set_expression` does not validate the expression. It will be
        validated in `Evaluate` call.
        """
    )

    def _expression_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExpression,
                        self.expression)

    def get_node(self, *args):
        """
        get_node(self, idx:int) -> SelectionNode
        C++: virtual SelectionNode *get_node(unsigned int idx)
        get_node(self, name:str) -> SelectionNode
        C++: virtual SelectionNode *get_node(const std::string &name)
        Returns a node given it's index. Performs bound checking and will
        return nullptr if out-of-bounds.
        """
        ret = self._wrap_call(self._vtk_obj.GetNode, *args)
        return wrap_vtk(ret)

    def set_node(self, *args):
        """
        set_node(self, name:str, __b:SelectionNode) -> None
        C++: virtual void set_node(const std::string &name,
            SelectionNode *)
        Adds a SelectionNode and assigns it the specified name. The
        name must be a non-empty string. If an item with the same name
        has already been added, it will be removed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNode, *my_args)
        return ret

    def get_node_name_at_index(self, *args):
        """
        get_node_name_at_index(self, idx:int) -> str
        C++: virtual std::string get_node_name_at_index(unsigned int idx)
        Returns the name for a node at the given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetNodeNameAtIndex, *args)
        return ret

    def _get_number_of_nodes(self):
        return self._vtk_obj.GetNumberOfNodes()
    number_of_nodes = traits.Property(_get_number_of_nodes, desc=\
        r"""
        Returns the number of nodes in this selection. Each node contains
        information about part of the selection.
        """
    )

    def add_node(self, *args):
        """
        add_node(self, __a:SelectionNode) -> str
        C++: virtual std::string add_node(SelectionNode *)
        Adds a selection node. Assigns the node a unique name and returns
        that name. This API is primarily provided for backwards
        compatibility and `set_node` is the preferred method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddNode, *my_args)
        return ret

    def dump(self):
        """
        dump(self) -> None
        C++: virtual void dump()
        Dumps the contents of the selection, giving basic information
        only.
        """
        ret = self._vtk_obj.Dump()
        return ret
        

    def remove_all_nodes(self):
        """
        remove_all_nodes(self) -> None
        C++: virtual void remove_all_nodes()
        Removes all selection nodes.
        """
        ret = self._vtk_obj.RemoveAllNodes()
        return ret
        

    def remove_node(self, *args):
        """
        remove_node(self, idx:int) -> None
        C++: virtual void remove_node(unsigned int idx)
        remove_node(self, name:str) -> None
        C++: virtual void remove_node(const std::string &name)
        remove_node(self, __a:SelectionNode) -> None
        C++: virtual void remove_node(SelectionNode *)
        Removes a selection node.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveNode, *my_args)
        return ret

    def subtract(self, *args):
        """
        subtract(self, selection:Selection) -> None
        C++: virtual void subtract(Selection *selection)
        subtract(self, node:SelectionNode) -> None
        C++: virtual void subtract(SelectionNode *node)
        Remove the nodes from the specified selection from this
        selection. Assumes that selection node internal arrays are
        IdTypeArrays.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Subtract, *my_args)
        return ret

    def union(self, *args):
        """
        union(self, selection:Selection) -> None
        C++: virtual void union(Selection *selection)
        union(self, node:SelectionNode) -> None
        C++: virtual void union(SelectionNode *node)
        Union this selection with the specified selection. Attempts to
        reuse selection nodes in this selection if properties match
        exactly. Otherwise, creates new selection nodes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Union, *my_args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('expression', 'GetExpression'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'expression', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Selection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['expression',
            'object_name']),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Selection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

