/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_TESTUTILS_H
#define MEDIASCANNER_TESTUTILS_H

// Boost C++
#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/filesystem/path.hpp>

// C++ Standard Library
#include <string>

// Media Scanner Library
#include "mediascanner/property.h"
#include "mediascanner/utilities.h"

namespace boost {
namespace filesystem {

inline void PrintTo(const path &p, std::ostream *os) {
    *os << p.string();
}

} // namespace filesystem
} // namespace boost

namespace mediascanner {

void InitTests(int *argc, char **argv);

inline void PrintTo(const Property *property, std::ostream *os) {
    *os << property->field_name() << " property";
}

inline void PrintTo(const Property &property, std::ostream *os) {
    *os << property.field_name() << " property";
}

inline void PrintTo(const Property::Value &value, std::ostream *os) {
    *os << value;
}

inline void PrintTo(const nullptr_t &, std::ostream *os) {
    *os << "NULL";
}

std::string make_base_url();

inline std::string full_url(const std::string &url) {
    return make_base_url() + url;
}

} // namespace mediascanner

#endif // MEDIASCANNER_TESTUTILS_H
