/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_REGISTEREDSENSORSPROFILEACCESS_H_
#define OPENDRIM_REGISTEREDSENSORSPROFILEACCESS_H_

#include "Sensors_Common.h"

#include "OpenDRIM_RegisteredSensorsProfile.h"

int Sensors_OpenDRIM_RegisteredSensorsProfile_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_unload(string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSensorsProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSensorsProfile& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& newInstance, const OpenDRIM_RegisteredSensorsProfile& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage);

int Sensors_OpenDRIM_RegisteredSensorsProfile_populate(OpenDRIM_RegisteredSensorsProfile& instance, string& errorMessage);

#endif /*OPENDRIM_REGISTEREDSENSORSPROFILEACCESS_H_*/
