# 6/18/2020

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Eskil Steenburg
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Nick Porcino
* Owen Thompson
* Peter Hillman
* Alison Rowan

### Discussion:

* Review OpenEXR logo concepts with Alison Rowan from the LF's Creative Services group.

  * General consensus on preferring the design that illustrates 3 exposure levels.

  * Based loosly Nick's idea sketch.

  * How well will it read when it’s small? 

  * Could EXR be in red?

  * Discusion of perspective vs orthographic. Does the perspective
    look a little too precious?  Consensus prefers the orthographic.

* Discussion of exception handling. 

  * Kimball will submit his proposal to a branch in the Imath repo,
    for further review. He had another idea that avoids any change to
    the API.

* Discussion of performance metrics

  * Peter: can we somehow link a test with two different variations of
    the library and compare metrics between them? Using namespaces?

  * Need further experiments.

* Should PyImath be a separate repo, or a submodule of Imath?

  * Owen configured PyImath as a submodule of Imath, but Cary
    suggested we actually want the opposite: Imath makes no mention of
    PyImath.
  
  * Cary: the goal is simplicity and reliability of the build process,
    especially for the default build behavior. Someone wanting the
    basic c++ library, and possibly not having much technical
    experience, should not get tripped up because of python or boost
    configuration on their machines.

  * Kimball: I've always had trouble getting git submodule's to work,
    they've tended to get out of sync.

  * Larry: OpenVDB is eager for Imath but doesn't want PyImath, so
    maybe there is merit in Imath w/o python bindings.

  * Peter: The current cmake configuration tries to build the
    bindings, but if it can’t, it doesn't, so there shouldn't be a
    problem.
  
  * Cary: Don't underestimate the amount of work to reimplement the
    imath FixedArray bindings, it's more complex that it seems.
    Nick mentioned issue #367, regarding python buffer protocols.

  * Conclusion: move PyImath to a subfolder of Imath. The same repo,
    but not built by default. The cmake configuation is completely
    indepedent, and disconnected. "If you want the python bindings, cd
    to PyImath and run cmake." This satisfies both goals: simple and
    reliable, but a single repo.
    
* Discussion of issue #765, leaks on static initialization. Resolved
  in 2.5, but the problem was errant c++ version #if's. It's time to
  remove all that stuff. Just remove all conditionals related to old
  c++ versions, and put them back in only where they're absolutely
  necessary. We may need to make a distinction between c++14 and 17
  for certain constexpr constructions.

* Update on the Disney CLA logjam, which came to a head with OSL, due
  to Pixar's involvement.  The governing board's legal group met to
  discuss the various iterations of the proposed CLA's and may be
  close to a decision but nothing is final yet.
  
