/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;


/***
 * This Class is a set of two values 
 * @param <L> left value
 * @param <R> right value
 */
public class Pair<L,R> {

	private L left;
	private R right;
	
	
	/***
	 * Instantiate this class
	 * @param left left value
	 * @param right right value
	 */
	public Pair(L left, R right)
	{
		this.left = left;
		this.right = right;
	}
	
	/***
	 * set the left value to left
	 * @param left value the left-value is set to
	 */
	public void setLeft(L left)
	{
		this.left = left;
	}
	
	/***
	 * set the right value to right
	 * @param right value the right value is set to
	 */	
	public void setRight(R right)
	{
		this.right = right;
	}
	
	/***
	 * get the left value
	 */
	public L getLeft()
	{
		return left;
	}
	
	/***
	 * get the right value 
	 */
	public R getRight()
	{
		return right;
	}
	
}
