# Installing pandoc

## Windows

  - There is a package installer at pandoc's [download page].

  - For PDF output, you'll also need to install LaTeX.
    We recommend [MiKTeX](http://miktex.org/).

  - If you'd prefer, you can extract the pandoc and pandoc-citeproc
    executables from the MSI and copy them directly to any directory,
    without running the installer.  Here is an example showing how to
    extract the executables from the pandoc-1.19.1 installer and copy
    them to `C:\Utils\Console\`:

        mkdir "%TEMP%\pandoc\"
        start /wait msiexec.exe /a pandoc-1.19.1-windows.msi /qn targetdir="%TEMP%\pandoc\"
        copy /y "%TEMP%\pandoc\pandoc.exe" C:\Utils\Console\
        copy /y "%TEMP%\pandoc\pandoc-citeproc.exe" C:\Utils\Console\
        rmdir /s /q "%TEMP%\pandoc\"

## Mac OS X

  - There is a package installer at pandoc's [download page].
    If you later want to uninstall the package, you can do so
    by downloading [this script][uninstaller]
    and running it with `perl uninstall-pandoc.pl`.

  - It is possible to extract the pandoc and pandoc-citeproc
    executables from the osx pkg file, if you'd rather not run
    the installer.  To do this (for the version 1.19.1 package):

        mkdir pandoc-extract
        cd pandoc-extract
        xar -x ../pandoc-1.19.1-osx.pkg
        cat pandoc.pkg/Payload | gunzip -dc | cpio -i
        # executables are now in ./usr/bin/, man pages in ./usr/share/man

  - You can also install pandoc using
    [homebrew](http://brew.sh): `brew install pandoc`.

  - For PDF output, you'll also need LaTeX.  Because a full [MacTeX]
    installation takes more than a gigabyte of disk space, we recommend
    installing [BasicTeX](http://www.tug.org/mactex/morepackages.html)
    (64M) and using the `tlmgr` tool to install additional packages
    as needed.  If you get errors warning of fonts not found, try

        tlmgr install collection-fontsrecommended

## Linux

  - First, try your package manager.
    Pandoc is in the [Debian], [Ubuntu], [Slackware],
    [Arch], [Fedora], [NiXOS], [openSUSE], and [gentoo] repositories.
    Note, however, that versions in the repositories are often
    old.

  - For 64-bit [Debian] and [Ubuntu], we provide a debian package
    on the [download page].

        sudo dpkg -i $DEB

    where `$DEB` is the path to the downloaded deb, will
    install the `pandoc` and `pandoc-citeproc` executables
    and man pages.  If you use an RPM-based distro, you may be
    able to install this deb using `alien`, or try

        ar p $DEB data.tar.gz | sudo tar xvz --strip-components 2 -C /usr/local

  - If you'd rather install pandoc in your home directory, say
    in `$HOME/.local`, then you can extract the files manually
    from the deb:

        ar p $DEB data.tar.gz | tar xvz --strip-components 2 -C $HOME/.local/

    where, again, `$DEB` is the path to the downloaded deb.

  - If the version in your repository is too old and you cannot
    use the deb we provide, you can install from source, using the
    instructions below under [Compiling from source].
    Note that most distros have the Haskell platform in their
    package repositories.  For example, on Debian/Ubuntu,
    you can install it with `apt-get install haskell-platform`.

  - For PDF output, you'll need LaTeX.  We recommend installing
    [TeX Live](http://www.tug.org/texlive/) via your package
    manager.  (On Debian/Ubuntu, `apt-get install texlive`.)

## BSD

  - Pandoc is in the [NetBSD] and [FreeBSD ports] repositories.

## Compiling from source

If for some reason a binary package is not available for your
platform, or if you want to hack on pandoc or use a non-released
version, you can install from source.

### Getting the pandoc source code

Source tarballs can be found at
<https://hackage.haskell.org/package/pandoc>.  For example, to
fetch the source for version 1.17.0.3:

    wget https://hackage.haskell.org/package/pandoc-1.17.0.3/pandoc-1.17.0.3.tar.gz
    tar xvzf pandoc-1.17.0.3.tar.gz
    cd pandoc-1.17.0.3

Or you can fetch the development code by cloning the repository:

    git clone https://github.com/jgm/pandoc
    cd pandoc
    git submodule update --init   # to fetch the templates

Note:  there may be times when the development code is broken
or depends on other libraries which must be installed
separately.  Unless you really know what you're doing, install
the last released version.

### Quick stack method

The easiest way to build pandoc from source is to use [stack]:

1.  Install [stack].

2.  Change to the pandoc source directory and issue the following commands:

        stack setup
        stack install --test

    `stack setup` will automatically download the ghc compiler
    if you don't have it.  `stack install` will install the
    `pandoc` executable into `~/.local/bin`, which you should
    add to your `PATH`.  This process will take a while, and
    will consume a considerable amount of disk space.

### Quick cabal method

1.  Install the [Haskell platform].  This will give you [GHC] and
    the [cabal-install] build tool.  Note that pandoc requires
    GHC >= 7.8.

2.  Update your package database:

        cabal update

3.  Use `cabal` to install pandoc and its dependencies:

        cabal install pandoc --enable-tests

    This procedure will install the released version of pandoc,
    which will be downloaded automatically from HackageDB.

    If you want to install a modified or development version
    of pandoc instead, switch to the source directory and do
    as above, but without the 'pandoc':

        cabal install

    Note: If you obtained the source from the git repository (rather
    than a release tarball), you'll need to do

        git submodule update --init

    to fetch the contents of `data/templates` before `cabal install`.

4.  Make sure the `$CABALDIR/bin` directory is in your path.  You should
    now be able to run `pandoc`:

        pandoc --help

    [Not sure where `$CABALDIR` is?](http://www.haskell.org/haskellwiki/Cabal-Install#The_cabal-install_configuration_file)

5.  If you want to process citations with pandoc, you will also need to
    install a separate package, `pandoc-citeproc`.  This can be installed
    using cabal:

        cabal install pandoc-citeproc

    By default `pandoc-citeproc` uses the "i;unicode-casemap" method
    to sort bibliography entries (RFC 5051).  If you would like to
    use the locale-sensitive unicode collation algorithm instead,
    specify the `unicode_collation` flag:

        cabal install pandoc-citeproc -funicode_collation

    Note that this requires the `text-icu` library, which in turn
    depends on the C library `icu4c`.  Installation directions
    vary by platform.  Here is how it might work on OSX with homebrew:

        brew install icu4c
        cabal install --extra-lib-dirs=/usr/local/Cellar/icu4c/51.1/lib \
          --extra-include-dirs=/usr/local/Cellar/icu4c/51.1/include \
          -funicode_collation text-icu pandoc-citeproc

6.  The `pandoc.1` man page will be installed automatically.  cabal shows
    you where it is installed: you may need to set your `MANPATH`
    accordingly. If `MANUAL.txt` has been modified, the man page can be
    rebuilt: `make man/pandoc.1`.

    The `pandoc-citeproc.1` man page will also be installed automatically.


### Custom cabal method

This is a step-by-step procedure that offers maximal control
over the build and installation.  Most users should use the
quick install, but this information may be of use to packagers.
For more details, see the [Cabal User's Guide].  These instructions
assume that the pandoc source directory is your working directory.

1.  Install dependencies:  in addition to the [Haskell platform],
    you will need a number of additional libraries.  You can install
    them all with

        cabal update
        cabal install --only-dependencies

2.  Configure:

        cabal configure --prefix=DIR --bindir=DIR --libdir=DIR \
          --datadir=DIR --libsubdir=DIR --datasubdir=DIR --docdir=DIR \
          --htmldir=DIR --program-prefix=PREFIX --program-suffix=SUFFIX \
          --mandir=DIR --flags=FLAGSPEC --enable-tests

    All of the options have sensible defaults that can be overridden
    as needed.

    `FLAGSPEC` is a list of Cabal configuration flags, optionally
    preceded by a `-` (to force the flag to `false`), and separated
    by spaces.  Pandoc's flags include:

    - `embed_data_files`: embed all data files into the binary (default no).
      This is helpful if you want to create a relocatable binary.
      Note:  if this option is selected, you need to install the
      `hsb2hs` preprocessor: `cabal install hsb2hs` (version 0.3.1 or
      higher is required).

    - `https`:  enable support for downloading resources over https
      (using the `http-client` and `http-client-tls` libraries).

3.  Build:

        cabal build
        cabal test

4.  Build API documentation:

        cabal haddock --html-location=URL --hyperlink-source

5.  Copy the files:

        cabal copy --destdir=PATH

    The default destdir is `/`.

6.  Register pandoc as a GHC package:

        cabal register

    Package managers may want to use the `--gen-script` option to
    generate a script that can be run to register the package at
    install time.

### Creating a relocatable binary

It is possible to compile pandoc such that the data files
pandoc uses are embedded in the binary.  The resulting binary
can be run from any directory and is completely self-contained.
With cabal, add `-fembed_data_files` to the `cabal configure`
or `cabal install` commands.

With stack, use `--flag pandoc:embed_data_files`.



### Running tests

Pandoc comes with an automated test suite.
To run with cabal, `cabal test`; to run with stack, `stack
test`.

To run particular tests (pattern-matching on their names), use
the `-t` option:

    cabal test --test-options='-t markdown'

If you add a new feature to pandoc, please add tests as well, following
the pattern of the existing tests. The test suite code is in
`tests/test-pandoc.hs`. If you are adding a new reader or writer, it is
probably easiest to add some data files to the `tests` directory, and
modify `tests/Tests/Old.hs`. Otherwise, it is better to modify the module
under the `tests/Tests` hierarchy corresponding to the pandoc module you
are changing.

### Running benchmarks

To build and run the benchmarks:

    cabal configure --enable-benchmarks && cabal build
    cabal bench

or with stack:

    stack bench

To use a smaller sample size so the benchmarks run faster:

    cabal bench --benchmark-options='-s 20'

To run just the markdown benchmarks:

    cabal bench --benchmark-options='markdown'

### Building the whole pandoc ecosystem

Sometimes pandoc's development code depends on unreleased versions
of dependent libraries.  You'll need to build these as well.  A
maximal build method would be

    mkdir pandoc-build
    cd pandoc-build
    git clone https://github.com/jgm/pandoc-types
    git clone https://github.com/jgm/texmath
    git clone https://github.com/jgm/pandoc-citeproc
    git clone https://github.com/jgm/pandoc
    git clone https://github.com/jgm/cmark-hs
    git clone https://github.com/jgm/zip-archive
    cd pandoc
    git submodule update --init
    stack install --test --install-ghc --stack-yaml stack.full.yaml

To pull in the latest changes, after you've done this and there have been
changes in the repositories:  Visit each repository in pandoc-build
(pandoc-types, texmath, pandoc-citeproc, pandoc, zip-archive, cmark-hs) and do
`git pull`.  In the pandoc repo, also do `git submodule update` and `stack
install --test --stack-yaml stack.full.yaml`.


[Arch]: https://www.archlinux.org/packages/community/x86_64/pandoc/
[Cabal User's Guide]: http://www.haskell.org/cabal/release/latest/doc/users-guide/builders.html#setup-configure-paths
[Debian]: http://packages.debian.org/lenny/pandoc
[Fedora]: https://apps.fedoraproject.org/packages/pandoc
[FreeBSD ports]: http://www.freshports.org/textproc/pandoc/
[GHC]:  http://www.haskell.org/ghc/
[GPL]:  http://www.gnu.org/copyleft/gpl.html
[Haskell platform]: http://hackage.haskell.org/platform/
[MacPorts]: http://trac.macports.org/browser/trunk/dports/textproc/pandoc/Portfile
[MacTeX]: https://tug.org/mactex/
[NetBSD]: http://pkgsrc.se/wip/pandoc
[NixOS]: http://nixos.org/nixos/
[Slackware]: http://www.linuxpackages.net/search_view.php?by=name&name=pandoc&ver=
[Ubuntu]: http://www.ubuntu.com
[download page]: https://github.com/jgm/pandoc/releases/latest
[gentoo]: http://packages.gentoo.org/package/app-text/pandoc
[haskell repository]: https://wiki.archlinux.org/index.php/Haskell_Package_Guidelines#.5Bhaskell.5D
[openSUSE]: https://software.opensuse.org/package/pandoc
[source tarball]: http://hackage.haskell.org/package/pandoc
[stack]: http://docs.haskellstack.org/en/stable/install_and_upgrade.html
[cabal-install]: http://hackage.haskell.org/trac/hackage/wiki/CabalInstall
[uninstaller]: https://raw.githubusercontent.com/jgm/pandoc/master/osx/uninstall-pandoc.pl
