/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __SORTIE__
#define __SORTIE__

#include <src/global/global.h>

typedef struct sortie CONTENEUR(Sortie);

#include <src/donnees/general/general.h>
#include <src/donnees/environnement/environnement.h>
#include <src/donnees/environnement/options/options.h>
#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/flux/processusflux.h>
#include <src/donnees/commandes/actioncommande.h>
#include <src/messages/messages/sources/messageparametres.h>
#include <src/messages/messages/sources/messages.h>
#include <src/problemes/probleme/probleme.h>
#include <src/problemes/verbeux/verbeux.h>
#include <src/donnees/commandes/commande.h>
#include <src/donnees/commandes/commandecommentaire.h>
#include <src/donnees/commandes/commandedefine.h>
#include <src/donnees/commandes/commandedep.h>
#include <src/donnees/commandes/commandedepref.h>
#include <src/donnees/commandes/commandeechappement.h>
#include <src/donnees/commandes/commandeerror.h>
#include <src/donnees/commandes/commandeextref.h>
#include <src/donnees/commandes/commandeextrefs.h>
#include <src/donnees/commandes/commandefoot.h>
#include <src/donnees/commandes/commandegeneric.h>
#include <src/donnees/commandes/commandehead.h>
#include <src/donnees/commandes/commandeidea.h>
#include <src/donnees/commandes/commandeinclude.h>
#include <src/donnees/commandes/commandeindex.h>
#include <src/donnees/commandes/commandemacro.h>
#include <src/donnees/commandes/commandemesg.h>
#include <src/donnees/commandes/commandemessage.h>
#include <src/donnees/commandes/commandemissing.h>
#include <src/donnees/commandes/commandeoption.h>
#include <src/donnees/commandes/commandeoptions.h>
#include <src/donnees/commandes/commandeparametre.h>
#include <src/donnees/commandes/commandereference.h>
#include <src/donnees/commandes/commanderef.h>
#include <src/donnees/commandes/commandesec.h>
#include <src/donnees/commandes/commandesection.h>
#include <src/donnees/commandes/commandestandard.h>
#include <src/donnees/commandes/commandestart.h>
#include <src/donnees/commandes/commandetexte.h>
#include <src/donnees/commandes/commandetitle.h>
#include <src/donnees/commandes/commandetxt.h>
#include <src/donnees/commandes/commandewarning.h>
#include <src/donnees/commandes/localisationfichier.h>

#include <src/donnees/sortie/arbreidees.h>
#include <src/donnees/sortie/denominationidee.h>
#include <src/donnees/sortie/referencesidee.h>
#include <src/donnees/styles/styles.h>
#include <src/donnees/idees/idees.h>

struct sortie
{
	STOCKAGE(ActionFlux) actiongenerationsortie;
	//Action de flux servant  gnrer le
	//document.
	STOCKAGE_SCALAIRE(Chaine) erreur;
	//Message d'erreur.
	STOCKAGE(Flux) message;
	//Flux contenant un message  transmettre
	//dans le document.
	STOCKAGE_SCALAIRE(Chaine) ideeindice;
	//Chaine reprsentant l'indice de l'ide
	//automatique en cours de parcours.
	STOCKAGE(Flux) ideereference;
	//Flux dcrivant la rfrence de l'ide parcourue.
	STOCKAGE(Flux) ideetitre;
	//Flux reprsentant le titre de l'ide parcourue.
	STOCKAGE(Flux) ideetexte;
	//Flux reprsentant le texte de l'ide parcourue.
	STOCKAGE_SCALAIRE(TypeIdee) typeidee;
	//Type de l'ide parcourue
	STOCKAGE(ReferencesIdee) ideereferencesidee;
	//Structure de rfrence de l'ide parcourue.
	STOCKAGE_SCALAIRE(Chaine) referenceindice;
	//Chaine reprsentant l'indice de l'ide
	//automatique destination de la rfrence.
	STOCKAGE(Flux) referencereference;
	//Flux dcrivant la rfrence de l'ide destination
	//de la rfrence.
	STOCKAGE_SCALAIRE(Chaine) referencereferencechaine;
	//Chaine reprsentant la rfrence, pour les messages
	//d'erreur.
	STOCKAGE(Flux) referencetitre;
	//Flux reprsentant le titre de l'ide destination
	//de la rfrence.
	STOCKAGE_SCALAIRE(Chaine) referencesection;
	//Chaine reprsentant le nom du niveau de la section
	//de l'ide destination de la rfrence.
	STOCKAGE_SCALAIRE(NiveauHierarchique) niveaureferencesection;
	//Niveau correspondant au nom de la section de l'ide
	//destination de la rfrence.
};
/* Structure utilise pour gnrer le document.
 * Les divers champs de cette structure seront
 * directement utiliss en interne.
 */

Resultat sortie_initialisation(TRAVAIL(Sortie) sortie);
/* Cre une structure de gnration du document.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat sortie_sortie(TRAVAIL(General) general);
/* Gnre la sortie  partir des informations
 * contenues dans general.
 */

Resultat sortie_copie(TRAVAIL(Sortie) sortie , TRAVAIL(Sortie) copie);
/* Ralise une copie d'une structure de gnration du
 * document.
 * Renvoie RESULTAT_ERREUR si sortie est NULL.
 * Si *copie est non NULL, la copie est dtruite.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation
 * choue.
 */

Resultat sortie_destruction(TRAVAIL(Sortie) sortie);
/* Dtruit une structure de gnration du document.
 */

#endif
