/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#include <QGridLayout>
#include <QGroupBox>
#include <QLabel>

#include <KComboBox>
#include <KLineEdit>
#include <KLocale>

#include "coordinatedialog.h"

static QString s_expression;

CoordinateDialog::CoordinateDialog( QWidget *p_parent )
: LocationDialog( p_parent )
, m_longitude_valid( false )
, m_latitude_valid( false )
, m_latitude( 0.0 )
, m_longitude( 0.0 )
{
  // used to check the validity of the input
  s_expression = "^[0-9]+([." + KGlobal::locale()->decimalSymbol() + "][0-9]+)?$";

  QGroupBox *group = new QGroupBox( i18n("Select a location:" ), this );
  QGridLayout *layout = new QGridLayout( group );

  QLabel *label = new QLabel( i18n( "Longitude:" ), this );
  m_longitudeEdit = new KLineEdit( this );
  label->setBuddy( m_longitudeEdit );
  connect( m_longitudeEdit, SIGNAL( textEdited( const QString & ) ), SLOT( longitudeChanged( const QString & ) ) ); 

  layout->addWidget( label, 0, 0 );
  layout->addWidget( m_longitudeEdit, 0, 1 );

  label = new QLabel( i18n( "Latitude:" ), this );
  m_latitudeEdit = new KLineEdit( this );
  label->setBuddy( m_latitudeEdit );
  connect( m_latitudeEdit, SIGNAL( textEdited( const QString & ) ), SLOT( latitudeChanged( const QString & ) ) );

  layout->addWidget( label, 1, 0 );
  layout->addWidget( m_latitudeEdit, 1, 1 );

  label = new QLabel( i18n( "Accuracy:" ), this );
  label->setBuddy( m_accuracyCombo );
  layout->addWidget( label, 2, 0 );
  layout->addWidget( m_accuracyCombo, 2, 1 );

  setMainWidget( group );
  setButtons( KDialog::Ok | KDialog::Cancel );
  setOkButton();
}

CoordinateDialog::~CoordinateDialog()
{
}

qreal CoordinateDialog::getLatitude() const
{
  return m_latitude;
}

qreal CoordinateDialog::getLongitude() const
{
  return m_longitude;
}

void CoordinateDialog::setLongitude( qreal p_longitude )
{
  m_longitude = p_longitude;
  m_longitude_valid = true;
  m_longitudeEdit->setText( QString::number( p_longitude ) );
  setOkButton();
}

void CoordinateDialog::setLatitude( qreal p_latitude )
{
  m_latitude = p_latitude;
  m_latitude_valid = true;
  m_latitudeEdit->setText( QString::number( p_latitude ) );
  setOkButton();
}

void CoordinateDialog::setOkButton()
{
  enableButtonOk( m_longitude_valid && m_latitude_valid );
}

void CoordinateDialog::longitudeChanged( const QString &p_longitude )
{
  m_longitude_valid = p_longitude.contains( QRegExp( s_expression ) );
  if ( m_longitude_valid )
  {
    m_longitude = p_longitude.toDouble();
  }
  setOkButton();
}

void CoordinateDialog::latitudeChanged( const QString &p_latitude )
{
  m_latitude_valid = p_latitude.contains( QRegExp( s_expression ) );
  if ( m_latitude_valid )
  {
    m_latitude = p_latitude.toDouble();
  }
  setOkButton();
}

