/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) Andrew Howard 2003
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/***************************************************************************
 * Desc: Tests for the motor device
 * Author: Andrew Howard
 * Date: 23 May 2002
 # CVS: $Id: test_motor.c 8106 2009-07-23 19:14:37Z thjc $
 **************************************************************************/

#include "test.h"
#include "playerc.h"


// Basic test for motor device.
int test_motor(playerc_client_t *client, int index)
{
  int t;
  void *rdevice;
  playerc_motor_t *device;

  printf("device [motor] index [%d]\n", index);

  device = playerc_motor_create(client, index);

  TEST("subscribing (read/write)");
  if (playerc_motor_subscribe(device, PLAYER_ALL_MODE) < 0)
  {
    FAIL();
    return -1;
  }
  PASS();

  for (t = 0; t < 30; t++)
  {
    TEST1("reading data (attempt %d)", t);

    do
      rdevice = playerc_client_read(client);
    while (rdevice == client);

    if (rdevice == device)
    {
      PASS();
      printf("motor: [%14.3f] [%6.3f] [%6.3f] [%d]\n",
             device->info.datatime, device->pt, device->vt, device->stall);
    }
    else
    {
      //printf("error: %s", playerc_error_str());
      FAIL();
      break;
    }
  }
  
  TEST("unsubscribing");
  if (playerc_motor_unsubscribe(device) != 0)
  {
    FAIL();
    return -1;
  }
  PASS();
  
  playerc_motor_destroy(device);
  
  return 0;
}

