# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxPhotoProperties;
use strict;
use Wx qw/
             wxDefaultSize
             wxDefaultPosition
             wxTAB_TRAVERSAL 
             wxID_CANCEL
             wxID_OK
             wxGREEN
         /;
use base qw/Wx::Panel Uploader::GUI::DlgCommon/;
use Wx::Event qw/
                    EVT_BUTTON
                    EVT_CLOSE
                /;
use Wx::Locale qw/:default/;
use Carp;
use Data::Dumper;

sub new {
    my ($this, $params) = @_;
    #on recupere le nom de la classe en fonction du type d'appel de la mthode.
    my $class = ref($this) || $this;


    my $self = $class->SUPER::new( $params->{parentwnd}, -1, wxDefaultPosition, [-1, -1], wxTAB_TRAVERSAL );
    # load controls
    &main::PhotoPropertiesCategoriesTags( $self, $params->{categories} );

    $self->_initNotebook($params->{tags});


    $self->properties(
        $params->{properties}
    );

    $self->InitLabels();
    $self->InitChoices();
    $self->SetProperties();
    $self->InitHandler();
    $self->_initEventHandlers();

    if($@){
        Wx::LogMessage("Error during dialogbox initialization");
    }


    $self;    
}



sub _initEventHandlers {
    my ( $self ) = @_;
    
    EVT_BUTTON( $self, $main::ID_REUPLOAD_OK, \&OnOK );
    EVT_CLOSE( $self, \&OnClose );
    
}


sub _initNotebook{
    my ( $self, $tags ) = @_;

    my $nb = $self->FindWindow(
        $main::PHOTO_PROPERTIES_NB
    );

    my( $page1 ) = Wx::Panel->new( $nb, -1 );
    &main::photo_properties_caption_comments( $page1, 0 );
    $nb->AddPage( $page1, "Photo informations" );

    my( $page2 ) = Wx::Panel->new( $nb, -1 );
    &main::photo_properties_tags( $page2, $tags );
    $nb->AddPage( $page2, "Tags" );

    $self->{notebook} = $nb;

}


sub OnOK {
    my ( $self, $event ) = @_;
    
    $self->_close;
}

sub OnClose {
    my ( $self, $event ) = @_;
	
	$self->_close;
}

sub _close {
    my ( $self ) = @_;

    $self->GetProperties();

    $self->Destroy;
}


sub SetEnabled {
    my ( $self ) = @_;

    $self->{_properties_notebook}->Enable(1);
}

sub SetDisabled {
    my ( $self ) = @_;

    $self->{_properties_notebook}->Enable(0);
}

sub IsEnabled {
    my ( $self ) = @_;

    $self->{_properties_notebook}->IsEnabled;
}


sub SetMultiSelectionMode {
    my ( $self, $count ) = @_;

    $self->{_multi_selection_mode_panel}{_text1}->SetLabel(
        sprintf(gettext("You have selected a batch of %s photos"), $count )
    );

    $self->{_multi_selection_mode_panel}{_text2}->SetLabel(
        gettext("Changes apply to the whole batch")
    );

    $self->{_multi_selection_mode_panel}->Show(1);
    $self->Layout;
}


sub SetSingleSelectionMode {
    my ( $self ) = @_;

    $self->{_multi_selection_mode_panel}->Show(0);
    $self->Layout;
}
1;