# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`gitolite`](#gitolite): This class is inherited by setup.pp and admin.pp  It's intention is to have alle the config parameters.  If you only use this class (and the 
* [`gitolite::admin`](#gitolite--admin): This class manages the gitolite.conf file and prepares to manage the ssh keys with puppet.  do not use this class if you want to use the gito
* [`gitolite::client`](#gitolite--client): Class to install git
* [`gitolite::ssh_key`](#gitolite--ssh_key): Generate an SSH authentication key  Key generation for (passwordless) authentication to a remote system.

### Defined types

* [`gitolite::repo`](#gitolite--repo): this resources define a git repository you also can use them to define values for a group of repositories (by using an @ in front of the grou
* [`gitolite::repos`](#gitolite--repos): this resource defines a group of repos with defaults
* [`gitolite::user`](#gitolite--user): this resources defines a git user you also can use it to define values for a group of repositories (by using an @ in front of the group name)
* [`gitolite::users`](#gitolite--users): this resource defines a group of users with defaults

### Resource types

* [`gitremote`](#gitremote): add a remote to a git repository

## Classes

### <a name="gitolite"></a>`gitolite`

This class is inherited by setup.pp and admin.pp

It's intention is to have alle the config parameters.

If you only use this class (and the setup), you can still do all admin work
(manage users, permissions etc. throug the git repository
gitolite-admin.git.)

#### Parameters

The following parameters are available in the `gitolite` class:

* [`reporoot`](#-gitolite--reporoot)
* [`user`](#-gitolite--user)
* [`userhome`](#-gitolite--userhome)
* [`user_ensure`](#-gitolite--user_ensure)
* [`umask`](#-gitolite--umask)
* [`git_config_keys`](#-gitolite--git_config_keys)
* [`log_extra`](#-gitolite--log_extra)
* [`log_dest`](#-gitolite--log_dest)
* [`roles`](#-gitolite--roles)
* [`site_info`](#-gitolite--site_info)
* [`gitolite_hostname`](#-gitolite--gitolite_hostname)
* [`local_code`](#-gitolite--local_code)
* [`additional_gitoliterc`](#-gitolite--additional_gitoliterc)
* [`commands`](#-gitolite--commands)
* [`package_ensure`](#-gitolite--package_ensure)
* [`packages`](#-gitolite--packages)
* [`additional_packages`](#-gitolite--additional_packages)
* [`admin_key_source`](#-gitolite--admin_key_source)
* [`admin_key`](#-gitolite--admin_key)
* [`additional_gitoliterc_notrc`](#-gitolite--additional_gitoliterc_notrc)
* [`fetch_cron`](#-gitolite--fetch_cron)

##### <a name="-gitolite--reporoot"></a>`reporoot`

Data type: `String`

path to the directory where you will store the repositories.
This does not have to be equal to the $users home directory.
defaults to $userhome

Default value: `"${userhome}/repositories"`

##### <a name="-gitolite--user"></a>`user`

Data type: `String`

the user to host the git repositories
this user needs a home directory to work with gitolite.

##### <a name="-gitolite--userhome"></a>`userhome`

Data type: `String`

the home directory of the user

##### <a name="-gitolite--user_ensure"></a>`user_ensure`

Data type: `Boolean`

if true, $user will be created, if false, you have
to create the user with the homedirectory elsewhere.
defaults to true

Default value: `true`

##### <a name="-gitolite--umask"></a>`umask`

Data type: `String`

see the rc file docs for how/why you might change this
defaults to '0077' which gives perms of '0700'

Default value: `'0077'`

##### <a name="-gitolite--git_config_keys"></a>`git_config_keys`

Data type: `String`

look for "git-config" in the documentation
default: '.*'

Default value: `'.*'`

##### <a name="-gitolite--log_extra"></a>`log_extra`

Data type: `Boolean`

set to true for extra log details
default: false

Default value: `false`

##### <a name="-gitolite--log_dest"></a>`log_dest`

Data type: `Array`

array of log destinations.
available values are:
  normal: normal gitolite logs
  syslog: log to syslog
  repo-log: log just the update records to
            gl-log in the bare repo directory
defaults to ['normal']

Default value: `['normal']`

##### <a name="-gitolite--roles"></a>`roles`

Data type: `Array`

Array of roles to add.
default: ['READERS', 'WRITERS']

Default value: `['READERS', 'WRITERS']`

##### <a name="-gitolite--site_info"></a>`site_info`

Data type: `Boolean`

the 'info' command prints this as additional info
default to false

Default value: `false`

##### <a name="-gitolite--gitolite_hostname"></a>`gitolite_hostname`

Data type: `String`

the hostname, to unset, set to false
defaults to $::hostname

Default value: `$facts['networking']['hostname']`

##### <a name="-gitolite--local_code"></a>`local_code`

Data type: `Optional[String[1]]`

suggested locations for site-local gitolite code
defaults to undef, no site-local code

Default value: `undef`

##### <a name="-gitolite--additional_gitoliterc"></a>`additional_gitoliterc`

Data type: `Hash`

hash of additional lines to add on gitolite.rc file
defaults to empty (beware of "' etc ...)
example:
{ 'CACHE' => '"Redis"' }

Default value: `{}`

##### <a name="-gitolite--commands"></a>`commands`

Data type: `Array`

Array of commands and features to enable
defaults to ['help', 'desc', 'info', 'perms' ]

Default value:

```puppet
[
    'help',
    'desc',
    'info',
    'perms',
    'writable',
    'ssh-authkeys',
    'git-config',
    'daemon',
    'gitweb',
  ]
```

##### <a name="-gitolite--package_ensure"></a>`package_ensure`

Data type: `String`

howto ensure the packages to install

Default value: `'present'`

##### <a name="-gitolite--packages"></a>`packages`

Data type: `Array`

packages to install for gitolite

Default value: `[]`

##### <a name="-gitolite--additional_packages"></a>`additional_packages`

Data type: `Array`

any additional packages you like to install

Default value: `[]`

##### <a name="-gitolite--admin_key_source"></a>`admin_key_source`

Data type: `Optional[String[1]]`

provide a admin key source (default undef)

Default value: `undef`

##### <a name="-gitolite--admin_key"></a>`admin_key`

Data type: `Optional[String[1]]`

admin key (string) (default undef)

Default value: `undef`

##### <a name="-gitolite--additional_gitoliterc_notrc"></a>`additional_gitoliterc_notrc`

Data type: `Hash`

hash of additional lines to add on gitolite.rc file
after the rc vars
defaults to empty (beware of "' etc ...)
example:
{ '$REF_OR_FILENAME_PATT' => 'qr(^[0-9a-zA-Z][-0-9a-zA-Z._\@/+ :%,]*$)' }

Default value: `{}`

##### <a name="-gitolite--fetch_cron"></a>`fetch_cron`

Data type: `Boolean`

if a cronjob should be established to fetch from remote repos
defaults to false

Default value: `false`

### <a name="gitolite--admin"></a>`gitolite::admin`

This class manages the gitolite.conf file
and prepares to manage the ssh keys with puppet.

do not use this class if you want to use the
gitolite-admin.git repositoy for these tasks.
(you have been warned ! if you use it once,
there is no puppet way back, only manual work
will get you back)

#### Parameters

The following parameters are available in the `gitolite::admin` class:

* [`remove_admin_repo`](#-gitolite--admin--remove_admin_repo)
* [`repos`](#-gitolite--admin--repos)
* [`users`](#-gitolite--admin--users)
* [`add_testing_repo`](#-gitolite--admin--add_testing_repo)

##### <a name="-gitolite--admin--remove_admin_repo"></a>`remove_admin_repo`

Data type: `Boolean`

if true (the default) the repository
gitoline_admin.git will be removed

Default value: `true`

##### <a name="-gitolite--admin--repos"></a>`repos`

Data type: `Hash`

a hash of repos, to be defined

Default value: `{}`

##### <a name="-gitolite--admin--users"></a>`users`

Data type: `Hash`

a hash of users, to be defined

Default value: `{}`

##### <a name="-gitolite--admin--add_testing_repo"></a>`add_testing_repo`

Data type: `Boolean`

allow RW+ for all users to the testing repo
default: true

Default value: `true`

### <a name="gitolite--client"></a>`gitolite::client`

Class to install git

### <a name="gitolite--ssh_key"></a>`gitolite::ssh_key`

Generate an SSH authentication key

Key generation for (passwordless) authentication to a
remote system.

#### Parameters

The following parameters are available in the `gitolite::ssh_key` class:

* [`filename`](#-gitolite--ssh_key--filename)
* [`type`](#-gitolite--ssh_key--type)
* [`length`](#-gitolite--ssh_key--length)
* [`password`](#-gitolite--ssh_key--password)
* [`comment`](#-gitolite--ssh_key--comment)
* [`user`](#-gitolite--ssh_key--user)

##### <a name="-gitolite--ssh_key--filename"></a>`filename`

Data type: `String`

Filename (full path) for the key. Required.

##### <a name="-gitolite--ssh_key--type"></a>`type`

Data type: `String`

Type of key, either dsa, ecdsa or rsa. Defaults to rsa.

Default value: `'rsa'`

##### <a name="-gitolite--ssh_key--length"></a>`length`

Data type: `Integer`

Key length. Defaults to 2048. See man ssh-keygen for restrictions
regarding non RSA keys.

Default value: `2048`

##### <a name="-gitolite--ssh_key--password"></a>`password`

Data type: `String`

Password for the key. Defaults to no password. This is not very secure
as the password is visible in plain text in the puppet manifest and as a
process parameters when creating the key.

Default value: `''`

##### <a name="-gitolite--ssh_key--comment"></a>`comment`

Data type: `Optional[String[1]]`

Comment describing the Key. Defaults to "Automatic authentication key for $user on $fqdn".

Default value: `undef`

##### <a name="-gitolite--ssh_key--user"></a>`user`

Data type: `String`

User who uses this key. This user must have write access to the directory
containing the key. Defaults to "root"

Default value: `'root'`

## Defined types

### <a name="gitolite--repo"></a>`gitolite::repo`

this resources define a git repository
you also can use them to define values for a group of
repositories (by using an @ in front of the group name)

#### Parameters

The following parameters are available in the `gitolite::repo` defined type:

* [`repos`](#-gitolite--repo--repos)
* [`comments`](#-gitolite--repo--comments)
* [`rules`](#-gitolite--repo--rules)
* [`options`](#-gitolite--repo--options)
* [`configs`](#-gitolite--repo--configs)
* [`add_configs`](#-gitolite--repo--add_configs)
* [`groups`](#-gitolite--repo--groups)
* [`order`](#-gitolite--repo--order)
* [`description`](#-gitolite--repo--description)
* [`hooks`](#-gitolite--repo--hooks)
* [`group`](#-gitolite--repo--group)
* [`remotes`](#-gitolite--repo--remotes)
* [`remote_option`](#-gitolite--repo--remote_option)

##### <a name="-gitolite--repo--repos"></a>`repos`

Data type: `Array`

an array of repos (or a group of repos ( @blah )
defaults to [ $title ]

Default value: `[$title]`

##### <a name="-gitolite--repo--comments"></a>`comments`

Data type: `Variant[String, Array]`

an array of comments to add defaults to []

Default value: `[]`

##### <a name="-gitolite--repo--rules"></a>`rules`

Data type: `Hash`

an array of rules.
a rule has three elements:
permission, refex and user/group
a hash of permissions:
[{ 'RW+' => 'username'}, ... ]

Default value: `{}`

##### <a name="-gitolite--repo--options"></a>`options`

Data type: `Hash`



Default value: `{}`

##### <a name="-gitolite--repo--configs"></a>`configs`

Data type: `Hash`



Default value: `{}`

##### <a name="-gitolite--repo--add_configs"></a>`add_configs`

Data type: `Hash`

additional configs, merged with configs

Default value: `{}`

##### <a name="-gitolite--repo--groups"></a>`groups`

Data type: `Array`

an array of groups to append the repos to
the group names can be prefixed with an @ sign
(if they are puppet take care of)

Default value: `[]`

##### <a name="-gitolite--repo--order"></a>`order`

Data type: `String`

string, to order the repos
$order will be prefixed with 60 for the grouping section
and 90 for the repo section.
defaults to ''

Default value: `''`

##### <a name="-gitolite--repo--description"></a>`description`

Data type: `Optional[String[1]]`

a description to add to the repo

Default value: `undef`

##### <a name="-gitolite--repo--hooks"></a>`hooks`

Data type: `Hash`

hooks to install

Default value: `{}`

##### <a name="-gitolite--repo--group"></a>`group`

Data type: `String`



Default value: `'root'`

##### <a name="-gitolite--repo--remotes"></a>`remotes`

Data type: `Hash`

Hash of remote repos to sync branches and tags from
defaults to {}
Example:
'upstream' => {
  'url' => 'https://github.com/openstack/puppet-nova'
  'fetches' => [
    'master:master',
    'refs/tags/*:refs/tags/*',
    'refs/heads/stable/*:refs/heads/stable/*',
  ]
}
will update the master branch, all tags and all branches stable/*
from the remote location mentioned in url.

To remove an upstream you can set ensure to 'absent'
You can set more than one repo to sync from, but it's up to you
to ensure that no conflicts occur !

Default value: `{}`

##### <a name="-gitolite--repo--remote_option"></a>`remote_option`

Data type: `String`

additional options to add when fetching the remotes.
Defaults to '', example add '-v' for verbose output.

Default value: `''`

### <a name="gitolite--repos"></a>`gitolite::repos`

this resource defines a group of repos with defaults

#### Parameters

The following parameters are available in the `gitolite::repos` defined type:

* [`defaults`](#-gitolite--repos--defaults)
* [`repos`](#-gitolite--repos--repos)

##### <a name="-gitolite--repos--defaults"></a>`defaults`

Data type: `Hash`

defaults for all generated repos

Default value: `{}`

##### <a name="-gitolite--repos--repos"></a>`repos`

Data type: `Hash`

repos to create see gitolite::repo for parameters

Default value: `{}`

### <a name="gitolite--user"></a>`gitolite::user`

this resources defines a git user
you also can use it to define values for a group of
repositories (by using an @ in front of the group name)

#### Parameters

The following parameters are available in the `gitolite::user` defined type:

* [`user`](#-gitolite--user--user)
* [`keys`](#-gitolite--user--keys)
* [`key_source`](#-gitolite--user--key_source)
* [`comments`](#-gitolite--user--comments)
* [`groups`](#-gitolite--user--groups)
* [`order`](#-gitolite--user--order)

##### <a name="-gitolite--user--user"></a>`user`

Data type: `String`

the user name
defaults to $title

Default value: `$title`

##### <a name="-gitolite--user--keys"></a>`keys`

Data type: `Array`

array of users ssh keys

Default value: `[]`

##### <a name="-gitolite--user--key_source"></a>`key_source`

Data type: `Optional[String[1]]`

a puppet source to fetch key from

Default value: `undef`

##### <a name="-gitolite--user--comments"></a>`comments`

Data type: `Variant[Array, String]`

an array of comments to add to this section
defaults to []

Default value: `[]`

##### <a name="-gitolite--user--groups"></a>`groups`

Data type: `Array`

an array of groups to append the user to
the group names can be prefix with an @ sign
(if they are puppet take care of)
defaults to []

Default value: `[]`

##### <a name="-gitolite--user--order"></a>`order`

Data type: `String`

string, to order the repos
$order will be prefixed with 30 for the grouping section
and 20 for the user section.
defaults to ''

Default value: `''`

### <a name="gitolite--users"></a>`gitolite::users`

this resource defines a group of users with defaults

#### Parameters

The following parameters are available in the `gitolite::users` defined type:

* [`defaults`](#-gitolite--users--defaults)
* [`users`](#-gitolite--users--users)

##### <a name="-gitolite--users--defaults"></a>`defaults`

Data type: `Hash`

defaults for all generated users

Default value: `{}`

##### <a name="-gitolite--users--users"></a>`users`

Data type: `Hash`

users to create see gitolite::user for parameters

Default value: `{}`

## Resource types

### <a name="gitremote"></a>`gitremote`

add a remote to a git repository

#### Properties

The following properties are available in the `gitremote` type.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

##### `fetches`

Array of fetch definitions

##### `url`

the url of the remote repository

#### Parameters

The following parameters are available in the `gitremote` type.

* [`confowner`](#-gitremote--confowner)
* [`directory`](#-gitremote--directory)
* [`name`](#-gitremote--name)
* [`provider`](#-gitremote--provider)
* [`remotename`](#-gitremote--remotename)

##### <a name="-gitremote--confowner"></a>`confowner`

the the owner of the config file and the user thar will run the git commands

##### <a name="-gitremote--directory"></a>`directory`

the the directory the repository is

##### <a name="-gitremote--name"></a>`name`

namevar

the title

##### <a name="-gitremote--provider"></a>`provider`

The specific backend to use for this `gitremote` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-gitremote--remotename"></a>`remotename`

the name of the remote to create

