 
<html>
<head>
<title>NLO Merging</title>
<link rel="stylesheet" type="text/css" href="pythia.css"/>
<link rel="shortcut icon" href="pythia32.gif"/>
</head>
<body>

<script language=javascript type=text/javascript>
function stopRKey(evt) {
var evt = (evt) ? evt : ((event) ? event : null);
var node = (evt.target) ? evt.target :((evt.srcElement) ? evt.srcElement : null);
if ((evt.keyCode == 13) && (node.type=="text"))
{return false;}
}

document.onkeypress = stopRKey;
</script>
<?php
if($_POST['saved'] == 1) {
if($_POST['filepath'] != "files/") {
echo "<font color='red'>SETTINGS SAVED TO FILE</font><br/><br/>"; }
else {
echo "<font color='red'>NO FILE SELECTED YET.. PLEASE DO SO </font><a href='SaveSettings.php'>HERE</a><br/><br/>"; }
}
?>

<form method='post' action='NLOMerging.php'>
 
<h2>NLO Merging</h2> 
 
Pythia offers two NLO merging approaches. Both of these methods have been 
presented in [<a href="Bibliography.php" target="page">Lon13</a>]. The goal of NLO merging is to extend tree-level 
multi-jet merging methods to next-to-leading order accuracy in QCD, for every 
available jet multiplicity. If for example NLO calculations for Higgs + 0 jet, 
Higgs + 1 jet and Higgs + 2 jets were available, NLO merging allows to 
simultaneously describe 0-, 1- and 2-jet observables with NLO accuracy. 
Further jets can, depending on additional tree-level input, be described by 
additional tree-level matrix elements. In the example, it would be possible to 
achieve NLO accuracy for 0-, 1- and 2-jet observables, tree-level accuracy 
for 3-, 4- and 5-jet configurations, and use the parton shower approximation 
for events with more than five jets. 
 
<p/> The two NLO merging methods implemented in Pythia are called 
NL<sup>3</sup> (for Nils Lavesson + Leif L&ouml;nnblad) and UNLOPS 
(for unitarised 
NLO+PS merging). Both of these schemes require Les Houches Event File input 
that is generated by tree-level or NLO matrix element generators. Currently, 
Pythia requires NLO input generated within the POWHEG framework. The 
generation of sensible input will be discussed below. The two NLO merging 
methods are illustrated in the sample main programs <code>main87.cc</code> 
(introducing NL<sup>3</sup> ) and <code>main88.cc</code> (introducing UNLOPS). 
Before describing these programs, we would like to outline the differences 
between the two approaches. 
 
<p/> NL<sup>3</sup> is a generalisation of <?php $filepath = $_GET["filepath"];
echo "<a href='CKKWLMerging.php?filepath=".$filepath."' target='page'>";?>CKKW-L 
tree-level merging</a>. The main 
idea of NL<sup>3</sup> is to start from CKKW-L-reweighted multi-jet 
merging, and replace the 
<i>&alpha;<sub>s</sub><sup>n+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>n+1</sup></i>-terms by the NLO result of POWHEG. 
This "replacement" means that we subtract the 
<i>&alpha;<sub>s</sub><sup>n+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>n+1</sup></i>-terms from the CKKW-L-reweighted 
tree-level samples, and add another sample -- the POWHEG input. 
All "higher orders" are unchanged w.r.t. CKKW-L. 
We have implemented the 
"inclusive" scheme of [<a href="Bibliography.php" target="page">Lon13</a>] in Pythia. This means that the POWHEG 
input will contain contributions for hard, resolved real emission jets, which 
are already taken care of by higher-multiplicity samples in CKKW-L. Thus, 
explicit phase space subtractions are also included. The sample program 
<code>main87.cc</code>, together with the input file <code>main87.cmnd</code>, 
illustrates the procedure. 
 
<p/> UNLOPS is a generalisation of the 
<?php $filepath = $_GET["filepath"];
echo "<a href='UMEPSMerging.php?filepath=".$filepath."' target='page'>";?>UMEPS multi-jet merging</a> scheme. 
Since UMEPS is already slightly more complicated than 
CKKW-L, this makes UNLOPS more complicated than NL<sup>3</sup>. The basic idea 
however remains the same: Start from a tree-level merging scheme (in this case 
UMEPS), remove all undesirable <i>&alpha;<sub>s</sub><sup>n+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>n+1</sup></i>-terms from this result, and add 
back the "correct" description via POWHEG input samples. Again, since the 
"inclusive" scheme of [<a href="Bibliography.php" target="page">Lon13</a>] was implemented in Pythia, it is 
necessary to handle explicit phase space subtractions. Similar to 
UMEPS, UNLOPS further ensures that the lowest-multiplicity cross section 
is given by the NLO result. This means that the UMEPS philosophy of "subtract 
what you add" needs to be extended to multi-leg NLO inputs. 
 
<p/> UNLOPS is a theoretically more appealing definition of NLO merging than 
NL<sup>3</sup>, and should thus be considered the preferred choice. However, 
we believe it valuable to include both methods into Pythia, so that the 
variation of NLO merged results due to different NLO merging schemes can be 
studied in situ. Furthermore, NLO merging can be outlined more pedagogically 
when starting from NL<sup>3</sup>. The two NLO merging methods share parts of 
code with CKKW-L and UMEPS, and correspondingly share many input settings 
with these schemes. In particular, 
<p/> 
 &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The hard process 
(<code>Merging:Process</code>) needs to be defined 
exactly as in CKKW-L (see <strong>Defining the hard process</strong> in the 
<?php $filepath = $_GET["filepath"];
echo "<a href='CKKWLMerging.php?filepath=".$filepath."' target='page'>";?>CKKW-L documentation</a>). 
<p/> 
 &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The merging scale value 
(<code>Merging:TMS</code>) has to be set. 
<p/> 
 &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; The maximal number of additional partons in 
tree-level events (<code>Merging:nJetMax</code>) has to be set. 
 
<p/> All settings listed under the sections "<strong>Matrix element 
merging and HepMC output for RIVET</strong>" and "<strong>Further 
variables</strong>" in  the <?php $filepath = $_GET["filepath"];
echo "<a href='CKKWLMerging.php?filepath=".$filepath."' target='page'>";?>CKKW-L 
documentation</a> can be accessed in NLO merging as well. Furthermore, 
the <code>Merging:nRecluster</code> switch (see the 
<?php $filepath = $_GET["filepath"];
echo "<a href='UMEPSMerging.php?filepath=".$filepath."' target='page'>";?>UMEPS documentation</a>) is important. 
 
Also, all <code>MergingHooks</code> routines that allow for user 
interference in CKKW-L merging are also usable for NLO merging -- with the 
exception of a user-defined merging scale. The NLO merging schemes currently 
implemented in Pythia do not allow for a merging scale definition that 
differs from the parton shower evolution variable. Since this merging scale 
definition is not completely obvious, the NLO merging schemes also share the 
<code>Merging:enforceCutOnLHE</code> switch with CKKW-L. In this way, it 
is possible to use LHE files that are regularised only with weak cuts as 
input, while the merging machinery imposes the stronger merging scale cut 
automatically. This means that no merging scale implementation is required 
from the user side, but also means that it is the user's responsibility to 
ensure that the cuts used for generating input LHE files are always looser 
than the cut given by the merging scale value <code>Merging:TMS</code>. This 
will lead to warnings of the form "<code>Les Houches Event fails merging scale 
cut. Cut by rejecting event</code>". These warning should rather be regarded 
as information. An example of inclusive matrix element generation cuts would 
be <i>pT<sub>jet</sub> = 5 GeV</i>, <i>&Delta;R<sub>jetA jetB</sub> = 
0.01</i> and <i>Q<sub>jetA jetB</sub> = 5 GeV</i>, if NLO merging with a 
desired merging scale value of <code>Merging:TMS = 15</code> is attempted for 
Higgs + jets events at the LHC. 
 
<p/> In the following, we will first describe the generation of NLO input 
samples, and list input settings for NLO merging in Pythia. Then, we will 
examine the sample main programs <code>main87.cc</code> and 
<code>main88.cc</code>, which implement NL<sup>3</sup> and UNLOPS merging, 
respectively. 
 
<br/><br/><hr/> 
<h3>Inputs for NLO merging</h3> 
 
The NLO merging schemes in Pythia currently require Les Houches Event File 
input. To perform a merging with up to <i>M</i> additional partons described 
by tree-level matrix elements, and with up to <i>N &le; M-1</i> additional 
partons at NLO accuracy, the user needs to supply 
<p/> 
 &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; LHE files for <i>0... M</i> additional 
partons, taken from a tree-level matrix element generator, and 
<p/> 
 &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; LHE files for <i>0... N</i> additional 
partons, taken from a POWHEG NLO generator. 
<p/> All input files need to be regularised, if they contain additional 
partons. Large files with fairly inclusive (i.e. loose) cuts are recommended. 
The input LHE files should further be generated with fixed renormalisation 
and factorisation scales. (In the POWHEG-BOX program, this means using the 
settings <code>runningscales 0, btlscalereal 1, btlscalect 1, 
ckkwscalup 0</code>. Some older processes in the POWHEG-BOX program need the 
input <code>runningscale 0</code> instead of <code>runningscales 0</code>.) 
 
<p/> When attempting NLO merging, the following Pythia settings are relevant. 
 
<br/><br/><table><tr><td><strong>Merging:nJetMaxNLO  </td><td></td><td> <input type="text" name="1" value="0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>0</strong></code>; <code>minimum = 0</code>)</td></tr></table>
The maximal number of additional jets for which NLO event samples are 
supplied by the user. 
   
 
<br/><br/><table><tr><td><strong>Merging:muFac </td><td></td><td> <input type="text" name="2" value="-1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>-1.0</strong></code>)</td></tr></table>
The fixed factorisation scale used in the hard process cross section, 
as needed to 
generate the leading-order weight, in case the factorisation scale cannot 
be inferred from Les Houches event input. (This is the case for files that 
have been generated with the POWHEG-BOX program, since this program prints 
the transverse momentum scale of the real emission into the LH events.). 
If the value is not set, the <code>SCALUP</code> variable of the current LH 
event will be used instead. 
If wimpy showers (see <?php $filepath = $_GET["filepath"];
echo "<a href='TimelikeShowers.php?filepath=".$filepath."' target='page'>";?>Timelike Showers</a> and 
<?php $filepath = $_GET["filepath"];
echo "<a href='SpacelikeShowers.php?filepath=".$filepath."' target='page'>";?>Spacelike Showers</a>) are used together 
with multi-jet merging, then this scale further sets the 
parton shower starting scale (<i>&mu;<sub>Q</sub></i>) for the core hard 
process. 
   
 
<br/><br/><table><tr><td><strong>Merging:muRen </td><td></td><td> <input type="text" name="3" value="-1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>-1.0</strong></code>)</td></tr></table>
The fixed renormalisation scale used in the hard process cross section, 
as needed to 
generate the leading-order weight, in case the renormalisation scale cannot 
be inferred from Les Houches event input. (As mentioned above, this is the 
case for files generated with the POWHEG-BOX program.) 
If the value is not set, the <code>SCALUP</code> variable of the current LH 
event will be used instead. 
   
 
<br/><br/><table><tr><td><strong>Merging:muFacInME </td><td></td><td> <input type="text" name="4" value="-1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>-1.0</strong></code>)</td></tr></table>
The fixed factorisation scale used in the matrix element calculation. This 
information is needed if factorisation scale variations in NLO merged results 
are attempted. Depending on the matrix element generator, it might not be 
possible to infer the factorisation scale from Les Houches event input, and 
thus, setting an explicit value is required. (As mentioned above, this is the 
case for files generated with the POWHEG-BOX program.) 
If the value is not set, the <code>SCALUP</code> variable of the current LH 
event will be used instead. 
   
 
<br/><br/><table><tr><td><strong>Merging:muRenInME </td><td></td><td> <input type="text" name="5" value="-1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>-1.0</strong></code>)</td></tr></table>
The fixed renormalisation scale used in the matrix element calculation. This 
information is needed if renormalisation scale variations in NLO merged 
results are attempted, for the same reason as factorisation scales might be 
required. (As mentioned above, this is the case for files generated with the 
POWHEG-BOX program.) 
If the value is not set, the <code>SCALUP</code> variable of the current LH 
event will be used instead. 
   
 
<p/> All further settings will be discussed while examining the sample main 
programs. 
 
<br/><br/><hr/> 
<h3>NL<sup>3</sup> merging with main87.cc</h3> 
 
NL<sup>3</sup>-style NLO merging in Pythia is illustrated by the sample 
main program <code>main87.cc</code>. This program works together with an input 
file (e.g. <code>main87.cmnd</code>) for Pythia settings, and requires LHE 
input files that follow the naming convention 
<i>name_tree_#nAdditionalJets.lhe</i> (tree-level samples) and 
<i>name_powheg_#nAdditionalJets.lhe</i> (POWHEG NLO samples). 
<code>main87.cc</code> produces HepMC event output [<a href="Bibliography.php" target="page">Dob01</a>], which can 
be used for analysis (e.g. using RIVET [<a href="Bibliography.php" target="page">Buc10</a>]), or as input for 
detector simulations. For users not familiar with HepMC output, it is of 
course possible remove the HepMC code in the sample program, and use Pythia's 
histogramming routines instead. Histograms should then be filled as indicated 
for the <i>histPTFirstSum</i> histograms in <code>main84.cc</code>, i.e. 
using <i>weightNLO*normhepmc</i>. 
 
<p/> If the user only wants to change the number of requested events 
(<code>Main:numberOfEvents</code>), the hard process 
(<code>Merging:Process</code>), the merging scale value 
(<code>Merging:TMS</code>) and the maximal number of additional tree-level or 
NLO-accuracte jets (<code>Merging:nJetMax</code> and 
<code>Merging:nJetMaxNLO</code>, respectively), and HepMC output is desired, 
then there is no need to change the <code>main87.cc</code> code. The input 
LHE files are also part of the (command line) input for 
<code>main87.exe</code>. The default settings in <code>main87.cmnd</code> 
are intended to work with the (very short) sample LHEF inputs 
(<i>w_production_tree_0.lhe</i>, <i>w_production_tree_1.lhe</i>, 
<i>w_production_tree_2.lhe</i> and <i>w_production_powheg_0.lhe</i>, 
<i>w_production_powheg_1.lhe</i>). For these input files, the 
<code>main87.exe</code> executable can be run with the command 
<p/> 
<code>./main87.exe main87.cmnd w_production myhepmc.hepmc</code> 
<p/> to produce a file myhepmc.hepmc of NLO merged HepMC event output. All 
mandatory Pythia input settngs have been outlined earlier. Please refrain from 
adding input switches than invoke any other merging scheme (e.g. e.g. 
<code>Merging:doKTMerging</code>) into the input file that you want to use in 
conjunction with <code>main87.cc</code>. 
 
<p/> In the following, we will explain <code>main87.cc</code> in depth. Users 
who are willing to accept the default choices do not need to know all details, 
but are still encouraged to read further. 
 
<h4>Program flow</h4> 
 
<code>main87.cc</code> can be divided into four steps: 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1. Estimate the cross section for 
tree-level and NLO samples <i>after</i> the merging scale cut. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 2. Produce reweighted tree-level 
     events, which do not contain <i>&alpha;<sub>s</sub><sup>0</sup></i>- 
     and <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 3. Add POWHEG NLO events. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 4. Subtract phase space points with an 
     extra (real-emission) jet above the merging scale from the POWHEG result, 
     since such configurations have already been taken into account by 
     processing other samples. 
 
<p/> The first step is necessary to produce the correct weights for HepMC 
output events. The estimation of tree-level cross sections after the merging 
scale cut is generated by invoking the switch 
<code>Merging:doXSectionEstimate</code> together with 
<code>Merging:doNL3Tree</code>. In this configuration, the latter switch will 
only act to define the merging scale.  After the tree-level cross sections 
have been estimated, <code>main87.cc</code> estimates the NLO cross sections 
after application of the merging scale cut, by inferring 
<code>Merging:doXSectionEstimate</code> together with 
<code>Merging:doNL3Loop</code>. Again, in this configuration, the latter 
switch only acts as the merging scale definition. When generating the 
estimates, all showering, multiparton interactions and hadronisation is 
turned off to not unnecessarily waste processor time. 
For all estimates, is further <i>mandatory</i> to set the value of 
<code>Merging:nRequested</code> to the jet multiplicity of the current event 
sample (e.g. to "2" for a sample containing W + 2 jet events). This is 
necessary in order to correctly apply the merging scale cut. POWHEG 
NLO input files for W + 1 jet e.g. contain W + 1 jet and W + 2 jet (i.e. real 
emission) kinematics. However, the merging scale cut aims at 
regularising the "underlying Born" configuration (i.e. the W + 1 states in our 
example). Setting <code>Merging:nRequested = 1</code> for the  W + 1 jet 
POWHEG sample ensures that even for real-emission (W + 2 jet) kinematics, the 
merging scale cut is applied to W + 1 jet states. 
 
<p/> After the cross section estimation step, <code>main87.cc</code> proceeds 
to perform the actual merging. Before explaining this part, we would like to 
make some comments about K-factors. 
 
<p/> <code>main87.cc</code> is prepared to use 
fixed K-factors to rescale the weight of tree-level events. This rescaling 
does not affect the NLO accuracy of the method, and was investigated in 
[<a href="Bibliography.php" target="page">Lon13</a>]. By default, <code>main87.cc</code> does not use K-factors. 
However, if the user wants to include K-factors, this can be done by using 
the following input settings. 
 
<br/><br/><table><tr><td><strong>Merging:kFactor0j </td><td></td><td> <input type="text" name="6" value="1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>1.0</strong></code>)</td></tr></table>
The k-Factor used to rescale the tree-level (i.e. CKKW-L or UMEPS) part of 
zero-jet tree-level events. 
   
 
<br/><br/><table><tr><td><strong>Merging:kFactor1j </td><td></td><td> <input type="text" name="7" value="1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>1.0</strong></code>)</td></tr></table>
The k-Factor used to rescale the tree-level (i.e. CKKW-L or UMEPS) part of 
one-jet tree-level events. 
   
 
<br/><br/><table><tr><td><strong>Merging:kFactor2j </td><td></td><td> <input type="text" name="8" value="1.0" size="20"/>  &nbsp;&nbsp;(<code>default = <strong>1.0</strong></code>)</td></tr></table>
The k-Factor used to rescale the tree-level (i.e. CKKW-L or UMEPS) part of 
two-jet tree-level events. 
   
 
<p/> If the variables <i>k0, k1, k2</i> in <code>main87.cc</code> are set 
to non-unity values, K-factors will be applied. The K-factor 
of highest jet multiplicity will then be used 
to also rescale tree-level samples with a number of additional jets 
beyond the number of the highest-multiplicity real-emission sample. If we, for 
example, attempt an NLO merging of <i>W+0 jet</i> and <i>W+1 jet</i> 
at NLO accuracy, and with <i>W+&le;4 jets</i> at tree-level accuracy, then 
<code>Merging:kFactor2j</code> is used to rescale the <i>W+2 jet</i>, 
<i>W+3 jets</i> and <i>W+4 jets</i> tree-level samples. We recommend to 
not include a K-factor rescaling of the tree-level samples. 
 
 
<p/> Let us turn to the production of NLO merged events. The first step in 
the procedure is to generate reweighted tree-level samples. This is 
implemented by using the following switch. 
 
<br/><br/><strong>Merging:doNL3Tree</strong>  <input type="radio" name="9" value="on"><strong>On</strong>
<input type="radio" name="9" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the generation of the weight that should be applied to 
tree-level events in the NL<sup>3</sup> merging scheme. Please note that, in 
order for this to work smoothly, the switch <code>Merging:doNL3Loop</code> and 
the switch <code>Merging:doNL3Subt</code> have to be turned off. As for the 
estimation of cross sections, it is <i>mandatory</i> to set 
the correct value of <code>Merging:nRequested</code>. 
   
 
<p/> 
The weight of tree-level events can be accessed by calling the function 
<strong>double Info::mergingWeightNLO()</strong>. When printing 
(or histogramming) NLO merged events, this weight, multiplied with the 
estimated cross section of the current event sample, should be used as event 
weight (or weight of histogram bins). For <code>Merging:doNL3Tree = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> contains the 
CKKW-L weight, subtracted, if necessary, by 
<i>&alpha;<sub>s</sub><sup>0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>1</sup></i>-terms. This weight can become 
negative. As an example, imagine we attempt an NLO merging of W + 0 jet and 
W + 1 jet at NLO accuracy, and with  W + 2 jets at tree-level accuracy. 
This weight will then be 
<p/> &nbsp; <i>Info::mergingWeightNLO() = CKKW-L-weight for zero jets 
 - <i>&alpha;<sub>s</sub><sup>0</sup></i>-terms 
 - <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms 
</i> for events in the zero-jet sample, 
<p/> &nbsp; <i>Info::mergingWeightNLO() = CKKW-L-weight for one jet 
 - <i>&alpha;<sub>s</sub><sup>0</sup></i>-terms 
 - <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms 
</i> for events in the one-jet sample, and 
<p/> &nbsp; <i>Info::mergingWeightNLO() = CKKW-L-weight for two jets </i> 
for events in the two-jet sample. 
 
<p/> After the tree-level events have been reweighted, <code>main87.cc</code> 
will move on to process the POWHEG NLO input. This is done by switching to the 
following flag. 
 
<br/><br/><strong>Merging:doNL3Loop</strong>  <input type="radio" name="10" value="on"><strong>On</strong>
<input type="radio" name="10" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the processing of POWHEG NLO events in the 
NL<sup>3</sup> merging scheme. Please note that, in order for this to work 
smoothly, the switch <code>Merging:doNL3Tree</code> and the switch 
<code>Merging:doNL3Subt</code> have to be turned off. As for the estimation 
of cross sections, it is <i>mandatory</i> to set the correct value of 
<code>Merging:nRequested</code>. 
   
 
<p/> 
Also in this case, the NLO merging weight of the events can be accessed by 
calling the function <strong>double Info::mergingWeightNLO()</strong>. This 
weight should also be used when printing (or histogramming) events. 
For <code>Merging:doNL3Loop = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> is either one or 
zero (see Appendix E in [<a href="Bibliography.php" target="page">Lon13</a>]). 
 
After the processing of POWHEG NLO events, <code>main87.cc</code> continues 
by generating explicit phase space subtractions. This is facilitated by the 
following switch. 
 
<br/><br/><strong>Merging:doNL3Subt</strong>  <input type="radio" name="11" value="on"><strong>On</strong>
<input type="radio" name="11" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the processing of tree-level events, to produce 
explicit phase space subtractions in the NL<sup>3</sup> merging scheme. 
Please note that, in order for this to work smoothly, the switch 
<code>Merging:doNL3Tree</code> and the switch 
<code>Merging:doNL3Loop</code> have to be turned off. As for the estimation 
of cross sections, it is <i>mandatory</i> to set the correct value of 
<code>Merging:nRequested</code>. Furthermore, it is necessary to set the 
value of <code>Merging:nRecluster</code> to one. 
   
 
<p/> These contributions are necessary because we have implemented 
the "inclusive 
scheme" of [<a href="Bibliography.php" target="page">Lon13</a>] in Pythia. The benefit of this scheme is the user 
does not have to intrusively change the POWHEG-BOX program to implement very 
particular cuts. Let us explain this comment with an example (a more detailed 
explanation of the idea is given in Appendix A.2 of [<a href="Bibliography.php" target="page">Lon13</a>]). When 
generating W + 0 jet events with the POWHEG-BOX program, the output LHE files 
will contain W  + 1 jet real emission events. Some of these events will 
contain a jet above the merging scale. However, in NLO merging methods, such 
configurations have already been included by a separate W + 1 jet sample. 
Thus, to avoid counting such events twice, we have to remove the 
configurations from the POWHEG-BOX output. We choose to remove such events 
by explicit subtraction. 
 
<p/> 
As always, the NLO merging weight of the events can be accessed by 
calling the function <strong>double Info::mergingWeightNLO()</strong>. This 
weight should also be used when printing (or histogramming) events. 
For <code>Merging:doNL3Subt = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> is either one or 
zero (see Appendix E in [<a href="Bibliography.php" target="page">Lon13</a>]). 
 
<p/> After these steps, all necessary events for NL<sup>3</sup> merging have 
been produced. <code>main87.cc</code> finishes by returning the 
NL<sup>3</sup>-merged total cross section. 
 
 
<br/><br/><hr/> 
<h3>UNLOPS merging with main88.cc</h3> 
 
UNLOPS-style NLO merging in Pythia is illustrated by the sample 
main program <code>main88.cc</code>, which relies on an input file (e.g. 
<code>main88.cmnd</code>) for Pythia settings. As for all merging methods in 
Pythia, <code>main88.cc</code> requires LHE input files. To use 
<code>main88.cc</code> without any changes, these input files should follow 
the naming convention <i>name_tree_#nAdditionalJets.lhe</i> (for tree-level 
samples) and <i>name_powheg_#nAdditionalJets.lhe</i> (for POWHEG NLO 
samples). <code>main88.cc</code> produces HepMC event output, which can e.g. 
be analysed with RIVET, or used as input for detector simulations. 
For users not familiar with HepMC output, it is of course possible remove 
the HepMC code in the sample program, and use Pythia's histogramming routines 
instead. Histograms should then be filled as indicated for the 
<i>histPTFirstSum</i> histograms in <code>main84.cc</code>, i.e. using 
<i>weightNLO*normhepmc</i>. 
 
<p/> As for NL<sup>3</sup>, it is not necessary to change 
<code>main88.cc</code> if the user is only interested in changing standard 
settings. Thus, if the user only wants to change the number of requested 
events (<code>Main:numberOfEvents</code>), the hard process 
(<code>Merging:Process</code>), the merging scale value 
(<code>Merging:TMS</code>) and the maximal number of additional tree-level or 
NLO-accuracte jets (<code>Merging:nJetMax</code> and 
<code>Merging:nJetMaxNLO</code>, respectively), and HepMC output is desired, 
then there is no need to change the <code>main88.cc</code> code. The input 
LHE files are also part of the (command line) input for 
<code>main88.exe</code>. The default settings in <code>main88.cmnd</code> 
are intended to work with the (very short) sample LHEF inputs 
(<i>w_production_tree_0.lhe</i>, <i>w_production_tree_1.lhe</i>, 
<i>w_production_tree_2.lhe</i> and <i>w_production_powheg_0.lhe</i>, 
<i>w_production_powheg_1.lhe</i>). For these input files, the 
<code>main88.exe</code> executable can be run with the command 
<p/> 
<code>./main88.exe main88.cmnd w_production myhepmc.hepmc</code> 
<p/> to produce a file myhepmc.hepmc of UNLOPS merged HepMC event output. 
Please refrain from adding input switches than invoke any other merging 
scheme (e.g. <code>Merging:doKTMerging</code>) into the input file that you 
want to use in conjunction with <code>main88.cc</code>. 
 
<p/> In the following, we will explain <code>main88.cc</code> in depth. To 
not be overly repetitive, we will at times refer to the relevant parts in the 
discussion of <code>main87.cc</code>. Users who are willing to accept the 
default choices do not need to know all details, but are still encouraged to 
read further. 
 
<h4>Program flow</h4> 
 
<code>main88.cc</code> can be divided into five steps: 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 1. Estimate the cross section for 
tree-level and NLO samples <i>after</i> the merging scale cut. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 2. Produce reweighted tree-level 
     events, which do not contain <i>&alpha;<sub>s</sub><sup>0</sup></i>- 
     and <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 3. Add POWHEG NLO events. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 4. Subtract integrated, reweighted 
     tree-level events, to ensure that the inclusive NLO cross section remains 
     intact upon inclusion of multi-jet tree-level events. 
<p/> &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; 5. Subtract integrated POWHEG NLO 
     events, to ensure that the inclusive NLO cross section remains 
     intact upon inclusion of multi-jet tree-level events. 
 
<p/> The estimation of cross sections after the application of the merging 
scale cut is nearly identical to the first step in <code>main87.cc</code>, and 
we refer to the first paragraph of the "Program flow" discussion for 
<code>main87.cc</code> for details. For <code>main88.cc</code>, the flags 
<code>Merging:doUNLOPSTree</code> or <code>Merging:doUNLOPSLoop</code> supply 
the merging scale definition used in the cross section estimation. 
 
<p/> After the cross section estimation step, <code>main88.cc</code> proceeds 
to perform the actual NLO merging. The discussion of K-factors given in the 
NL<sup>3</sup> section (i.e. of <code>Merging:kFactor0j</code>, 
<code>Merging:kFactor1j</code> and <code>Merging:kFactor2j</code>) also 
applies to <code>main88.cc</code>. Although UNLOPS is considerably more stable 
than NL<sup>3</sup> upon changing the K-factors, we do not recommend the 
use of K-factors. 
 
<p/> The production of UNLOPS-merged events with <code>main88.cc</code> starts 
by generating reweighted tree-level events. The processing of tree-level 
events can be invoked by setting the following flag. 
 
<br/><br/><strong>Merging:doUNLOPSTree</strong>  <input type="radio" name="12" value="on"><strong>On</strong>
<input type="radio" name="12" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the generation of the weight that should be applied to 
tree-level events in the UNLOPS merging scheme. Please note that, in 
order for this to work smoothly, the switches 
<code>Merging:doUNLOPSLoop</code>, <code>Merging:doUNLOPSSubt</code> and 
<code>Merging:doUNLOPSSubtNLO</code> have to be turned off. As for the 
estimation of cross sections, it is <i>mandatory</i> to set 
the correct value of <code>Merging:nRequested</code>. 
   
 
<p/> 
The weight of tree-level events is returned by the function 
<strong>double Info::mergingWeightNLO()</strong>. When printing 
(or histogramming) NLO merged events, this weight, multiplied with the 
estimated cross section of the current event sample, should be used as event 
weight (or weight of histogram bins). For 
<code>Merging:doUNLOPSTree = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> contains the 
UMEPS weight, subtracted, if necessary, by 
<i>&alpha;<sub>s</sub><sup>0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>1</sup></i>-terms. This weight can become 
negative. As an example, assume that we attempt an UNLOPS merging of W + 0 jet 
and W + 1 jet at NLO accuracy, and with  W + 2 jets at tree-level accuracy. 
This weight will then be 
<p/> &nbsp; <i>Info::mergingWeightNLO() = UMEPS-weight for one jet 
 - <i>&alpha;<sub>s</sub><sup>0</sup></i>-terms 
 - <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms 
</i> for events in the one-jet sample, and 
<p/> &nbsp; <i>Info::mergingWeightNLO() = UMEPS-weight for two jets </i> 
for events in the two-jet sample. 
 
<p/> After reweighted tree-level events have been generated, 
<code>main88.cc</code> processes the POWHEG NLO input files. This is 
facilitated by the following switch. 
 
<br/><br/><strong>Merging:doUNLOPSLoop</strong>  <input type="radio" name="13" value="on"><strong>On</strong>
<input type="radio" name="13" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the processing of POWHEG NLO events in the 
UNLOPS merging scheme. Please note that, in order for this to work 
smoothly, the switches <code>Merging:doUNLOPSTree</code>, 
<code>Merging:doUNLOPSSubt</code> and <code>Merging:doUNLOPSSubtNLO</code> 
have to be turned off. As for the estimation of cross sections, it is 
<i>mandatory</i> to set the correct value of 
<code>Merging:nRequested</code>. 
   
 
<p/> 
The NLO merging weight of the events can be accessed by 
calling the function <strong>double Info::mergingWeightNLO()</strong>. This 
weight should also be used when printing (or histogramming) events. 
For <code>Merging:doUNLOPSLoop = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> is either one or 
zero (see Appendix E in [<a href="Bibliography.php" target="page">Lon13</a>]). 
 
<p/> 
After processing the POWHEG NLO events, <code>main88.cc</code> continues 
by generating the reweighted subtraction terms of UMEPS. This part is 
implemented by setting the following flag. 
 
<br/><br/><strong>Merging:doUNLOPSSubt</strong>  <input type="radio" name="14" value="on"><strong>On</strong>
<input type="radio" name="14" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the processing of tree-level events, to produce UMEPS 
subtraction terms for the UNLOPS merging scheme. Please note 
that, in order for this to work smoothly, the switches 
<code>Merging:doUNLOPSTree</code>, <code>Merging:doUNLOPSLoop</code> and 
<code>Merging:doUNLOPSSubtNLO</code> have to be turned off. 
As for the estimation of cross sections, it is <i>mandatory</i> to set the 
correct value of <code>Merging:nRequested</code>. Furthermore, it is necessary 
to set the value of <code>Merging:nRecluster</code> to one. 
   
 
<p/>By using this switch, <code>main88.cc</code> ensures that the inclusive 
cross section is preserved. At variance with UMEPS however, the event weight 
contains the UMEPS weight, subtracted, if necessary, by 
<i>&alpha;<sub>s</sub><sup>+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>1</sup></i>-terms. Otherwise, 
<i>&alpha;<sub>s</sub><sup>n+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>n+1</sup></i>-terms of the UMEPS procedure would 
be introduced, although our goal is to describe all 
<i>&alpha;<sub>s</sub><sup>n+0</sup></i>- and 
<i>&alpha;<sub>s</sub><sup>n+1</sup></i>-terms by n-jet POWHEG input. 
The weight of these integrated, subtractive tree-level events is, as always, 
returned by the function <strong>double Info::mergingWeightNLO()</strong>. 
When printing (or histogramming) NLO merged events, this weight, multiplied 
with the estimated cross section of the current event sample, and with <i> 
-1</i>, should be used 
as event weight (or weight of histogram bins). As for the case of tree-level 
events in UNLOPS, this weight can become negative. 
For the example given before, i.e. attempting an UNLOPS merging of 
W + 0 jet and  W + 1 jet at NLO accuracy, and with 
W + 2 jets at tree-level accuracy, this weight will be 
<p/> &nbsp; <i>Info::mergingWeightNLO() = UMEPS-weight for the integrated 
 one-jet sample - <i>&alpha;<sub>s</sub><sup>0</sup></i>-terms 
 - <i>&alpha;<sub>s</sub><sup>1</sup></i>-terms 
</i> for events in the integrated one-jet sample, and 
<p/> &nbsp; <i>Info::mergingWeightNLO() = UMEPS-weight for the integrated 
 two-jet sample</i> 
for events in the integrated two-jet sample. 
 
<p/>This choice of weights already 
incorporates the fact that we have implemented the "inclusive scheme" of 
[<a href="Bibliography.php" target="page">Lon13</a>], meaning that the "explicit phase space subtractions" of 
NL<sup>3</sup> are (partially) included though these weights. 
 
<p/> To ensure that the NLO inclusive cross section is unchanged, UNLOPS 
further requires the introduction of another sample. If POWHEG NLO events with 
one or more jets are included, it is necessary to subtract these samples 
in an integrated form. In <code>main88.cc</code>, this is done by setting the 
following flag. 
 
<br/><br/><strong>Merging:doUNLOPSSubtNLO</strong>  <input type="radio" name="15" value="on"><strong>On</strong>
<input type="radio" name="15" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This switch will allow the processing of POWHEG NLO events, to produce NLO 
subtraction terms for the UNLOPS merging scheme. Please note 
that, in order for this to work smoothly, the switches 
<code>Merging:doUNLOPSTree</code>, <code>Merging:doUNLOPSLoop</code> and 
<code>Merging:doUNLOPSSubt</code> have to be turned off. 
As for the estimation of cross sections, it is <i>mandatory</i> to set the 
correct value of <code>Merging:nRequested</code>. Furthermore, it is necessary 
to set the value of <code>Merging:nRecluster</code> to one. 
   
 
<p/> This sample also provides some "explicit phase space subtractions" of 
NL<sup>3</sup>, which are necessary because we implemented the 
"inclusive scheme" of [<a href="Bibliography.php" target="page">Lon13</a>]. Let us again look at the example of 
UNLOPS merging of W + 0 jet and W + 1 jet at NLO accuracy. 
The integrated  W + 1 jet NLO events, which are produced by the setting 
<code>Merging:doUNLOPSSubtNLO = on</code>, contain a tree-level part. This 
part will exactly cancel the real-emission events with one jet above the 
merging scale in the  W + 0 jet NLO events. 
 
<p/> 
The NLO merging weight of these "integrated" events can be accessed by 
calling the function <strong>double Info::mergingWeightNLO()</strong>. This 
weight should also be used when printing (or histogramming) events. 
For <code>Merging:doUNLOPSSubtNLO = on</code>, 
the weight <strong>double Info::mergingWeightNLO()</strong> is either one or 
zero (see Appendix E in [<a href="Bibliography.php" target="page">Lon13</a>]). 
 
<p/> After these five steps (estimation of cross sections, tree-level 
processing, POWHEG processing, integrated tree-level processing, 
integrated POWHEG processing) we have produced a UNLOPS-merged HepMC 
event file. <code>main88.cc</code> finishes by returning the 
UNLOPS-merged total cross section. 
 
 
<br/><br/><hr/> 
<h3>NLO merging and "exclusive" NLO inputs</h3> 
 
Currently, both sample main programs for NLO merging (<code>main87.cc</code> 
and <code>main88.cc</code>) are intended for "inclusive" POWHEG input. 
Inclusive input means that all real emission phase space points are included 
in the POWHEG output files. In order to avoid double counting with 
higher-multiplicity matrix elements, it is then necessary remove phase space 
points with too many jets from the real-emission configurations. 
This can be done by introducing explicit phase space subtractions. Another 
way of removing the undesired configurations is by implementing a cut in the 
NLO generator. This is not a completely trivial task, since it is necessary 
to ensure numerical stability and the correct cancellation of (finite) dipole 
regularisation terms. One way of producing such exclusive NLO output is by 
setting the (tree-level) real-emission matrix element in the NLO generator to 
zero if the real-emission phase space point contains too many jets above the 
merging scale. This will however not be numerically stable for too low merging 
scale values. 
 
<p/><i> We should be very clear that using exclusive NLO input is not 
recommended, since it requires hacking the NLO generator.  Only for the expert 
user, we briefly summarise the necessary changes for using exclusive 
NLO input.</i> 
 
<p/> For the moment, assume that the NLO input has been produced in an 
"exclusive" way. This input can then be processed by some trivial changes in 
<code>main87.cc</code>: estimate the cross section for tree-level and NLO 
samples <i>after</i> the merging scale cut, still using inclusive NLO 
samples, remove the last part of <code>main87.cc</code>, i.e. the part that 
produces explicit phase space subtractions, and use the exclusive NLO files as 
input files for the processing of "POWHEG NLO files". 
 
<p/> The changes to <code>main88.cc</code> (implementing UNLOPS) are slightly 
more complicated. This is the case because the weights of integrated 
tree-level samples change when using exclusive input, as can be seen in 
Appendix D in [<a href="Bibliography.php" target="page">Lon13</a>]. The correct weights can be produced by Pythia 
by using the following flag. 
 
<br/><br/><strong>Merging:doUNLOPSTilde</strong>  <input type="radio" name="16" value="on"><strong>On</strong>
<input type="radio" name="16" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
This flag allows the UNLOPS machinery to produce the event weights if 
exclusive NLO input is used for the merging. This flag should be set to "on" 
directly after the cross section estimates have been produced. 
   
 
<p/> Then, it is necessary to add code for processing another sample to 
<code>main88.cc</code>, since when using exclusive inputs, it is also 
necessary to enforce two integrations on tree-level events (the 
"&uarr;"-contributions in Appendix D of [<a href="Bibliography.php" target="page">Lon13</a>]). This can be 
achieved by adding the following code at the end of <code>main88.cc</code>. 
<p/> 
<pre> 
  cout << endl << endl << endl; 
  cout << "Shower subtractive events" << endl; 
 
  // Switch on processing of counter-events. 
  pythia.settings.flag("Merging:doUNLOPSTree",false); 
  pythia.settings.flag("Merging:doUNLOPSLoop",false); 
  pythia.settings.flag("Merging:doUNLOPSSubt",true); 
  pythia.settings.flag("Merging:doUNLOPSSubtNLO",false); 
  pythia.settings.mode("Merging:nRecluster",2); 
 
  nMaxCT         = nMaxNLO+1; 
  njetcounterCT  = nMaxCT; 
  iPathSubt      = iPath + "_tree"; 
 
  while(njetcounterCT >= 2){ 
 
    // From njet, choose LHE file 
    stringstream in; 
    in   << "_" << njetcounterCT << ".lhe"; 
    string LHEfile = iPathSubt + in.str(); 
 
    cout << endl << endl << endl 
         << "Start subtractive treatment for " << njetcounterCT << " jets\n" 
         << "Recluster at least 2 times" << endl; 
 
    pythia.readString("Beams:frameType = 4"); 
    pythia.settings.word("Beams:LHEF", LHEfile); 
    pythia.settings.mode("Merging:nRequested", njetcounterCT); 
    pythia.init(); 
    // Remember position in vector of cross section estimates. 
    int iNow = sizeLO-1-njetcounterCT; 
 
    // Start generation loop 
    for( int iEvent=0; iEvent < nEvent; ++iEvent ){ 
 
      // Generate next event 
      if( !pythia.next() ) { 
        if( pythia.info.atEndOfFile() ) break; 
        else continue; 
      } 
 
      // Get event weight(s). 
      double weightNLO  = pythia.info.mergingWeightNLO(); 
      double evtweight  = pythia.info.weight(); 
      weightNLO        *= evtweight; 
      // Do not print zero-weight events. 
      if ( weightNLO == 0. ) continue; 
 
      // Construct new empty HepMC event. 
      HepMC::GenEvent* hepmcevt = new HepMC::GenEvent(); 
      // Get correct cross section from previous estimate. 
      double normhepmc = -1*xsecLO[iNow] / nAcceptLO[iNow]; 
      // Set hepmc event weight. 
      hepmcevt->weights().push_back(weightNLO*normhepmc); 
      // Fill HepMC event. 
      ToHepMC.fill_next_event( pythia, hepmcevt ); 
      // Add the weight of the current event to the cross section. 
      sigmaTotal += weightNLO*normhepmc; 
      errorTotal += pow2(weightNLO*normhepmc); 
      // Report cross section to hepmc. 
      HepMC::GenCrossSection xsec; 
      xsec.set_cross_section( sigmaTotal*1e9, pythia.info.sigmaErr()*1e9 ); 
      hepmcevt->set_cross_section( xsec ); 
      // Write the HepMC event to file. Done with it. 
      ascii_io << hepmcevt; 
      delete hepmcevt; 
 
    } // end loop over events to generate 
 
    // print cross section, errors 
    pythia.stat(); 
 
    // Restart with ME of a reduced the number of jets 
    if( njetcounterCT > 2 ) 
      njetcounterCT--; 
    else 
      break; 
 
  } 
</pre> 

<br/><br/><hr/>
<h3>Further variables</h3>

More advanced manipulations of the merging machinery are of
course possible, and additional switches can be found at
the end of the <?php $filepath = $_GET["filepath"];
echo "<a href='CKKWLMerging.php?filepath=".$filepath."' target='page'>";?>CKKW-L
tree-level merging</a> documentation. Here, we only document
switches that <i>only</i> apply to NLO merging. 

<br/><br/><strong>Merging:allowIncompleteHistoriesInReal</strong>  <input type="radio" name="17" value="on"><strong>On</strong>
<input type="radio" name="17" value="off" checked="checked"><strong>Off</strong>
 &nbsp;&nbsp;(<code>default = <strong>off</strong></code>)<br/>
If switched on, this will allow to keep states with incomplete parton
shower histories (i.e. states that cannot be projected onto an allowed
underlying Born process) in the real contributions of an NLO input sample. By
default, such configurations will instead be included through
higher-multiplicity tree-level matrix elements. However, NLO input samples
can contain a significant number of such configurations if Diagram Subtraction
(DS) techniques had been applied. In order not to change the DS scheme, it
is important not to remove incomplete histories from the real-emission
contribution. Note that furthermore, if this switch turned on, you will
have to ensure yourself that no double-counting between states with incomplete
histories will occur between NLO samples and higher-multiplicity tree-level
samples. This might for example entail using the <code>MergingHooks</code> 
facilities, and the function 
<code>double MergingHooks::dampenIfFailCuts(const Event& event)"</code> in
particular.
  
 
<input type="hidden" name="saved" value="1"/>

<?php
echo "<input type='hidden' name='filepath' value='".$_GET["filepath"]."'/>"?>

<table width="100%"><tr><td align="right"><input type="submit" value="Save Settings" /></td></tr></table>
</form>

<?php

if($_POST["saved"] == 1)
{
$filepath = $_POST["filepath"];
$handle = fopen($filepath, 'a');

if($_POST["1"] != "0")
{
$data = "Merging:nJetMaxNLO = ".$_POST["1"]."\n";
fwrite($handle,$data);
}
if($_POST["2"] != "-1.0")
{
$data = "Merging:muFac = ".$_POST["2"]."\n";
fwrite($handle,$data);
}
if($_POST["3"] != "-1.0")
{
$data = "Merging:muRen = ".$_POST["3"]."\n";
fwrite($handle,$data);
}
if($_POST["4"] != "-1.0")
{
$data = "Merging:muFacInME = ".$_POST["4"]."\n";
fwrite($handle,$data);
}
if($_POST["5"] != "-1.0")
{
$data = "Merging:muRenInME = ".$_POST["5"]."\n";
fwrite($handle,$data);
}
if($_POST["6"] != "1.0")
{
$data = "Merging:kFactor0j = ".$_POST["6"]."\n";
fwrite($handle,$data);
}
if($_POST["7"] != "1.0")
{
$data = "Merging:kFactor1j = ".$_POST["7"]."\n";
fwrite($handle,$data);
}
if($_POST["8"] != "1.0")
{
$data = "Merging:kFactor2j = ".$_POST["8"]."\n";
fwrite($handle,$data);
}
if($_POST["9"] != "off")
{
$data = "Merging:doNL3Tree = ".$_POST["9"]."\n";
fwrite($handle,$data);
}
if($_POST["10"] != "off")
{
$data = "Merging:doNL3Loop = ".$_POST["10"]."\n";
fwrite($handle,$data);
}
if($_POST["11"] != "off")
{
$data = "Merging:doNL3Subt = ".$_POST["11"]."\n";
fwrite($handle,$data);
}
if($_POST["12"] != "off")
{
$data = "Merging:doUNLOPSTree = ".$_POST["12"]."\n";
fwrite($handle,$data);
}
if($_POST["13"] != "off")
{
$data = "Merging:doUNLOPSLoop = ".$_POST["13"]."\n";
fwrite($handle,$data);
}
if($_POST["14"] != "off")
{
$data = "Merging:doUNLOPSSubt = ".$_POST["14"]."\n";
fwrite($handle,$data);
}
if($_POST["15"] != "off")
{
$data = "Merging:doUNLOPSSubtNLO = ".$_POST["15"]."\n";
fwrite($handle,$data);
}
if($_POST["16"] != "off")
{
$data = "Merging:doUNLOPSTilde = ".$_POST["16"]."\n";
fwrite($handle,$data);
}
if($_POST["17"] != "off")
{
$data = "Merging:allowIncompleteHistoriesInReal = ".$_POST["17"]."\n";
fwrite($handle,$data);
}
fclose($handle);
}

?>
</body>
</html>
 
<!-- Copyright (C) 2014 Torbjorn Sjostrand --> 
