% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-sp.R
\name{mo}
\alias{mo}
\title{Monotonic Predictors in \pkg{brms} Models}
\usage{
mo(x)
}
\arguments{
\item{x}{An integer variable or an ordered factor to be modeled as monotonic.}
}
\description{
Specify a monotonic predictor term in \pkg{brms}. The function does not
evaluate its arguments -- it exists purely to help set up a model.
}
\details{
For detailed documentation see \code{help(brmsformula)}
  as well as \code{vignette("brms_monotonic")}.
}
\examples{
  
\dontrun{
# generate some data
income_options <- c("below_20", "20_to_40", "40_to_100", "greater_100")
income <- factor(sample(income_options, 100, TRUE), 
                 levels = income_options, ordered = TRUE)
mean_ls <- c(30, 60, 70, 75)
ls <- mean_ls[income] + rnorm(100, sd = 7)
dat <- data.frame(income, ls)

# fit a simple monotonic model
fit1 <- brm(ls ~ mo(income), data = dat)

# summarise the model
summary(fit1)
plot(fit1, N = 6)
plot(marginal_effects(fit1), points = TRUE)

# model interaction with other variables
dat$x <- sample(c("a", "b", "c"), 100, TRUE)
fit2 <- brm(ls ~ mo(income)*x, data = dat)

# summarise the model
summary(fit2)
plot(marginal_effects(fit2), points = TRUE)
} 
 
}
\references{
Bürkner P. C. & Charpentier, E. (in review). Monotonic Effects: A Principled 
Approach for Including Ordinal Predictors in Regression Models. PsyArXiv 
preprint.
}
\seealso{
\code{\link{brmsformula}}
}
