% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_barDiag}
\alias{ggally_barDiag}
\title{Bar plot}
\usage{
ggally_barDiag(data, mapping, ..., rescale = FALSE)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments are sent to geom_bar}

\item{rescale}{boolean to decide whether or not to rescale the count output. Only applies to numeric data}
}
\description{
Displays a bar plot for the diagonal of a \code{\link{ggpairs}} plot matrix.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")
p_(ggally_barDiag(tips, mapping = ggplot2::aes(x = day)))
p_(ggally_barDiag(tips, mapping = ggplot2::aes(x = tip), binwidth = 0.25))
}
\author{
Barret Schloerke
}
\keyword{hplot}
