% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ci.R
\name{plot.ci}
\alias{plot.ci}
\title{Plot confidence intervals}
\usage{
\method{plot}{ci}(x, xlim, xlab = "", labels, ...)
}
\arguments{
\item{x}{List, data.frame or other object of this form containing point estimates (first element) and the corresponding confidence intervals as elements lower and upper.}

\item{xlim}{Limit of the x-axis}

\item{xlab}{Label for the y-axis}

\item{labels}{labels}

\item{...}{Used to transport arguments to \code{plotConfidence}.}
}
\description{
Function to plot confidence intervals
}
\details{
Function to plot means and other point estimates with confidence
intervals
}
\examples{

data(Diabetes)
x=ci.mean(bp.2s~AgeGroups,data=Diabetes)
plot(x,title.labels="Age groups",xratio=c(0.4,0.3))
x=ci.mean(bp.2s/500~AgeGroups+gender,data=Diabetes)
plot(x,xratio=c(0.4,0.2))
plot(x,xratio=c(0.4,0.2),
     labels=split(x$labels[,"AgeGroups"],x$labels[,"gender"]),
     title.labels="Age groups")
\dontrun{
plot(x, leftmargin=0, rightmargin=0)
plotConfidence(x, leftmargin=0, rightmargin=0)

data(CiTable)
with(CiTable,plotConfidence(x=list(HazardRatio),
                               lower=lower,
                               upper=upper,
                               labels=CiTable[,2:6],
                               factor.reference.pos=c(1,10,19),
                               format="(u-l)",
                               points.col="blue",
                               digits=2))

with(CiTable,Publish::plot.ci(x=list(HazardRatio),
                               lower=lower,
                               upper=upper,
                               labels=CiTable[,2:6],
                               factor.reference.pos=c(1,10,19),
                               format="(u-l)",
                               points.col="blue",
                               digits=2,
                               leftmargin=-2,
                               title.labels.cex=1.1,
                               labels.cex=0.8,values.cex=0.8))
}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
