% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{pkg_attach}
\alias{pkg_attach}
\alias{pkg_load}
\alias{loadable}
\alias{pkg_attach2}
\alias{pkg_load2}
\title{Attach or load packages, and automatically install missing packages if
requested}
\usage{
pkg_attach(
  ...,
  install = FALSE,
  message = getOption("xfun.pkg_attach.message", TRUE)
)

pkg_load(..., error = TRUE, install = FALSE)

loadable(pkg, strict = TRUE, new_session = FALSE)

pkg_attach2(...)

pkg_load2(...)
}
\arguments{
\item{...}{Package names (character vectors, and must always be quoted).}

\item{install}{Whether to automatically install packages that are not
available using \code{\link{install.packages}()}. You are recommended to
set a CRAN mirror in the global option \code{repos} via
\code{\link{options}()} if you want to automatically install packages.}

\item{message}{Whether to show the package startup messages (if any startup
messages are provided in a package).}

\item{error}{Whether to signal an error when certain packages cannot be loaded.}

\item{pkg}{A single package name.}

\item{strict}{If \code{TRUE}, use \code{\link{requireNamespace}()} to test if
a package is loadable; otherwise only check if the package is in
\code{\link{.packages}(TRUE)} (this does not really load the package, so it
is less rigorous but on the other hand, it can keep the current R session
clean).}

\item{new_session}{Whether to test if a package is loadable in a new R
session. Note that \code{new_session = TRUE} implies \code{strict = TRUE}.}
}
\value{
\code{pkg_attach()} returns \code{NULL} invisibly. \code{pkg_load()}
  returns a logical vector, indicating whether the packages can be loaded.
}
\description{
\code{pkg_attach()} is a vectorized version of \code{\link{library}()} over
the \code{package} argument to attach multiple packages in a single function
call. \code{pkg_load()} is a vectorized version of
\code{\link{requireNamespace}()} to load packages (without attaching them).
The functions \code{pkg_attach2()} and \code{pkg_load2()} are wrappers of
\code{pkg_attach(install = TRUE)} and \code{pkg_load(install = TRUE)},
respectively. \code{loadable()} is an abbreviation of
\code{requireNamespace(quietly = TRUE)}.
}
\details{
These are convenience functions that aim to solve these common problems: (1)
We often need to attach or load multiple packages, and it is tedious to type
several \code{library()} calls; (2) We are likely to want to install the
packages when attaching/loading them but they have not been installed.
}
\examples{
library(xfun)
pkg_attach("stats", "graphics")
# pkg_attach2('servr') # automatically install servr if it is not installed

(pkg_load("stats", "graphics"))
}
