% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{period.sum}
\alias{period.sum}
\alias{period.prod}
\alias{period.max}
\alias{period.min}
\title{Optimized Calculations By Period}
\usage{
period.sum(x, INDEX)

period.prod(x, INDEX)

period.max(x, INDEX)

period.min(x, INDEX)
}
\arguments{
\item{x}{A univariate data object.}

\item{INDEX}{A numeric vector of endpoints for each period.}
}
\value{
An xts or zoo object containing the sum, product, minimum, or
maximum for each endpoint in \code{INDEX}.
}
\description{
Calculate a sum, product, minimum, or maximum for each non-overlapping
period specified by \code{INDEX}.
}
\details{
These functions are similar to calling \code{period.apply()} with the same
endpoints and function. There may be slight differences in the results due
to numerical accuracy.

For xts-coercible objects, an appropriate \code{INDEX} can be created by a call
to \code{endpoints()}.
}
\examples{

x <- c(1, 1, 4, 2, 2, 6, 7, 8, -1, 20)
i <- c(0, 3, 5, 8, 10)

period.sum(x, i)
period.prod(x, i)
period.min(x, i)
period.max(x, i)

data(sample_matrix)
y <- sample_matrix[, 1]
ep <- endpoints(sample_matrix)

period.sum(y, ep)
period.sum(as.xts(y), ep)

period.prod(y, ep)
period.prod(as.xts(y), ep)

period.min(y, ep)
period.min(as.xts(y), ep)

period.max(y, ep)
period.max(as.xts(y), ep)

}
\seealso{
\code{\link[=endpoints]{endpoints()}}, \code{\link[=period.apply]{period.apply()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
