% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.xts}
\alias{print.xts}
\title{Print An xts Time-Series Object}
\usage{
\method{print}{xts}(x, fmt, ..., show.rows = 10, max.rows = 100)
}
\arguments{
\item{x}{An xts object.}

\item{fmt}{Passed to \code{\link[zoo:coredata]{coredata()}} to format the time index.}

\item{\dots}{Arguments passed to other methods.}

\item{show.rows}{The number of first and last rows to print if the number of
rows is truncated (default 10, or \code{getOption("xts.print.show.rows")}).}

\item{max.rows}{The output will contain at most \code{max.rows} rows before being
truncated (default 100, or \code{getOption("xts.print.max.rows")}).}
}
\value{
Returns \code{x} invisibly.
}
\description{
Method for printing an extensible time-series object.
}
\examples{

data(sample_matrix)
sample.xts <- as.xts(sample_matrix)

# output is truncated and shows first and last 10 observations
print(sample.xts)

# show the first and last 5 observations
print(sample.xts, show.rows = 5)

}
\author{
Joshua M. Ulrich
}
\keyword{print}
