% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_event.R
\name{plot_event}
\alias{plot_event}
\title{Plot PSI values of a given alternative splicing event}
\usage{
plot_event(x, config = NULL, subg = FALSE, subg.show = c("mean", "all",
  "beeswarm"), trim_colnames = NULL, qual = c("VLOW", "N", "LOW", "OK",
  "SOK"), errorbar = TRUE, groupmean = ifelse(is.null(config), FALSE, TRUE),
  col = NULL, title = NULL, xlab = "", ylab = "PSI", ylim = c(0, 100),
  cex.main = 14, cex.yaxis = 12, cex.xaxis = 12, pch = 20,
  cex.pch = 3, plot = NULL, gridlines = TRUE, show_group_legend = TRUE)
}
\arguments{
\item{x}{A 1-row data frame containing PSI values to be plotted.}

\item{config}{Optional configuration settings for \code{plot_event}. Can be
a path to the \code{.config} file, or 4/5-column data frame of the \code{.config}
file. Use the latter option if you are calling \code{plot_event} multiple times.}

\item{subg}{Logical indicating whether samples should be subgrouped for plotting.}

\item{subg.show}{Only applies when \code{subg == TRUE}. Default is \code{mean},
in which the average PSI is computed for each subgroup. If \code{all}, then
individual point estimates with error bars are shown. If \code{beeswarm}, this is
similar to \code{all}, but shown as a beeswarm plot and without error bars.}

\item{trim_colnames}{String that must be searched for and trimmed at the end
of every sample column in x. If no string must be trimmed, leave as \code{FALSE}.}

\item{qual}{String indicating the minimun \emph{vast-tools} quality score
for the PSI to be accepted. Defaults to \code{'VLOW'}. See the
\href{https://github.com/vastgroup/vast-tools/blob/master/README.md}{vast-tools
documentation} for details.}

\item{errorbar}{Logical indicating whether error bars should be drawn.}

\item{groupmean}{Logical indicating whether grouped means should be drawn.
Requires \code{config}.}

\item{col}{Vector of colors with length matching the number of samples. If
specified, this will override the color settings specified in \code{config}.}

\item{title}{Title of the plot. If \code{NULL} (default), the title generated
by \code{\link{make_title}}.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{ylim}{Range of y-axis.}

\item{cex.main}{Plot title size (pts).}

\item{cex.yaxis}{Y-axis font size (pts).}

\item{cex.xaxis}{X-axis font size (i.e. the sample names) (pts).}

\item{pch}{Point symbol.}

\item{cex.pch}{Size of datapoints.}

\item{plot}{(deprecated) Prints the plot.}

\item{gridlines}{Logical indicating whether grid lines should be drawn.}

\item{show_group_legend}{Set to FALSE to avoid showing a legend with the sample
groups and their colors.}
}
\value{
ggplot2 object
}
\description{
Generate a plot of PSI values for a given exon. The PSI values and
corresponding quality scores are typically obtained from the
\href{https://www.github.com/vastgroup/vast-tools}{vast-tools}
pipeline.
}
\details{
Plots can be customized via the \code{config} option. Either a data frame or
the filepath to the config file can be used. Alternatively, plots can be
customized using a limited set of graphical parameters as described above.

The order of samples (e.g. columns in \code{x}) as it appears on the
resulting plot can be customized using a config file. If a config file is not
used and re-ordering is desired, then it must be done manually before calling
\code{\link{plot_event}} by altering the columns of \code{x}.

If subgroups are defined in \code{config} and \code{subg=TRUE}:
\itemize{
  \item{The mean PSI of the samples within each subgroup are drawn as a single
  data point.}
  \item{If \code{subg=TRUE} and \code{errorbar=TRUE}, confidence intervals for
  the subgroup are derived from a joint beta distribution, fitted to a set of
  points derived from individual beta distributions corresponding to each
  sample (see \code{\link{get_beta_ci_subg}}). This is an experimental feature,
  computationally expensive, and CIs may not be shown for some subgroups,due
  to failure in fitting the joint distribution, especially for events with low
  coverage and PSI values near 0 or 1.}
  \item{Subgroups will be ordered by the minimum \emph{Order} value of their
  samples, and assigned to the first group to which they are matched.}
  \item{(Experimental) Instead of computing the average PSI, the individual
  PSI values can be plotted for each subgroup by setting \code{subg.show}. The
  default is "mean", which plots the average PSI. The other two options are
  "all" or "beeswarm". For "all", the individual PSI values and error bars
  are plotted for each subgroup and sorted in increasing order. For
  "beeswarm", the optional
  \href{https://github.com/eclarke/ggbeeswarm}{ggbeeswarm} package is used to
  create beeswarm scatterplots for each subgroup (error bars are not possible).
  As this is an optional feature, please manually install the package first
  before using it: \code{install.packages("ggbeeswarm")}.}
}

If no subgroups are defined in \code{config}, or \code{subg=FALSE} (default),
a subgroup will be defined for each sample, preserving their name and order.

If groups and colors are defined in \code{config}, all the samples in a group
will be colored with the first color assigned to the group. Else, all
samples will be plotted in black.

If groups are defined in \code{config} and \code{groupmean=TRUE}, the mean
PSI of the samples within each group are drawn as horizontal lines. The
colors of the lines are determined by the color set to the first sample of
each group by \code{RColorCode} in \code{config}. A corresponding legend key
will also be drawn.

(See also \code{\link{preprocess_sample_colors}} and \code{vignette('psiplot-usage')}
for details on how to use config files).

PSI values that have \emph{NA} value are omitted and not plotted.

Error bars based on the confidence interval of the PSI estimation can be
shown by setting \code{errorbar=TRUE}.
}
\examples{
\dontrun{
plot_event(psi[1,])
# Plot with custom configuration
config
plot_event(psi[1,], config = config, groupmean=TRUE)
plot_event(psi[1,], config = "/path/to/config")

# Plot with subgrouped samples
config
plot_event(psi[1,], config = config, subg = TRUE, errorbar = FALSE)

# Plot with subroups and error bars (slow, experimental feature)
\dontrun{
plot_event(psi[1,], config = config, subg = TRUE, errorbar = TRUE)
}

# Plot using custom configuration, changing point symbol, and y-axis
# scale
plot_event(psi[1,], config = config, pch = 9, ylim = c(20, 80))
}
}
\seealso{
\code{\link{format_table}} for performing some initial conversion steps of
\code{x}.

\code{\link{preprocess_sample_colors}} for pre-processing of \code{x}
using\code{config}.

\code{\link{plot_multievent}} for plotting more than one
event in the same plot.
}
