'\" t
.\"	recite - english text speech synthesizer
.\"	Copyright (C) 1993 Peter Miller.
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 1, or (at your option)
.\"	any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" MANIFEST: source of the BUILDING file
.\"
.TH building recite
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
recite \- english text speech synthesizer
.SH SITE CONFIGURATION
A file which may require editing is the
.I Makefile
file.
The first few lines contain comments describing what may require changing.
In general these changes will relate to the name of your favorite
C compiler,
and where it keeps its include files.
.ne 1i
.SH KNOWN SYSTEMS
This distribution of
.I recite
is known to build on the following systems:
.TP 8n
SunOS 4.1
.br
The native
.IR cc (1)
and also
.IR gcc (1)
are known to work.
.PP
Please let the author know of any other systems you get
.I recite
working on,
and the modifications necessary.
.PP
The
.I recite
program was developed using gcc,
however this is not the default in the
.I Makefile
file.
The
.I recite
program source attempts to use ANSI C features without compromising the ability
to be compilted on older C compilers.
Functions mandated by the ANSI C standard are used,
because many systems provided them, one way or another.
Please let the author know of any others you think should
be added to the
.I common/ansi.c
file.
.PP
You may need to use some ANSI C header files which the
.I recite
code uses,
but which some systems (as yet) fail to provide.
You will find lines at the top of the
.I Makefile
file similar to
.RS
H = -I/usr/include -Ih
.RE
Change this to suit your system and your compiler.
The "h" directory must be searched last as it is
intended to suplement your system,
not replace it.
.PP
You will need to check the include files in the "h" directory
to see that they are suitable for your system.
You may want to delete any that your system already has.
.br
.ne 1i
.SH BUILDING RECITE
All you should need to do is use the
.RS
% \fBmake\fP
.br
\fI\&...lots of output...\fP
.br
%
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing the file:
.IR recite .
.br
.ne 1i
.SH TESTING
The
.I recite
program comes with a test suite.
To run this test suite, use the command
.RS
.nf
% \fBmake sure\fP
\fI\&...lots of output...\fP
Passed All Tests
%
.fi
.RE
.PP
The tests take a few seconds each,
with a few very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
Passed All Tests
.RE
should appear at the end of the make.
.br
.ne 1i
.SH INSTALLING RECITE
Put the
.I recite
program somewhere where users will automatically pick it up,
such as in the
.I /usr/local/bin
directory.
Use the command
.RS
# \fBcp bin/* /usr/local/bin\fP
.br
#
.RE
.PP
The manuals can be installed using the commands
.RS
# \fBcp man1/* /usr/man/man1\fP
.br
#
.RE
.PP
These paths are only example, where to install things tends
to be very system specific, and I won't even try to guess.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the
.I recite
program,
please do not hesitate to contact the author at
.RS
Peter Miller <pmiller@bmr.gov.au>
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
% recite -version
.br
%
.RE
command.
.PP
In the
.I common/main.h
file, the is a define of
.I DEBUG
in comments.
If the comments are removed,
extensive debugging is turned on.
This causes some performance loss,
but performs much run-time checking
and adds the
.B -TRace
command line option.
When followed by one or more file names,
this turns on execution traces in those files.
.br
.ne 2i
.SH COPYRIGHT
The
.I recite
program is
Copyright
.if n (c)
.if t \(co
1993 Peter Miller.
.br
All rights reserved.
.PP
The
.I recite
package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l l l.
Peter Miller;UUCP;uunet!munnari!bmr.gov.au!pmiller
/\e/\e*;CSNET;pmiller@bmr.gov.au
.TE
